/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.ErrorTag;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IndexBuilder;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableNameRegistryStore;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.VacuumColumnVersions;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewGraph;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.mv.MatViewStateReader;
import io.questdb.cairo.mv.MatViewStateStore;
import io.questdb.cairo.security.AllowAllSecurityContext;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.WalUtils;
import io.questdb.cairo.wal.WalWriterMetadata;
import io.questdb.griffin.BatchCallback;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.CompiledQueryImpl;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.InsertRowImpl;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.OperatorRegistry;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.QueryBuilder;
import io.questdb.griffin.QueryRegistry;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.RecordToRowCopierUtils;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlParserCallback;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.QueryProgress;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.engine.ops.AlterOperationBuilder;
import io.questdb.griffin.engine.ops.CopyCancelFactory;
import io.questdb.griffin.engine.ops.CopyFactory;
import io.questdb.griffin.engine.ops.CreateMatViewOperation;
import io.questdb.griffin.engine.ops.CreateMatViewOperationBuilder;
import io.questdb.griffin.engine.ops.CreateTableOperation;
import io.questdb.griffin.engine.ops.CreateTableOperationBuilder;
import io.questdb.griffin.engine.ops.DropAllOperation;
import io.questdb.griffin.engine.ops.GenericDropOperation;
import io.questdb.griffin.engine.ops.GenericDropOperationBuilder;
import io.questdb.griffin.engine.ops.InsertAsSelectOperationImpl;
import io.questdb.griffin.engine.ops.InsertOperationImpl;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExplainModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseAsciiCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.Path;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompilerImpl
implements SqlCompiler,
Closeable,
SqlParserCallback {
    public static final String ALTER_TABLE_EXPECTED_TOKEN_DESCR = "'add', 'alter', 'attach', 'detach', 'drop', 'convert', 'resume', 'rename', 'set' or 'squash'";
    static final ObjList<String> sqlControlSymbols = new ObjList(8);
    private static final BatchCallback EMPTY_CALLBACK = new BatchCallback(){

        @Override
        public void postCompile(SqlCompiler compiler, CompiledQuery cq, CharSequence queryText) {
        }

        @Override
        public boolean preCompile(SqlCompiler compiler, CharSequence sqlText) {
            return true;
        }
    };
    private static final boolean[][] columnConversionSupport = new boolean[33][33];
    private static Log LOG = LogFactory.getLog(SqlCompilerImpl.class);
    protected final AlterOperationBuilder alterOperationBuilder;
    protected final SqlCodeGenerator codeGenerator;
    protected final CompiledQueryImpl compiledQuery;
    protected final CairoConfiguration configuration;
    protected final CairoEngine engine;
    protected final LowerCaseAsciiCharSequenceObjHashMap<KeywordBasedExecutor> keywordBasedExecutors = new LowerCaseAsciiCharSequenceObjHashMap();
    protected final GenericLexer lexer;
    protected final SqlOptimiser optimiser;
    protected final Path path;
    protected final QueryRegistry queryRegistry;
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final DatabaseBackupAgent backupAgent;
    private final BlockFileWriter blockFileWriter;
    private final CharacterStore characterStore;
    private final ObjList<CharSequence> columnNames = new ObjList();
    private final CharSequenceObjHashMap<String> dropAllTablesFailedTableNames = new CharSequenceObjHashMap();
    private final GenericDropOperationBuilder dropOperationBuilder;
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final FilesFacade ff;
    private final FunctionParser functionParser;
    private final ListColumnFilter listColumnFilter = new ListColumnFilter();
    private final int maxRecompileAttempts;
    private final MemoryMARW mem = Vm.getCMARWInstance();
    private final MessageBus messageBus;
    private final SqlParser parser;
    private final TimestampValueRecord partitionFunctionRec = new TimestampValueRecord();
    private final QueryBuilder queryBuilder;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final Path renamePath;
    private final ObjectPool<ExpressionNode> sqlNodePool;
    private final ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet();
    private final ObjList<TableWriterAPI> tableWriters = new ObjList();
    private final VacuumColumnVersions vacuumColumnVersions;
    protected CharSequence sqlText;
    private boolean closed = false;
    private long insertCount;
    private boolean isSingleQueryMode = true;

    public SqlCompilerImpl(CairoEngine engine) {
        try {
            this.path = new Path(255, 54);
            this.renamePath = new Path(255, 54);
            this.engine = engine;
            this.maxRecompileAttempts = engine.getConfiguration().getMaxSqlRecompileAttempts();
            this.queryBuilder = new QueryBuilder(this);
            this.configuration = engine.getConfiguration();
            this.ff = this.configuration.getFilesFacade();
            this.messageBus = engine.getMessageBus();
            this.sqlNodePool = new ObjectPool<ExpressionNode>(ExpressionNode.FACTORY, this.configuration.getSqlExpressionPoolCapacity());
            this.queryColumnPool = new ObjectPool<QueryColumn>(QueryColumn.FACTORY, this.configuration.getSqlColumnPoolCapacity());
            this.queryModelPool = new ObjectPool<QueryModel>(QueryModel.FACTORY, this.configuration.getSqlModelPoolCapacity());
            this.compiledQuery = new CompiledQueryImpl(engine);
            this.characterStore = new CharacterStore(this.configuration.getSqlCharacterStoreCapacity(), this.configuration.getSqlCharacterStoreSequencePoolCapacity());
            this.lexer = new GenericLexer(this.configuration.getSqlLexerPoolCapacity());
            this.functionParser = new FunctionParser(this.configuration, engine.getFunctionFactoryCache());
            this.codeGenerator = new SqlCodeGenerator(this.configuration, this.functionParser, this.sqlNodePool);
            this.vacuumColumnVersions = new VacuumColumnVersions(engine);
            this.functionParser.setSqlCodeGenerator(this.codeGenerator);
            this.backupAgent = new DatabaseBackupAgent();
            this.registerKeywordBasedExecutors();
            SqlCompilerImpl.configureLexer(this.lexer);
            PostOrderTreeTraversalAlgo postOrderTreeTraversalAlgo = new PostOrderTreeTraversalAlgo();
            this.optimiser = this.newSqlOptimiser(this.configuration, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo, this.functionParser, this.path);
            this.parser = new SqlParser(this.configuration, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo);
            this.alterOperationBuilder = new AlterOperationBuilder();
            this.dropOperationBuilder = new GenericDropOperationBuilder();
            this.queryRegistry = engine.getQueryRegistry();
            this.blockFileWriter = new BlockFileWriter(this.ff, this.configuration.getCommitMode());
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public static long copyOrderedBatched(TableWriterAPI writer, RecordMetadata metadata, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        long rowCount = ColumnType.isSymbolOrString(metadata.getColumnType(cursorTimestampIndex)) ? SqlCompilerImpl.copyOrderedBatchedStrTimestamp(writer, cursor, copier, cursorTimestampIndex, batchSize, o3MaxLag, circuitBreaker) : (metadata.getColumnType(cursorTimestampIndex) == 26 ? SqlCompilerImpl.copyOrderedBatchedVarcharTimestamp(writer, cursor, copier, cursorTimestampIndex, batchSize, o3MaxLag, circuitBreaker) : SqlCompilerImpl.copyOrderedBatched0(writer, cursor, copier, cursorTimestampIndex, batchSize, o3MaxLag, circuitBreaker));
        return rowCount;
    }

    public static long copyUnordered(RecordCursor cursor, TableWriterAPI writer, RecordToRowCopier copier, SqlExecutionCircuitBreaker circuitBreaker) {
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            TableWriter.Row row = writer.newRow();
            copier.copy(record, row);
            row.append();
            ++rowCount;
        }
        return rowCount;
    }

    public static void expectKeyword(GenericLexer lexer, CharSequence keyword) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(keyword).put("' expected");
        }
        if (!Chars.equalsLowerCaseAscii(tok, keyword)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(keyword).put("' expected");
        }
    }

    @Override
    public void clear() {
        this.clearExceptSqlText();
        this.sqlText = null;
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("close was already called");
        }
        this.closed = true;
        Misc.free(this.backupAgent);
        Misc.free(this.vacuumColumnVersions);
        Misc.free(this.path);
        Misc.free(this.renamePath);
        Misc.free(this.codeGenerator);
        Misc.free(this.mem);
        Misc.freeObjList(this.tableWriters);
        Misc.free(this.blockFileWriter);
    }

    @Override
    @NotNull
    public CompiledQuery compile(@NotNull CharSequence sqlText, @NotNull SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(sqlText);
        this.isSingleQueryMode = true;
        this.compileInner(executionContext, sqlText, true);
        return this.compiledQuery;
    }

    @Override
    public void compileBatch(@NotNull CharSequence batchText, @NotNull SqlExecutionContext executionContext, BatchCallback batchCallback) throws Exception {
        this.clear();
        this.lexer.of(batchText);
        this.isSingleQueryMode = false;
        if (batchCallback == null) {
            batchCallback = EMPTY_CALLBACK;
        }
        while (this.lexer.hasNext()) {
            int position = this.getNextValidTokenPosition();
            if (position == -1) {
                return;
            }
            boolean recompileStale = true;
            int retries = 0;
            while (recompileStale) {
                this.clear();
                CharSequence sqlText = batchText.subSequence(position, this.goToQueryEnd());
                if (batchCallback.preCompile(this, sqlText)) {
                    this.lexer.backTo(position, null);
                    this.compileInner(executionContext, sqlText, true);
                    this.goToQueryEnd();
                    try {
                        batchCallback.postCompile(this, this.compiledQuery, sqlText);
                        recompileStale = false;
                    }
                    catch (TableReferenceOutOfDateException e) {
                        if (retries == this.maxRecompileAttempts) {
                            throw e;
                        }
                        LOG.info().$safe(e.getFlyweightMessage()).$();
                        this.lexer.restart();
                    }
                } else {
                    recompileStale = false;
                }
                ++retries;
            }
        }
    }

    @Override
    public void execute(Operation op, SqlExecutionContext executionContext) throws SqlException {
        switch (op.getOperationCode()) {
            case 1: {
                this.executeCreateTable((CreateTableOperation)op, executionContext);
                break;
            }
            case 4: {
                this.executeCreateMatView((CreateMatViewOperation)op, executionContext);
                break;
            }
            case 2: {
                this.executeDropTable((GenericDropOperation)op, executionContext);
                break;
            }
            case 5: {
                this.executeDropMatView((GenericDropOperation)op, executionContext);
                break;
            }
            case 3: {
                this.executeDropAllTables(executionContext);
                break;
            }
            default: {
                throw SqlException.position(0).put("Unsupported operation [code=").put(op.getOperationCode()).put(']');
            }
        }
    }

    @Override
    public RecordCursorFactory generateSelectWithRetries(QueryModel initialQueryModel, @Nullable InsertModel insertModel, SqlExecutionContext executionContext, boolean generateProgressLogger) throws SqlException {
        QueryModel queryModel = initialQueryModel;
        int remainingRetries = this.maxRecompileAttempts;
        while (true) {
            try {
                return this.generateSelectOneShot(queryModel, executionContext, generateProgressLogger);
            }
            catch (TableReferenceOutOfDateException e) {
                if (--remainingRetries < 0) {
                    throw SqlException.position(0).put("too many ").put(e.getFlyweightMessage());
                }
                LOG.info().$("retrying plan [q=`").$(queryModel).$("`, fd=").$(executionContext.getRequestFd()).I$();
                this.clearExceptSqlText();
                this.lexer.restart();
                if (insertModel != null) {
                    queryModel = this.compileExecutionModel(executionContext).getQueryModel();
                    insertModel.setQueryModel(queryModel);
                    continue;
                }
                queryModel = (QueryModel)this.compileExecutionModel(executionContext);
                continue;
            }
            break;
        }
    }

    @Override
    public BytecodeAssembler getAsm() {
        return this.asm;
    }

    @Override
    public CairoEngine getEngine() {
        return this.engine;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionParser.getFunctionFactoryCache();
    }

    @Override
    public QueryBuilder query() {
        this.queryBuilder.clear();
        return this.queryBuilder;
    }

    @Override
    public void setEnableJitNullChecks(boolean value) {
        this.codeGenerator.setEnableJitNullChecks(value);
    }

    @Override
    public void setFullFatJoins(boolean value) {
        this.codeGenerator.setFullFatJoins(value);
    }

    @Override
    public ExecutionModel testCompileModel(CharSequence sqlText, SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(sqlText);
        return this.compileExecutionModel(executionContext);
    }

    @Override
    public ExpressionNode testParseExpression(CharSequence expression, QueryModel model) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        return this.parser.expr(this.lexer, model, (SqlParserCallback)this);
    }

    @Override
    public void testParseExpression(CharSequence expression, ExpressionParserListener listener) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        this.parser.expr(this.lexer, listener, (SqlParserCallback)this);
    }

    private static void addSupportedConversion(short fromType, short ... toTypes) {
        for (short toType : toTypes) {
            SqlCompilerImpl.columnConversionSupport[fromType][toType] = true;
            SqlCompilerImpl.columnConversionSupport[toType][fromType] = true;
        }
    }

    private static void configureLexer(GenericLexer lexer) {
        int k = sqlControlSymbols.size();
        for (int i = 0; i < k; ++i) {
            lexer.defineSymbol(sqlControlSymbols.getQuick(i));
        }
        OperatorRegistry registry = OperatorExpression.getRegistry();
        int k2 = registry.operators.size();
        for (int i = 0; i < k2; ++i) {
            OperatorExpression op = registry.operators.getQuick(i);
            if (!op.symbol) continue;
            lexer.defineSymbol(op.operator.token);
        }
    }

    private static long copyOrderedBatched0(TableWriterAPI writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        long commitTarget = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
            if (++rowCount < commitTarget) continue;
            writer.ic(o3MaxLag);
            commitTarget = rowCount + batchSize;
        }
        return rowCount;
    }

    private static long copyOrderedBatchedStrTimestamp(TableWriterAPI writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        long commitTarget = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            CharSequence str = record.getStrA(cursorTimestampIndex);
            long timestamp = SqlUtil.implicitCastStrAsTimestamp(str);
            TableWriter.Row row = writer.newRow(timestamp);
            copier.copy(record, row);
            row.append();
            if (++rowCount < commitTarget) continue;
            writer.ic(o3MaxLag);
            commitTarget = rowCount + batchSize;
        }
        return rowCount;
    }

    private static long copyOrderedBatchedVarcharTimestamp(TableWriterAPI writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        long commitTarget = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            Utf8Sequence varchar = record.getVarcharA(cursorTimestampIndex);
            long timestamp = varchar != null ? SqlUtil.implicitCastStrAsTimestamp(varchar.asAsciiCharSequence()) : Long.MIN_VALUE;
            TableWriter.Row row = writer.newRow(timestamp);
            copier.copy(record, row);
            row.append();
            if (++rowCount < commitTarget) continue;
            writer.ic(o3MaxLag);
            commitTarget = rowCount + batchSize;
        }
        return rowCount;
    }

    private static int estimateIndexValueBlockSizeFromReader(SqlExecutionContext executionContext, TableToken matViewToken, int columnIndex) {
        int indexValueBlockSize;
        try (TableReader reader = executionContext.getReader(matViewToken);){
            int symbolCount = reader.getSymbolMapReader(columnIndex).getSymbolCount();
            long v = Math.max(2L, reader.size() / (long)reader.getPartitionCount() / (long)symbolCount / 4L);
            indexValueBlockSize = (long)((int)v) != v ? 50000000 : (int)v;
        }
        return indexValueBlockSize;
    }

    private static boolean isIPv4UpdateCast(int from, int to) {
        return from == 11 && to == 25 || from == 25 && to == 11 || from == 26 && to == 25 || from == 25 && to == 26;
    }

    private int addColumnWithType(AlterOperationBuilder addColumn, CharSequence columnName, int columnNamePosition) throws SqlException {
        int indexValueBlockCapacity;
        boolean indexed;
        boolean cache;
        int symbolCapacity;
        int columnType;
        int typePosition;
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "column type");
        int typeTag = SqlUtil.toPersistedTypeTag(tok, this.lexer.lastTokenPosition());
        int dim = SqlUtil.parseArrayDimensionality(this.lexer, typeTag, typePosition = this.lexer.lastTokenPosition());
        if (dim > 0) {
            if (!ColumnType.isSupportedArrayElementType((short)typeTag)) {
                throw SqlException.position(typePosition).put("unsupported array element type [type=").put(ColumnType.nameOf(typeTag)).put(']');
            }
            columnType = ColumnType.encodeArrayType((short)typeTag, dim);
        } else {
            columnType = typeTag;
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && Chars.equals(tok, ']')) {
            throw SqlException.position(typePosition).put(columnName).put(" has an unmatched `]` - were you trying to define an array?");
        }
        this.lexer.unparseLast();
        if (columnType == 23) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok == null || tok.charAt(0) != '(') {
                throw SqlException.position(this.lexer.getPosition()).put("missing GEOHASH precision");
            }
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && tok.charAt(0) != ')') {
                int geoHashBits = GeoHashUtil.parseGeoHashBits(this.lexer.lastTokenPosition(), 0, tok);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || tok.charAt(0) != ')') {
                    if (tok != null) {
                        throw SqlException.position(this.lexer.lastTokenPosition()).put("invalid GEOHASH type literal, expected ')'").put(" found='").put(tok.charAt(0)).put("'");
                    }
                    throw SqlException.position(this.lexer.getPosition()).put("invalid GEOHASH type literal, expected ')'");
                }
                columnType = ColumnType.getGeoHashTypeWithBits(geoHashBits);
            } else {
                throw SqlException.position(this.lexer.lastTokenPosition()).put("missing GEOHASH precision");
            }
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (ColumnType.isSymbol(columnType) && tok != null && !Chars.equals(tok, ',') && !Chars.equals(tok, ';')) {
            if (SqlKeywords.isCapacityKeyword(tok)) {
                boolean negative;
                tok = SqlCompilerImpl.expectToken(this.lexer, "symbol capacity");
                int errorPos = this.lexer.lastTokenPosition();
                if (Chars.equals(tok, '-')) {
                    negative = true;
                    tok = SqlCompilerImpl.expectToken(this.lexer, "symbol capacity");
                } else {
                    negative = false;
                }
                try {
                    symbolCapacity = Numbers.parseInt(tok);
                }
                catch (NumericException e) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                }
                if (negative) {
                    symbolCapacity = -symbolCapacity;
                }
                TableUtils.validateSymbolCapacity(errorPos, symbolCapacity);
                tok = SqlUtil.fetchNext(this.lexer);
            } else {
                symbolCapacity = this.configuration.getDefaultSymbolCapacity();
            }
            if (Chars.equalsLowerCaseAsciiNc("cache", tok)) {
                cache = true;
                tok = SqlUtil.fetchNext(this.lexer);
            } else if (Chars.equalsLowerCaseAsciiNc("nocache", tok)) {
                cache = false;
                tok = SqlUtil.fetchNext(this.lexer);
            } else {
                cache = this.configuration.getDefaultSymbolCacheFlag();
            }
            TableUtils.validateSymbolCapacityCached(cache, symbolCapacity, this.lexer.lastTokenPosition());
            indexed = Chars.equalsLowerCaseAsciiNc("index", tok);
            if (indexed) {
                tok = SqlUtil.fetchNext(this.lexer);
            }
            if (Chars.equalsLowerCaseAsciiNc("capacity", tok)) {
                tok = SqlCompilerImpl.expectToken(this.lexer, "symbol index capacity");
                try {
                    indexValueBlockCapacity = Numbers.parseInt(tok);
                }
                catch (NumericException e) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                }
                SqlUtil.fetchNext(this.lexer);
            } else {
                indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
            }
        } else {
            if (tok != null && SqlKeywords.isNotKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
            }
            if (tok != null && SqlKeywords.isNullKeyword(tok)) {
                SqlUtil.fetchNext(this.lexer);
            }
            cache = this.configuration.getDefaultSymbolCacheFlag();
            indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
            symbolCapacity = this.configuration.getDefaultSymbolCapacity();
            indexed = false;
        }
        addColumn.addColumnToList(columnName, columnNamePosition, columnType, Numbers.ceilPow2(symbolCapacity), cache, indexed, Numbers.ceilPow2(indexValueBlockCapacity), false);
        this.lexer.unparseLast();
        return columnType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void alterTableAddColumn(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, TableRecordMetadata tableMetadata) throws SqlException {
        block11: {
            CharSequence tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && !SqlKeywords.isColumnKeyword(tok)) {
                this.lexer.unparseLast();
            }
            AlterOperationBuilder addColumn = this.alterOperationBuilder.ofAddColumn(tableNamePosition, tableToken, tableMetadata.getTableId());
            int semicolonPos = -1;
            do {
                tok = SqlCompilerImpl.maybeExpectToken(this.lexer, "'column' or column name", semicolonPos < 0);
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block11;
                }
                if (SqlKeywords.isIfKeyword(tok)) {
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok == null || !SqlKeywords.isNotKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'not' expected");
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok == null || !SqlKeywords.isExistsKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token '").put(tok).put("' for if not exists");
                    tok = SqlUtil.fetchNext(this.lexer);
                    int columnIndex = tableMetadata.getColumnIndexQuiet(tok);
                    if (columnIndex != -1) {
                        tok = SqlCompilerImpl.expectToken(this.lexer, "column type");
                        int columnType = ColumnType.typeOf(tok);
                        if (columnType == -1) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "unrecognized column type: ").put(tok);
                        }
                        int existingType = tableMetadata.getColumnType(columnIndex);
                        if (existingType != columnType) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "column already exists with a different column type [current type=").put(ColumnType.nameOf(existingType)).put(", requested type=").put(ColumnType.nameOf(columnType)).put(']');
                        }
                        break block11;
                    }
                } else {
                    int index = tableMetadata.getColumnIndexQuiet(tok);
                    if (index != -1) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "column '").put(tok).put("' already exists");
                    }
                }
                CharSequence columnName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                int columnNamePosition = this.lexer.lastTokenPosition();
                if (!TableUtils.isValidColumnName(columnName, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                this.addColumnWithType(addColumn, columnName, columnNamePosition);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block11;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            this.addColumnSuffix(securityContext, tok, tableToken, this.alterOperationBuilder);
            this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
            return;
        }
        this.addColumnSuffix(securityContext, null, tableToken, this.alterOperationBuilder);
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
        if (this.alterOperationBuilder.getExtraStrInfo().size() != 0) return;
        this.compiledQuery.done();
    }

    private void alterTableChangeColumnType(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, int columnNamePosition, CharSequence columnName, TableRecordMetadata tableMetadata, int columnIndex) throws SqlException {
        AlterOperationBuilder changeColumn = this.alterOperationBuilder.ofColumnChangeType(tableNamePosition, tableToken, tableMetadata.getTableId());
        int existingColumnType = tableMetadata.getColumnType(columnIndex);
        int newColumnType = this.addColumnWithType(changeColumn, columnName, columnNamePosition);
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !SqlKeywords.isSemicolon(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("] while trying to change column type");
        }
        if (columnIndex == tableMetadata.getTimestampIndex()) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "cannot change type of designated timestamp column");
        }
        if (newColumnType == existingColumnType) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "column '").put(columnName).put("' type is already '").put(ColumnType.nameOf(existingColumnType)).put('\'');
        }
        if (!this.isCompatibleColumnTypeChange(existingColumnType, newColumnType)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "incompatible column type change [existing=").put(ColumnType.nameOf(existingColumnType)).put(", new=").put(ColumnType.nameOf(newColumnType)).put(']');
        }
        securityContext.authorizeAlterTableAlterColumnType(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private void alterTableChangeSymbolCapacity(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, int columnNamePosition, CharSequence columnName, TableRecordMetadata tableMetadata, int columnIndex) throws SqlException {
        int symbolCapacity;
        boolean negative;
        AlterOperationBuilder changeColumn = this.alterOperationBuilder.ofSymbolCapacityChange(tableNamePosition, tableToken, tableMetadata.getTableId());
        int existingColumnType = tableMetadata.getColumnType(columnIndex);
        if (!ColumnType.isSymbol(existingColumnType)) {
            throw SqlException.walRecoverable(columnNamePosition).put("column '").put(columnName).put("' is not of symbol type");
        }
        SqlCompilerImpl.expectKeyword(this.lexer, "capacity");
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "numeric capacity");
        int errorPos = this.lexer.lastTokenPosition();
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = SqlCompilerImpl.expectToken(this.lexer, "numeric capacity");
        } else {
            negative = false;
        }
        try {
            symbolCapacity = Numbers.parseInt(tok);
        }
        catch (NumericException e) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
        }
        if (negative) {
            symbolCapacity = -symbolCapacity;
        }
        TableUtils.validateSymbolCapacity(errorPos, symbolCapacity);
        changeColumn.addColumnToList(columnName, columnNamePosition, 12, Numbers.ceilPow2(symbolCapacity), this.configuration.getDefaultSymbolCacheFlag(), false, Numbers.ceilPow2(this.configuration.getIndexValueBlockSize()), false);
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !SqlKeywords.isSemicolon(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("] while trying to change symbol capacity");
        }
        securityContext.authorizeAlterTableAlterColumnType(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private void alterTableColumnAddIndex(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, int columnNamePosition, CharSequence columnName, TableRecordMetadata metadata, int indexValueBlockSize) throws SqlException {
        int columnIndex = metadata.getColumnIndexQuiet(columnName);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(columnNamePosition, columnName);
        }
        int type = metadata.getColumnType(columnIndex);
        if (!ColumnType.isSymbol(type)) {
            throw SqlException.position(columnNamePosition).put("indexes are only supported for symbol type [column=").put(columnName).put(", type=").put(ColumnType.nameOf(type)).put(']');
        }
        if (indexValueBlockSize == -1) {
            indexValueBlockSize = this.configuration.getIndexValueBlockSize();
        }
        this.alterOperationBuilder.ofAddIndex(tableNamePosition, tableToken, metadata.getTableId(), columnName, Numbers.ceilPow2(indexValueBlockSize));
        securityContext.authorizeAlterTableAddIndex(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private void alterTableColumnCacheFlag(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, int columnNamePosition, CharSequence columnName, TableRecordMetadata metadata, boolean cache) throws SqlException {
        int columnIndex = metadata.getColumnIndexQuiet(columnName);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(columnNamePosition, columnName);
        }
        int type = metadata.getColumnType(columnIndex);
        if (!ColumnType.isSymbol(type)) {
            throw SqlException.position(columnNamePosition).put("cache is only supported for symbol type [column=").put(columnName).put(", type=").put(ColumnType.nameOf(type)).put(']');
        }
        if (cache) {
            this.alterOperationBuilder.ofCacheSymbol(tableNamePosition, tableToken, metadata.getTableId(), columnName);
        } else {
            this.alterOperationBuilder.ofRemoveCacheSymbol(tableNamePosition, tableToken, metadata.getTableId(), columnName);
        }
        securityContext.authorizeAlterTableAlterColumnCache(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private void alterTableColumnDropIndex(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, int columnNamePosition, CharSequence columnName, TableRecordMetadata metadata) throws SqlException {
        int columnIndex = metadata.getColumnIndexQuiet(columnName);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(columnNamePosition, columnName);
        }
        int type = metadata.getColumnType(columnIndex);
        if (!ColumnType.isSymbol(type)) {
            throw SqlException.position(columnNamePosition).put("indexes are only supported for symbol type [column=").put(columnName).put(", type=").put(ColumnType.nameOf(type)).put(']');
        }
        this.alterOperationBuilder.ofDropIndex(tableNamePosition, tableToken, metadata.getTableId(), columnName, columnNamePosition);
        securityContext.authorizeAlterTableDropIndex(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private void alterTableDedupEnable(int tableNamePosition, TableToken tableToken, TableRecordMetadata tableMetadata, GenericLexer lexer) throws SqlException {
        if (!tableMetadata.isWalEnabled()) {
            throw SqlException.$(tableNamePosition, "deduplication is only supported for WAL tables");
        }
        AlterOperationBuilder setDedup = this.alterOperationBuilder.ofDedupEnable(tableNamePosition, tableToken);
        CharSequence tok = SqlUtil.fetchNext(lexer);
        boolean tsIncludedInDedupColumns = false;
        if (tok != null && SqlKeywords.isEnableKeyword(tok)) {
            tok = SqlUtil.fetchNext(lexer);
        }
        if (tok == null || !SqlKeywords.isUpsertKeyword(tok)) {
            throw SqlException.position(lexer.lastTokenPosition()).put("expected 'upsert'");
        }
        tok = SqlUtil.fetchNext(lexer);
        if (tok == null || !SqlKeywords.isKeysKeyword(tok)) {
            throw SqlException.position(lexer.lastTokenPosition()).put("expected 'keys'");
        }
        tok = SqlUtil.fetchNext(lexer);
        if (tok != null && Chars.equals(tok, '(')) {
            tok = SqlUtil.fetchNext(lexer);
            int columnListPos = lexer.lastTokenPosition();
            while (tok != null && !Chars.equals(tok, ')')) {
                SqlKeywords.validateLiteral(lexer.lastTokenPosition(), tok);
                CharSequence columnName = GenericLexer.unquote(tok);
                int colIndex = tableMetadata.getColumnIndexQuiet(columnName);
                if (colIndex < 0) {
                    throw SqlException.position(lexer.lastTokenPosition()).put("deduplicate key column not found [column=").put(columnName).put(']');
                }
                if (colIndex == tableMetadata.getTimestampIndex()) {
                    tsIncludedInDedupColumns = true;
                }
                setDedup.setDedupKeyFlag(tableMetadata.getWriterIndex(colIndex));
                tok = SqlUtil.fetchNext(lexer);
                if (tok == null || !Chars.equals(tok, ',')) continue;
                tok = SqlUtil.fetchNext(lexer);
            }
            if (tok == null || !Chars.equals(tok, ')')) {
                throw SqlException.position(lexer.getPosition()).put("')' expected");
            }
            if (!tsIncludedInDedupColumns) {
                throw SqlException.position(columnListPos).put("deduplicate key list must include dedicated timestamp column");
            }
        } else {
            throw SqlException.$(lexer.getPosition(), "deduplicate key column list expected");
        }
        this.compiledQuery.ofAlter(setDedup.build());
    }

    private void alterTableDropColumn(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, TableRecordMetadata metadata) throws SqlException {
        AlterOperationBuilder dropColumnStatement;
        block4: {
            CharSequence tok;
            dropColumnStatement = this.alterOperationBuilder.ofDropColumn(tableNamePosition, tableToken, metadata.getTableId());
            int semicolonPos = -1;
            do {
                tok = GenericLexer.unquote(SqlCompilerImpl.maybeExpectToken(this.lexer, "column name", semicolonPos < 0));
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block4;
                }
                if (metadata.getColumnIndexQuiet(tok) == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                CharSequence columnName = tok;
                dropColumnStatement.ofDropColumn(columnName);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block4;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            this.unknownDropColumnSuffix(securityContext, tok, tableToken, dropColumnStatement);
            return;
        }
        securityContext.authorizeAlterTableDropColumn(tableToken, dropColumnStatement.getExtraStrInfo());
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterTableDropConvertDetachOrAttachPartition(TableRecordMetadata tableMetadata, TableToken tableToken, int action, SqlExecutionContext executionContext) throws SqlException {
        block19: {
            int pos = this.lexer.lastTokenPosition();
            TableReader reader = null;
            if (!tableMetadata.isWalEnabled() || executionContext.isWalApplication()) {
                reader = executionContext.getReader(tableToken);
            }
            try {
                if (reader != null && !PartitionBy.isPartitioned(reader.getMetadata().getPartitionBy())) {
                    throw SqlException.$(pos, "table is not partitioned");
                }
                CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'list' or 'where'");
                if (SqlKeywords.isListKeyword(tok)) {
                    this.alterTableDropConvertDetachOrAttachPartitionByList(tableMetadata, tableToken, reader, pos, action);
                    break block19;
                }
                if (SqlKeywords.isWhereKeyword(tok)) {
                    AlterOperationBuilder alterOperationBuilder;
                    switch (action) {
                        case 1: {
                            alterOperationBuilder = this.alterOperationBuilder.ofDropPartition(pos, tableToken, tableMetadata.getTableId());
                            break;
                        }
                        case 3: {
                            alterOperationBuilder = this.alterOperationBuilder.ofDetachPartition(pos, tableToken, tableMetadata.getTableId());
                            break;
                        }
                        case 4: 
                        case 5: {
                            boolean toParquet = action == 4;
                            alterOperationBuilder = this.alterOperationBuilder.ofConvertPartition(pos, tableToken, tableMetadata.getTableId(), toParquet);
                            break;
                        }
                        default: {
                            throw SqlException.$(pos, "WHERE clause can only be used with command DROP PARTITION, DETACH PARTITION or CONVERT PARTITION");
                        }
                    }
                    int functionPosition = this.lexer.getPosition();
                    ExpressionNode expr = this.parser.expr(this.lexer, (QueryModel)null, (SqlParserCallback)this);
                    String designatedTimestampColumnName = null;
                    int tsIndex = tableMetadata.getTimestampIndex();
                    if (tsIndex >= 0) {
                        designatedTimestampColumnName = tableMetadata.getColumnName(tsIndex);
                    }
                    if (designatedTimestampColumnName != null) {
                        GenericRecordMetadata metadata = new GenericRecordMetadata();
                        metadata.add(new TableColumnMetadata(designatedTimestampColumnName, 8, null));
                        Function function = this.functionParser.parseFunction(expr, metadata, executionContext);
                        try {
                            if (function != null && ColumnType.isBoolean(function.getType())) {
                                int affected;
                                function.init(null, executionContext);
                                if (reader != null && (affected = this.filterPartitions(function, functionPosition, reader, alterOperationBuilder)) == 0) {
                                    throw CairoException.partitionManipulationRecoverable().position(functionPosition).put("no partitions matched WHERE clause");
                                }
                                this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
                                break block19;
                            }
                            throw SqlException.$(this.lexer.lastTokenPosition(), "boolean expression expected");
                        }
                        finally {
                            Misc.free(function);
                        }
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "this table does not have a designated timestamp column");
                }
                throw SqlException.$(this.lexer.lastTokenPosition(), "'list' or 'where' expected");
            }
            finally {
                Misc.free(reader);
            }
        }
    }

    private void alterTableDropConvertDetachOrAttachPartitionByList(TableRecordMetadata tableMetadata, TableToken tableToken, @Nullable TableReader reader, int pos, int action) throws SqlException {
        AlterOperationBuilder alterOperationBuilder;
        block22: {
            CharSequence tok;
            switch (action) {
                case 4: 
                case 5: {
                    boolean toParquet = action == 4;
                    alterOperationBuilder = this.alterOperationBuilder.ofConvertPartition(pos, tableToken, tableMetadata.getTableId(), toParquet);
                    break;
                }
                case 1: {
                    alterOperationBuilder = this.alterOperationBuilder.ofDropPartition(pos, tableToken, tableMetadata.getTableId());
                    break;
                }
                case 6: {
                    alterOperationBuilder = this.alterOperationBuilder.ofForceDropPartition(pos, tableToken, tableMetadata.getTableId());
                    break;
                }
                case 3: {
                    alterOperationBuilder = this.alterOperationBuilder.ofDetachPartition(pos, tableToken, tableMetadata.getTableId());
                    break;
                }
                case 2: {
                    alterOperationBuilder = this.alterOperationBuilder.ofAttachPartition(pos, tableToken, tableMetadata.getTableId());
                    break;
                }
                default: {
                    alterOperationBuilder = null;
                    assert (false);
                    break;
                }
            }
            int semicolonPos = -1;
            do {
                int partitionBy;
                tok = SqlCompilerImpl.maybeExpectToken(this.lexer, "partition name", semicolonPos < 0);
                if (semicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
                    }
                    break block22;
                }
                if (Chars.equals(tok, ',') || Chars.equals(tok, ';')) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "partition name missing");
                }
                CharSequence partitionName = GenericLexer.unquote(tok);
                int lastPosition = this.lexer.lastTokenPosition();
                if (reader != null) {
                    partitionBy = reader.getPartitionedBy();
                } else {
                    try (TableMetadata meta = this.engine.getTableMetadata(tableToken);){
                        partitionBy = meta.getPartitionBy();
                    }
                }
                try {
                    int hi = action == 6 ? partitionName.length() : -1;
                    long timestamp = PartitionBy.parsePartitionDirName(partitionName, partitionBy, 0, hi);
                    alterOperationBuilder.addPartitionToList(timestamp, lastPosition);
                }
                catch (CairoException e) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), e.getFlyweightMessage());
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block22;
            } while ((semicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        this.compiledQuery.ofAlter(alterOperationBuilder.build());
    }

    private void alterTableRenameColumn(SecurityContext securityContext, int tableNamePosition, TableToken tableToken, TableRecordMetadata metadata) throws SqlException {
        block8: {
            CharSequence tok;
            AlterOperationBuilder renameColumnStatement = this.alterOperationBuilder.ofRenameColumn(tableNamePosition, tableToken, metadata.getTableId());
            int hadSemicolonPos = -1;
            do {
                tok = GenericLexer.unquote(SqlCompilerImpl.maybeExpectToken(this.lexer, "current column name", hadSemicolonPos < 0));
                if (hadSemicolonPos >= 0) {
                    if (tok != null) {
                        throw SqlException.$(hadSemicolonPos, "',' expected");
                    }
                    break block8;
                }
                int columnIndex = metadata.getColumnIndexQuiet(tok);
                if (columnIndex == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                CharSequence existingName = GenericLexer.immutableOf(tok);
                tok = SqlCompilerImpl.expectToken(this.lexer, "'to' expected");
                if (!SqlKeywords.isToKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'to' expected'");
                }
                tok = GenericLexer.unquote(SqlCompilerImpl.expectToken(this.lexer, "new column name"));
                if (Chars.equals(existingName, tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "new column name is identical to existing name");
                }
                if (metadata.getColumnIndexQuiet(tok) > -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " column already exists");
                }
                if (!TableUtils.isValidColumnName(tok, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                CharSequence newName = GenericLexer.immutableOf(tok);
                renameColumnStatement.ofRenameColumn(existingName, newName);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !this.isSingleQueryMode && SqlKeywords.isSemicolon(tok)) break block8;
            } while ((hadSemicolonPos = Chars.equals(tok, ';') ? this.lexer.lastTokenPosition() : -1) >= 0 || Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
        securityContext.authorizeAlterTableRenameColumn(tableToken, this.alterOperationBuilder.getExtraStrInfo());
        this.compiledQuery.ofAlter(this.alterOperationBuilder.build());
    }

    private void alterTableResume(int tableNamePosition, TableToken tableToken, long resumeFromTxn, SqlExecutionContext executionContext) {
        try {
            this.engine.getTableSequencerAPI().resumeTable(tableToken, resumeFromTxn);
            executionContext.storeTelemetry((short)108, (short)6);
            this.compiledQuery.ofTableResume();
        }
        catch (CairoException ex) {
            LOG.critical().$("table resume failed [table=").$(tableToken).$(", msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            ex.position(tableNamePosition);
            throw ex;
        }
    }

    private void alterTableSetParam(CharSequence paramName, CharSequence value, int paramNamePosition, TableToken tableToken, int tableNamePosition, int tableId) throws SqlException {
        if (SqlKeywords.isMaxUncommittedRowsKeyword(paramName)) {
            int maxUncommittedRows;
            try {
                maxUncommittedRows = Numbers.parseInt(value);
            }
            catch (NumericException e) {
                throw SqlException.$(paramNamePosition, "invalid value [value=").put(value).put(",parameter=").put(paramName).put(']');
            }
            if (maxUncommittedRows < 0) {
                throw SqlException.$(paramNamePosition, "maxUncommittedRows must be non negative");
            }
            this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSetParamUncommittedRows(tableNamePosition, tableToken, tableId, maxUncommittedRows).build());
        } else if (SqlKeywords.isO3MaxLagKeyword(paramName)) {
            long o3MaxLag = SqlUtil.expectMicros(value, paramNamePosition);
            if (o3MaxLag < 0L) {
                throw SqlException.$(paramNamePosition, "o3MaxLag must be non negative");
            }
            this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSetO3MaxLag(tableNamePosition, tableToken, tableId, o3MaxLag).build());
        } else {
            throw SqlException.$(paramNamePosition, "unknown parameter '").put(paramName).put('\'');
        }
    }

    private void alterTableSetType(SqlExecutionContext executionContext, int pos, TableToken tableToken, byte walFlag) throws SqlException {
        executionContext.getSecurityContext().authorizeAlterTableSetType(tableToken);
        try {
            try (TableReader reader = this.engine.getReader(tableToken);){
                if (reader != null && !PartitionBy.isPartitioned(reader.getMetadata().getPartitionBy())) {
                    throw SqlException.$(pos, "Cannot convert non-partitioned table");
                }
            }
            this.path.of(this.configuration.getDbRoot()).concat(tableToken.getDirName());
            TableUtils.createConvertFile(this.ff, this.path, walFlag);
            this.compiledQuery.ofTableSetType();
        }
        catch (CairoException e) {
            throw SqlException.position(pos).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private void alterTableSuspend(int tableNamePosition, TableToken tableToken, ErrorTag errorTag, String errorMessage, SqlExecutionContext executionContext) {
        try {
            this.engine.getTableSequencerAPI().suspendTable(tableToken, errorTag, errorMessage);
            executionContext.storeTelemetry((short)107, (short)6);
            this.compiledQuery.ofTableSuspend();
        }
        catch (CairoException ex) {
            LOG.critical().$("table suspend failed [table=").$(tableToken).$(", error=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            ex.position(tableNamePosition);
            throw ex;
        }
    }

    private CharSequence authorizeInsertForCopy(SecurityContext securityContext, CopyModel model) {
        CharSequence tableName = GenericLexer.unquote(model.getTableName());
        TableToken tt = this.engine.getTableTokenIfExists(tableName);
        if (tt != null) {
            securityContext.authorizeInsert(tt);
        }
        return tableName;
    }

    private void checkMatViewModification(ExecutionModel executionModel) throws SqlException {
        CharSequence name = executionModel.getTableName();
        TableToken tableToken = this.engine.getTableTokenIfExists(name);
        if (tableToken != null && tableToken.isMatView()) {
            throw SqlException.position(executionModel.getTableNameExpr().position).put("cannot modify materialized view [view=").put(name).put(']');
        }
    }

    private void checkMatViewModification(TableToken tableToken) throws SqlException {
        if (tableToken != null && tableToken.isMatView()) {
            throw SqlException.position(this.lexer.lastTokenPosition()).put("cannot modify materialized view [view=").put(tableToken.getTableName()).put(']');
        }
    }

    private void clearExceptSqlText() {
        this.sqlNodePool.clear();
        this.characterStore.clear();
        this.queryColumnPool.clear();
        this.queryModelPool.clear();
        this.optimiser.clear();
        this.parser.clear();
        this.backupAgent.clear();
        this.alterOperationBuilder.clear();
        this.functionParser.clear();
        this.compiledQuery.clear();
        this.columnNames.clear();
    }

    private void compileAlter(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isTableKeyword(tok) && !SqlKeywords.isMaterializedKeyword(tok)) {
            this.compileAlterExt(executionContext, tok);
            return;
        }
        if (SqlKeywords.isTableKeyword(tok)) {
            this.compileAlterTable(executionContext);
        } else {
            this.compileAlterMatView(executionContext);
        }
    }

    private void compileAlterMatView(SqlExecutionContext executionContext) throws SqlException {
        block60: {
            CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'view'");
            if (!SqlKeywords.isViewKeyword(tok)) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "'view' expected'");
            }
            int matViewNamePosition = this.lexer.getPosition();
            tok = SqlCompilerImpl.expectToken(this.lexer, "materialized view name");
            SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, matViewNamePosition);
            TableToken matViewToken = this.tableExistsOrFail(matViewNamePosition, GenericLexer.unquote(tok), executionContext);
            if (!matViewToken.isMatView()) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "materialized view name expected");
            }
            SecurityContext securityContext = executionContext.getSecurityContext();
            MatViewDefinition viewDefinition = this.engine.getMatViewGraph().getViewDefinition(matViewToken);
            if (viewDefinition == null) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "materialized view does not exist");
            }
            try (TableMetadata tableMetadata = this.engine.getTableMetadata(matViewToken);){
                tok = SqlCompilerImpl.expectToken(this.lexer, "'alter' or 'resume' or 'suspend'");
                if (SqlKeywords.isAlterKeyword(tok)) {
                    SqlCompilerImpl.expectKeyword(this.lexer, "column");
                    int columnNamePosition = this.lexer.getPosition();
                    tok = SqlCompilerImpl.expectToken(this.lexer, "column name");
                    CharSequence columnName = GenericLexer.immutableOf(tok);
                    int columnIndex = tableMetadata.getColumnIndexQuiet(columnName);
                    if (columnIndex == -1) {
                        throw SqlException.walRecoverable(columnNamePosition).put("column '").put(columnName).put("' does not exist in materialized view '").put(matViewToken.getTableName()).put('\'');
                    }
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'symbol capacity', 'add index' or 'drop index'");
                    if (SqlKeywords.isSymbolKeyword(tok)) {
                        this.alterTableChangeSymbolCapacity(securityContext, matViewNamePosition, matViewToken, columnNamePosition, columnName, tableMetadata, columnIndex);
                        break block60;
                    }
                    if (SqlKeywords.isAddKeyword(tok)) {
                        boolean sizeInferred;
                        int indexValueBlockSize;
                        SqlCompilerImpl.expectKeyword(this.lexer, "index");
                        if (tableMetadata.isColumnIndexed(columnIndex)) {
                            throw SqlException.walRecoverable(columnNamePosition).put("column '").put(columnName).put("' already indexed");
                        }
                        int columnType = tableMetadata.getColumnType(columnIndex);
                        if (columnType != 12) {
                            throw SqlException.walRecoverable(columnNamePosition).put("column '").put(columnName).put("' is of type '").put(ColumnType.nameOf(columnType)).put("'. Index supports column type 'SYMBOL' only.");
                        }
                        tok = SqlUtil.fetchNext(this.lexer);
                        if (tok == null) {
                            indexValueBlockSize = SqlCompilerImpl.estimateIndexValueBlockSizeFromReader(executionContext, matViewToken, columnIndex);
                            sizeInferred = true;
                        } else {
                            if (!SqlKeywords.isCapacityKeyword(tok)) {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "'capacity' keyword expected");
                            }
                            tok = SqlCompilerImpl.expectToken(this.lexer, "index capacity value");
                            try {
                                indexValueBlockSize = Numbers.parseInt(tok);
                                sizeInferred = false;
                            }
                            catch (NumericException e) {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "index capacity value must be numeric");
                            }
                        }
                        LOG.info().$("adding mat view index [viewName=").$(matViewToken).$(", column=").$safe(columnName).$(", indexValueBlockSize=").$(indexValueBlockSize).$(", sizeInferred=").$(sizeInferred).I$();
                        this.alterTableColumnAddIndex(securityContext, matViewNamePosition, matViewToken, columnNamePosition, columnName, tableMetadata, indexValueBlockSize);
                        break block60;
                    }
                    if (SqlKeywords.isDropKeyword(tok)) {
                        SqlCompilerImpl.expectKeyword(this.lexer, "index");
                        if (!tableMetadata.isColumnIndexed(columnIndex)) {
                            throw SqlException.walRecoverable(columnNamePosition).put("column '").put(columnName).put("' is not indexed");
                        }
                        this.alterTableColumnDropIndex(securityContext, matViewNamePosition, matViewToken, columnNamePosition, columnName, tableMetadata);
                        break block60;
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'symbol capacity', 'add index' or 'drop index' expected");
                }
                if (SqlKeywords.isSetKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'ttl' or 'refresh'");
                    if (SqlKeywords.isTtlKeyword(tok)) {
                        int ttlValuePos = this.lexer.getPosition();
                        int ttlHoursOrMonths = SqlParser.parseTtlHoursOrMonths(this.lexer);
                        try (TableMetadata matViewMeta = this.engine.getTableMetadata(matViewToken);){
                            PartitionBy.validateTtlGranularity(matViewMeta.getPartitionBy(), ttlHoursOrMonths, ttlValuePos);
                        }
                        AlterOperationBuilder setTtl = this.alterOperationBuilder.ofSetTtl(matViewNamePosition, matViewToken, tableMetadata.getTableId(), ttlHoursOrMonths);
                        this.compiledQuery.ofAlter(setTtl.build());
                        break block60;
                    }
                    if (SqlKeywords.isRefreshKeyword(tok)) {
                        tok = SqlCompilerImpl.expectToken(this.lexer, "'immediate' or 'manual' or 'period' or 'every' or 'limit'");
                        if (SqlKeywords.isLimitKeyword(tok)) {
                            int limitHoursOrMonths = SqlParser.parseTtlHoursOrMonths(this.lexer);
                            AlterOperationBuilder setRefreshLimit = this.alterOperationBuilder.ofSetMatViewRefreshLimit(matViewNamePosition, matViewToken, tableMetadata.getTableId(), limitHoursOrMonths);
                            this.compiledQuery.ofAlter(setRefreshLimit.build());
                            break block60;
                        }
                        if (SqlKeywords.isImmediateKeyword(tok) || SqlKeywords.isManualKeyword(tok) || SqlKeywords.isEveryKeyword(tok) || SqlKeywords.isPeriodKeyword(tok)) {
                            int refreshType = 0;
                            int every = 0;
                            char everyUnit = '\u0000';
                            long start = Long.MIN_VALUE;
                            String tz = null;
                            TimeZoneRules tzRules = null;
                            int length = 0;
                            char lengthUnit = '\u0000';
                            int delay = 0;
                            char delayUnit = '\u0000';
                            if (SqlKeywords.isImmediateKeyword(tok)) {
                                tok = SqlUtil.fetchNext(this.lexer);
                            } else if (SqlKeywords.isManualKeyword(tok)) {
                                refreshType = 2;
                                tok = SqlUtil.fetchNext(this.lexer);
                            } else if (SqlKeywords.isEveryKeyword(tok)) {
                                tok = SqlCompilerImpl.expectToken(this.lexer, "interval");
                                every = Timestamps.getStrideMultiple(tok, this.lexer.lastTokenPosition());
                                everyUnit = Timestamps.getStrideUnit(tok, this.lexer.lastTokenPosition());
                                SqlParser.validateMatViewEveryUnit(everyUnit, this.lexer.lastTokenPosition());
                                refreshType = 1;
                                tok = SqlUtil.fetchNext(this.lexer);
                            }
                            if (tok != null && SqlKeywords.isPeriodKeyword(tok)) {
                                SqlCompilerImpl.expectKeyword(this.lexer, "(");
                                SqlCompilerImpl.expectKeyword(this.lexer, "length");
                                tok = SqlCompilerImpl.expectToken(this.lexer, "LENGTH interval");
                                length = Timestamps.getStrideMultiple(tok, this.lexer.lastTokenPosition());
                                lengthUnit = Timestamps.getStrideUnit(tok, this.lexer.lastTokenPosition());
                                SqlParser.validateMatViewLength(length, lengthUnit, this.lexer.lastTokenPosition());
                                TimestampSampler periodSampler = TimestampSamplerFactory.getInstance((long)length, lengthUnit, this.lexer.lastTokenPosition());
                                tok = SqlCompilerImpl.expectToken(this.lexer, "'time zone' or 'delay' or ')'");
                                if (SqlKeywords.isTimeKeyword(tok)) {
                                    SqlCompilerImpl.expectKeyword(this.lexer, "zone");
                                    tok = SqlCompilerImpl.expectToken(this.lexer, "TIME ZONE name");
                                    if (Chars.equals(tok, ')') || SqlKeywords.isDelayKeyword(tok)) {
                                        throw SqlException.position(this.lexer.lastTokenPosition()).put("TIME ZONE name expected");
                                    }
                                    tz = GenericLexer.unquote(tok).toString();
                                    try {
                                        tzRules = Timestamps.getTimezoneRules(TimestampFormatUtils.EN_LOCALE, tz);
                                    }
                                    catch (NumericException e) {
                                        throw SqlException.position(this.lexer.lastTokenPosition()).put("invalid timezone: ").put(tz);
                                    }
                                    tok = SqlCompilerImpl.expectToken(this.lexer, "'delay' or ')'");
                                }
                                if (SqlKeywords.isDelayKeyword(tok)) {
                                    tok = SqlCompilerImpl.expectToken(this.lexer, "DELAY interval");
                                    delay = Timestamps.getStrideMultiple(tok, this.lexer.lastTokenPosition());
                                    delayUnit = Timestamps.getStrideUnit(tok, this.lexer.lastTokenPosition());
                                    SqlParser.validateMatViewDelay(length, lengthUnit, delay, delayUnit, this.lexer.lastTokenPosition());
                                    tok = SqlCompilerImpl.expectToken(this.lexer, "')'");
                                }
                                if (!Chars.equals(tok, ')')) {
                                    throw SqlException.position(this.lexer.lastTokenPosition()).put("')' expected");
                                }
                                long now = this.configuration.getMicrosecondClock().getTicks();
                                long nowLocal = tzRules != null ? now + tzRules.getOffset(now) : now;
                                start = periodSampler.round(nowLocal);
                                tok = SqlUtil.fetchNext(this.lexer);
                            } else if (refreshType == 1) {
                                if (tok != null && SqlKeywords.isStartKeyword(tok)) {
                                    tok = SqlCompilerImpl.expectToken(this.lexer, "START timestamp");
                                    try {
                                        start = IntervalUtils.parseFloorPartialTimestamp(GenericLexer.unquote(tok));
                                    }
                                    catch (NumericException e) {
                                        throw SqlException.$(this.lexer.lastTokenPosition(), "invalid START timestamp value");
                                    }
                                    tok = SqlCompilerImpl.maybeExpectToken(this.lexer, "'time zone'", false);
                                    if (SqlKeywords.isTimeKeyword(tok)) {
                                        SqlCompilerImpl.expectKeyword(this.lexer, "zone");
                                        tok = SqlCompilerImpl.expectToken(this.lexer, "TIME ZONE name");
                                        tz = GenericLexer.unquote(tok).toString();
                                        try {
                                            Timestamps.getTimezoneRules(TimestampFormatUtils.EN_LOCALE, tz);
                                        }
                                        catch (NumericException e) {
                                            throw SqlException.position(this.lexer.lastTokenPosition()).put("invalid timezone: ").put(tz);
                                        }
                                        tok = SqlUtil.fetchNext(this.lexer);
                                    }
                                } else {
                                    start = this.configuration.getMicrosecondClock().getTicks();
                                }
                            }
                            if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                                throw SqlException.unexpectedToken(this.lexer.lastTokenPosition(), tok);
                            }
                            AlterOperationBuilder setTimer = this.alterOperationBuilder.ofSetMatViewRefresh(matViewNamePosition, matViewToken, tableMetadata.getTableId(), refreshType, every, everyUnit, start, tz, length, lengthUnit, delay, delayUnit);
                            this.compiledQuery.ofAlter(setTimer.build());
                            break block60;
                        }
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'immediate' or 'manual' or 'period' or 'every' or 'limit' expected");
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'ttl' or 'refresh' or 'start' expected");
                }
                if (SqlKeywords.isResumeKeyword(tok)) {
                    this.parseResumeWal(matViewToken, matViewNamePosition, executionContext);
                    break block60;
                }
                if (SqlKeywords.isSuspendKeyword(tok)) {
                    this.parseSuspendWal(matViewToken, matViewNamePosition, executionContext);
                    break block60;
                }
                throw SqlException.$(this.lexer.lastTokenPosition(), "'alter' or 'resume' or 'suspend' expected");
            }
            catch (CairoException e) {
                LOG.info().$("could not alter materialized view [view=").$(matViewToken.getTableName()).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                if (e.getPosition() == 0) {
                    e.position(this.lexer.lastTokenPosition());
                }
                throw e;
            }
        }
    }

    private void compileAlterTable(SqlExecutionContext executionContext) throws SqlException {
        block67: {
            int tableNamePosition = this.lexer.getPosition();
            CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "table name");
            SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, tableNamePosition);
            TableToken tableToken = this.tableExistsOrFail(tableNamePosition, GenericLexer.unquote(tok), executionContext);
            this.checkMatViewModification(tableToken);
            SecurityContext securityContext = executionContext.getSecurityContext();
            try (TableRecordMetadata tableMetadata = executionContext.getMetadataForWrite(tableToken);){
                tok = SqlCompilerImpl.expectToken(this.lexer, ALTER_TABLE_EXPECTED_TOKEN_DESCR);
                if (SqlKeywords.isAddKeyword(tok)) {
                    securityContext.authorizeAlterTableAddColumn(tableToken);
                    this.alterTableAddColumn(executionContext.getSecurityContext(), tableNamePosition, tableToken, tableMetadata);
                    break block67;
                }
                if (SqlKeywords.isConvertKeyword(tok)) {
                    int action;
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'partition'");
                    if (!SqlKeywords.isPartitionKeyword(tok)) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                    }
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'to'");
                    if (!SqlKeywords.isToKeyword(tok)) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'to' expected");
                    }
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'parquet' or 'native'");
                    if (SqlKeywords.isParquetKeyword(tok)) {
                        action = 4;
                    } else if (SqlKeywords.isNativeKeyword(tok)) {
                        action = 5;
                    } else {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'parquet' or 'native' expected");
                    }
                    this.alterTableDropConvertDetachOrAttachPartition(tableMetadata, tableToken, action, executionContext);
                    break block67;
                }
                if (SqlKeywords.isDropKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'column' or 'partition'");
                    if (SqlKeywords.isColumnKeyword(tok)) {
                        this.alterTableDropColumn(executionContext.getSecurityContext(), tableNamePosition, tableToken, tableMetadata);
                        break block67;
                    }
                    if (SqlKeywords.isPartitionKeyword(tok)) {
                        securityContext.authorizeAlterTableDropPartition(tableToken);
                        this.alterTableDropConvertDetachOrAttachPartition(tableMetadata, tableToken, 1, executionContext);
                        break block67;
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                }
                if (SqlKeywords.isRenameKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'column'");
                    if (SqlKeywords.isColumnKeyword(tok)) {
                        this.alterTableRenameColumn(securityContext, tableNamePosition, tableToken, tableMetadata);
                        break block67;
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'column' expected");
                }
                if (SqlKeywords.isAttachKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'partition'");
                    if (SqlKeywords.isPartitionKeyword(tok)) {
                        securityContext.authorizeAlterTableAttachPartition(tableToken);
                        this.alterTableDropConvertDetachOrAttachPartition(tableMetadata, tableToken, 2, executionContext);
                        break block67;
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                }
                if (SqlKeywords.isDetachKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'partition'");
                    if (SqlKeywords.isPartitionKeyword(tok)) {
                        securityContext.authorizeAlterTableDetachPartition(tableToken);
                        this.alterTableDropConvertDetachOrAttachPartition(tableMetadata, tableToken, 3, executionContext);
                        break block67;
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                }
                if (SqlKeywords.isForceKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'drop'");
                    if (SqlKeywords.isDropKeyword(tok)) {
                        tok = SqlCompilerImpl.expectToken(this.lexer, "'partition'");
                        if (SqlKeywords.isPartitionKeyword(tok)) {
                            tok = SqlCompilerImpl.expectToken(this.lexer, "'list'");
                            if (SqlKeywords.isListKeyword(tok)) {
                                securityContext.authorizeAlterTableDropPartition(tableToken);
                                this.alterTableDropConvertDetachOrAttachPartitionByList(tableMetadata, tableToken, null, this.lexer.lastTokenPosition(), 6);
                                break block67;
                            }
                            throw SqlException.$(this.lexer.lastTokenPosition(), "'list' expected");
                        }
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'partition' expected");
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'drop' expected");
                }
                if (SqlKeywords.isAlterKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'column'");
                    if (SqlKeywords.isColumnKeyword(tok)) {
                        int columnNamePosition = this.lexer.getPosition();
                        tok = SqlCompilerImpl.expectToken(this.lexer, "column name");
                        CharSequence columnName = GenericLexer.immutableOf(tok);
                        int columnIndex = tableMetadata.getColumnIndexQuiet(columnName);
                        if (columnIndex == -1) {
                            throw SqlException.walRecoverable(columnNamePosition).put("column '").put(columnName).put("' does not exist in table '").put(tableToken.getTableName()).put('\'');
                        }
                        tok = SqlCompilerImpl.expectToken(this.lexer, "'add index' or 'drop index' or 'type' or 'cache' or 'nocache' or 'symbol'");
                        if (SqlKeywords.isAddKeyword(tok)) {
                            SqlCompilerImpl.expectKeyword(this.lexer, "index");
                            tok = SqlUtil.fetchNext(this.lexer);
                            int indexValueCapacity = -1;
                            if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                                if (!SqlKeywords.isCapacityKeyword(tok)) {
                                    throw SqlException.$(this.lexer.lastTokenPosition(), "'capacity' expected");
                                }
                                tok = SqlCompilerImpl.expectToken(this.lexer, "capacity value");
                                try {
                                    indexValueCapacity = Numbers.parseInt(tok);
                                    if (indexValueCapacity <= 0) {
                                        throw SqlException.$(this.lexer.lastTokenPosition(), "positive integer literal expected as index capacity");
                                    }
                                }
                                catch (NumericException e) {
                                    throw SqlException.$(this.lexer.lastTokenPosition(), "positive integer literal expected as index capacity");
                                }
                            }
                            this.alterTableColumnAddIndex(securityContext, tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata, indexValueCapacity);
                            break block67;
                        }
                        if (SqlKeywords.isDropKeyword(tok)) {
                            SqlCompilerImpl.expectKeyword(this.lexer, "index");
                            tok = SqlUtil.fetchNext(this.lexer);
                            if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("] while trying to drop index");
                            }
                            this.alterTableColumnDropIndex(securityContext, tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata);
                            break block67;
                        }
                        if (SqlKeywords.isCacheKeyword(tok)) {
                            this.alterTableColumnCacheFlag(securityContext, tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata, true);
                            break block67;
                        }
                        if (SqlKeywords.isNoCacheKeyword(tok)) {
                            this.alterTableColumnCacheFlag(securityContext, tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata, false);
                            break block67;
                        }
                        if (SqlKeywords.isTypeKeyword(tok)) {
                            this.alterTableChangeColumnType(securityContext, tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata, columnIndex);
                            break block67;
                        }
                        if (SqlKeywords.isSymbolKeyword(tok)) {
                            this.alterTableChangeSymbolCapacity(securityContext, tableNamePosition, tableToken, columnNamePosition, columnName, tableMetadata, columnIndex);
                            break block67;
                        }
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'add', 'drop', 'symbol', 'cache' or 'nocache' expected").put(" found '").put(tok).put('\'');
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                }
                if (SqlKeywords.isSetKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'param', 'ttl' or 'type'");
                    if (SqlKeywords.isParamKeyword(tok)) {
                        int paramNamePosition = this.lexer.getPosition();
                        tok = SqlCompilerImpl.expectToken(this.lexer, "param name");
                        CharSequence paramName = GenericLexer.immutableOf(tok);
                        tok = SqlCompilerImpl.expectToken(this.lexer, "'='");
                        if (tok.length() == 1 && tok.charAt(0) == '=') {
                            CharSequence value = GenericLexer.immutableOf(SqlUtil.fetchNext(this.lexer));
                            this.alterTableSetParam(paramName, value, paramNamePosition, tableToken, tableNamePosition, tableMetadata.getTableId());
                            break block67;
                        }
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'=' expected");
                    }
                    if (SqlKeywords.isTtlKeyword(tok)) {
                        int ttlValuePos = this.lexer.getPosition();
                        int ttlHoursOrMonths = SqlParser.parseTtlHoursOrMonths(this.lexer);
                        try (MetadataCacheReader metadataRO = this.engine.getMetadataCache().readLock();){
                            CairoTable table = metadataRO.getTable(tableToken);
                            assert (table != null) : "CairoTable == null after we already checked it exists";
                            PartitionBy.validateTtlGranularity(table.getPartitionBy(), ttlHoursOrMonths, ttlValuePos);
                        }
                        AlterOperationBuilder setTtl = this.alterOperationBuilder.ofSetTtl(tableNamePosition, tableToken, tableMetadata.getTableId(), ttlHoursOrMonths);
                        this.compiledQuery.ofAlter(setTtl.build());
                        break block67;
                    }
                    if (SqlKeywords.isTypeKeyword(tok)) {
                        tok = SqlCompilerImpl.expectToken(this.lexer, "'bypass' or 'wal'");
                        if (SqlKeywords.isBypassKeyword(tok)) {
                            tok = SqlCompilerImpl.expectToken(this.lexer, "'wal'");
                            if (SqlKeywords.isWalKeyword(tok)) {
                                this.alterTableSetType(executionContext, tableNamePosition, tableToken, (byte)0);
                                break block67;
                            }
                            throw SqlException.$(this.lexer.lastTokenPosition(), "'wal' expected");
                        }
                        if (SqlKeywords.isWalKeyword(tok)) {
                            this.alterTableSetType(executionContext, tableNamePosition, tableToken, (byte)1);
                            break block67;
                        }
                        throw SqlException.$(this.lexer.lastTokenPosition(), "'bypass' or 'wal' expected");
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'param' or 'type' expected");
                }
                if (SqlKeywords.isResumeKeyword(tok)) {
                    this.parseResumeWal(tableToken, tableNamePosition, executionContext);
                    break block67;
                }
                if (SqlKeywords.isSuspendKeyword(tok)) {
                    this.parseSuspendWal(tableToken, tableNamePosition, executionContext);
                    break block67;
                }
                if (SqlKeywords.isSquashKeyword(tok)) {
                    securityContext.authorizeAlterTableDropPartition(tableToken);
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'partitions'");
                    if (SqlKeywords.isPartitionsKeyword(tok)) {
                        this.compiledQuery.ofAlter(this.alterOperationBuilder.ofSquashPartitions(tableNamePosition, tableToken).build());
                        break block67;
                    }
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'partitions' expected");
                }
                if (SqlKeywords.isDedupKeyword(tok) || SqlKeywords.isDeduplicateKeyword(tok)) {
                    tok = SqlCompilerImpl.expectToken(this.lexer, "'dedup columns'");
                    if (SqlKeywords.isDisableKeyword(tok)) {
                        executionContext.getSecurityContext().authorizeAlterTableDedupDisable(tableToken);
                        AlterOperationBuilder setDedup = this.alterOperationBuilder.ofDedupDisable(tableNamePosition, tableToken);
                        this.compiledQuery.ofAlter(setDedup.build());
                    } else {
                        this.lexer.unparseLast();
                        executionContext.getSecurityContext().authorizeAlterTableDedupEnable(tableToken);
                        this.alterTableDedupEnable(tableNamePosition, tableToken, tableMetadata, this.lexer);
                    }
                    break block67;
                }
                throw SqlException.$(this.lexer.lastTokenPosition(), ALTER_TABLE_EXPECTED_TOKEN_DESCR).put(" expected");
            }
            catch (CairoException e) {
                LOG.info().$("could not alter table [table=").$(tableToken.getTableName()).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                if (e.getPosition() == 0) {
                    e.position(this.lexer.lastTokenPosition());
                }
                throw e;
            }
        }
    }

    private void compileBegin(SqlExecutionContext executionContext, CharSequence sqlText) {
        this.compiledQuery.ofBegin();
    }

    private void compileCancel(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isQueryKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'QUERY' expected'");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        int position = this.lexer.lastTokenPosition();
        try {
            long queryId = Numbers.parseLong(tok);
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                throw SqlException.unexpectedToken(this.lexer.lastTokenPosition(), tok);
            }
            try {
                if (!executionContext.getCairoEngine().getQueryRegistry().cancel(queryId, executionContext)) {
                    throw SqlException.$(position, "query to cancel not found in registry [id=").put(queryId).put(']');
                }
            }
            catch (CairoException e) {
                throw SqlException.$(position, e.getFlyweightMessage());
            }
            this.compiledQuery.ofCancelQuery();
        }
        catch (NumericException e) {
            throw SqlException.$(position, "non-negative integer literal expected as query id");
        }
    }

    private void compileCheckpoint(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        executionContext.getSecurityContext().authorizeDatabaseSnapshot();
        executionContext.getCircuitBreaker().resetTimer();
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'create' or 'release'");
        if (SqlKeywords.isCreateKeyword(tok)) {
            this.engine.checkpointCreate(executionContext);
            this.compiledQuery.ofCheckpointCreate();
        } else if (Chars.equalsLowerCaseAscii(tok, "release")) {
            this.engine.checkpointRelease();
            this.compiledQuery.ofCheckpointRelease();
        } else {
            throw SqlException.position(this.lexer.lastTokenPosition()).put("'create' or 'release' expected");
        }
    }

    private void compileCommit(SqlExecutionContext executionContext, CharSequence sqlText) {
        this.compiledQuery.ofCommit();
    }

    private RecordCursorFactory compileCopy(SecurityContext securityContext, CopyModel model) throws SqlException {
        ExpressionNode fileNameNode;
        CharSequence fileName;
        assert (!model.isCancel());
        CharSequence tableName = this.authorizeInsertForCopy(securityContext, model);
        if (model.getTimestampColumnName() == null && model.getPartitionBy() != -1 && model.getPartitionBy() != 3) {
            throw SqlException.$(-1, "invalid option used for import without a designated timestamp (format or partition by)");
        }
        if (model.getDelimiter() < 0) {
            model.setDelimiter((byte)44);
        }
        CharSequence charSequence = fileName = (fileNameNode = model.getFileName()) != null ? GenericLexer.assertNoDots(GenericLexer.unquote(fileNameNode.token), fileNameNode.position) : null;
        assert (fileName != null);
        return new CopyFactory(this.messageBus, this.engine.getCopyContext(), Chars.toString(tableName), Chars.toString(fileName), model);
    }

    private RecordCursorFactory compileCopyCancel(SqlExecutionContext executionContext, CopyModel model) throws SqlException {
        long cancelCopyID;
        assert (model.isCancel());
        String cancelCopyIDStr = Chars.toString(GenericLexer.unquote(model.getTableName()));
        try {
            cancelCopyID = Numbers.parseHexLong(cancelCopyIDStr);
        }
        catch (NumericException e) {
            throw SqlException.$(0, "copy cancel ID format is invalid: '").put(cancelCopyIDStr).put('\'');
        }
        return new CopyCancelFactory(this.engine.getCopyContext(), cancelCopyID, cancelCopyIDStr, this.query().$("select * from '").$(this.engine.getConfiguration().getSystemTableNamePrefix()).$("text_import_log' where id = '").$(cancelCopyIDStr).$("' limit -1").compile(executionContext).getRecordCursorFactory());
    }

    private void compileDeallocate(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        CharSequence statementName = GenericLexer.unquote(SqlCompilerImpl.expectToken(this.lexer, "statement name"));
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            throw SqlException.unexpectedToken(this.lexer.lastTokenPosition(), tok);
        }
        this.compiledQuery.ofDeallocate(statementName);
    }

    private void compileDrop(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        QueryProgress.logStart(-1L, sqlText, executionContext, false);
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null) {
            if (SqlKeywords.isTableKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "expected ").put("IF EXISTS table-name");
                }
                boolean hasIfExists = false;
                int tableNamePosition = this.lexer.lastTokenPosition();
                if (SqlKeywords.isIfKeyword(tok)) {
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok == null || !SqlKeywords.isExistsKeyword(tok)) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "expected ").put("EXISTS table-name");
                    }
                    hasIfExists = true;
                    tableNamePosition = this.lexer.getPosition();
                } else {
                    this.lexer.unparseLast();
                }
                tok = SqlCompilerImpl.expectToken(this.lexer, "table name");
                SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, this.lexer.lastTokenPosition());
                CharSequence tableName = GenericLexer.unquote(tok);
                TableToken tableToken = executionContext.getTableTokenIfExists(tableName);
                this.checkMatViewModification(tableToken);
                this.dropOperationBuilder.clear();
                this.dropOperationBuilder.setOperationCode(2);
                this.dropOperationBuilder.setEntityName(tableName);
                this.dropOperationBuilder.setEntityNamePosition(tableNamePosition);
                this.dropOperationBuilder.setIfExists(hasIfExists);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok != null && !Chars.equals(tok, ';')) {
                    this.compileDropExt(executionContext, this.dropOperationBuilder, tok, this.lexer.lastTokenPosition());
                }
                this.dropOperationBuilder.setSqlText(sqlText);
                this.compiledQuery.ofDrop(this.dropOperationBuilder.build());
            } else if (SqlKeywords.isMaterializedKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !SqlKeywords.isViewKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "expected VIEW");
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "expected ").put("IF EXISTS mat-view-name");
                }
                boolean hasIfExists = false;
                int tableNamePosition = this.lexer.lastTokenPosition();
                if (SqlKeywords.isIfKeyword(tok)) {
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok == null || !SqlKeywords.isExistsKeyword(tok)) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "expected ").put("EXISTS mat-view-name");
                    }
                    hasIfExists = true;
                    tableNamePosition = this.lexer.getPosition();
                } else {
                    this.lexer.unparseLast();
                }
                tok = SqlCompilerImpl.expectToken(this.lexer, "view name");
                SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, this.lexer.lastTokenPosition());
                CharSequence matViewName = GenericLexer.unquote(tok);
                TableToken tableToken = executionContext.getTableTokenIfExists(matViewName);
                if (tableToken != null && !tableToken.isMatView()) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "materialized view name expected, got table name");
                }
                this.dropOperationBuilder.clear();
                this.dropOperationBuilder.setOperationCode(5);
                this.dropOperationBuilder.setEntityName(matViewName);
                this.dropOperationBuilder.setEntityNamePosition(tableNamePosition);
                this.dropOperationBuilder.setIfExists(hasIfExists);
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok != null && !Chars.equals(tok, ';')) {
                    this.compileDropExt(executionContext, this.dropOperationBuilder, tok, this.lexer.lastTokenPosition());
                }
                this.dropOperationBuilder.setSqlText(sqlText);
                this.compiledQuery.ofDrop(this.dropOperationBuilder.build());
            } else if (SqlKeywords.isAllKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok != null && SqlKeywords.isTablesKeyword(tok)) {
                    tok = SqlUtil.fetchNext(this.lexer);
                }
                if (tok != null && !Chars.equals(tok, ';')) {
                    throw SqlException.position(this.lexer.lastTokenPosition()).put("';' or 'tables' expected");
                }
                this.compiledQuery.ofDrop(DropAllOperation.INSTANCE);
            } else {
                this.compileDropOther(executionContext, tok, this.lexer.lastTokenPosition());
            }
        } else {
            this.compileDropReportExpected(this.lexer.getPosition());
        }
    }

    private ExecutionModel compileExecutionModel(SqlExecutionContext executionContext) throws SqlException {
        ExecutionModel model = this.parser.parse(this.lexer, executionContext, this);
        if (model.getModelType() != 7) {
            return this.compileExecutionModel0(executionContext, model);
        }
        ExplainModel explainModel = (ExplainModel)model;
        ExecutionModel innerModel = this.compileExplainExecutionModel0(executionContext, explainModel.getInnerExecutionModel());
        explainModel.setModel(innerModel);
        return explainModel;
    }

    private ExecutionModel compileExecutionModel0(SqlExecutionContext executionContext, ExecutionModel model) throws SqlException {
        switch (model.getModelType()) {
            case 1: {
                return this.optimiser.optimise((QueryModel)model, executionContext, this);
            }
            case 4: {
                InsertModel insertModel = (InsertModel)model;
                if (insertModel.getQueryModel() != null) {
                    this.validateAndOptimiseInsertAsSelect(executionContext, insertModel);
                } else {
                    this.lightlyValidateInsertModel(insertModel);
                }
                TableToken tableToken = this.engine.getTableTokenIfExists(insertModel.getTableName());
                executionContext.getSecurityContext().authorizeInsert(tableToken);
                return insertModel;
            }
            case 6: {
                QueryModel queryModel = (QueryModel)model;
                TableToken tableToken = executionContext.getTableToken(queryModel.getTableName());
                try (TableRecordMetadata metadata = executionContext.getMetadataForWrite(tableToken);){
                    this.optimiser.optimiseUpdate(queryModel, executionContext, metadata, this);
                    ExecutionModel executionModel = model;
                    return executionModel;
                }
            }
        }
        return model;
    }

    private ExecutionModel compileExplainExecutionModel0(SqlExecutionContext executionContext, ExecutionModel model) throws SqlException {
        switch (model.getModelType()) {
            case 2: {
                CreateTableOperationBuilder createTableBuilder = (CreateTableOperationBuilder)model;
                if (createTableBuilder.getQueryModel() != null) {
                    QueryModel selectModel = this.optimiser.optimise(createTableBuilder.getQueryModel(), executionContext, this);
                    createTableBuilder.setSelectModel(selectModel);
                }
                return model;
            }
            case 8: {
                CreateMatViewOperationBuilder createMatViewBuilder = (CreateMatViewOperationBuilder)model;
                if (createMatViewBuilder.getQueryModel() != null) {
                    QueryModel selectModel = this.optimiser.optimise(createMatViewBuilder.getQueryModel(), executionContext, this);
                    createMatViewBuilder.setSelectModel(selectModel);
                }
                return model;
            }
        }
        return this.compileExecutionModel0(executionContext, model);
    }

    private void compileInner(@NotNull SqlExecutionContext executionContext, CharSequence sqlText, boolean generateProgressLogger) throws SqlException {
        short type;
        CharSequence tok;
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        if (!circuitBreaker.isTimerSet()) {
            circuitBreaker.resetTimer();
        }
        if ((tok = SqlUtil.fetchNext(this.lexer)) == null) {
            this.compiledQuery.ofEmpty();
            return;
        }
        KeywordBasedExecutor executor = this.keywordBasedExecutors.get(tok);
        long beginNanos = this.configuration.getNanosecondClock().getTicks();
        if (executor != null) {
            try {
                executor.execute(executionContext, sqlText);
                this.sqlText = executionContext.containsSecret() ? "** redacted for privacy **" : sqlText;
                QueryProgress.logEnd(-1L, this.sqlText, executionContext, beginNanos);
            }
            catch (Throwable th) {
                this.sqlText = executionContext.containsSecret() ? "** redacted for privacy** " : sqlText;
                QueryProgress.logError(th, -1L, this.sqlText, executionContext, beginNanos);
                throw th;
            }
        } else {
            this.sqlText = sqlText;
        }
        if (executor == null || this.compiledQuery.getType() == 0) {
            this.compileUsingModel(executionContext, beginNanos, generateProgressLogger);
        }
        if (!((type = this.compiledQuery.getType()) != 4 && type != 14 || executionContext.isWalApplication())) {
            this.compiledQuery.withSqlText(Chars.toString(sqlText));
        }
        this.compiledQuery.withContext(executionContext);
    }

    private InsertOperation compileInsert(InsertModel insertModel, SqlExecutionContext executionContext) throws SqlException {
        InsertOperationImpl insertOperationImpl;
        block18: {
            ExpressionNode tableNameExpr = insertModel.getTableNameExpr();
            InsertOperationImpl insertOperation = null;
            Function timestampFunction = null;
            ObjList<Function> valueFunctions = null;
            TableToken token = this.tableExistsOrFail(tableNameExpr.position, tableNameExpr.token, executionContext);
            TableRecordMetadata metadata = executionContext.getMetadataForWrite(token);
            try {
                long metadataVersion = metadata.getMetadataVersion();
                insertOperation = new InsertOperationImpl(this.engine, metadata.getTableToken(), metadataVersion);
                int metadataTimestampIndex = metadata.getTimestampIndex();
                ObjList<CharSequence> columnNameList = insertModel.getColumnNameList();
                int columnSetSize = columnNameList.size();
                int designatedTimestampPosition = 0;
                int n = insertModel.getRowTupleCount();
                for (int tupleIndex = 0; tupleIndex < n; ++tupleIndex) {
                    timestampFunction = null;
                    this.listColumnFilter.clear();
                    if (columnSetSize > 0) {
                        valueFunctions = new ObjList<Function>(columnSetSize);
                        for (int i = 0; i < columnSetSize; ++i) {
                            int metadataColumnIndex = metadata.getColumnIndexQuiet(columnNameList.getQuick(i));
                            if (metadataColumnIndex > -1) {
                                ExpressionNode node = insertModel.getRowTupleValues(tupleIndex).getQuick(i);
                                Function function = this.functionParser.parseFunction(node, EmptyRecordMetadata.INSTANCE, executionContext);
                                this.insertValidateFunctionAndAddToList(insertModel, tupleIndex, valueFunctions, metadata, metadataTimestampIndex, i, metadataColumnIndex, function, node.position, executionContext.getBindVariableService());
                                if (metadataTimestampIndex != metadataColumnIndex) continue;
                                timestampFunction = function;
                                designatedTimestampPosition = node.position;
                                continue;
                            }
                            throw SqlException.invalidColumn(insertModel.getColumnPosition(i), columnNameList.getQuick(i));
                        }
                    } else {
                        ObjList<ExpressionNode> values;
                        int valueCount;
                        int columnCount = metadata.getColumnCount();
                        if (columnCount != (valueCount = (values = insertModel.getRowTupleValues(tupleIndex)).size())) {
                            throw SqlException.$(insertModel.getEndOfRowTupleValuesPosition(tupleIndex), "row value count does not match column count [expected=").put(columnCount).put(", actual=").put(values.size()).put(", tuple=").put(tupleIndex + 1).put(']');
                        }
                        valueFunctions = new ObjList(columnCount);
                        for (int i = 0; i < columnCount; ++i) {
                            ExpressionNode node = values.getQuick(i);
                            Function function = this.functionParser.parseFunction(node, EmptyRecordMetadata.INSTANCE, executionContext);
                            this.insertValidateFunctionAndAddToList(insertModel, tupleIndex, valueFunctions, metadata, metadataTimestampIndex, i, i, function, node.position, executionContext.getBindVariableService());
                            if (metadataTimestampIndex != i) continue;
                            timestampFunction = function;
                            designatedTimestampPosition = node.position;
                        }
                    }
                    if (metadataTimestampIndex > -1) {
                        if (timestampFunction == null) {
                            throw SqlException.$(0, "insert statement must populate timestamp");
                        }
                        if (ColumnType.isNull(timestampFunction.getType()) || timestampFunction.isNullConstant()) {
                            throw SqlException.$(designatedTimestampPosition, "designated timestamp column cannot be NULL");
                        }
                    }
                    VirtualRecord record = new VirtualRecord(valueFunctions);
                    RecordToRowCopier copier = RecordToRowCopierUtils.generateCopier(this.asm, record, metadata, this.listColumnFilter);
                    insertOperation.addInsertRow(new InsertRowImpl(record, copier, timestampFunction, designatedTimestampPosition, tupleIndex));
                }
                insertOperationImpl = insertOperation;
                if (metadata == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (metadata != null) {
                        try {
                            metadata.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable th) {
                    Misc.free(insertOperation);
                    Misc.free(timestampFunction);
                    Misc.freeObjList(valueFunctions);
                    throw th;
                }
            }
            metadata.close();
        }
        return insertOperationImpl;
    }

    private InsertOperation compileInsertAsSelect(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        InsertAsSelectOperationImpl insertAsSelectOperationImpl;
        block21: {
            InsertModel model = (InsertModel)executionModel;
            ExpressionNode tableNameExpr = model.getTableNameExpr();
            TableToken tableToken = this.tableExistsOrFail(tableNameExpr.position, tableNameExpr.token, executionContext);
            RecordCursorFactory factory = null;
            TableRecordMetadata writerMetadata = executionContext.getMetadataForWrite(tableToken);
            try {
                RecordToRowCopier copier;
                long metadataVersion = writerMetadata.getMetadataVersion();
                factory = this.generateSelectWithRetries(model.getQueryModel(), model, executionContext, true);
                RecordMetadata cursorMetadata = factory.getMetadata();
                int writerTimestampIndex = writerMetadata.getTimestampIndex();
                int cursorTimestampIndex = cursorMetadata.getTimestampIndex();
                int cursorColumnCount = cursorMetadata.getColumnCount();
                ObjList<CharSequence> columnNameList = model.getColumnNameList();
                int columnSetSize = columnNameList.size();
                int timestampIndexFound = -1;
                if (columnSetSize > 0) {
                    this.listColumnFilter.clear();
                    for (int i = 0; i < columnSetSize; ++i) {
                        int toType;
                        CharSequence columnName = columnNameList.get(i);
                        int index = writerMetadata.getColumnIndexQuiet(columnName);
                        if (index == -1) {
                            throw SqlException.invalidColumn(model.getColumnPosition(i), columnName);
                        }
                        int fromType = cursorMetadata.getColumnType(i);
                        if (!ColumnType.isAssignableFrom(fromType, toType = writerMetadata.getColumnType(index))) {
                            throw SqlException.inconvertibleTypes(model.getColumnPosition(i), fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                        }
                        this.listColumnFilter.add(index + 1);
                        if (index != writerTimestampIndex) continue;
                        timestampIndexFound = i;
                        if (fromType == 8 || fromType == 11) continue;
                        throw SqlException.$(tableNameExpr.position, "expected timestamp column but type is ").put(ColumnType.nameOf(fromType));
                    }
                    if (timestampIndexFound < 0 && writerTimestampIndex >= 0) {
                        throw SqlException.$(tableNameExpr.position, "select clause must provide timestamp column");
                    }
                    copier = RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.listColumnFilter);
                } else {
                    if (writerTimestampIndex > -1 && cursorTimestampIndex == -1) {
                        if (cursorColumnCount <= writerTimestampIndex) {
                            throw SqlException.$(tableNameExpr.position, "select clause must provide timestamp column");
                        }
                        short columnType = ColumnType.tagOf(cursorMetadata.getColumnType(writerTimestampIndex));
                        if (columnType != 8 && columnType != 11 && columnType != 26 && columnType != 33) {
                            throw SqlException.$(tableNameExpr.position, "expected timestamp column but type is ").put(ColumnType.nameOf(columnType));
                        }
                    }
                    if (writerTimestampIndex > -1 && cursorTimestampIndex > -1 && writerTimestampIndex != cursorTimestampIndex) {
                        throw SqlException.$(tableNameExpr.position, "designated timestamp of existing table (").put(writerTimestampIndex).put(") does not match designated timestamp in select query (").put(cursorTimestampIndex).put(')');
                    }
                    timestampIndexFound = writerTimestampIndex;
                    int n = writerMetadata.getColumnCount();
                    if (n > cursorMetadata.getColumnCount()) {
                        throw SqlException.$(model.getSelectKeywordPosition(), "not enough columns selected");
                    }
                    for (int i = 0; i < n; ++i) {
                        int toType;
                        int fromType = cursorMetadata.getColumnType(i);
                        if (ColumnType.isAssignableFrom(fromType, toType = writerMetadata.getColumnType(i))) continue;
                        assert (i < model.getQueryModel().getBottomUpColumns().size());
                        throw SqlException.inconvertibleTypes(model.getQueryModel().getBottomUpColumns().getQuick((int)i).getAst().position, fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                    }
                    this.entityColumnFilter.of(writerMetadata.getColumnCount());
                    copier = RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter);
                }
                insertAsSelectOperationImpl = new InsertAsSelectOperationImpl(this.engine, tableToken, factory, copier, metadataVersion, timestampIndexFound, model.getBatchSize(), model.getO3MaxLag());
                if (writerMetadata == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (writerMetadata != null) {
                        try {
                            writerMetadata.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    Misc.free(factory);
                    throw e;
                }
            }
            writerMetadata.close();
        }
        return insertAsSelectOperationImpl;
    }

    private void compileLegacyCheckpoint(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        executionContext.getSecurityContext().authorizeDatabaseSnapshot();
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'prepare' or 'complete'");
        if (Chars.equalsLowerCaseAscii(tok, "prepare")) {
            this.engine.snapshotCreate(executionContext);
            this.compiledQuery.ofCheckpointCreate();
        } else if (Chars.equalsLowerCaseAscii(tok, "complete")) {
            this.engine.checkpointRelease();
            this.compiledQuery.ofCheckpointRelease();
        } else {
            throw SqlException.position(this.lexer.lastTokenPosition()).put("'prepare' or 'complete' expected");
        }
    }

    private void compileMatViewQuery(@NotNull SqlExecutionContext executionContext, @NotNull CreateMatViewOperation createMatViewOp) throws SqlException {
        CharSequence tok;
        CreateTableOperation createTableOp = createMatViewOp.getCreateTableOperation();
        this.lexer.of(createTableOp.getSelectText());
        this.clear();
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        if (!circuitBreaker.isTimerSet()) {
            circuitBreaker.resetTimer();
        }
        if ((tok = SqlUtil.fetchNext(this.lexer)) == null) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "SELECT query expected");
        }
        this.lexer.unparseLast();
        this.sqlText = createTableOp.getSelectText();
        this.compiledQuery.withContext(executionContext);
        int startPos = this.lexer.getPosition();
        long beginNanos = this.configuration.getNanosecondClock().getTicks();
        int selectTextPosition = createTableOp.getSelectTextPosition();
        try {
            QueryModel queryModel;
            try {
                ExecutionModel executionModel = this.parser.parse(this.lexer, executionContext, this);
                if (executionModel.getModelType() != 1) {
                    throw SqlException.$(startPos, "SELECT query expected");
                }
                queryModel = this.optimiser.optimise((QueryModel)executionModel, executionContext, this);
            }
            catch (SqlException e) {
                e.setPosition(e.getPosition() + selectTextPosition);
                throw e;
            }
            createMatViewOp.validateAndUpdateMetadataFromModel(executionContext, this.optimiser.getFunctionFactoryCache(), queryModel);
            boolean ogAllowNonDeterministic = executionContext.allowNonDeterministicFunctions();
            executionContext.setAllowNonDeterministicFunction(false);
            try {
                this.compiledQuery.ofSelect(this.generateSelectWithRetries(queryModel, null, executionContext, false));
            }
            catch (SqlException e) {
                e.setPosition(e.getPosition() + selectTextPosition);
                throw e;
            }
            finally {
                executionContext.setAllowNonDeterministicFunction(ogAllowNonDeterministic);
            }
        }
        catch (Throwable th) {
            QueryProgress.logError(th, -1L, this.sqlText, executionContext, beginNanos);
            throw th;
        }
    }

    private void compileRefresh(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'materialized'");
        if (!SqlKeywords.isMaterializedKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'materialized' expected'");
        }
        tok = SqlCompilerImpl.expectToken(this.lexer, "'view'");
        if (!SqlKeywords.isViewKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'view' expected'");
        }
        tok = SqlCompilerImpl.expectToken(this.lexer, "materialized view name");
        if (SqlKeywords.isSemicolon(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "materialized view name expected");
        }
        SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, this.lexer.lastTokenPosition());
        CharSequence matViewName = GenericLexer.unquote(tok);
        TableToken matViewToken = executionContext.getTableTokenIfExists(matViewName);
        if (matViewToken == null) {
            throw SqlException.matViewDoesNotExist(this.lexer.lastTokenPosition(), matViewName);
        }
        if (!matViewToken.isMatView()) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "materialized view name expected, got table name");
        }
        tok = SqlCompilerImpl.expectToken(this.lexer, "'full' or 'incremental' or 'range'");
        boolean fullRefresh = SqlKeywords.isFullKeyword(tok);
        long from = Long.MIN_VALUE;
        long to = Long.MIN_VALUE;
        if (SqlKeywords.isRangeKeyword(tok)) {
            SqlCompilerImpl.expectKeyword(this.lexer, "from");
            tok = SqlCompilerImpl.expectToken(this.lexer, "FROM timestamp");
            try {
                from = IntervalUtils.parseFloorPartialTimestamp(GenericLexer.unquote(tok));
            }
            catch (NumericException e) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "invalid FROM timestamp value");
            }
            SqlCompilerImpl.expectKeyword(this.lexer, "to");
            tok = SqlCompilerImpl.expectToken(this.lexer, "TO timestamp");
            try {
                to = IntervalUtils.parseFloorPartialTimestamp(GenericLexer.unquote(tok));
            }
            catch (NumericException e) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "invalid TO timestamp value");
            }
            if (from > to) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "TO timestamp must not be earlier than FROM timestamp");
            }
        } else if (!fullRefresh && !SqlKeywords.isIncrementalKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'full' or 'incremental' or 'range' expected");
        }
        if ((tok = SqlUtil.fetchNext(this.lexer)) != null && !SqlKeywords.isSemicolon(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [").put(tok).put("] while trying to refresh materialized view");
        }
        MatViewStateStore matViewStateStore = this.engine.getMatViewStateStore();
        executionContext.getSecurityContext().authorizeMatViewRefresh(matViewToken);
        if (fullRefresh) {
            matViewStateStore.enqueueFullRefresh(matViewToken);
        } else if (from != Long.MIN_VALUE) {
            matViewStateStore.enqueueRangeRefresh(matViewToken, from, to);
        } else {
            matViewStateStore.enqueueIncrementalRefresh(matViewToken);
        }
        this.compiledQuery.ofRefreshMatView();
    }

    private void compileReindex(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "TABLE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || Chars.equals(tok, ',')) {
            throw SqlException.$(this.lexer.getPosition(), "table name expected");
        }
        if (Chars.isQuoted(tok)) {
            tok = GenericLexer.unquote(tok);
        }
        TableToken tableToken = this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
        this.checkMatViewModification(tableToken);
        try (IndexBuilder indexBuilder = new IndexBuilder(this.configuration);){
            indexBuilder.of(this.path.of(this.configuration.getDbRoot()).concat(tableToken.getDirName()));
            tok = SqlUtil.fetchNext(this.lexer);
            CharSequence columnName = null;
            if (tok != null && SqlKeywords.isColumnKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (Chars.isQuoted(tok)) {
                    tok = GenericLexer.unquote(tok);
                }
                if (tok == null || TableUtils.isValidColumnName(tok, this.configuration.getMaxFileNameLength())) {
                    columnName = GenericLexer.immutableOf(tok);
                    tok = SqlUtil.fetchNext(this.lexer);
                }
            }
            CharSequence partition = null;
            if (tok != null && SqlKeywords.isPartitionKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (Chars.isQuoted(tok)) {
                    tok = GenericLexer.unquote(tok);
                }
                partition = tok;
                tok = SqlUtil.fetchNext(this.lexer);
            }
            if (tok == null || !SqlKeywords.isLockKeyword(tok)) {
                throw SqlException.$(this.lexer.getPosition(), "LOCK EXCLUSIVE expected");
            }
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok == null || !SqlKeywords.isExclusiveKeyword(tok)) {
                throw SqlException.$(this.lexer.getPosition(), "LOCK EXCLUSIVE expected");
            }
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                throw SqlException.$(this.lexer.getPosition(), "EOF expected");
            }
            this.columnNames.clear();
            if (columnName != null) {
                this.columnNames.add(columnName);
            }
            executionContext.getSecurityContext().authorizeTableReindex(tableToken, this.columnNames);
            indexBuilder.reindex(partition, columnName);
        }
        this.compiledQuery.ofRepair();
    }

    private void compileRollback(SqlExecutionContext executionContext, CharSequence sqlText) {
        this.compiledQuery.ofRollback();
    }

    private void compileSet(SqlExecutionContext executionContext, CharSequence sqlText) {
        this.compiledQuery.ofSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileTruncate(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(this.lexer.getPosition(), "TABLE expected");
        }
        if (!SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "TABLE expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        boolean hasIfExists = false;
        if (tok != null && SqlKeywords.isIfKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok == null || !SqlKeywords.isExistsKeyword(tok)) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "expected ").put("EXISTS table-name");
            }
            hasIfExists = true;
            tok = SqlUtil.fetchNext(this.lexer);
        }
        if (tok != null && SqlKeywords.isOnlyKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
        }
        if (tok != null && SqlKeywords.isWithKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "table name expected");
        }
        this.tableWriters.clear();
        try {
            block32: {
                do {
                    TableToken tableToken;
                    if (tok == null || Chars.equals(tok, ',')) {
                        throw SqlException.$(this.lexer.getPosition(), "table name expected");
                    }
                    if (Chars.isQuoted(tok)) {
                        tok = GenericLexer.unquote(tok);
                    }
                    if ((tableToken = executionContext.getTableTokenIfExists(tok)) == null && !hasIfExists) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "table does not exist [table=").put(tok).put(']');
                    }
                    if (tableToken != null) {
                        this.checkMatViewModification(tableToken);
                        executionContext.getSecurityContext().authorizeTableTruncate(tableToken);
                        try {
                            this.tableWriters.add(this.engine.getTableWriterAPI(tableToken, "truncateTables"));
                        }
                        catch (CairoException e) {
                            LOG.info().$("table busy [table=").$(tok).$(", e=").$(e).I$();
                            throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tok).put("' could not be truncated: ").put(e);
                        }
                    }
                    if ((tok = SqlUtil.fetchNext(this.lexer)) == null || Chars.equals(tok, ';') || SqlKeywords.isKeepKeyword(tok)) break block32;
                    if (Chars.equalsNc(tok, ',')) continue;
                    throw SqlException.$(this.lexer.getPosition(), "',' or 'keep' expected");
                } while ((tok = SqlUtil.fetchNext(this.lexer)) == null || !SqlKeywords.isKeepKeyword(tok));
                throw SqlException.$(this.lexer.getPosition(), "table name expected");
            }
            boolean keepSymbolTables = false;
            if (tok != null && SqlKeywords.isKeepKeyword(tok)) {
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !SqlKeywords.isSymbolKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "SYMBOL expected");
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null || !SqlKeywords.isMapsKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "MAPS expected");
                }
                keepSymbolTables = true;
                tok = SqlUtil.fetchNext(this.lexer);
            }
            if (tok != null && !Chars.equals(tok, ';')) {
                throw SqlException.unexpectedToken(this.lexer.lastTokenPosition(), tok);
            }
            long queryId = this.queryRegistry.register(sqlText, executionContext);
            try {
                int n = this.tableWriters.size();
                for (int i = 0; i < n; ++i) {
                    TableWriterAPI writer = this.tableWriters.getQuick(i);
                    try {
                        if (writer.getMetadata().isWalEnabled()) {
                            writer.truncateSoft();
                            continue;
                        }
                        TableToken tableToken = writer.getTableToken();
                        if (this.engine.lockReaders(tableToken)) {
                            try {
                                if (keepSymbolTables) {
                                    writer.truncateSoft();
                                    continue;
                                }
                                writer.truncate();
                                continue;
                            }
                            finally {
                                this.engine.unlockReaders(tableToken);
                            }
                        }
                        throw SqlException.$(0, "there is an active query against '").put(tableToken.getTableName()).put("'. Try again.");
                    }
                    catch (CairoError | CairoException e) {
                        LOG.error().$("could not truncate [table=").$(writer.getTableToken()).$(", e=").$((Sinkable)((Object)e)).I$();
                        throw e;
                    }
                }
            }
            finally {
                this.queryRegistry.unregister(queryId, executionContext);
            }
        }
        finally {
            Misc.freeObjListAndClear(this.tableWriters);
        }
        this.compiledQuery.ofTruncate();
    }

    private void compileUsingModel(SqlExecutionContext executionContext, long beginNanos, boolean generateProgressLogger) throws SqlException {
        this.lexer.unparseLast();
        this.codeGenerator.clear();
        long sqlId = -1L;
        ExecutionModel executionModel = null;
        try {
            executionModel = this.compileExecutionModel(executionContext);
            switch (executionModel.getModelType()) {
                case 1: {
                    this.compiledQuery.ofSelect(this.generateSelectWithRetries((QueryModel)executionModel, null, executionContext, generateProgressLogger));
                    break;
                }
                case 2: {
                    this.compiledQuery.ofCreateTable(((CreateTableOperationBuilder)executionModel).build(this, executionContext, this.sqlText));
                    break;
                }
                case 8: {
                    this.compiledQuery.ofCreateMatView(((CreateMatViewOperationBuilder)executionModel).build(this, executionContext, this.sqlText));
                    break;
                }
                case 5: {
                    QueryProgress.logStart(sqlId, this.sqlText, executionContext, false);
                    this.checkMatViewModification(executionModel);
                    this.copy(executionContext, (CopyModel)executionModel);
                    QueryProgress.logEnd(sqlId, this.sqlText, executionContext, beginNanos);
                    break;
                }
                case 3: {
                    sqlId = this.queryRegistry.register(this.sqlText, executionContext);
                    QueryProgress.logStart(sqlId, this.sqlText, executionContext, false);
                    this.checkMatViewModification(executionModel);
                    RenameTableModel rtm = (RenameTableModel)executionModel;
                    this.engine.rename(executionContext.getSecurityContext(), this.path, this.mem, GenericLexer.unquote(rtm.getFrom().token), this.renamePath, GenericLexer.unquote(rtm.getTo().token));
                    QueryProgress.logEnd(sqlId, this.sqlText, executionContext, beginNanos);
                    this.compiledQuery.ofRenameTable();
                    break;
                }
                case 6: {
                    QueryProgress.logStart(sqlId, this.sqlText, executionContext, false);
                    this.checkMatViewModification(executionModel);
                    QueryModel updateQueryModel = (QueryModel)executionModel;
                    TableToken tableToken = executionContext.getTableToken(updateQueryModel.getTableName());
                    try (TableRecordMetadata metadata = executionContext.getMetadataForWrite(tableToken);){
                        this.compiledQuery.ofUpdate(this.generateUpdate(updateQueryModel, executionContext, metadata));
                    }
                    QueryProgress.logEnd(sqlId, this.sqlText, executionContext, beginNanos);
                    break;
                }
                case 7: {
                    sqlId = this.queryRegistry.register(this.sqlText, executionContext);
                    QueryProgress.logStart(sqlId, this.sqlText, executionContext, false);
                    this.compiledQuery.ofExplain(this.generateExplain((ExplainModel)executionModel, executionContext));
                    QueryProgress.logEnd(sqlId, this.sqlText, executionContext, beginNanos);
                    break;
                }
                default: {
                    this.checkMatViewModification(executionModel);
                    InsertModel insertModel = (InsertModel)executionModel;
                    if (insertModel.getQueryModel() != null) {
                        this.compiledQuery.ofInsert(this.compileInsertAsSelect(insertModel, executionContext), true);
                        break;
                    }
                    QueryProgress.logStart(sqlId, this.sqlText, executionContext, false);
                    this.compiledQuery.ofInsert(this.compileInsert(insertModel, executionContext), false);
                    QueryProgress.logEnd(sqlId, this.sqlText, executionContext, beginNanos);
                }
            }
            short type = this.compiledQuery.getType();
            if (type == 25 || type == 12) {
                this.queryRegistry.unregister(sqlId, executionContext);
            }
        }
        catch (Throwable th) {
            if (executionModel != null) {
                this.freeTableNameFunctions(executionModel.getQueryModel());
            }
            this.queryRegistry.unregister(sqlId, executionContext);
            QueryProgress.logError(th, sqlId, this.sqlText, executionContext, beginNanos);
            throw th;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileVacuum(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'table'");
        boolean partitionsKeyword = SqlKeywords.isPartitionsKeyword(tok);
        if (!partitionsKeyword && !SqlKeywords.isTableKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'partitions' expected");
        tok = SqlCompilerImpl.expectToken(this.lexer, "table name");
        SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, this.lexer.lastTokenPosition());
        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), this.lexer.lastTokenPosition());
        int tableNamePos = this.lexer.lastTokenPosition();
        CharSequence eol = SqlUtil.fetchNext(this.lexer);
        if (eol != null && !Chars.equals(eol, ';')) throw SqlException.$(this.lexer.lastTokenPosition(), "end of line or ';' expected");
        TableToken tableToken = this.tableExistsOrFail(this.lexer.lastTokenPosition(), tableName, executionContext);
        this.checkMatViewModification(tableToken);
        try (TableReader rdr = executionContext.getReader(tableToken);){
            int partitionBy = rdr.getMetadata().getPartitionBy();
            if (PartitionBy.isPartitioned(partitionBy)) {
                executionContext.getSecurityContext().authorizeTableVacuum(rdr.getTableToken());
                if (!TableUtils.schedulePurgeO3Partitions(this.messageBus, rdr.getTableToken(), partitionBy)) {
                    throw SqlException.$(tableNamePos, "cannot schedule vacuum action, queue is full, please retry or increase Purge Discovery Queue Capacity");
                }
            } else if (partitionsKeyword) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tableName).put("' is not partitioned");
            }
            this.vacuumColumnVersions.run(rdr);
            this.compiledQuery.ofVacuum();
            return;
        }
    }

    private void copy(SqlExecutionContext executionContext, CopyModel copyModel) throws SqlException {
        if (!copyModel.isCancel() && Chars.equalsLowerCaseAscii(copyModel.getFileName().token, "stdin")) {
            this.authorizeInsertForCopy(executionContext.getSecurityContext(), copyModel);
            this.compiledQuery.ofCopyRemote();
        } else {
            RecordCursorFactory copyFactory = copyModel.isCancel() ? this.compileCopyCancel(executionContext, copyModel) : this.compileCopy(executionContext.getSecurityContext(), copyModel);
            this.compiledQuery.ofPseudoSelect(copyFactory);
        }
    }

    private long copyTableData(RecordCursor cursor, RecordMetadata metadata, TableWriterAPI writer, RecordMetadata writerMetadata, RecordToRowCopier recordToRowCopier, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        int timestampIndex = writerMetadata.getTimestampIndex();
        long rowCount = timestampIndex == -1 ? SqlCompilerImpl.copyUnordered(cursor, writer, recordToRowCopier, circuitBreaker) : (batchSize != -1L ? SqlCompilerImpl.copyOrderedBatched(writer, metadata, cursor, recordToRowCopier, timestampIndex, batchSize, o3MaxLag, circuitBreaker) : SqlCompilerImpl.copyOrderedBatched(writer, metadata, cursor, recordToRowCopier, timestampIndex, Long.MAX_VALUE, o3MaxLag, circuitBreaker));
        writer.commit();
        return rowCount;
    }

    private void copyTableDataAndUnlock(SecurityContext securityContext, TableToken tableToken, boolean isWalEnabled, RecordCursor cursor, RecordMetadata cursorMetadata, long batchSize, long o3MaxLag, SqlExecutionCircuitBreaker circuitBreaker) {
        block9: {
            TableWriter writer;
            block8: {
                TableWriterAPI writerAPI = null;
                writer = null;
                try {
                    if (!isWalEnabled) {
                        writer = new TableWriter(this.engine.getConfiguration(), tableToken, this.engine.getMessageBus(), null, false, DefaultLifecycleManager.INSTANCE, this.engine.getConfiguration().getDbRoot(), this.engine.getDdlListener(tableToken), this.engine.getCheckpointStatus(), this.engine);
                        writerAPI = writer;
                    } else {
                        writerAPI = this.engine.getTableWriterAPI(tableToken, "create as select");
                    }
                    TableRecordMetadata writerMetadata = writerAPI.getMetadata();
                    this.entityColumnFilter.of(writerMetadata.getColumnCount());
                    this.insertCount = this.copyTableData(cursor, cursorMetadata, writerAPI, writerMetadata, RecordToRowCopierUtils.generateCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter), batchSize, o3MaxLag, circuitBreaker);
                    if (!isWalEnabled) break block8;
                }
                catch (CairoException e) {
                    try {
                        writerAPI = Misc.free(writerAPI);
                        writer = null;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (isWalEnabled) {
                            Misc.free(writerAPI);
                        } else {
                            this.engine.unlock(securityContext, tableToken, writer, false);
                        }
                        throw throwable;
                    }
                }
                Misc.free(writerAPI);
                break block9;
            }
            this.engine.unlock(securityContext, tableToken, writer, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeCreateMatView(CreateMatViewOperation createMatViewOp, SqlExecutionContext executionContext) throws SqlException {
        if (createMatViewOp.getRefreshType() != 0 && createMatViewOp.getRefreshType() != 1 && createMatViewOp.getRefreshType() != 2) {
            throw SqlException.$(createMatViewOp.getTableNamePosition(), "unexpected refresh type: ").put(createMatViewOp.getRefreshType());
        }
        long sqlId = this.queryRegistry.register(createMatViewOp.getSqlText(), executionContext);
        long beginNanos = this.configuration.getMicrosecondClock().getTicks();
        QueryProgress.logStart(sqlId, createMatViewOp.getSqlText(), executionContext, false);
        try {
            int status = executionContext.getTableStatus(this.path, createMatViewOp.getTableName());
            if (status == 0) {
                TableToken tt = executionContext.getTableTokenIfExists(createMatViewOp.getTableName());
                if (tt != null && !tt.isMatView()) {
                    throw SqlException.$(createMatViewOp.getTableNamePosition(), "table with the requested name already exists");
                }
                if (!createMatViewOp.ignoreIfExists()) throw SqlException.$(createMatViewOp.getTableNamePosition(), "materialized view already exists");
                createMatViewOp.updateOperationFutureTableToken(tt);
            } else {
                TableToken matViewToken;
                RecordCursor newCursor;
                CreateTableOperation createTableOp;
                CharSequence volumeAlias = createMatViewOp.getVolumeAlias();
                if (volumeAlias != null) {
                    CharSequence volumePath = this.configuration.getVolumeDefinitions().resolveAlias(volumeAlias);
                    if (volumePath == null) throw SqlException.position(createMatViewOp.getVolumePosition()).put("volume alias is not allowed [alias=").put(volumeAlias).put(']');
                    if (!this.ff.isDirOrSoftLinkDir(this.path.of(volumePath).$())) {
                        throw CairoException.critical(0).position(createMatViewOp.getVolumePosition()).put("not a valid path for volume [alias=").put(volumeAlias).put(", path=").put(this.path).put(']');
                    }
                }
                if ((createTableOp = createMatViewOp.getCreateTableOperation()).getSelectText() == null) throw SqlException.$(createTableOp.getTableNamePosition(), "materialized view requires a SELECT statement");
                RecordCursorFactory newFactory = null;
                int retryCount = 0;
                while (true) {
                    try {
                        this.compileMatViewQuery(executionContext, createMatViewOp);
                        Misc.free(newFactory);
                        newFactory = this.compiledQuery.getRecordCursorFactory();
                        newCursor = newFactory.getCursor(executionContext);
                        break;
                    }
                    catch (TableReferenceOutOfDateException e) {
                        if (retryCount == this.maxRecompileAttempts) {
                            Misc.free(newFactory);
                            throw SqlException.$(0, e.getFlyweightMessage());
                        }
                        LOG.info().$("retrying plan [q=`").$(createTableOp.getSelectText()).$("`]").$();
                    }
                    catch (Throwable th) {
                        Misc.free(newFactory);
                        throw th;
                    }
                    ++retryCount;
                }
                try {
                    RecordMetadata metadata = newFactory.getMetadata();
                    try (TableReader baseReader = this.engine.getReader(createMatViewOp.getBaseTableName());){
                        createMatViewOp.validateAndUpdateMetadataFromSelect(metadata, baseReader.getMetadata());
                    }
                    MatViewDefinition matViewDefinition = this.engine.createMatView(executionContext.getSecurityContext(), this.mem, this.blockFileWriter, this.path, createMatViewOp.ignoreIfExists(), createMatViewOp, !createMatViewOp.isWalEnabled(), volumeAlias != null);
                    matViewToken = matViewDefinition.getMatViewToken();
                }
                finally {
                    Misc.free(newCursor);
                    Misc.free(newFactory);
                }
                createMatViewOp.updateOperationFutureTableToken(matViewToken);
            }
            QueryProgress.logEnd(sqlId, createMatViewOp.getSqlText(), executionContext, beginNanos);
            return;
        }
        catch (Throwable th) {
            if (th instanceof CairoException) {
                ((CairoException)th).position(createMatViewOp.getTableNamePosition());
            }
            QueryProgress.logError(th, sqlId, createMatViewOp.getSqlText(), executionContext, beginNanos);
            throw th;
        }
        finally {
            this.queryRegistry.unregister(sqlId, executionContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeCreateTable(CreateTableOperation createTableOp, SqlExecutionContext executionContext) throws SqlException {
        long sqlId = this.queryRegistry.register(createTableOp.getSqlText(), executionContext);
        long beginNanos = this.configuration.getMicrosecondClock().getTicks();
        QueryProgress.logStart(sqlId, createTableOp.getSqlText(), executionContext, false);
        try {
            executionContext.setUseSimpleCircuitBreaker(true);
            int status = executionContext.getTableStatus(this.path, createTableOp.getTableName());
            if (status == 0) {
                TableToken tt = executionContext.getTableTokenIfExists(createTableOp.getTableName());
                if (tt != null && tt.isMatView()) {
                    throw SqlException.$(createTableOp.getTableNamePosition(), "materialized view with the requested name already exists");
                }
                if (!createTableOp.ignoreIfExists()) throw SqlException.$(createTableOp.getTableNamePosition(), "table already exists");
                createTableOp.updateOperationFutureTableToken(tt);
            } else {
                TableToken tableToken;
                CharSequence volumeAlias = createTableOp.getVolumeAlias();
                if (volumeAlias != null) {
                    CharSequence volumePath = this.configuration.getVolumeDefinitions().resolveAlias(volumeAlias);
                    if (volumePath == null) throw SqlException.position(createTableOp.getVolumePosition()).put("volume alias is not allowed [alias=").put(volumeAlias).put(']');
                    if (!this.ff.isDirOrSoftLinkDir(this.path.of(volumePath).$())) {
                        throw CairoException.critical(0).position(createTableOp.getVolumePosition()).put("not a valid path for volume [alias=").put(volumeAlias).put(", path=").put(this.path).put(']');
                    }
                }
                if (createTableOp.getSelectText() != null) {
                    RecordCursor newCursor;
                    this.insertCount = -1L;
                    int position = createTableOp.getTableNamePosition();
                    RecordCursorFactory newFactory = null;
                    int retryCount = 0;
                    while (true) {
                        try {
                            this.lexer.of(createTableOp.getSelectText());
                            this.clearExceptSqlText();
                            this.compileInner(executionContext, createTableOp.getSelectText(), false);
                            Misc.free(newFactory);
                            newFactory = this.compiledQuery.getRecordCursorFactory();
                            newCursor = newFactory.getCursor(executionContext);
                            break;
                        }
                        catch (TableReferenceOutOfDateException e) {
                            if (retryCount == this.maxRecompileAttempts) {
                                Misc.free(newFactory);
                                throw SqlException.$(createTableOp.getSelectTextPosition(), e.getFlyweightMessage());
                            }
                            LOG.info().$("retrying plan [q=`").$(createTableOp.getSelectText()).$("`]").$();
                        }
                        catch (SqlException e) {
                            e.setPosition(e.getPosition() + createTableOp.getSelectTextPosition());
                            Misc.free(newFactory);
                            throw e;
                        }
                        catch (Throwable th) {
                            Misc.free(newFactory);
                            throw th;
                        }
                        ++retryCount;
                    }
                    try (RecordCursorFactory factory = newFactory;
                         RecordCursor cursor = newCursor;){
                        RecordMetadata metadata = factory.getMetadata();
                        createTableOp.validateAndUpdateMetadataFromSelect(metadata);
                        boolean keepLock = !createTableOp.isWalEnabled();
                        tableToken = this.engine.createTable(executionContext.getSecurityContext(), this.mem, this.path, createTableOp.ignoreIfExists(), createTableOp, keepLock, volumeAlias != null);
                        try {
                            this.copyTableDataAndUnlock(executionContext.getSecurityContext(), tableToken, createTableOp.isWalEnabled(), cursor, metadata, createTableOp.getBatchSize(), createTableOp.getBatchO3MaxLag(), executionContext.getCircuitBreaker());
                        }
                        catch (CairoException e) {
                            e.position(position);
                            LogRecord record = LOG.error().$("could not create table as select [message=").$safe(e.getFlyweightMessage());
                            if (!e.isCancellation()) {
                                record.$(", errno=").$(e.getErrno());
                            }
                            record.I$();
                            this.engine.dropTableOrMatView(this.path, tableToken);
                            this.engine.unlockTableName(tableToken);
                            throw e;
                        }
                    }
                    createTableOp.updateOperationFutureTableToken(tableToken);
                    createTableOp.updateOperationFutureAffectedRowsCount(this.insertCount);
                } else {
                    try {
                        if (createTableOp.getLikeTableName() != null) {
                            TableToken likeTableToken = executionContext.getTableTokenIfExists(createTableOp.getLikeTableName());
                            if (likeTableToken == null) {
                                throw SqlException.$(createTableOp.getLikeTableNamePosition(), "table does not exist [table=").put(createTableOp.getLikeTableName()).put(']');
                            }
                            try (TableMetadata likeTableMetadata = executionContext.getCairoEngine().getTableMetadata(likeTableToken);){
                                createTableOp.updateFromLikeTableMetadata(likeTableMetadata);
                                tableToken = this.engine.createTable(executionContext.getSecurityContext(), this.mem, this.path, createTableOp.ignoreIfExists(), createTableOp, false, volumeAlias != null);
                            }
                        } else {
                            tableToken = this.engine.createTable(executionContext.getSecurityContext(), this.mem, this.path, createTableOp.ignoreIfExists(), createTableOp, false, volumeAlias != null);
                        }
                        createTableOp.updateOperationFutureTableToken(tableToken);
                    }
                    catch (EntryUnavailableException e) {
                        throw SqlException.$(createTableOp.getTableNamePosition(), "table already exists");
                    }
                    catch (CairoException e) {
                        if (e.isAuthorizationError() || e.isCancellation()) {
                            LOG.error().$("could not create table [error=").$safe(e.getFlyweightMessage()).I$();
                        } else {
                            LOG.error().$("could not create table [error=").$(e).I$();
                        }
                        if (!e.isInterruption()) throw SqlException.$(createTableOp.getTableNamePosition(), "Could not create table, ").put(e.getFlyweightMessage());
                        throw e;
                    }
                }
            }
            QueryProgress.logEnd(sqlId, createTableOp.getSqlText(), executionContext, beginNanos);
            return;
        }
        catch (Throwable e) {
            if (e instanceof CairoException) {
                ((CairoException)e).position(createTableOp.getTableNamePosition());
            }
            QueryProgress.logError(e, sqlId, createTableOp.getSqlText(), executionContext, beginNanos);
            throw e;
        }
        finally {
            executionContext.setUseSimpleCircuitBreaker(false);
            this.queryRegistry.unregister(sqlId, executionContext);
        }
    }

    private void executeDropAllTables(SqlExecutionContext executionContext) {
        this.dropAllTablesFailedTableNames.clear();
        this.tableTokenBucket.clear();
        this.engine.getTableTokens(this.tableTokenBucket, false);
        SecurityContext securityContext = executionContext.getSecurityContext();
        int n = this.tableTokenBucket.size();
        for (int i = 0; i < n; ++i) {
            TableToken tableToken = this.tableTokenBucket.get(i);
            if (tableToken.isSystem()) continue;
            if (tableToken.isMatView()) {
                securityContext.authorizeMatViewDrop(tableToken);
            } else {
                securityContext.authorizeTableDrop(tableToken);
            }
            try {
                this.engine.dropTableOrMatView(this.path, tableToken);
                continue;
            }
            catch (CairoException report) {
                this.dropAllTablesFailedTableNames.put(tableToken.getTableName(), report.getMessage());
            }
        }
        if (this.dropAllTablesFailedTableNames.size() > 0) {
            CairoException ex = CairoException.nonCritical().put("failed to drop tables and materialized views [");
            ObjList<CharSequence> keys = this.dropAllTablesFailedTableNames.keys();
            int n2 = keys.size();
            for (int i = 0; i < n2; ++i) {
                CharSequence tableName = keys.get(i);
                String reason = this.dropAllTablesFailedTableNames.get(tableName);
                ex.put('\'').put(tableName).put("': ").put(reason);
                if (i + 1 >= n2) continue;
                ex.put(", ");
            }
            throw ex.put(']');
        }
    }

    private void executeDropMatView(GenericDropOperation op, SqlExecutionContext sqlExecutionContext) throws SqlException {
        TableToken tableToken = sqlExecutionContext.getTableTokenIfExists(op.getEntityName());
        if (tableToken == null || TableNameRegistry.isLocked(tableToken)) {
            if (op.ifExists()) {
                return;
            }
            throw SqlException.matViewDoesNotExist(op.getEntityNamePosition(), op.getEntityName());
        }
        if (!tableToken.isMatView()) {
            throw SqlException.$(op.getEntityNamePosition(), "materialized view name expected, got table name");
        }
        sqlExecutionContext.getSecurityContext().authorizeMatViewDrop(tableToken);
        String sqlText = op.getSqlText();
        long queryId = this.queryRegistry.register(sqlText, sqlExecutionContext);
        try {
            this.engine.dropTableOrMatView(this.path, tableToken);
        }
        catch (CairoException ex) {
            if ((ex.isTableDropped() || ex.isTableDoesNotExist()) && op.ifExists()) {
                return;
            }
            if (!op.ifExists() && ex.isTableDropped()) {
                throw CairoException.matViewDoesNotExist(op.getEntityName());
            }
            throw ex;
        }
        finally {
            this.queryRegistry.unregister(queryId, sqlExecutionContext);
        }
    }

    private void executeDropTable(GenericDropOperation op, SqlExecutionContext sqlExecutionContext) throws SqlException {
        TableToken tableToken = sqlExecutionContext.getTableTokenIfExists(op.getEntityName());
        if (tableToken == null || TableNameRegistry.isLocked(tableToken)) {
            if (op.ifExists()) {
                return;
            }
            throw SqlException.tableDoesNotExist(op.getEntityNamePosition(), op.getEntityName());
        }
        if (tableToken.isMatView()) {
            throw SqlException.$(op.getEntityNamePosition(), "table name expected, got materialized view name: ").put(op.getEntityName());
        }
        sqlExecutionContext.getSecurityContext().authorizeTableDrop(tableToken);
        String sqlText = op.getSqlText();
        long queryId = this.queryRegistry.register(sqlText, sqlExecutionContext);
        try {
            this.engine.dropTableOrMatView(this.path, tableToken);
        }
        catch (CairoException ex) {
            if ((ex.isTableDropped() || ex.isTableDoesNotExist()) && op.ifExists()) {
                return;
            }
            if (!op.ifExists() && ex.isTableDropped()) {
                throw CairoException.tableDoesNotExist(op.getEntityName());
            }
            throw ex;
        }
        finally {
            this.queryRegistry.unregister(queryId, sqlExecutionContext);
        }
    }

    private int filterApply(Function filter, int functionPosition, AlterOperationBuilder changePartitionStatement, long timestamp) {
        this.partitionFunctionRec.setTimestamp(timestamp);
        if (filter.getBool(this.partitionFunctionRec)) {
            changePartitionStatement.addPartitionToList(timestamp, functionPosition);
            return 1;
        }
        return 0;
    }

    private int filterPartitions(Function filter, int filterPosition, TableReader reader, AlterOperationBuilder changePartitionStatement) {
        int affectedPartitions = 0;
        int partitionCount = reader.getPartitionCount();
        if (partitionCount > 0) {
            long firstPartition = reader.getTxFile().getPartitionFloor(reader.getPartitionTimestampByIndex(0));
            long lastPartition = reader.getTxFile().getPartitionFloor(reader.getPartitionTimestampByIndex(partitionCount - 1));
            long lastLogicalPartition = Long.MIN_VALUE;
            for (int partitionIndex = 1; partitionIndex < partitionCount - 1; ++partitionIndex) {
                long physicalTimestamp = reader.getPartitionTimestampByIndex(partitionIndex);
                long logicalTimestamp = reader.getTxFile().getPartitionFloor(physicalTimestamp);
                if (logicalTimestamp == lastLogicalPartition || logicalTimestamp == firstPartition || logicalTimestamp == lastPartition || this.filterApply(filter, filterPosition, changePartitionStatement, logicalTimestamp) <= 0) continue;
                ++affectedPartitions;
                lastLogicalPartition = logicalTimestamp;
            }
            affectedPartitions += this.filterApply(filter, filterPosition, changePartitionStatement, firstPartition);
            if (firstPartition != lastPartition) {
                affectedPartitions += this.filterApply(filter, filterPosition, changePartitionStatement, lastPartition);
            }
        }
        return affectedPartitions;
    }

    private void freeTableNameFunctions(QueryModel queryModel) {
        if (queryModel == null) {
            return;
        }
        do {
            ObjList<QueryModel> joinModels;
            if ((joinModels = queryModel.getJoinModels()).size() > 1) {
                int n = joinModels.size();
                for (int i = 1; i < n; ++i) {
                    this.freeTableNameFunctions(joinModels.getQuick(i));
                }
            }
            Misc.free(queryModel.getTableNameFunction());
            queryModel.setTableNameFunction(null);
        } while ((queryModel = queryModel.getNestedModel()) != null);
    }

    private RecordCursorFactory generateExplain(ExplainModel model, SqlExecutionContext executionContext) throws SqlException {
        if (model.getInnerExecutionModel().getModelType() == 6) {
            QueryModel updateQueryModel = model.getInnerExecutionModel().getQueryModel();
            QueryModel selectQueryModel = updateQueryModel.getNestedModel();
            RecordCursorFactory recordCursorFactory = this.generateUpdateFactory(updateQueryModel.getUpdateTableToken(), selectQueryModel, updateQueryModel, executionContext);
            return this.codeGenerator.generateExplain(updateQueryModel, recordCursorFactory, model.getFormat());
        }
        return this.codeGenerator.generateExplain(model, executionContext);
    }

    private UpdateOperation generateUpdate(QueryModel updateQueryModel, SqlExecutionContext executionContext, TableRecordMetadata metadata) throws SqlException {
        TableToken updateTableToken = updateQueryModel.getUpdateTableToken();
        QueryModel selectQueryModel = updateQueryModel.getNestedModel();
        RecordCursorFactory recordCursorFactory = this.generateUpdateFactory(updateTableToken, selectQueryModel, updateQueryModel, executionContext);
        if (!metadata.isWalEnabled() || executionContext.isWalApplication()) {
            return new UpdateOperation(updateTableToken, selectQueryModel.getTableId(), selectQueryModel.getMetadataVersion(), this.lexer.getPosition(), recordCursorFactory);
        }
        recordCursorFactory.close();
        if (selectQueryModel.containsJoin()) {
            throw SqlException.position(0).put("UPDATE statements with join are not supported yet for WAL tables");
        }
        return new UpdateOperation(updateTableToken, metadata.getTableId(), metadata.getMetadataVersion(), this.lexer.getPosition());
    }

    private RecordCursorFactory generateUpdateFactory(TableToken tableToken, QueryModel selectQueryModel, QueryModel updateQueryModel, SqlExecutionContext executionContext) throws SqlException {
        IntList tableColumnTypes = selectQueryModel.getUpdateTableColumnTypes();
        ObjList<CharSequence> tableColumnNames = selectQueryModel.getUpdateTableColumnNames();
        RecordCursorFactory updateToDataCursorFactory = this.generateSelectOneShot(selectQueryModel, executionContext, false);
        try {
            if (!updateToDataCursorFactory.supportsUpdateRowId(tableToken)) {
                throw SqlException.$(updateQueryModel.getModelPosition(), "Unsupported SQL complexity for the UPDATE statement");
            }
            RecordMetadata updateDataFactoryMetadata = updateToDataCursorFactory.getMetadata();
            int n = updateDataFactoryMetadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String updateColumnName;
                int tableColumnIndex;
                int tableColumnType;
                int virtualColumnType = updateDataFactoryMetadata.getColumnType(i);
                if (virtualColumnType == (tableColumnType = tableColumnTypes.get(tableColumnIndex = tableColumnNames.indexOf(updateColumnName = updateDataFactoryMetadata.getColumnName(i)))) || SqlCompilerImpl.isIPv4UpdateCast(virtualColumnType, tableColumnType) || ColumnType.isSymbolOrString(tableColumnType) && ColumnType.isAssignableFrom(virtualColumnType, 11) || tableColumnType == 26 && ColumnType.isAssignableFrom(virtualColumnType, 26)) continue;
                ExpressionNode setRhs = updateQueryModel.getNestedModel().getColumns().getQuick(i).getAst();
                throw SqlException.inconvertibleTypes(setRhs.position, virtualColumnType, "", tableColumnType, updateColumnName);
            }
            return updateToDataCursorFactory;
        }
        catch (Throwable th) {
            updateToDataCursorFactory.close();
            throw th;
        }
    }

    private int getNextValidTokenPosition() throws SqlException {
        while (this.lexer.hasNext()) {
            CharSequence token = SqlUtil.fetchNext(this.lexer);
            if (token == null) {
                return -1;
            }
            if (SqlKeywords.isSemicolon(token)) continue;
            this.lexer.unparseLast();
            return this.lexer.lastTokenPosition();
        }
        return -1;
    }

    private int goToQueryEnd() throws SqlException {
        CharSequence token;
        this.lexer.unparseLast();
        while (this.lexer.hasNext() && (token = SqlUtil.fetchNext(this.lexer)) != null && !SqlKeywords.isSemicolon(token)) {
        }
        return this.lexer.getPosition();
    }

    private void insertValidateFunctionAndAddToList(InsertModel model, int tupleIndex, ObjList<Function> valueFunctions, RecordMetadata metadata, int metadataTimestampIndex, int insertColumnIndex, int metadataColumnIndex, Function function, int functionPosition, BindVariableService bindVariableService) throws SqlException {
        int columnType = metadata.getColumnType(metadataColumnIndex);
        if (ColumnType.isUnderdefined(function.getType())) {
            function.assignType(columnType, bindVariableService);
        }
        if (ColumnType.isAssignableFrom(function.getType(), columnType)) {
            if (metadataColumnIndex == metadataTimestampIndex) {
                return;
            }
            valueFunctions.add(function);
            this.listColumnFilter.add(metadataColumnIndex + 1);
            return;
        }
        throw SqlException.inconvertibleTypes(functionPosition, function.getType(), model.getRowTupleValues((int)tupleIndex).getQuick((int)insertColumnIndex).token, metadata.getColumnType(metadataColumnIndex), metadata.getColumnName(metadataColumnIndex));
    }

    private boolean isCompatibleColumnTypeChange(int from, int to) {
        return columnConversionSupport[ColumnType.tagOf(from)][ColumnType.tagOf(to)];
    }

    private void lightlyValidateInsertModel(InsertModel model) throws SqlException {
        ExpressionNode tableNameExpr = model.getTableNameExpr();
        if (tableNameExpr.type != 7) {
            throw SqlException.$(tableNameExpr.position, "literal expected");
        }
        int columnNameListSize = model.getColumnNameList().size();
        if (columnNameListSize > 0) {
            int n = model.getRowTupleCount();
            for (int i = 0; i < n; ++i) {
                if (columnNameListSize == model.getRowTupleValues(i).size()) continue;
                throw SqlException.$(model.getEndOfRowTupleValuesPosition(i), "row value count does not match column count [expected=").put(columnNameListSize).put(", actual=").put(model.getRowTupleValues(i).size()).put(", tuple=").put(i + 1).put(']');
            }
        }
    }

    private void parseResumeWal(TableToken tableToken, int tableNamePosition, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'wal'");
        if (!SqlKeywords.isWalKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'wal' expected");
        }
        if (!this.engine.isWalTable(tableToken)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), tableToken.getTableName()).put(" is not a WAL table.");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        long fromTxn = -1L;
        if (tok != null && !Chars.equals(tok, ';')) {
            if (SqlKeywords.isFromKeyword(tok)) {
                tok = SqlCompilerImpl.expectToken(this.lexer, "'transaction' or 'txn'");
                if (!SqlKeywords.isTransactionKeyword(tok) && !SqlKeywords.isTxnKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'transaction' or 'txn' expected");
                }
                CharSequence txnValue = SqlCompilerImpl.expectToken(this.lexer, "transaction value");
                try {
                    fromTxn = Numbers.parseLong(txnValue);
                }
                catch (NumericException e) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "invalid value [value=").put(txnValue).put(']');
                }
            } else {
                throw SqlException.$(this.lexer.lastTokenPosition(), "'from' expected");
            }
        }
        executionContext.getSecurityContext().authorizeResumeWal(tableToken);
        this.alterTableResume(tableNamePosition, tableToken, fromTxn, executionContext);
    }

    private void parseSuspendWal(TableToken tableToken, int tableNamePosition, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlCompilerImpl.expectToken(this.lexer, "'wal'");
        if (!SqlKeywords.isWalKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'wal' expected");
        }
        if (!this.engine.isWalTable(tableToken)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), tableToken.getTableName()).put(" is not a WAL table.");
        }
        if (!this.configuration.isDevModeEnabled()) {
            throw SqlException.$(0, "Cannot suspend table, database is not in dev mode");
        }
        ErrorTag errorTag = ErrorTag.NONE;
        String errorMessage = "";
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            if (SqlKeywords.isWithKeyword(tok)) {
                tok = SqlCompilerImpl.expectToken(this.lexer, "error code/tag");
                String errorCodeOrTagValue = GenericLexer.unquote(tok).toString();
                try {
                    int errorCode = Numbers.parseInt(errorCodeOrTagValue);
                    errorTag = ErrorTag.resolveTag(errorCode);
                }
                catch (NumericException e) {
                    try {
                        errorTag = ErrorTag.resolveTag(errorCodeOrTagValue);
                    }
                    catch (CairoException cairoException) {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "invalid value [value=").put(errorCodeOrTagValue).put(']');
                    }
                }
                CharSequence comma = SqlCompilerImpl.expectToken(this.lexer, "','");
                if (!Chars.equals(comma, ',')) {
                    throw SqlException.position(this.lexer.getPosition()).put("',' expected");
                }
                tok = SqlCompilerImpl.expectToken(this.lexer, "error message");
                errorMessage = GenericLexer.unquote(tok).toString();
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok != null && !Chars.equals(tok, ';')) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token [token=").put(tok).put(']');
                }
            } else {
                throw SqlException.$(this.lexer.lastTokenPosition(), "'with' expected");
            }
        }
        this.alterTableSuspend(tableNamePosition, tableToken, errorTag, errorMessage, executionContext);
    }

    private TableToken tableExistsOrFail(int position, CharSequence tableName, SqlExecutionContext executionContext) throws SqlException {
        if (executionContext.getTableStatus(this.path, tableName) != 0) {
            throw SqlException.tableDoesNotExist(position, tableName);
        }
        TableToken token = executionContext.getTableTokenIfExists(tableName);
        if (token == null) {
            throw SqlException.tableDoesNotExist(position, tableName);
        }
        return token;
    }

    private void validateAndOptimiseInsertAsSelect(SqlExecutionContext executionContext, InsertModel model) throws SqlException {
        QueryModel queryModel = this.optimiser.optimise(model.getQueryModel(), executionContext, this);
        int columnNameListSize = model.getColumnNameList().size();
        if (columnNameListSize > 0 && queryModel.getBottomUpColumns().size() != columnNameListSize) {
            throw SqlException.$(model.getTableNameExpr().position, "column count mismatch");
        }
        model.setQueryModel(queryModel);
    }

    protected static CharSequence expectToken(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
        }
        if (Chars.equals(tok, ';')) {
            throw SqlException.position(lexer.lastTokenPosition()).put(expected).put(" expected");
        }
        return tok;
    }

    protected static CharSequence maybeExpectToken(GenericLexer lexer, CharSequence expected, boolean expect) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (expect) {
            if (tok == null) {
                throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
            }
            if (Chars.equals(tok, ';')) {
                throw SqlException.position(lexer.lastTokenPosition()).put(expected).put(" expected");
            }
        }
        return tok;
    }

    protected void addColumnSuffix(SecurityContext securityContext, @Nullable CharSequence tok, TableToken tableToken, AlterOperationBuilder alterOperationBuilder) throws SqlException {
        if (tok != null) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    protected void compileAlterExt(SqlExecutionContext executionContext, CharSequence tok) throws SqlException {
        if (tok == null) {
            throw SqlException.position(this.lexer.getPosition()).put("'table' or 'materialized' expected");
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("'table' or 'materialized' expected");
    }

    protected void compileDropExt(@NotNull SqlExecutionContext executionContext, @NotNull GenericDropOperationBuilder opBuilder, @NotNull CharSequence tok, int position) throws SqlException {
        throw SqlException.$(position, "unexpected token [").put(tok).put(']');
    }

    protected void compileDropOther(@NotNull SqlExecutionContext executionContext, @NotNull CharSequence tok, int position) throws SqlException {
        throw SqlException.position(position).put("'table' or 'materialized view' or 'all' expected");
    }

    protected void compileDropReportExpected(int position) throws SqlException {
        throw SqlException.position(position).put("'table' or 'materialized view' or 'all' expected");
    }

    protected RecordCursorFactory generateSelectOneShot(QueryModel selectQueryModel, SqlExecutionContext executionContext, boolean generateProgressLogger) throws SqlException {
        RecordCursorFactory factory = this.codeGenerator.generate(selectQueryModel, executionContext);
        if (generateProgressLogger) {
            return new QueryProgress(this.queryRegistry, this.sqlText, factory);
        }
        return factory;
    }

    @NotNull
    protected SqlOptimiser newSqlOptimiser(CairoConfiguration configuration, CharacterStore characterStore, ObjectPool<ExpressionNode> sqlNodePool, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<QueryModel> queryModelPool, PostOrderTreeTraversalAlgo postOrderTreeTraversalAlgo, FunctionParser functionParser, Path path) {
        return new SqlOptimiser(configuration, characterStore, sqlNodePool, queryColumnPool, queryModelPool, postOrderTreeTraversalAlgo, functionParser, path);
    }

    protected void registerKeywordBasedExecutors() {
        KeywordBasedExecutor compileSet = this::compileSet;
        this.keywordBasedExecutors.put("truncate", this::compileTruncate);
        this.keywordBasedExecutors.put("alter", this::compileAlter);
        this.keywordBasedExecutors.put("reindex", this::compileReindex);
        this.keywordBasedExecutors.put("set", compileSet);
        this.keywordBasedExecutors.put("begin", this::compileBegin);
        this.keywordBasedExecutors.put("commit", this::compileCommit);
        this.keywordBasedExecutors.put("rollback", this::compileRollback);
        this.keywordBasedExecutors.put("discard", compileSet);
        this.keywordBasedExecutors.put("close", compileSet);
        this.keywordBasedExecutors.put("unlisten", compileSet);
        this.keywordBasedExecutors.put("reset", compileSet);
        this.keywordBasedExecutors.put("drop", this::compileDrop);
        this.keywordBasedExecutors.put("backup", (x$0, x$1) -> this.backupAgent.sqlBackup(x$0, x$1));
        this.keywordBasedExecutors.put("vacuum", this::compileVacuum);
        this.keywordBasedExecutors.put("checkpoint", this::compileCheckpoint);
        this.keywordBasedExecutors.put("snapshot", this::compileLegacyCheckpoint);
        this.keywordBasedExecutors.put("deallocate", this::compileDeallocate);
        this.keywordBasedExecutors.put("cancel", this::compileCancel);
        this.keywordBasedExecutors.put("refresh", this::compileRefresh);
    }

    protected void unknownDropColumnSuffix(SecurityContext securityContext, CharSequence tok, TableToken tableToken, AlterOperationBuilder dropColumnStatement) throws SqlException {
        throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
    }

    static {
        sqlControlSymbols.add("(");
        sqlControlSymbols.add(";");
        sqlControlSymbols.add(")");
        sqlControlSymbols.add(",");
        sqlControlSymbols.add("/*");
        sqlControlSymbols.add("/*+");
        sqlControlSymbols.add("*/");
        sqlControlSymbols.add("--");
        sqlControlSymbols.add("[");
        sqlControlSymbols.add("]");
        short[] numericTypes = new short[]{2, 3, 5, 6, 9, 10, 8, 1, 7, 11, 26, 12};
        SqlCompilerImpl.addSupportedConversion((short)2, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)3, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)5, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)6, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)9, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)10, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)8, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)1, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)7, numericTypes);
        SqlCompilerImpl.addSupportedConversion((short)25, 11, 26, 12);
        SqlCompilerImpl.addSupportedConversion((short)19, 11, 26, 12);
        SqlCompilerImpl.addSupportedConversion((short)4, 11, 26, 12);
        SqlCompilerImpl.addSupportedConversion((short)12, 11, 26, 12);
        SqlCompilerImpl.addSupportedConversion((short)11, 11, 26, 12);
        SqlCompilerImpl.addSupportedConversion((short)26, 11, 26, 12);
    }

    private static class TimestampValueRecord
    implements Record {
        private long value;

        private TimestampValueRecord() {
        }

        @Override
        public long getTimestamp(int col) {
            return this.value;
        }

        public void setTimestamp(long value) {
            this.value = value;
        }
    }

    private class DatabaseBackupAgent
    implements Closeable {
        private final Path auxPath;
        private final Path dstPath;
        private final StringSink sink = new StringSink();
        private final Path srcPath;
        private final Utf8SequenceObjHashMap<RecordToRowCopier> tableBackupRowCopiedCache = new Utf8SequenceObjHashMap();
        private final ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet();
        private final ObjHashSet<TableToken> tableTokens = new ObjHashSet();
        private transient String cachedBackupTmpRoot;
        private transient int dstCurrDirLen;
        private transient int dstPathRoot;

        public DatabaseBackupAgent() {
            try {
                this.auxPath = new Path(255, 54);
                this.dstPath = new Path(255, 54);
                this.srcPath = new Path(255, 54);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        public void clear() {
            this.auxPath.trimTo(0);
            this.srcPath.trimTo(0);
            this.dstPath.trimTo(0);
            this.cachedBackupTmpRoot = null;
            this.dstPathRoot = 0;
            this.dstCurrDirLen = 0;
            this.tableBackupRowCopiedCache.clear();
            this.tableTokens.clear();
        }

        @Override
        public void close() {
            this.tableBackupRowCopiedCache.clear();
            Misc.free(this.auxPath);
            Misc.free(this.srcPath);
            Misc.free(this.dstPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void backupTable(@NotNull TableToken tableToken) throws SqlException {
            LOG.info().$("starting backup of ").$(tableToken).$();
            if (this.cachedBackupTmpRoot == null) {
                if (SqlCompilerImpl.this.configuration.getBackupRoot() == null) {
                    throw CairoException.nonCritical().put("backup is disabled, server.conf property 'cairo.sql.backup.root' is not set");
                }
                this.auxPath.of(SqlCompilerImpl.this.configuration.getBackupRoot()).concat(SqlCompilerImpl.this.configuration.getBackupTempDirName()).slash$();
                this.cachedBackupTmpRoot = Utf8s.toString(this.auxPath);
            }
            String tableName = tableToken.getTableName();
            this.auxPath.of(this.cachedBackupTmpRoot).concat(tableToken).slash();
            int tableRootLen = this.auxPath.size();
            try {
                try (TableReader reader = SqlCompilerImpl.this.engine.getReader(tableToken);){
                    block65: {
                        if (SqlCompilerImpl.this.ff.exists(this.auxPath.$())) {
                            throw CairoException.nonCritical().put("backup dir already exists [path=").put(this.auxPath).put(", table=").put(tableName).put(']');
                        }
                        if (SqlCompilerImpl.this.ff.mkdirs(this.auxPath, SqlCompilerImpl.this.configuration.getBackupMkDirMode()) != 0) {
                            throw CairoException.critical(SqlCompilerImpl.this.ff.errno()).put("could not create [dir=").put(this.auxPath).put(']');
                        }
                        try {
                            TableReaderMetadata metadata = reader.getMetadata();
                            SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.trimTo(tableRootLen).concat("_meta").$(), 0);
                            metadata.dumpTo(SqlCompilerImpl.this.mem);
                            this.auxPath.trimTo(tableRootLen).$();
                            int symbolMapCount = 0;
                            int sz = metadata.getColumnCount();
                            for (int i = 0; i < sz; ++i) {
                                if (!ColumnType.isSymbol(metadata.getColumnType(i))) continue;
                                SymbolMapReader mapReader = reader.getSymbolMapReader(i);
                                MapWriter.createSymbolMapFiles(SqlCompilerImpl.this.ff, SqlCompilerImpl.this.mem, this.auxPath, metadata.getColumnName(i), -1L, mapReader.getSymbolCapacity(), mapReader.isCached());
                                ++symbolMapCount;
                            }
                            SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.trimTo(tableRootLen).concat("_txn").$(), 0);
                            TableUtils.createTxn(SqlCompilerImpl.this.mem, symbolMapCount, 0L, 0L, 0L, 0L, metadata.getMetadataVersion(), 0L, 0L);
                            SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.trimTo(tableRootLen).concat("_cv").$(), 0);
                            TableUtils.createColumnVersionFile(SqlCompilerImpl.this.mem);
                            if (tableToken.isWal()) {
                                SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.trimTo(tableRootLen).concat("_name").$(), 0);
                                TableUtils.createTableNameFile(SqlCompilerImpl.this.mem, tableToken.getTableName());
                                this.auxPath.trimTo(tableRootLen).concat("txn_seq").slash$();
                                if (SqlCompilerImpl.this.ff.mkdirs(this.auxPath, SqlCompilerImpl.this.configuration.getBackupMkDirMode()) != 0) {
                                    throw CairoException.critical(SqlCompilerImpl.this.ff.errno()).put("Cannot create [path=").put(this.auxPath).put(']');
                                }
                                int len = this.auxPath.size();
                                SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.concat("_wal_index.d").$(), 0);
                                SqlCompilerImpl.this.mem.putLong(0L);
                                SqlCompilerImpl.this.mem.close(true, (byte)1);
                                WalUtils.createTxnLogFile(SqlCompilerImpl.this.ff, SqlCompilerImpl.this.mem, this.auxPath.trimTo(len), SqlCompilerImpl.this.configuration.getMicrosecondClock().getTicks(), SqlCompilerImpl.this.configuration.getDefaultSeqPartTxnCount(), SqlCompilerImpl.this.configuration.getMkDirMode());
                                SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.trimTo(len).concat("_txnlog.meta.i").$(), 0);
                                SqlCompilerImpl.this.mem.putLong(0L);
                                SqlCompilerImpl.this.mem.close(true, (byte)1);
                                SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.trimTo(len).concat("_txnlog.meta.d").$(), 0);
                                SqlCompilerImpl.this.mem.close(true, (byte)1);
                                SqlCompilerImpl.this.mem.smallFile(SqlCompilerImpl.this.ff, this.auxPath.trimTo(len).concat("_meta").$(), 0);
                                WalWriterMetadata.syncToMetaFile(SqlCompilerImpl.this.mem, metadata.getMetadataVersion(), metadata.getColumnCount(), metadata.getTimestampIndex(), metadata.getTableId(), false, metadata);
                                SqlCompilerImpl.this.mem.close(true, (byte)1);
                            }
                            if (!tableToken.isMatView()) break block65;
                            try (BlockFileReader matViewFileReader = new BlockFileReader(SqlCompilerImpl.this.configuration);
                                 BlockFileWriter matViewFileWriter = new BlockFileWriter(SqlCompilerImpl.this.ff, SqlCompilerImpl.this.configuration.getCommitMode());){
                                MatViewGraph graph = SqlCompilerImpl.this.engine.getMatViewGraph();
                                MatViewDefinition matViewDefinition = graph.getViewDefinition(tableToken);
                                if (matViewDefinition != null) {
                                    boolean isMatViewStateExists = TableUtils.isMatViewStateFileExists(SqlCompilerImpl.this.configuration, this.srcPath, tableToken.getDirName());
                                    if (isMatViewStateExists) {
                                        matViewFileReader.of(this.srcPath.of(SqlCompilerImpl.this.configuration.getDbRoot()).concat(tableToken.getDirName()).concat("_mv.s").$());
                                        MatViewStateReader matViewStateReader = new MatViewStateReader().of(matViewFileReader, tableToken);
                                        matViewFileWriter.of(this.auxPath.trimTo(tableRootLen).concat("_mv.s").$());
                                        MatViewState.append(matViewStateReader, matViewFileWriter);
                                        matViewFileWriter.of(this.auxPath.trimTo(tableRootLen).concat("_mv").$());
                                        MatViewDefinition.append(matViewDefinition, matViewFileWriter);
                                    } else {
                                        LOG.info().$("materialized view state for backup not found [view=").$(tableToken).I$();
                                    }
                                } else {
                                    LOG.info().$("materialized view definition for backup not found [view=").$(tableToken).I$();
                                }
                            }
                        }
                        finally {
                            SqlCompilerImpl.this.mem.close();
                        }
                    }
                    try (TableWriter backupWriter = SqlCompilerImpl.this.engine.getBackupWriter(tableToken, this.cachedBackupTmpRoot);){
                        TableMetadata writerMetadata = backupWriter.getMetadata();
                        this.srcPath.of(tableName).slash().put(reader.getMetadataVersion()).$();
                        RecordToRowCopier recordToRowCopier = this.tableBackupRowCopiedCache.get(this.srcPath);
                        if (recordToRowCopier == null) {
                            SqlCompilerImpl.this.entityColumnFilter.of(writerMetadata.getColumnCount());
                            recordToRowCopier = RecordToRowCopierUtils.generateCopier(SqlCompilerImpl.this.asm, reader.getMetadata(), writerMetadata, SqlCompilerImpl.this.entityColumnFilter);
                            this.tableBackupRowCopiedCache.put(this.srcPath, recordToRowCopier);
                        }
                        this.sink.clear();
                        ((Utf16Sink)this.sink.put('\'').put(tableName)).put('\'');
                        try (SqlExecutionContextImpl allowAllContext = new SqlExecutionContextImpl(SqlCompilerImpl.this.engine, 1).with(AllowAllSecurityContext.INSTANCE);){
                            while (true) {
                                try (RecordCursorFactory factory = SqlCompilerImpl.this.engine.select(this.sink, allowAllContext);){
                                    RecordCursor cursor = factory.getCursor(allowAllContext);
                                    try {
                                        SqlCompilerImpl.this.copyTableData(cursor, factory.getMetadata(), backupWriter, writerMetadata, recordToRowCopier, SqlCompilerImpl.this.configuration.getCreateTableModelBatchSize(), SqlCompilerImpl.this.configuration.getO3MaxLag(), SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER);
                                        if (cursor != null) {
                                            cursor.close();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (cursor != null) {
                                            try {
                                                cursor.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (TableReferenceOutOfDateException ex) {
                                    LOG.info().$("retrying backup due to concurrent metadata update [table=").$safe(tableName).$(", ex=").$(ex.getFlyweightMessage()).I$();
                                    continue;
                                }
                                break;
                            }
                        }
                        backupWriter.commit();
                    }
                }
                int renameRootLen = this.dstPath.size();
                try {
                    this.dstPath.trimTo(renameRootLen).concat(tableToken);
                    TableUtils.renameOrFail(SqlCompilerImpl.this.ff, this.auxPath.trimTo(tableRootLen).$(), this.dstPath.$());
                    LOG.info().$("backup complete [table=").$safe(tableName).$(", to=").$(this.dstPath).I$();
                }
                finally {
                    this.dstPath.trimTo(renameRootLen).$();
                }
            }
            catch (CairoException e) {
                LOG.info().$("could not backup [table=").$safe(tableName).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                this.auxPath.of(this.cachedBackupTmpRoot).concat(tableToken).slash$();
                if (!SqlCompilerImpl.this.ff.rmdir(this.auxPath)) {
                    LOG.error().$("could not delete directory [path=").$(this.auxPath).$(", errno=").$(SqlCompilerImpl.this.ff.errno()).I$();
                }
                throw e;
            }
        }

        private void mkBackupDstDir(CharSequence dir, String errorMessage) {
            this.dstPath.trimTo(this.dstPathRoot).concat(dir).slash$();
            this.dstCurrDirLen = this.dstPath.size();
            if (SqlCompilerImpl.this.ff.mkdirs(this.dstPath, SqlCompilerImpl.this.configuration.getBackupMkDirMode()) != 0) {
                throw CairoException.critical(SqlCompilerImpl.this.ff.errno()).put(errorMessage).put(this.dstPath).put(']');
            }
        }

        private void mkBackupDstRoot() {
            DateFormat format = SqlCompilerImpl.this.configuration.getBackupDirTimestampFormat();
            long epochMicros = SqlCompilerImpl.this.configuration.getMicrosecondClock().getTicks();
            this.dstPath.of(SqlCompilerImpl.this.configuration.getBackupRoot()).slash();
            int plen = this.dstPath.size();
            int n = 0;
            do {
                this.dstPath.trimTo(plen);
                format.format(epochMicros, SqlCompilerImpl.this.configuration.getDefaultDateLocale(), null, this.dstPath);
                if (n > 0) {
                    this.dstPath.put('.').put(n);
                }
                this.dstPath.slash();
                ++n;
            } while (SqlCompilerImpl.this.ff.exists(this.dstPath.$()));
            if (SqlCompilerImpl.this.ff.mkdirs(this.dstPath, SqlCompilerImpl.this.configuration.getBackupMkDirMode()) != 0) {
                throw CairoException.critical(SqlCompilerImpl.this.ff.errno()).put("could not create backup [dir=").put(this.dstPath).put(']');
            }
            this.dstPathRoot = this.dstPath.size();
        }

        private void sqlBackup(SqlExecutionContext executionContext, CharSequence sqlText) throws SqlException {
            if (SqlCompilerImpl.this.configuration.getBackupRoot() == null) {
                throw CairoException.nonCritical().put("backup is disabled, server.conf property 'cairo.sql.backup.root' is not set");
            }
            CharSequence tok = SqlUtil.fetchNext(SqlCompilerImpl.this.lexer);
            if (tok != null) {
                if (SqlKeywords.isTableKeyword(tok)) {
                    this.sqlTableBackup(executionContext);
                    return;
                }
                if (SqlKeywords.isDatabaseKeyword(tok)) {
                    this.sqlDatabaseBackup(executionContext);
                    return;
                }
                if (SqlKeywords.isMaterializedKeyword(tok) && (tok = SqlUtil.fetchNext(SqlCompilerImpl.this.lexer)) != null && SqlKeywords.isViewKeyword(tok)) {
                    this.sqlTableBackup(executionContext);
                    return;
                }
            }
            throw SqlException.position(SqlCompilerImpl.this.lexer.lastTokenPosition()).put("expected 'table', 'materialized view' or 'database'");
        }

        private void sqlDatabaseBackup(SqlExecutionContext executionContext) throws SqlException {
            this.mkBackupDstRoot();
            this.mkBackupDstDir(SqlCompilerImpl.this.configuration.getDbDirectory(), "could not create backup [db dir=");
            SqlCompilerImpl.this.engine.getTableTokens(this.tableTokenBucket, false);
            executionContext.getSecurityContext().authorizeTableBackup(this.tableTokens);
            int n = this.tableTokenBucket.size();
            for (int i = 0; i < n; ++i) {
                this.backupTable(this.tableTokenBucket.get(i));
            }
            this.srcPath.of(SqlCompilerImpl.this.configuration.getDbRoot()).$();
            int srcLen = this.srcPath.size();
            int version = TableNameRegistryStore.findLastTablesFileVersion(SqlCompilerImpl.this.ff, this.srcPath, this.sink);
            this.srcPath.trimTo(srcLen).concat("tables.d").putAscii('.').put(version);
            this.dstPath.trimTo(this.dstCurrDirLen).concat("tables.d").putAscii(".0");
            LOG.info().$("backup copying file [from=").$(this.srcPath).$(", to=").$(this.dstPath).I$();
            if (SqlCompilerImpl.this.ff.copy(this.srcPath.$(), this.dstPath.$()) < 0) {
                throw CairoException.critical(SqlCompilerImpl.this.ff.errno()).put("cannot backup table registry file [from=").put(this.srcPath).put(", to=").put(this.dstPath).put(']');
            }
            this.srcPath.trimTo(srcLen).concat("_tab_index.d");
            this.dstPath.trimTo(this.dstCurrDirLen).concat("_tab_index.d");
            LOG.info().$("backup copying file [from=").$(this.srcPath).$(", to=").$(this.dstPath).I$();
            if (SqlCompilerImpl.this.ff.copy(this.srcPath.$(), this.dstPath.$()) < 0) {
                throw CairoException.critical(SqlCompilerImpl.this.ff.errno()).put("cannot backup table index file [from=").put(this.srcPath).put(", to=").put(this.dstPath).put(']');
            }
            this.mkBackupDstDir("conf", "could not create backup [conf dir=");
            SqlCompilerImpl.this.ff.copyRecursive(this.srcPath.of(SqlCompilerImpl.this.configuration.getConfRoot()), this.auxPath.of(this.dstPath), SqlCompilerImpl.this.configuration.getMkDirMode());
            SqlCompilerImpl.this.compiledQuery.ofBackupTable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sqlTableBackup(SqlExecutionContext executionContext) throws SqlException {
            this.mkBackupDstRoot();
            this.mkBackupDstDir(SqlCompilerImpl.this.configuration.getDbDirectory(), "could not create backup [db dir=");
            try {
                block6: {
                    CharSequence tok;
                    this.tableTokens.clear();
                    do {
                        if ((tok = SqlUtil.fetchNext(SqlCompilerImpl.this.lexer)) == null) {
                            throw SqlException.position(SqlCompilerImpl.this.lexer.getPosition()).put("expected a table name");
                        }
                        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), SqlCompilerImpl.this.lexer.lastTokenPosition());
                        TableToken tableToken = SqlCompilerImpl.this.tableExistsOrFail(SqlCompilerImpl.this.lexer.lastTokenPosition(), tableName, executionContext);
                        this.tableTokens.add(tableToken);
                        tok = SqlUtil.fetchNext(SqlCompilerImpl.this.lexer);
                        if (tok == null || Chars.equals(tok, ';')) break block6;
                    } while (Chars.equals(tok, ','));
                    throw SqlException.position(SqlCompilerImpl.this.lexer.lastTokenPosition()).put("expected ','");
                }
                executionContext.getSecurityContext().authorizeTableBackup(this.tableTokens);
                int n = this.tableTokens.size();
                for (int i = 0; i < n; ++i) {
                    this.backupTable(this.tableTokens.get(i));
                }
                SqlCompilerImpl.this.compiledQuery.ofBackupTable();
            }
            finally {
                this.tableTokens.clear();
            }
        }
    }

    public static final class PartitionAction {
        public static final int ATTACH = 2;
        public static final int CONVERT_TO_NATIVE = 5;
        public static final int CONVERT_TO_PARQUET = 4;
        public static final int DETACH = 3;
        public static final int DROP = 1;
        public static final int FORCE_DROP = 6;
    }

    @FunctionalInterface
    public static interface KeywordBasedExecutor {
        public void execute(SqlExecutionContext var1, CharSequence var2) throws SqlException;
    }
}

