/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryScanner;
import io.questdb.log.Log;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class FunctionFactoryCacheBuilder {
    private static ArrayList<FunctionFactory> functionFactoriesCache;
    private static final String FUNCTION_LIST_FILE_NAME = "function_list.txt";
    ArrayList<FunctionFactory> functionFactories;

    public static void clearCache() {
        functionFactoriesCache = null;
    }

    public FunctionFactoryCacheBuilder scan(@Nullable Log log) {
        return this.scan("io.questdb.griffin.engine.functions", FUNCTION_LIST_FILE_NAME, FunctionFactoryCacheBuilder.class, "io.questdb", log);
    }

    public FunctionFactoryCacheBuilder scan(String packageName, String functionListFileName, Class<?> clazz, String moduleName, @Nullable Log log) {
        if (functionFactoriesCache != null) {
            return this;
        }
        if (this.functionFactories == null) {
            this.functionFactories = new ArrayList();
        }
        FunctionFactoryScanner.scan(this.functionFactories, packageName, functionListFileName, clazz, moduleName, log);
        return this;
    }

    public Iterable<FunctionFactory> build() {
        if (functionFactoriesCache != null) {
            return functionFactoriesCache;
        }
        functionFactoriesCache = this.functionFactories;
        return this.functionFactories;
    }
}

