/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRecordCursorFactory;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.CreateMatViewOperation;
import io.questdb.griffin.engine.ops.CreateTableOperation;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.griffin.engine.ops.OperationDispatcher;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import org.jetbrains.annotations.Nullable;

public class CompiledQueryImpl
implements CompiledQuery,
Mutable {
    private final OperationDispatcher<AlterOperation> alterOperationDispatcher;
    private final DoneOperationFuture doneFuture = new DoneOperationFuture();
    private final OperationDispatcher<UpdateOperation> updateOperationDispatcher;
    private long affectedRowsCount;
    private AlterOperation alterOp;
    private boolean done;
    private InsertOperation insertOp;
    private boolean isExecutedAtParseTime;
    private Operation operation;
    private RecordCursorFactory recordCursorFactory;
    private SqlExecutionContext sqlExecutionContext;
    private String sqlStatement;
    private CharSequence statementName;
    private short type;
    private UpdateOperation updateOp;

    public CompiledQueryImpl(CairoEngine engine) {
        this.updateOperationDispatcher = new OperationDispatcher<UpdateOperation>(engine, "sync 'UPDATE' execution"){

            @Override
            protected long apply(UpdateOperation operation, TableWriterAPI writerAPI) {
                return writerAPI.apply(operation);
            }
        };
        this.alterOperationDispatcher = new OperationDispatcher<AlterOperation>(engine, "Alter table execute"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected long apply(AlterOperation operation, TableWriterAPI writerAPI) {
                try {
                    long l = writerAPI.apply(operation, true);
                    return l;
                }
                finally {
                    operation.clearSecurityContext();
                }
            }
        };
    }

    @Override
    public void clear() {
        this.type = 0;
        this.recordCursorFactory = null;
        this.affectedRowsCount = -1L;
        this.insertOp = null;
        this.alterOp = null;
        this.updateOp = null;
        this.statementName = null;
        this.operation = null;
        this.isExecutedAtParseTime = false;
        this.done = false;
    }

    public void done() {
        this.done = true;
    }

    @Override
    public OperationFuture execute(SCSequence eventSubSeq) throws SqlException {
        return this.execute(this.sqlExecutionContext, eventSubSeq, true);
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext, SCSequence eventSubSeq, boolean closeOnDone) throws SqlException {
        if (this.done) {
            return this.doneFuture.of(0L);
        }
        switch (this.type) {
            case 2: 
            case 10: {
                OperationFuture future = this.insertOp.execute(sqlExecutionContext);
                if (closeOnDone) {
                    Misc.free(this.insertOp);
                }
                return future;
            }
            case 14: {
                this.updateOp.withSqlStatement(this.sqlStatement);
                return this.updateOperationDispatcher.execute(this.updateOp, sqlExecutionContext, eventSubSeq, closeOnDone);
            }
            case 4: {
                this.alterOp.withSqlStatement(this.sqlStatement);
                return this.alterOperationDispatcher.execute(this.alterOp, sqlExecutionContext, eventSubSeq, closeOnDone);
            }
            case 7: 
            case 9: 
            case 21: 
            case 32: {
                assert (false);
                break;
            }
        }
        return this.doneFuture.of(0L);
    }

    @Override
    public boolean executedAtParseTime() {
        return this.isExecutedAtParseTime;
    }

    @Override
    public long getAffectedRowsCount() {
        return this.affectedRowsCount;
    }

    @Override
    public AlterOperation getAlterOperation() {
        return this.alterOp;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        return this.recordCursorFactory;
    }

    @Override
    public String getSqlText() {
        return this.sqlStatement;
    }

    @Override
    public CharSequence getStatementName() {
        return this.statementName;
    }

    @Override
    public short getType() {
        return this.type;
    }

    @Override
    public UpdateOperation getUpdateOperation() {
        return this.updateOp;
    }

    public void ofAlter(AlterOperation alterOp) {
        this.of((short)4);
        this.alterOp = alterOp;
        this.isExecutedAtParseTime = false;
    }

    public void ofAlterUser() {
        this.of((short)29);
        this.isExecutedAtParseTime = true;
    }

    public void ofBackupTable() {
        this.of((short)13);
        this.isExecutedAtParseTime = true;
    }

    public void ofBegin() {
        this.of((short)18);
        this.isExecutedAtParseTime = false;
    }

    public void ofCancelQuery() {
        this.of((short)30);
        this.isExecutedAtParseTime = true;
    }

    public void ofCheckpointCreate() {
        this.of((short)22);
        this.isExecutedAtParseTime = true;
    }

    public void ofCheckpointRelease() {
        this.of((short)23);
        this.isExecutedAtParseTime = true;
    }

    public void ofCommit() {
        this.of((short)19);
        this.isExecutedAtParseTime = false;
    }

    public void ofCopyRemote() {
        this.of((short)11);
        this.isExecutedAtParseTime = true;
    }

    public void ofCreateMatView(CreateMatViewOperation createMatViewOp) {
        this.of((short)32);
        this.operation = createMatViewOp;
        this.isExecutedAtParseTime = false;
    }

    public void ofCreateTable(CreateTableOperation createTableOp) {
        this.of(createTableOp.getSelectText() == null ? (short)9 : 21);
        this.operation = createTableOp;
        this.isExecutedAtParseTime = false;
    }

    public void ofCreateUser() {
        this.of((short)28);
        this.isExecutedAtParseTime = true;
    }

    public void ofDeallocate(CharSequence statementName) {
        this.statementName = Chars.toString(statementName);
        this.of((short)24);
        this.isExecutedAtParseTime = false;
    }

    public void ofDrop(Operation op) {
        this.of((short)7);
        this.operation = op;
        this.isExecutedAtParseTime = false;
    }

    public void ofEmpty() {
        this.of((short)34, new EmptyTableRecordCursorFactory(EmptyRecordMetadata.INSTANCE));
        this.isExecutedAtParseTime = false;
    }

    public void ofExplain(RecordCursorFactory recordCursorFactory) {
        this.of((short)25, recordCursorFactory);
        this.isExecutedAtParseTime = false;
    }

    public void ofInsert(InsertOperation insertOperation, boolean isInsectAsSelect) {
        this.insertOp = insertOperation;
        this.of(isInsectAsSelect ? (short)10 : 2);
        this.isExecutedAtParseTime = false;
    }

    public void ofNone() {
        this.of((short)0);
    }

    public void ofPseudoSelect(@Nullable RecordCursorFactory factory) {
        this.type = (short)8;
        this.recordCursorFactory = factory;
        this.affectedRowsCount = -1L;
        this.isExecutedAtParseTime = false;
    }

    public void ofRefreshMatView() {
        this.type = (short)33;
        this.isExecutedAtParseTime = true;
    }

    public void ofRenameTable() {
        this.of((short)12);
        this.isExecutedAtParseTime = true;
    }

    public void ofRepair() {
        this.of((short)5);
        this.isExecutedAtParseTime = true;
    }

    public void ofRollback() {
        this.of((short)20);
        this.isExecutedAtParseTime = false;
    }

    public void ofSelect(RecordCursorFactory recordCursorFactory) {
        this.of((short)1, recordCursorFactory);
        this.isExecutedAtParseTime = false;
    }

    public void ofSet() {
        this.of((short)6);
        this.isExecutedAtParseTime = true;
    }

    public void ofTableResume() {
        this.type = (short)26;
        this.isExecutedAtParseTime = true;
    }

    public void ofTableSetType() {
        this.type = (short)27;
        this.isExecutedAtParseTime = true;
    }

    public void ofTableSuspend() {
        this.type = (short)31;
        this.isExecutedAtParseTime = true;
    }

    public void ofTruncate() {
        this.of((short)3);
        this.isExecutedAtParseTime = true;
    }

    public void ofUpdate(UpdateOperation updateOperation) {
        this.updateOp = updateOperation;
        this.type = (short)14;
        this.isExecutedAtParseTime = false;
    }

    public void ofVacuum() {
        this.of((short)17);
        this.isExecutedAtParseTime = true;
    }

    @Override
    public InsertOperation popInsertOperation() {
        InsertOperation op = this.insertOp;
        this.insertOp = null;
        return op;
    }

    @Override
    public CompiledQueryImpl withContext(SqlExecutionContext sqlExecutionContext) {
        this.sqlExecutionContext = sqlExecutionContext;
        return this;
    }

    @Override
    public void withSqlText(String sqlText) {
        this.sqlStatement = sqlText;
    }

    private CompiledQuery of(short type) {
        return this.of(type, null);
    }

    private CompiledQuery of(short type, RecordCursorFactory factory) {
        this.type = type;
        this.recordCursorFactory = factory;
        this.affectedRowsCount = -1L;
        return this;
    }
}

