/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpLegacyWriterJob;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementEvent;
import io.questdb.cutlass.line.tcp.LineTcpNetworkIOJob;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.LineWalAppender;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.TableStructureAdapter;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.cutlass.line.tcp.WalTableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.Utf8StringObjHashMap;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.TelemetryTask;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class LineTcpMeasurementScheduler
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpMeasurementScheduler.class);
    private final ObjList<TableUpdateDetails>[] assignedTables;
    private final boolean autoCreateNewColumns;
    private final boolean autoCreateNewTables;
    private final MillisecondClock clock;
    private final LineTcpReceiverConfiguration configuration;
    private final MemoryMARW ddlMem = Vm.getCMARWInstance();
    private final DefaultColumnTypes defaultColumnTypes;
    private final CairoEngine engine;
    private final LowerCaseCharSequenceObjHashMap<TableUpdateDetails> idleTableUpdateDetailsUtf16;
    private final LineWalAppender lineWalAppender;
    private final long[] loadByWriterThread;
    private final NetworkIOJob[] netIoJobs;
    private final Path path = new Path();
    private final MPSequence[] pubSeq;
    private final RingQueue<LineTcpMeasurementEvent>[] queue;
    private final long spinLockTimeoutMs;
    private final StringSink[] tableNameSinks;
    private final TableStructureAdapter tableStructureAdapter;
    private final ReadWriteLock tableUpdateDetailsLock = new SimpleReadWriteLock();
    private final LowerCaseCharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf16;
    private final Telemetry<TelemetryTask> telemetry;
    private final long writerIdleTimeout;

    public LineTcpMeasurementScheduler(LineTcpReceiverConfiguration lineConfiguration, CairoEngine engine, WorkerPool networkSharedPool, IODispatcher<LineTcpConnectionContext> dispatcher, WorkerPool writerWorkerPool) {
        try {
            this.engine = engine;
            this.telemetry = engine.getTelemetry();
            CairoConfiguration cairoConfiguration = engine.getConfiguration();
            this.configuration = lineConfiguration;
            this.clock = cairoConfiguration.getMillisecondClock();
            this.spinLockTimeoutMs = cairoConfiguration.getSpinLockTimeout();
            this.defaultColumnTypes = new DefaultColumnTypes(lineConfiguration);
            int networkSharedPoolSize = networkSharedPool.getWorkerCount();
            this.netIoJobs = new NetworkIOJob[networkSharedPoolSize];
            this.tableNameSinks = new StringSink[networkSharedPoolSize];
            for (int i = 0; i < networkSharedPoolSize; ++i) {
                NetworkIOJob netIoJob;
                this.tableNameSinks[i] = new StringSink();
                this.netIoJobs[i] = netIoJob = this.createNetworkIOJob(dispatcher, i);
                networkSharedPool.assign(i, netIoJob);
                networkSharedPool.freeOnExit(netIoJob);
            }
            this.tableUpdateDetailsUtf16 = new LowerCaseCharSequenceObjHashMap();
            this.idleTableUpdateDetailsUtf16 = new LowerCaseCharSequenceObjHashMap();
            this.loadByWriterThread = new long[writerWorkerPool.getWorkerCount()];
            this.autoCreateNewTables = lineConfiguration.getAutoCreateNewTables();
            this.autoCreateNewColumns = lineConfiguration.getAutoCreateNewColumns();
            int maxMeasurementSize = lineConfiguration.getMaxMeasurementSize();
            int queueSize = lineConfiguration.getWriterQueueCapacity();
            long commitInterval = this.configuration.getCommitInterval();
            int nWriterThreads = writerWorkerPool.getWorkerCount();
            this.pubSeq = new MPSequence[nWriterThreads];
            this.queue = new RingQueue[nWriterThreads];
            this.assignedTables = new ObjList[nWriterThreads];
            for (int i = 0; i < nWriterThreads; ++i) {
                MPSequence ps;
                this.pubSeq[i] = ps = new MPSequence(queueSize);
                RingQueue<LineTcpMeasurementEvent> q = new RingQueue<LineTcpMeasurementEvent>((address, addressSize) -> new LineTcpMeasurementEvent(address, addressSize, lineConfiguration.getMicrosecondClock(), lineConfiguration.getTimestampAdapter(), this.defaultColumnTypes, lineConfiguration.isStringToCharCastAllowed(), lineConfiguration.getMaxFileNameLength(), lineConfiguration.getAutoCreateNewColumns()), LineTcpMeasurementScheduler.getEventSlotSize(maxMeasurementSize), queueSize, 34);
                this.queue[i] = q;
                SCSequence subSeq = new SCSequence();
                ps.then(subSeq).then(ps);
                this.assignedTables[i] = new ObjList();
                LineTcpLegacyWriterJob lineTcpLegacyWriterJob = new LineTcpLegacyWriterJob(i, q, subSeq, this.clock, commitInterval, this, engine.getMetrics(), this.assignedTables[i]);
                writerWorkerPool.assign(i, lineTcpLegacyWriterJob);
                writerWorkerPool.freeOnExit(lineTcpLegacyWriterJob);
            }
            this.tableStructureAdapter = new TableStructureAdapter(cairoConfiguration, this.defaultColumnTypes, this.configuration.getDefaultPartitionBy(), cairoConfiguration.getWalEnabledDefault());
            this.writerIdleTimeout = lineConfiguration.getWriterIdleTimeout();
            this.lineWalAppender = new LineWalAppender(this.autoCreateNewColumns, this.configuration.isStringToCharCastAllowed(), this.configuration.getTimestampAdapter(), cairoConfiguration.getMaxFileNameLength(), this.configuration.getMicrosecondClock());
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void close() {
        int i;
        this.tableUpdateDetailsLock.writeLock().lock();
        try {
            this.closeLocals(this.tableUpdateDetailsUtf16);
            this.closeLocals(this.idleTableUpdateDetailsUtf16);
        }
        finally {
            this.tableUpdateDetailsLock.writeLock().unlock();
        }
        Misc.free(this.path);
        Misc.free(this.ddlMem);
        int n = this.assignedTables.length;
        for (i = 0; i < n; ++i) {
            Misc.freeObjList(this.assignedTables[i]);
            this.assignedTables[i].clear();
        }
        n = this.queue.length;
        for (i = 0; i < n; ++i) {
            Misc.free(this.queue[i]);
        }
        n = this.netIoJobs.length;
        for (i = 0; i < n; ++i) {
            this.netIoJobs[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doMaintenance(Utf8StringObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8, int readerWorkerId, long millis) {
        int sz = tableUpdateDetailsUtf8.size();
        for (int n = 0; n < sz; ++n) {
            Utf8String tableNameUtf8 = tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tud = tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (millis - tud.getLastMeasurementMillis() < this.writerIdleTimeout) continue;
            this.tableUpdateDetailsLock.writeLock().lock();
            try {
                if (tud.getNetworkIOOwnerCount() == 1) {
                    int writerWorkerId = tud.getWriterThreadId();
                    long seq = this.getNextPublisherEventSequence(writerWorkerId);
                    if (seq > -1L) {
                        LineTcpMeasurementEvent event = this.queue[writerWorkerId].get(seq);
                        event.createWriterReleaseEvent(tud, true);
                        tableUpdateDetailsUtf8.remove(tableNameUtf8);
                        String tableNameUtf16 = tud.getTableNameUtf16();
                        this.tableUpdateDetailsUtf16.remove(tableNameUtf16);
                        this.idleTableUpdateDetailsUtf16.put(tableNameUtf16, tud);
                        tud.removeReference(readerWorkerId);
                        this.pubSeq[writerWorkerId].done(seq);
                        LOG.info().$("active table going idle [tableName=").$safe(tableNameUtf16).I$();
                    }
                    boolean bl = true;
                    return bl;
                }
                tableUpdateDetailsUtf8.remove(tableNameUtf8);
                tud.removeReference(readerWorkerId);
                boolean bl = sz > 1;
                return bl;
            }
            finally {
                this.tableUpdateDetailsLock.writeLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWriterReleaseEvent(LineTcpMeasurementEvent event, int workerId) {
        this.tableUpdateDetailsLock.readLock().lock();
        try {
            TableUpdateDetails tub = event.getTableUpdateDetails();
            if (tub.getWriterThreadId() != workerId) {
                return;
            }
            if (!event.getTableUpdateDetails().isWriterInError() && this.tableUpdateDetailsUtf16.keyIndex(tub.getTableNameUtf16()) < 0) {
                return;
            }
            LOG.info().$("releasing writer, its been idle since ").$ts(tub.getLastMeasurementMillis() * 1000L).$("[tableName=").$safe(tub.getTableNameUtf16()).I$();
            event.releaseWriter();
        }
        finally {
            this.tableUpdateDetailsLock.readLock().unlock();
        }
    }

    public void releaseWalTableDetails(Utf8StringObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8) {
        ObjList<Utf8String> keys = tableUpdateDetailsUtf8.keys();
        for (int n = keys.size() - 1; n > -1; --n) {
            Utf8String tableNameUtf8 = keys.getQuick(n);
            TableUpdateDetails tud = tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (!tud.isWal()) continue;
            tableUpdateDetailsUtf8.remove(tableNameUtf8);
        }
    }

    public boolean scheduleEvent(SecurityContext securityContext, NetworkIOJob netIoJob, LineTcpConnectionContext ctx, LineTcpParser parser) throws Exception {
        TableUpdateDetails tud;
        DirectUtf8Sequence measurementName = parser.getMeasurementName();
        try {
            tud = ctx.getTableUpdateDetails(measurementName);
            if (tud == null) {
                tud = netIoJob.getLocalTableDetails(measurementName);
                if (tud == null) {
                    tud = this.getTableUpdateDetailsFromSharedArea(securityContext, netIoJob, ctx, parser);
                }
            } else if (tud.isWriterInError()) {
                TableUpdateDetails removed = ctx.removeTableUpdateDetails(measurementName);
                assert (tud == removed);
                removed.close();
                tud = this.getTableUpdateDetailsFromSharedArea(securityContext, netIoJob, ctx, parser);
            }
        }
        catch (EntryUnavailableException ex) {
            LOG.info().$("could not get table writer [tableName=").$(measurementName).$(", ex=`").$(ex.getFlyweightMessage()).$("`]").$();
            return true;
        }
        catch (CairoException ex) {
            LOG.error().$("could not create table [tableName=").$(measurementName).$(", msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            throw ex;
        }
        if (tud.isWal()) {
            try {
                this.lineWalAppender.appendToWal(securityContext, parser, tud);
            }
            catch (CommitFailedException ex) {
                if (ex.isTableDropped()) {
                    LOG.info().$("closing writer because table has been dropped (1) [table=").$(measurementName).I$();
                    tud.setWriterInError();
                    tud.releaseWriter(false);
                    return false;
                }
                LineTcpMeasurementScheduler.handleAppendException(measurementName, tud, ex);
            }
            catch (Throwable ex) {
                LineTcpMeasurementScheduler.handleAppendException(measurementName, tud, ex);
            }
            return false;
        }
        return this.dispatchEvent(securityContext, netIoJob, parser, tud);
    }

    private static long getEventSlotSize(int maxMeasurementSize) {
        return Numbers.ceilPow2((long)(maxMeasurementSize / 4) * 13L);
    }

    private static void handleAppendException(DirectUtf8Sequence measurementName, TableUpdateDetails tud, Throwable ex) {
        tud.setWriterInError();
        LogRecord logRecord = ex instanceof CairoException && !((CairoException)ex).isCritical() ? LOG.error() : LOG.critical();
        logRecord.$("closing writer because of error [table=").$(tud.getTableNameUtf16()).$(", ex=").$(ex).I$();
        throw CairoException.critical(0).put("could not write ILP message to WAL [tableName=").put(measurementName).put(", error=").put(ex.getMessage()).put(']');
    }

    private void closeLocals(LowerCaseCharSequenceObjHashMap<TableUpdateDetails> tudUtf16) {
        ObjList tableNames = tudUtf16.keys();
        int sz = tableNames.size();
        for (int n = 0; n < sz; ++n) {
            tudUtf16.get((CharSequence)tableNames.get(n)).closeLocals();
        }
        tudUtf16.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchEvent(SecurityContext securityContext, NetworkIOJob netIoJob, LineTcpParser parser, TableUpdateDetails tud) {
        int writerThreadId = tud.getWriterThreadId();
        long seq = this.getNextPublisherEventSequence(writerThreadId);
        if (seq > -1L) {
            try {
                if (tud.isWriterInError()) {
                    throw CairoException.critical(0).put("writer is in error, aborting ILP pipeline");
                }
                this.queue[writerThreadId].get(seq).createMeasurementEvent(securityContext, tud, parser, netIoJob.getWorkerId());
            }
            finally {
                this.pubSeq[writerThreadId].done(seq);
            }
            tud.incrementEventsProcessedSinceReshuffle();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableUpdateDetails getTableUpdateDetailsFromSharedArea(SecurityContext securityContext, @NotNull NetworkIOJob netIoJob, @NotNull LineTcpConnectionContext ctx, @NotNull LineTcpParser parser) {
        DirectUtf8Sequence tableNameUtf8 = parser.getMeasurementName();
        StringSink tableNameUtf16 = this.tableNameSinks[netIoJob.getWorkerId()];
        tableNameUtf16.clear();
        Utf8s.utf8ToUtf16(tableNameUtf8.lo(), tableNameUtf8.hi(), tableNameUtf16);
        this.tableUpdateDetailsLock.writeLock().lock();
        try {
            TableUpdateDetails tud;
            block15: {
                TableToken tableToken;
                int tudKeyIndex;
                block16: {
                    long deadline = this.clock.getTicks() + this.spinLockTimeoutMs;
                    do {
                        int idleTudKeyIndex;
                        if ((tudKeyIndex = this.tableUpdateDetailsUtf16.keyIndex(tableNameUtf16)) < 0) {
                            tud = this.tableUpdateDetailsUtf16.valueAt(tudKeyIndex);
                            break block15;
                        }
                        int status = this.engine.getTableStatus(this.path, tableNameUtf16);
                        if (status != 0) {
                            if (!this.autoCreateNewTables) {
                                throw CairoException.nonCritical().put("table does not exist, creating new tables is disabled [table=").put(tableNameUtf16).put(']');
                            }
                            if (!this.autoCreateNewColumns) {
                                throw CairoException.nonCritical().put("table does not exist, cannot create table, creating new columns is disabled [table=").put(tableNameUtf16).put(']');
                            }
                            TableStructureAdapter tsa = this.tableStructureAdapter.of(tableNameUtf16, parser);
                            int n = tsa.getColumnCount();
                            for (int i = 0; i < n; ++i) {
                                if (tsa.getColumnType(i) != 0) continue;
                                throw CairoException.nonCritical().put("unknown column type [columnName=").put(tsa.getColumnName(i)).put(']');
                            }
                            this.engine.createTable(securityContext, this.ddlMem, this.path, true, tsa, false);
                        }
                        if ((idleTudKeyIndex = this.idleTableUpdateDetailsUtf16.keyIndex(tableNameUtf16)) < 0) {
                            tud = this.idleTableUpdateDetailsUtf16.valueAt(idleTudKeyIndex);
                            LOG.info().$("idle table going active [tableName=").$safe(tud.getTableNameUtf16()).I$();
                            if (tud.getWriter() == null) {
                                tud.closeNoLock();
                                tud = this.unsafeAssignTableToWriterThread(tudKeyIndex, tud.getTableNameUtf16(), tud.getTableNameUtf8());
                            } else {
                                this.idleTableUpdateDetailsUtf16.removeAt(idleTudKeyIndex);
                                this.tableUpdateDetailsUtf16.putAt(tudKeyIndex, tud.getTableNameUtf16(), tud);
                            }
                            break block15;
                        }
                        tableToken = this.engine.getTableTokenIfExists(tableNameUtf16);
                        if (tableToken != null) break block16;
                    } while (this.clock.getTicks() <= deadline);
                    throw CairoException.nonCritical().put("could not create table within timeout [table=").put(tableNameUtf16).put(", timeout=").put(this.spinLockTimeoutMs).put(']');
                }
                if (tableToken.isMatView()) {
                    throw CairoException.nonCritical().put("cannot modify materialized view [view=").put(tableToken.getTableName()).put(']');
                }
                TelemetryTask.store(this.telemetry, (short)5, (short)102);
                if (this.engine.isWalTable(tableToken)) {
                    WalTableUpdateDetails tud2 = new WalTableUpdateDetails(this.engine, securityContext, this.engine.getWalWriter(tableToken), this.defaultColumnTypes, Utf8String.newInstance(tableNameUtf8), netIoJob.getSymbolCachePool(), this.configuration.getCommitInterval(), true, this.engine.getConfiguration().getMaxUncommittedRows());
                    ctx.addTableUpdateDetails(Utf8String.newInstance(tableNameUtf8), tud2);
                    WalTableUpdateDetails walTableUpdateDetails = tud2;
                    return walTableUpdateDetails;
                }
                tud = this.unsafeAssignTableToWriterThread(tudKeyIndex, tableNameUtf16, Utf8String.newInstance(tableNameUtf8));
            }
            Utf8String key = Utf8s.equals(tud.getTableNameUtf8(), tableNameUtf8) ? tud.getTableNameUtf8() : Utf8String.newInstance(tableNameUtf8);
            netIoJob.addTableUpdateDetails(key, tud);
            TableUpdateDetails tableUpdateDetails = tud;
            return tableUpdateDetails;
        }
        finally {
            this.tableUpdateDetailsLock.writeLock().unlock();
        }
    }

    private boolean isOpen() {
        return this.pubSeq != null;
    }

    @NotNull
    private TableUpdateDetails unsafeAssignTableToWriterThread(int tudKeyIndex, CharSequence tableNameUtf16, Utf8String tableNameUtf8) {
        this.unsafeCalcThreadLoad();
        long leastLoad = Long.MAX_VALUE;
        int threadId = 0;
        int n = this.loadByWriterThread.length;
        for (int i = 0; i < n; ++i) {
            if (this.loadByWriterThread[i] >= leastLoad) continue;
            leastLoad = this.loadByWriterThread[i];
            threadId = i;
        }
        TableUpdateDetails tud = new TableUpdateDetails(this.configuration, this.engine, null, this.engine.getTableWriterAPI(tableNameUtf16, "tcpIlp"), threadId, this.netIoJobs, this.defaultColumnTypes, tableNameUtf8);
        this.tableUpdateDetailsUtf16.putAt(tudKeyIndex, tud.getTableNameUtf16(), tud);
        LOG.info().$("assigned ").$safe(tableNameUtf16).$(" to thread ").$(threadId).$();
        return tud;
    }

    private void unsafeCalcThreadLoad() {
        Arrays.fill(this.loadByWriterThread, 0L);
        ObjList tableNames = this.tableUpdateDetailsUtf16.keys();
        int sz = tableNames.size();
        for (int n = 0; n < sz; ++n) {
            CharSequence tableName = (CharSequence)tableNames.getQuick(n);
            TableUpdateDetails stats = this.tableUpdateDetailsUtf16.get(tableName);
            if (stats != null) {
                int n2 = stats.getWriterThreadId();
                this.loadByWriterThread[n2] = this.loadByWriterThread[n2] + stats.getEventsProcessedSinceReshuffle();
                continue;
            }
            LOG.error().$("could not find statistic for table [name=").$safe(tableName).I$();
        }
    }

    protected NetworkIOJob createNetworkIOJob(IODispatcher<LineTcpConnectionContext> dispatcher, int workerId) {
        return new LineTcpNetworkIOJob(this.configuration, this, dispatcher, workerId);
    }

    long getNextPublisherEventSequence(int writerWorkerId) {
        long seq;
        assert (this.isOpen());
        while ((seq = this.pubSeq[writerWorkerId].next()) == -2L) {
            Os.pause();
        }
        return seq;
    }
}

