/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Metrics;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.metrics.AtomicLongGauge;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;

public class LineHttpPingProcessor
implements HttpRequestProcessor,
HttpRequestHandler {
    private final String header;

    public LineHttpPingProcessor(CharSequence version) {
        this.header = "X-Influxdb-Version: " + String.valueOf(version);
    }

    @Override
    public AtomicLongGauge connectionCountGauge(Metrics metrics) {
        return metrics.lineMetrics().httpConnectionCountGauge();
    }

    @Override
    public int getConnectionLimit(HttpContextConfiguration configuration) {
        return configuration.getIlpConnectionLimit();
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return 0;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        context.simpleResponse().sendStatusNoContent(204, this.header);
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerIsSlowToReadException, PeerDisconnectedException {
        context.simpleResponse().sendStatusNoContent(204, this.header);
    }
}

