/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.Metrics;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.http.ChunkedContentParser;
import io.questdb.cutlass.http.DefaultHttpCookieHandler;
import io.questdb.cutlass.http.DefaultHttpHeaderParserFactory;
import io.questdb.cutlass.http.HttpAuthenticator;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpCookieHandler;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpHeaderParser;
import io.questdb.cutlass.http.HttpHeaderParserFactory;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.HttpMultipartContentParser;
import io.questdb.cutlass.http.HttpMultipartContentProcessor;
import io.questdb.cutlass.http.HttpPostPutProcessor;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpRequestValidator;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.HttpResponseSink;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.LocalValueMap;
import io.questdb.cutlass.http.Locality;
import io.questdb.cutlass.http.MultipartParserState;
import io.questdb.cutlass.http.RescheduleContext;
import io.questdb.cutlass.http.Retry;
import io.questdb.cutlass.http.RetryAttemptAttributes;
import io.questdb.cutlass.http.ex.BufferOverflowException;
import io.questdb.cutlass.http.ex.NotEnoughLinesException;
import io.questdb.cutlass.http.ex.RetryFailedOperationException;
import io.questdb.cutlass.http.ex.RetryOperationException;
import io.questdb.cutlass.http.ex.TooFewBytesReceivedException;
import io.questdb.cutlass.http.processors.RejectProcessor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.metrics.AtomicLongGauge;
import io.questdb.network.HeartBeatException;
import io.questdb.network.IOContext;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.network.Socket;
import io.questdb.network.SocketFactory;
import io.questdb.network.SuspendEvent;
import io.questdb.network.TlsSessionInitFailedException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.ObjectPool;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.StdoutSink;
import io.questdb.std.str.Utf8s;

public class HttpConnectionContext
extends IOContext<HttpConnectionContext>
implements Locality,
Retry {
    private static final Log LOG = LogFactory.getLog(HttpConnectionContext.class);
    private final HttpAuthenticator authenticator;
    private final ChunkedContentParser chunkedContentParser = new ChunkedContentParser();
    private final HttpServerConfiguration configuration;
    private final HttpCookieHandler cookieHandler;
    private final ObjectPool<DirectUtf8String> csPool;
    private final boolean dumpNetworkTraffic;
    private final int forceFragmentationReceiveChunkSize;
    private final HttpHeaderParser headerParser;
    private final LocalValueMap localValueMap = new LocalValueMap();
    private final Metrics metrics;
    private final HttpHeaderParser multipartContentHeaderParser;
    private final HttpMultipartContentParser multipartContentParser;
    private final long multipartIdleSpinCount;
    private final MultipartParserState multipartParserState = new MultipartParserState();
    private final NetworkFacade nf;
    private final boolean preAllocateBuffers;
    private final RejectProcessor rejectProcessor;
    private final HttpRequestValidator requestValidator = new HttpRequestValidator();
    private final HttpResponseSink responseSink;
    private final RetryAttemptAttributes retryAttemptAttributes = new RetryAttemptAttributes();
    private final RescheduleContext retryRescheduleContext = retry -> {
        LOG.info().$("Retry is requested after successful writer allocation. Retry will be re-scheduled [thread=").$(Thread.currentThread().getId()).I$();
        throw RetryOperationException.INSTANCE;
    };
    private final AssociativeCache<RecordCursorFactory> selectCache;
    private long authenticationNanos = 0L;
    private AtomicLongGauge connectionCountGauge;
    private boolean connectionCounted;
    private int nCompletedRequests;
    private boolean pendingRetry = false;
    private int receivedBytes;
    private long recvBuffer;
    private int recvBufferReadSize;
    private int recvBufferSize;
    private long recvPos;
    private HttpRequestProcessor resumeProcessor = null;
    private SecurityContext securityContext;
    private SuspendEvent suspendEvent;
    private long totalBytesSent;
    private long totalReceived;

    public HttpConnectionContext(HttpServerConfiguration configuration, SocketFactory socketFactory) {
        this(configuration, socketFactory, DefaultHttpCookieHandler.INSTANCE, DefaultHttpHeaderParserFactory.INSTANCE, HttpServer.NO_OP_CACHE);
    }

    public HttpConnectionContext(HttpServerConfiguration configuration, SocketFactory socketFactory, HttpCookieHandler cookieHandler, HttpHeaderParserFactory headerParserFactory, AssociativeCache<RecordCursorFactory> selectCache) {
        super(socketFactory, configuration.getHttpContextConfiguration().getNetworkFacade(), LOG);
        this.configuration = configuration;
        this.cookieHandler = cookieHandler;
        HttpContextConfiguration contextConfiguration = configuration.getHttpContextConfiguration();
        this.nf = contextConfiguration.getNetworkFacade();
        this.csPool = new ObjectPool<DirectUtf8String>(DirectUtf8String.FACTORY, contextConfiguration.getConnectionStringPoolCapacity());
        this.headerParser = headerParserFactory.newParser(contextConfiguration.getRequestHeaderBufferSize(), this.csPool);
        this.multipartContentHeaderParser = new HttpHeaderParser(contextConfiguration.getMultipartHeaderBufferSize(), this.csPool);
        this.multipartContentParser = new HttpMultipartContentParser(this.multipartContentHeaderParser);
        this.responseSink = new HttpResponseSink(configuration);
        this.recvBufferSize = configuration.getRecvBufferSize();
        this.preAllocateBuffers = configuration.preAllocateBuffers();
        if (this.preAllocateBuffers) {
            this.recvBuffer = Unsafe.malloc(this.recvBufferSize, 33);
            this.responseSink.open(configuration.getSendBufferSize());
        }
        this.multipartIdleSpinCount = contextConfiguration.getMultipartIdleSpinCount();
        this.dumpNetworkTraffic = contextConfiguration.getDumpNetworkTraffic();
        this.securityContext = DenyAllSecurityContext.INSTANCE;
        this.metrics = contextConfiguration.getMetrics();
        this.authenticator = contextConfiguration.getFactoryProvider().getHttpAuthenticatorFactory().getHttpAuthenticator();
        this.rejectProcessor = contextConfiguration.getFactoryProvider().getRejectProcessorFactory().getRejectProcessor(this);
        this.forceFragmentationReceiveChunkSize = contextConfiguration.getForceRecvFragmentationChunkSize();
        this.recvBufferReadSize = Math.min(this.forceFragmentationReceiveChunkSize, this.recvBufferSize);
        this.selectCache = selectCache;
    }

    @Override
    public void clear() {
        LOG.debug().$("clear [fd=").$(this.getFd()).I$();
        super.clear();
        this.reset();
        if (this.pendingRetry) {
            LOG.error().$("reused context with retry pending").$();
        }
        this.pendingRetry = false;
        if (!this.preAllocateBuffers) {
            this.recvBuffer = Unsafe.free(this.recvBuffer, this.recvBufferSize, 33);
            this.responseSink.close();
            this.headerParser.close();
            this.multipartContentHeaderParser.close();
        }
        this.localValueMap.disconnect();
        if (this.connectionCountGauge != null) {
            this.connectionCountGauge.dec();
            this.connectionCounted = false;
            this.connectionCountGauge = null;
        }
    }

    @Override
    public void clearSuspendEvent() {
        this.suspendEvent = Misc.free(this.suspendEvent);
    }

    @Override
    public void close() {
        long fd = this.getFd();
        LOG.debug().$("close [fd=").$(fd).I$();
        super.close();
        if (this.pendingRetry) {
            this.pendingRetry = false;
            LOG.info().$("closed context with retry pending [fd=").$(this.getFd()).I$();
        }
        this.nCompletedRequests = 0;
        this.totalBytesSent = 0L;
        this.csPool.clear();
        this.multipartContentParser.close();
        this.multipartContentHeaderParser.close();
        this.headerParser.close();
        this.localValueMap.close();
        this.recvBuffer = Unsafe.free(this.recvBuffer, this.recvBufferSize, 33);
        this.responseSink.close();
        this.receivedBytes = 0;
        this.securityContext = DenyAllSecurityContext.INSTANCE;
        this.authenticator.close();
        LOG.debug().$("closed [fd=").$(fd).I$();
    }

    @Override
    public void fail(HttpRequestProcessorSelector selector, HttpException e) throws PeerIsSlowToReadException, ServerDisconnectException {
        LOG.info().$("failed to retry query [fd=").$(this.getFd()).I$();
        HttpRequestProcessor processor = this.getHttpRequestProcessor(selector);
        this.failProcessor(processor, e, 6);
    }

    @Override
    public RetryAttemptAttributes getAttemptDetails() {
        return this.retryAttemptAttributes;
    }

    public long getAuthenticationNanos() {
        return this.authenticationNanos;
    }

    public HttpChunkedResponse getChunkedResponse() {
        return this.responseSink.getChunkedResponse();
    }

    public HttpCookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public long getLastRequestBytesSent() {
        return this.responseSink.getTotalBytesSent();
    }

    @Override
    public LocalValueMap getMap() {
        return this.localValueMap;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public int getNCompletedRequests() {
        return this.nCompletedRequests;
    }

    public HttpRawSocket getRawResponseSocket() {
        return this.responseSink.getRawSocket();
    }

    public RejectProcessor getRejectProcessor() {
        return this.rejectProcessor;
    }

    public HttpRequestHeader getRequestHeader() {
        return this.headerParser;
    }

    public HttpResponseHeader getResponseHeader() {
        return this.responseSink.getHeader();
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public AssociativeCache<RecordCursorFactory> getSelectCache() {
        return this.selectCache;
    }

    @Override
    public SuspendEvent getSuspendEvent() {
        return this.suspendEvent;
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    public long getTotalReceived() {
        return this.totalReceived;
    }

    public boolean handleClientOperation(int operation, HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) throws HeartBeatException, PeerIsSlowToReadException, ServerDisconnectException, PeerIsSlowToWriteException {
        boolean keepGoing;
        switch (operation) {
            case 1: {
                keepGoing = this.handleClientRecv(selector, rescheduleContext);
                break;
            }
            case 4: {
                keepGoing = this.handleClientSend();
                break;
            }
            case 8: {
                throw this.registerDispatcherHeartBeat();
            }
            default: {
                throw this.registerDispatcherDisconnect(0);
            }
        }
        boolean useful = keepGoing;
        if (keepGoing) {
            if (this.configuration.getHttpContextConfiguration().getServerKeepAlive()) {
                while (keepGoing = this.handleClientRecv(selector, rescheduleContext)) {
                }
            } else {
                throw this.registerDispatcherDisconnect(1);
            }
        }
        return useful;
    }

    @Override
    public boolean invalid() {
        return this.pendingRetry || this.receivedBytes > 0 || this.socket == null;
    }

    public void reset() {
        LOG.debug().$("reset [fd=").$(this.getFd()).$(']').$();
        this.totalBytesSent += this.responseSink.getTotalBytesSent();
        this.responseSink.clear();
        ++this.nCompletedRequests;
        this.resumeProcessor = null;
        this.headerParser.clear();
        this.multipartContentParser.clear();
        this.multipartContentHeaderParser.clear();
        this.csPool.clear();
        this.localValueMap.clear();
        this.multipartParserState.multipartRetry = false;
        this.retryAttemptAttributes.waitStartTimestamp = 0L;
        this.retryAttemptAttributes.lastRunTimestamp = 0L;
        this.retryAttemptAttributes.attempt = 0;
        this.receivedBytes = 0;
        this.authenticationNanos = 0L;
        this.securityContext = DenyAllSecurityContext.INSTANCE;
        this.authenticator.clear();
        this.totalReceived = 0L;
        this.chunkedContentParser.clear();
        this.recvPos = this.recvBuffer;
        this.rejectProcessor.clear();
        this.clearSuspendEvent();
    }

    public void resumeResponseSend() throws PeerIsSlowToReadException, PeerDisconnectedException {
        this.responseSink.resumeSend();
    }

    public void scheduleRetry(HttpRequestProcessor processor, RescheduleContext rescheduleContext) throws PeerIsSlowToReadException, ServerDisconnectException {
        try {
            this.pendingRetry = true;
            rescheduleContext.reschedule(this);
        }
        catch (RetryFailedOperationException e) {
            this.failProcessor(processor, e, 6);
        }
    }

    public HttpResponseSink.SimpleResponseImpl simpleResponse() {
        return this.responseSink.simpleResponse();
    }

    @Override
    public boolean tryRerun(HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) throws PeerIsSlowToReadException, PeerIsSlowToWriteException, ServerDisconnectException {
        if (this.pendingRetry) {
            this.pendingRetry = false;
            HttpRequestProcessor processor = this.getHttpRequestProcessor(selector);
            try {
                LOG.info().$("retrying query [fd=").$(this.getFd()).I$();
                processor.onRequestRetry(this);
                if (this.multipartParserState.multipartRetry) {
                    if (this.continueConsumeMultipart(this.socket, this.multipartParserState.start, this.multipartParserState.buf, this.multipartParserState.bufRemaining, (HttpMultipartContentProcessor)processor, this.retryRescheduleContext)) {
                        LOG.info().$("success retried multipart import [fd=").$(this.getFd()).I$();
                        this.busyRcvLoop(selector, rescheduleContext);
                    } else {
                        LOG.info().$("retry success but import not finished [fd=").$(this.getFd()).I$();
                    }
                } else {
                    this.busyRcvLoop(selector, rescheduleContext);
                }
            }
            catch (RetryOperationException e2) {
                this.pendingRetry = true;
                return false;
            }
            catch (PeerDisconnectedException ignore) {
                throw this.registerDispatcherDisconnect(10);
            }
            catch (PeerIsSlowToReadException e2) {
                LOG.info().$("peer is slow on running the rerun [fd=").$(this.getFd()).$(", thread=").$(Thread.currentThread().getId()).I$();
                processor.parkRequest(this, false);
                this.resumeProcessor = processor;
                throw this.registerDispatcherWrite();
            }
            catch (QueryPausedException e) {
                LOG.info().$("partition is in cold storage, suspending query [fd=").$(this.getFd()).$(", thread=").$(Thread.currentThread().getId()).I$();
                processor.parkRequest(this, true);
                this.resumeProcessor = processor;
                this.suspendEvent = e.getEvent();
                throw this.registerDispatcherWrite();
            }
            catch (ServerDisconnectException e) {
                LOG.info().$("kicked out [fd=").$(this.getFd()).I$();
                throw this.registerDispatcherDisconnect(2);
            }
        }
        return true;
    }

    private void busyRcvLoop(HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) throws PeerIsSlowToReadException, ServerDisconnectException, PeerIsSlowToWriteException {
        this.reset();
        if (this.configuration.getHttpContextConfiguration().getServerKeepAlive()) {
            while (this.handleClientRecv(selector, rescheduleContext)) {
            }
        } else {
            throw this.registerDispatcherDisconnect(1);
        }
    }

    private HttpRequestProcessor checkConnectionLimit(HttpRequestProcessor processor) {
        int connectionLimit = processor.getConnectionLimit(this.configuration.getHttpContextConfiguration());
        if (connectionLimit > -1) {
            this.connectionCountGauge = processor.connectionCountGauge(this.metrics);
            long numOfConnections = this.connectionCountGauge.incrementAndGet();
            if (numOfConnections > (long)connectionLimit) {
                this.rejectProcessor.getMessageSink().put("exceeded connection limit [name=").put(this.connectionCountGauge.getName()).put(", numOfConnections=").put(numOfConnections).put(", connectionLimit=").put(connectionLimit).put(']');
                return this.rejectProcessor.withShutdownWrite().reject(400);
            }
            if (numOfConnections == (long)connectionLimit && !this.securityContext.isSystemAdmin()) {
                this.rejectProcessor.getMessageSink().put("non-admin user reached connection limit [name=").put(this.connectionCountGauge.getName()).put(", numOfConnections=").put(numOfConnections).put(", connectionLimit=").put(connectionLimit).put(']');
                return this.rejectProcessor.withShutdownWrite().reject(400);
            }
        }
        return processor;
    }

    private void completeRequest(HttpRequestProcessor processor, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        LOG.debug().$("complete [fd=").$(this.getFd()).I$();
        try {
            processor.onRequestComplete(this);
            this.reset();
        }
        catch (RetryOperationException e) {
            this.pendingRetry = true;
            this.scheduleRetry(processor, rescheduleContext);
        }
    }

    private boolean configureSecurityContext() {
        if (this.securityContext == DenyAllSecurityContext.INSTANCE) {
            NanosecondClock clock = this.configuration.getHttpContextConfiguration().getNanosecondClock();
            long authenticationStart = clock.getTicks();
            if (!this.authenticator.authenticate(this.headerParser)) {
                return false;
            }
            this.securityContext = this.configuration.getFactoryProvider().getSecurityContextFactory().getInstance(this.authenticator.getPrincipal(), this.authenticator.getGroups(), this.authenticator.getAuthType(), (byte)0);
            this.authenticationNanos = clock.getTicks() - authenticationStart;
        }
        return true;
    }

    private boolean consumeChunked(HttpPostPutProcessor processor, long headerEnd, long read, boolean newRequest) throws PeerIsSlowToReadException, ServerDisconnectException, PeerDisconnectedException, QueryPausedException, PeerIsSlowToWriteException {
        if (!newRequest) {
            processor.resumeRecv(this);
        }
        do {
            long hi;
            long lo;
            int bufferLenLeft = (int)(this.recvBuffer + (long)this.recvBufferSize - this.recvPos);
            if (newRequest) {
                processor.onHeadersReady(this);
                this.totalReceived -= headerEnd - this.recvBuffer;
                lo = headerEnd;
                hi = this.recvBuffer + read;
                newRequest = false;
            } else {
                read = this.socket.recv(this.recvPos, Math.min(this.forceFragmentationReceiveChunkSize, bufferLenLeft));
                lo = this.recvBuffer;
                hi = this.recvPos + read;
            }
            if (read > 0L) {
                if ((lo = this.chunkedContentParser.handleRecv(lo, hi, processor)) == Long.MAX_VALUE) {
                    processor.onRequestComplete(this);
                    this.reset();
                    if (this.configuration.getHttpContextConfiguration().getServerKeepAlive()) {
                        return true;
                    }
                    return this.disconnectHttp(processor, 4);
                }
                if (lo == Long.MIN_VALUE) {
                    LOG.error().$("cannot parse chunk length, chunked protocol violation, disconnecting [fd=").$(this.getFd()).I$();
                    return this.disconnectHttp(processor, 13);
                }
                if (lo != hi) {
                    lo = -lo;
                    assert (lo >= this.recvBuffer && lo <= hi && lo < this.recvBuffer + (long)this.recvBufferSize);
                    if (lo != this.recvBuffer) {
                        Vect.memmove(this.recvBuffer, lo, hi - lo);
                    }
                    this.recvPos = this.recvBuffer + (hi - lo);
                } else {
                    this.recvPos = this.recvBuffer;
                }
            }
            if (read != 0L && read != (long)this.forceFragmentationReceiveChunkSize) continue;
            throw this.registerDispatcherRead();
        } while (read >= 0L);
        return this.disconnectHttp(processor, 5);
    }

    private boolean consumeContent(long contentLength, Socket socket, HttpPostPutProcessor processor, long headerEnd, int read, boolean newRequest) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException, PeerIsSlowToWriteException {
        if (!newRequest) {
            processor.resumeRecv(this);
        }
        do {
            long lo;
            if (newRequest) {
                processor.onHeadersReady(this);
                this.totalReceived -= headerEnd - this.recvBuffer;
                lo = headerEnd;
                newRequest = false;
            } else {
                read = socket.recv(this.recvBuffer, this.recvBufferReadSize);
                lo = this.recvBuffer;
            }
            if (read > 0) {
                if (this.totalReceived + (long)read > contentLength) {
                    return this.disconnectHttp(processor, 13);
                }
                processor.onChunk(lo, this.recvBuffer + (long)read);
                this.totalReceived += (long)read;
                if (this.totalReceived == contentLength) {
                    read = socket.recv(this.recvBuffer, this.recvBufferSize);
                    if (read < 0) {
                        return this.disconnectHttp(processor, 5);
                    }
                    if (read > 0) {
                        return this.disconnectHttp(processor, 13);
                    }
                    processor.onRequestComplete(this);
                    this.reset();
                    if (this.configuration.getHttpContextConfiguration().getServerKeepAlive()) {
                        return true;
                    }
                    return this.disconnectHttp(processor, 4);
                }
            }
            if (read != 0 && read != this.forceFragmentationReceiveChunkSize) continue;
            throw this.registerDispatcherRead();
        } while (read >= 0);
        return this.disconnectHttp(processor, 5);
    }

    private boolean consumeMultipart(Socket socket, HttpMultipartContentProcessor processor, long headerEnd, int read, boolean newRequest, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException, PeerIsSlowToWriteException {
        int bufRemaining;
        long buf;
        long start;
        if (newRequest) {
            if (!this.headerParser.hasBoundary()) {
                LOG.error().$("Bad request. Form data in multipart POST expected.").$(". Disconnecting [fd=").$(this.getFd()).I$();
                throw this.registerDispatcherDisconnect(7);
            }
            processor.onHeadersReady(this);
            this.multipartContentParser.of(this.headerParser.getBoundary());
        }
        processor.resumeRecv(this);
        long bufferEnd = this.recvBuffer + (long)read;
        LOG.debug().$("multipart").$();
        if (headerEnd < bufferEnd) {
            start = headerEnd;
            buf = bufferEnd;
            bufRemaining = (int)((long)this.recvBufferSize - (bufferEnd - this.recvBuffer));
        } else {
            start = this.recvBuffer;
            buf = start + (long)this.receivedBytes;
            bufRemaining = this.recvBufferSize - this.receivedBytes;
            this.receivedBytes = 0;
        }
        return this.continueConsumeMultipart(socket, start, buf, bufRemaining, processor, rescheduleContext);
    }

    private boolean continueConsumeMultipart(Socket socket, long start, long buf, int bufRemaining, HttpMultipartContentProcessor processor, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException, PeerIsSlowToWriteException {
        boolean keepGoing = false;
        if (buf > start) {
            try {
                if (this.parseMultipartResult(start, buf, bufRemaining, processor, rescheduleContext)) {
                    return true;
                }
                buf = start = this.recvBuffer;
                bufRemaining = this.recvBufferSize;
            }
            catch (TooFewBytesReceivedException e) {
                start = this.multipartContentParser.getResumePtr();
            }
        }
        long spinsRemaining = this.multipartIdleSpinCount;
        while (true) {
            int n;
            if ((n = socket.recv(buf, bufRemaining)) < 0) {
                throw this.registerDispatcherDisconnect(8);
            }
            if (n == 0) {
                if (spinsRemaining-- > 0L) continue;
                if (buf > start) {
                    try {
                        if (this.parseMultipartResult(start, buf, bufRemaining, processor, rescheduleContext)) {
                            keepGoing = true;
                            break;
                        }
                        buf = start = this.recvBuffer;
                        bufRemaining = this.recvBufferSize;
                    }
                    catch (TooFewBytesReceivedException e) {
                        start = this.multipartContentParser.getResumePtr();
                        this.shiftReceiveBufferUnprocessedBytes(start, (int)(buf - start));
                        throw this.registerDispatcherRead();
                    }
                }
                LOG.debug().$("peer is slow [multipart]").$();
                throw this.registerDispatcherRead();
            }
            LOG.debug().$("multipart recv [len=").$(n).I$();
            this.dumpBuffer(buf, n);
            buf += (long)n;
            if ((bufRemaining -= n) != 0) continue;
            try {
                if (buf - start > 1L && this.parseMultipartResult(start, buf, bufRemaining, processor, rescheduleContext)) {
                    keepGoing = true;
                    break;
                }
                buf = start = this.recvBuffer;
                bufRemaining = this.recvBufferSize;
            }
            catch (TooFewBytesReceivedException e) {
                start = this.multipartContentParser.getResumePtr();
                int unprocessedSize = (int)(buf - start);
                if (unprocessedSize < this.recvBufferSize) {
                    start = this.multipartContentParser.getResumePtr();
                    this.shiftReceiveBufferUnprocessedBytes(start, unprocessedSize);
                    throw this.registerDispatcherRead();
                }
                this.failProcessor(processor, BufferOverflowException.INSTANCE, 9);
                break;
            }
        }
        return keepGoing;
    }

    private boolean disconnectHttp(HttpRequestProcessor processor, int reason) throws ServerDisconnectException {
        processor.onConnectionClosed(this);
        this.reset();
        throw this.registerDispatcherDisconnect(reason);
    }

    private void dumpBuffer(long buffer, int size) {
        if (this.dumpNetworkTraffic && size > 0) {
            StdoutSink.INSTANCE.put('>');
            Net.dump(buffer, size);
        }
    }

    private void failProcessor(HttpRequestProcessor processor, HttpException e, int reason) throws PeerIsSlowToReadException, ServerDisconnectException {
        this.pendingRetry = false;
        boolean canReset = true;
        try {
            try {
                LOG.info().$("failed query result cannot be delivered. Kicked out [fd=").$(this.getFd()).$(", error=").$safe(e.getFlyweightMessage()).I$();
                processor.failRequest(this, e);
                throw this.registerDispatcherDisconnect(reason);
            }
            catch (PeerDisconnectedException peerDisconnectedException) {
                throw this.registerDispatcherDisconnect(11);
            }
            catch (PeerIsSlowToReadException peerIsSlowToReadException) {
                LOG.info().$("peer is slow to receive failed to retry response [fd=").$(this.getFd()).I$();
                processor.parkRequest(this, false);
                this.resumeProcessor = processor;
                canReset = false;
                throw this.registerDispatcherWrite();
            }
        }
        catch (Throwable throwable) {
            if (canReset) {
                this.reset();
            }
            throw throwable;
        }
    }

    private HttpRequestProcessor getHttpRequestProcessor(HttpRequestProcessorSelector selector) {
        HttpRequestProcessor processor = selector.select(this.headerParser);
        if (processor == null) {
            processor = selector.getDefaultProcessor();
        }
        return this.requestValidator.validateRequestType(processor, this.rejectProcessor);
    }

    private boolean handleClientRecv(HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) throws PeerIsSlowToReadException, PeerIsSlowToWriteException, ServerDisconnectException {
        boolean busyRecv = true;
        try {
            long headerEnd = this.recvBuffer;
            int read = 0;
            boolean newRequest = this.headerParser.isIncomplete();
            if (newRequest) {
                while (this.headerParser.isIncomplete()) {
                    read = this.socket.recv(this.recvBuffer, this.recvBufferReadSize);
                    LOG.debug().$("recv [fd=").$(this.getFd()).$(", count=").$(read).I$();
                    if (read < 0 && !this.headerParser.onRecvError(read)) {
                        LOG.debug().$("done [fd=").$(this.getFd()).$(", errno=").$(this.nf.errno()).I$();
                        throw this.registerDispatcherDisconnect(12);
                    }
                    if (read == 0) {
                        throw this.registerDispatcherRead();
                    }
                    this.dumpBuffer(this.recvBuffer, read);
                    headerEnd = this.headerParser.parse(this.recvBuffer, this.recvBuffer + (long)read, true, false);
                }
                this.requestValidator.of(this.headerParser);
            }
            this.requestValidator.validateRequestHeader(this.rejectProcessor);
            HttpRequestProcessor processor = this.rejectProcessor.isRequestBeingRejected() ? this.rejectProcessor : this.getHttpRequestProcessor(selector);
            DirectUtf8Sequence acceptEncoding = this.headerParser.getHeader(HttpConstants.HEADER_CONTENT_ACCEPT_ENCODING);
            if (this.configuration.getHttpContextConfiguration().allowDeflateBeforeSend() && acceptEncoding != null && Utf8s.containsAscii(acceptEncoding, "gzip")) {
                this.responseSink.setDeflateBeforeSend(true, this.configuration.getSendBufferSize());
            }
            try {
                boolean multipartRequest;
                if (newRequest) {
                    if (processor.requiresAuthentication() && !this.configureSecurityContext()) {
                        byte requiredAuthType = processor.getRequiredAuthType();
                        processor = this.rejectProcessor.withAuthenticationType(requiredAuthType).reject(401);
                    }
                    if (this.configuration.getHttpContextConfiguration().areCookiesEnabled() && !processor.processCookies(this, this.securityContext)) {
                        processor = this.rejectProcessor;
                    }
                    try {
                        this.securityContext.checkEntityEnabled();
                    }
                    catch (CairoException e) {
                        processor = this.rejectProcessor.reject(403, e.getFlyweightMessage());
                    }
                }
                if (!this.connectionCounted && !processor.ignoreConnectionLimitCheck()) {
                    processor = this.checkConnectionLimit(processor);
                    this.connectionCounted = true;
                }
                long contentLength = this.headerParser.getContentLength();
                boolean chunked = HttpKeywords.isChunked(this.headerParser.getHeader(HttpConstants.HEADER_TRANSFER_ENCODING));
                boolean bl = multipartRequest = HttpKeywords.isContentTypeMultipartFormData(this.headerParser.getContentType()) || HttpKeywords.isContentTypeMultipartMixed(this.headerParser.getContentType());
                if (multipartRequest) {
                    busyRecv = this.consumeMultipart(this.socket, (HttpMultipartContentProcessor)processor, headerEnd, read, newRequest, rescheduleContext);
                } else if (chunked) {
                    busyRecv = this.consumeChunked((HttpPostPutProcessor)processor, headerEnd, read, newRequest);
                } else if (contentLength > 0L) {
                    busyRecv = this.consumeContent(contentLength, this.socket, (HttpPostPutProcessor)processor, headerEnd, read, newRequest);
                } else {
                    read = this.socket.recv(this.recvBuffer, 1);
                    if (read != 0) {
                        this.dumpBuffer(this.recvBuffer, read);
                        LOG.info().$("disconnect after request [fd=").$(this.getFd()).$(", read=").$(read).I$();
                        int reason = read > 0 ? 13 : 15;
                        throw this.registerDispatcherDisconnect(reason);
                    }
                    processor.onHeadersReady(this);
                    LOG.debug().$("good [fd=").$(this.getFd()).I$();
                    processor.onRequestComplete(this);
                    this.resumeProcessor = null;
                    this.reset();
                }
            }
            catch (RetryOperationException e) {
                this.pendingRetry = true;
                this.scheduleRetry(processor, rescheduleContext);
                busyRecv = false;
            }
            catch (PeerDisconnectedException e) {
                return this.disconnectHttp(processor, 15);
            }
            catch (PeerIsSlowToReadException e) {
                LOG.debug().$("peer is slow reader [two]").$();
                processor.parkRequest(this, false);
                this.resumeProcessor = processor;
                throw this.registerDispatcherWrite();
            }
            catch (QueryPausedException e) {
                LOG.debug().$("partition is in cold storage").$();
                processor.parkRequest(this, true);
                this.resumeProcessor = processor;
                this.suspendEvent = e.getEvent();
                throw this.registerDispatcherWrite();
            }
        }
        catch (PeerIsSlowToReadException | PeerIsSlowToWriteException | ServerDisconnectException e) {
            throw e;
        }
        catch (HttpException e) {
            LOG.error().$("http error [fd=").$(this.getFd()).$(", e=`").$safe(e.getFlyweightMessage()).$("`]").$();
            throw this.registerDispatcherDisconnect(7);
        }
        catch (Throwable e) {
            LOG.error().$("internal error [fd=").$(this.getFd()).$(", e=`").$(e).$("`]").$();
            throw this.registerDispatcherDisconnect(17);
        }
        return busyRecv;
    }

    private boolean handleClientSend() throws PeerIsSlowToReadException, ServerDisconnectException {
        if (this.resumeProcessor != null) {
            try {
                this.resumeProcessor.resumeSend(this);
                this.reset();
                return true;
            }
            catch (PeerIsSlowToReadException ignore) {
                this.resumeProcessor.parkRequest(this, false);
                LOG.debug().$("peer is slow reader").$();
                throw this.registerDispatcherWrite();
            }
            catch (QueryPausedException e) {
                this.resumeProcessor.parkRequest(this, true);
                this.suspendEvent = e.getEvent();
                LOG.debug().$("partition is in cold storage").$();
                throw this.registerDispatcherWrite();
            }
            catch (PeerDisconnectedException ignore) {
                throw this.registerDispatcherDisconnect(11);
            }
            catch (ServerDisconnectException ignore) {
                LOG.info().$("kicked out [fd=").$(this.getFd()).I$();
                throw this.registerDispatcherDisconnect(3);
            }
        }
        LOG.error().$("spurious write request [fd=").$(this.getFd()).I$();
        return false;
    }

    private boolean parseMultipartResult(long start, long buf, int bufRemaining, HttpMultipartContentProcessor processor, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException, TooFewBytesReceivedException {
        boolean parseResult;
        try {
            parseResult = this.multipartContentParser.parse(start, buf, processor);
        }
        catch (RetryOperationException e) {
            this.multipartParserState.saveFdBufferPosition(this.multipartContentParser.getResumePtr(), buf, bufRemaining);
            throw e;
        }
        catch (NotEnoughLinesException e) {
            this.failProcessor(processor, e, 14);
            parseResult = false;
        }
        if (parseResult) {
            this.completeRequest(processor, rescheduleContext);
            return true;
        }
        return false;
    }

    private void shiftReceiveBufferUnprocessedBytes(long start, int receivedBytes) {
        this.receivedBytes = receivedBytes;
        Vect.memmove(this.recvBuffer, start, receivedBytes);
        LOG.debug().$("peer is slow, waiting for bigger part to parse [multipart]").$();
    }

    @Override
    protected void doInit() throws TlsSessionInitFailedException {
        if (this.recvBuffer == 0L) {
            this.recvBufferSize = this.configuration.getRecvBufferSize();
            this.recvBufferReadSize = Math.min(this.forceFragmentationReceiveChunkSize, this.recvBufferSize);
            this.recvBuffer = Unsafe.malloc(this.recvBufferSize, 33);
        }
        this.responseSink.of(this.socket, this.configuration.getSendBufferSize());
        this.headerParser.reopen(this.configuration.getHttpContextConfiguration().getRequestHeaderBufferSize());
        this.multipartContentHeaderParser.reopen(this.configuration.getHttpContextConfiguration().getMultipartHeaderBufferSize());
        if (this.socket.supportsTls()) {
            this.socket.startTlsSession(null);
        }
        this.connectionCounted = false;
    }
}

