/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectByteSequenceView;
import io.questdb.std.FilesFacade;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Mutable;
import io.questdb.std.str.DirectString;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8SplitString;

public abstract class AbstractMemoryCR
implements MemoryCR,
Mutable {
    private final BorrowedArray borrowedArray = new BorrowedArray();
    private final DirectByteSequenceView bsview = new DirectByteSequenceView();
    private final DirectString csviewA = new DirectString();
    private final DirectString csviewB = new DirectString();
    private final Long256Impl long256A = new Long256Impl();
    private final Long256Impl long256B = new Long256Impl();
    private final DirectUtf8String utf8DirectView = new DirectUtf8String();
    private final Utf8SplitString utf8SplitViewA = new Utf8SplitString();
    private final Utf8SplitString utf8SplitViewB = new Utf8SplitString();
    protected FilesFacade ff;
    protected long lim;
    protected long pageAddress = 0L;
    protected long size = 0L;
    private long shiftAddressRight = 0L;

    @Override
    public long addressOf(long offset) {
        assert (this.checkOffsetMapped(offset -= this.shiftAddressRight));
        return this.pageAddress + offset;
    }

    @Override
    public void clear() {
        this.csviewA.clear();
        this.csviewB.clear();
        this.bsview.clear();
    }

    @Override
    public final ArrayView getArray(long offset) {
        return this.getArray(offset, this.borrowedArray);
    }

    @Override
    public final BinarySequence getBin(long offset) {
        return this.getBin(offset, this.bsview);
    }

    @Override
    public DirectUtf8Sequence getDirectVarchar(long offset, int size, boolean ascii) {
        long addr = this.addressOf(offset);
        assert (addr > 0L);
        if (this.checkOffsetMapped((long)size + offset)) {
            return this.utf8DirectView.of(addr, addr + (long)size, ascii);
        }
        throw CairoException.critical(0).put("varchar is outside of file boundary [offset=").put(offset).put(", size=").put(size).put(", size()=").put(this.size()).put(']');
    }

    public FilesFacade getFilesFacade() {
        return this.ff;
    }

    @Override
    public Long256 getLong256A(long offset) {
        this.getLong256(offset, this.long256A);
        return this.long256A;
    }

    @Override
    public Long256 getLong256B(long offset) {
        this.getLong256(offset, this.long256B);
        return this.long256B;
    }

    @Override
    public long getPageAddress(int pageIndex) {
        return this.pageAddress;
    }

    @Override
    public int getPageCount() {
        return this.pageAddress == 0L ? 0 : 1;
    }

    @Override
    public Utf8SplitString getSplitVarcharA(long auxLo, long dataLo, long dataLim, int size, boolean ascii) {
        return this.utf8SplitViewA.of(auxLo, dataLo, dataLim, size, ascii);
    }

    @Override
    public Utf8SplitString getSplitVarcharB(long auxLo, long dataLo, long dataLim, int size, boolean ascii) {
        return this.utf8SplitViewB.of(auxLo, dataLo, dataLim, size, ascii);
    }

    @Override
    public final CharSequence getStrA(long offset) {
        return this.getStr(offset, this.csviewA);
    }

    @Override
    public final CharSequence getStrB(long offset) {
        return this.getStr(offset, this.csviewB);
    }

    @Override
    public long offsetInPage(long offset) {
        return offset;
    }

    @Override
    public int pageIndex(long offset) {
        return 0;
    }

    @Override
    public long resize(long size) {
        this.extend(size);
        return this.pageAddress;
    }

    public void shiftAddressRight(long shiftRightOffset) {
        this.shiftAddressRight = shiftRightOffset;
    }

    @Override
    public long size() {
        return this.size;
    }
}

