/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerWrapper;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.MCSequence;
import io.questdb.mp.RingQueue;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Rnd;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageFrameReduceJob
implements Job,
QuietCloseable {
    private static final Log LOG = LogFactory.getLog(PageFrameReduceJob.class);
    private final MessageBus messageBus;
    private final int shardCount;
    private final int[] shards;
    private SqlExecutionCircuitBreakerWrapper circuitBreaker;
    private PageFrameMemoryRecord record;

    public PageFrameReduceJob(MessageBus bus, Rnd rnd, @NotNull SqlExecutionCircuitBreakerConfiguration circuitBreakerConfiguration) {
        this.messageBus = bus;
        this.shardCount = this.messageBus.getPageFrameReduceShardCount();
        this.shards = new int[this.shardCount];
        for (int i = 0; i < this.shardCount; ++i) {
            this.shards[i] = i;
        }
        int currentIndex = this.shardCount;
        while (currentIndex != 0) {
            int randomIndex = (int)Math.floor(rnd.nextDouble() * (double)currentIndex);
            int tmp = this.shards[--currentIndex];
            this.shards[currentIndex] = this.shards[randomIndex];
            this.shards[randomIndex] = tmp;
        }
        this.record = new PageFrameMemoryRecord(0);
        this.circuitBreaker = new SqlExecutionCircuitBreakerWrapper(circuitBreakerConfiguration);
    }

    public static boolean consumeQueue(RingQueue<PageFrameReduceTask> queue, MCSequence subSeq, PageFrameMemoryRecord record, SqlExecutionCircuitBreakerWrapper circuitBreaker, PageFrameSequence<?> stealingFrameSequence) {
        return PageFrameReduceJob.consumeQueue(-1, queue, subSeq, record, circuitBreaker, stealingFrameSequence);
    }

    public static void reduce(PageFrameMemoryRecord record, SqlExecutionCircuitBreakerWrapper circuitBreaker, PageFrameReduceTask task, PageFrameSequence<?> frameSequence, PageFrameSequence<?> stealingFrameSequence) {
        PageFrameReduceJob.reduce(-1, record, circuitBreaker, task, frameSequence, stealingFrameSequence);
    }

    @Override
    public void close() {
        this.circuitBreaker = Misc.free(this.circuitBreaker);
        this.record = Misc.free(this.record);
    }

    public SqlExecutionCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker.getDelegate();
    }

    @Override
    public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
        boolean useful = false;
        for (int i = 0; i < this.shardCount; ++i) {
            int shard = this.shards[i];
            useful = !PageFrameReduceJob.consumeQueue(workerId, this.messageBus.getPageFrameReduceQueue(shard), this.messageBus.getPageFrameReduceSubSeq(shard), this.record, this.circuitBreaker, null) || useful;
        }
        return useful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean consumeQueue(int workerId, RingQueue<PageFrameReduceTask> queue, MCSequence subSeq, PageFrameMemoryRecord record, SqlExecutionCircuitBreakerWrapper circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        while (true) {
            long cursor;
            if ((cursor = subSeq.next()) > -1L) {
                PageFrameReduceTask task = queue.get(cursor);
                PageFrameSequence<?> frameSequence = task.getFrameSequence();
                try {
                    LOG.debug().$("reducing [shard=").$(frameSequence.getShard()).$(", id=").$(frameSequence.getId()).$(", taskType=").$(task.getTaskType()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(frameSequence.getFrameCount()).$(", active=").$(frameSequence.isActive()).$(", cursor=").$(cursor).I$();
                    if (frameSequence.isActive()) {
                        circuitBreaker.init(frameSequence.getCircuitBreaker());
                        PageFrameReduceJob.reduce(workerId, record, circuitBreaker, task, frameSequence, stealingFrameSequence);
                    }
                }
                catch (Throwable th) {
                    LOG.error().$("reduce error [error=").$(th).$(", id=").$(frameSequence.getId()).$(", taskType=").$(task.getTaskType()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(frameSequence.getFrameCount()).I$();
                    int interruptReason = 0;
                    if (th instanceof CairoException) {
                        CairoException e = (CairoException)th;
                        interruptReason = e.getInterruptionReason();
                    }
                    task.setErrorMsg(th);
                    frameSequence.cancel(interruptReason);
                }
                finally {
                    subSeq.done(cursor);
                    frameSequence.getReduceFinishedCounter().incrementAndGet();
                }
                return false;
            }
            if (cursor == -1L) break;
            Os.pause();
        }
        return true;
    }

    private static void reduce(int workerId, PageFrameMemoryRecord record, SqlExecutionCircuitBreaker circuitBreaker, PageFrameReduceTask task, PageFrameSequence<?> frameSequence, PageFrameSequence<?> stealingFrameSequence) {
        int cbState;
        int n = cbState = frameSequence.isUninterruptible() ? 0 : circuitBreaker.getState(frameSequence.getStartTime(), frameSequence.getCircuitBreaker().getFd());
        if (cbState == 0) {
            record.of(frameSequence.getSymbolTableSource());
            assert (!frameSequence.done);
            frameSequence.getReduceStartedCounter().incrementAndGet();
            frameSequence.getReducer().reduce(workerId, record, task, circuitBreaker, stealingFrameSequence);
        } else {
            frameSequence.cancel(cbState);
        }
    }
}

