/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.LongList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SampleByIntervalIterator {
    protected TimestampSampler sampler;
    protected int step;
    private LongList intervals;
    private int txnIntervalLoIndex;

    public abstract long getMaxTimestamp();

    public abstract long getMinTimestamp();

    public abstract int getStep();

    public abstract long getTimestampHi();

    public abstract long getTimestampLo();

    public boolean isLast() {
        return this.getTimestampHi() >= this.getMaxTimestamp();
    }

    public boolean next() {
        int intervalsSize;
        int n = intervalsSize = this.intervals != null ? this.intervals.size() : -1;
        block0: while (this.next0()) {
            if (intervalsSize != -1) {
                long iteratorLo = this.getTimestampLo();
                long iteratorHi = this.getTimestampHi() - 1L;
                while (this.txnIntervalLoIndex < intervalsSize) {
                    long intervalLo = this.intervals.getQuick(this.txnIntervalLoIndex);
                    long intervalHi = this.intervals.getQuick(this.txnIntervalLoIndex + 1);
                    if (iteratorHi < intervalLo) continue block0;
                    if (iteratorLo <= intervalHi) {
                        return true;
                    }
                    this.txnIntervalLoIndex += 2;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void toTop(int step) {
        this.step = step;
        this.txnIntervalLoIndex = 0;
        this.toTop0();
    }

    protected abstract boolean next0();

    protected void of(@NotNull TimestampSampler sampler, @Nullable LongList intervals) {
        this.sampler = sampler;
        this.intervals = intervals;
    }

    protected abstract void toTop0();
}

