/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexBwdReader;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;

public abstract class AbstractIndexReader
implements BitmapIndexReader {
    public static final String INDEX_CORRUPT = "cursor could not consistently read index header [corrupt?]";
    protected static final Log LOG = LogFactory.getLog(BitmapIndexBwdReader.class);
    protected final MemoryMR keyMem = Vm.getCMRInstance();
    protected final MemoryMR valueMem = Vm.getCMRInstance();
    protected int blockCapacity;
    protected int blockValueCountMod;
    protected MillisecondClock clock;
    protected long columnTop;
    protected int keyCount;
    protected long spinLockTimeoutMs;
    private long columnTxn;
    private int keyCountIncludingNulls;
    private long keyFileSequence = -1L;
    private long partitionTxn;
    private long valueMemSize = -1L;

    @Override
    public void close() {
        Misc.free(this.keyMem);
        Misc.free(this.valueMem);
    }

    @Override
    public long getColumnTop() {
        return this.columnTop;
    }

    @Override
    public long getColumnTxn() {
        return this.columnTxn;
    }

    @Override
    public long getKeyBaseAddress() {
        return this.keyMem.addressOf(0L);
    }

    @Override
    public int getKeyCount() {
        return this.keyCountIncludingNulls;
    }

    @Override
    public long getKeyMemorySize() {
        return this.keyMem.size();
    }

    @Override
    public long getPartitionTxn() {
        return this.partitionTxn;
    }

    @Override
    public long getValueBaseAddress() {
        return this.valueMem.addressOf(0L);
    }

    @Override
    public int getValueBlockCapacity() {
        return this.blockValueCountMod;
    }

    @Override
    public long getValueMemorySize() {
        return this.valueMem.size();
    }

    @Override
    public boolean isOpen() {
        return this.keyMem.getFd() != -1L;
    }

    @Override
    public void of(CairoConfiguration configuration, Path path, CharSequence columnName, long columnNameTxn, long partitionTxn, long columnTop) {
        this.columnTop = columnTop;
        this.columnTxn = columnNameTxn;
        this.partitionTxn = partitionTxn;
        int plen = path.size();
        this.spinLockTimeoutMs = configuration.getSpinLockTimeout();
        try {
            this.keyMem.wholeFile(configuration.getFilesFacade(), BitmapIndexUtils.keyFileName(path, columnName, columnNameTxn), 3);
            this.clock = configuration.getMillisecondClock();
            long keyMemSize = this.keyMem.size();
            if (keyMemSize < 64L) {
                LOG.error().$("file too short [corrupt] ").$(path).$();
                throw CairoException.critical(0).put("Index file too short: ").put(path);
            }
            if (this.keyMem.getByte(0L) != -6) {
                LOG.error().$("unknown format [corrupt] ").$(path).$();
                throw CairoException.critical(0).put("Unknown format: ").put(path);
            }
            this.readIndexMetadataAtomically();
            this.keyMem.extend(BitmapIndexUtils.getKeyEntryOffset(this.keyCount));
            this.valueMem.of(configuration.getFilesFacade(), BitmapIndexUtils.valueFileName(path.trimTo(plen), columnName, columnNameTxn), this.valueMemSize, this.valueMemSize, 3);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    @Override
    public void reloadConditionally() {
        long seq = this.keyMem.getLong(29L);
        if (seq != this.keyFileSequence) {
            this.readIndexMetadataAtomically();
            this.keyMem.extend(BitmapIndexUtils.getKeyEntryOffset(this.keyCount));
            this.valueMem.extend(this.valueMemSize);
        }
    }

    public void updateKeyCount() {
        int keyCount;
        long deadline = this.clock.getTicks() + this.spinLockTimeoutMs;
        while (true) {
            long seq = this.keyMem.getLong(1L);
            Unsafe.getUnsafe().loadFence();
            if (this.keyMem.getLong(29L) == seq) {
                keyCount = this.keyMem.getInt(21L);
                Unsafe.getUnsafe().loadFence();
                if (seq == this.keyMem.getLong(1L)) break;
            }
            if (this.clock.getTicks() > deadline) {
                this.keyCount = 0;
                LOG.error().$(INDEX_CORRUPT).$(" [timeout=").$(this.spinLockTimeoutMs).$("ms]").$();
                throw CairoException.critical(0).put(INDEX_CORRUPT);
            }
            Os.pause();
        }
        if (keyCount > this.keyCount) {
            this.keyCount = keyCount;
            this.keyCountIncludingNulls = this.columnTop > 0L ? keyCount + 1 : keyCount;
        }
    }

    private void readIndexMetadataAtomically() {
        long valueMemSize;
        int keyCount;
        int blockValueCountMod;
        long seq;
        long deadline = this.clock.getTicks() + this.spinLockTimeoutMs;
        while (true) {
            seq = this.keyMem.getLong(1L);
            Unsafe.getUnsafe().loadFence();
            if (this.keyMem.getLong(29L) == seq) {
                blockValueCountMod = this.keyMem.getInt(17L) - 1;
                keyCount = this.keyMem.getInt(21L);
                valueMemSize = this.keyMem.getLong(9L);
                Unsafe.getUnsafe().loadFence();
                if (this.keyMem.getLong(1L) == seq) break;
            }
            if (this.clock.getTicks() > deadline) {
                LOG.error().$(INDEX_CORRUPT).$(" [timeout=").$(this.spinLockTimeoutMs).$("ms]").$();
                throw CairoException.critical(0).put(INDEX_CORRUPT);
            }
            Os.pause();
        }
        this.keyFileSequence = seq;
        this.valueMemSize = valueMemSize;
        this.keyCount = keyCount;
        this.blockValueCountMod = blockValueCountMod;
        this.blockCapacity = (blockValueCountMod + 1) * 8 + 16;
        this.keyCountIncludingNulls = this.columnTop > 0L ? keyCount + 1 : keyCount;
    }
}

