/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.FactoryProvider;
import io.questdb.FreeOnExit;
import io.questdb.MemoryConfiguration;
import io.questdb.Metrics;
import io.questdb.PublicPassthroughConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.metrics.MetricsConfiguration;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.str.Utf8StringSink;

public interface ServerConfiguration {
    public static final String OSS = "OSS";

    default public void exportConfiguration(Utf8StringSink sink) {
        sink.putAscii("\"config\":{");
        if (this.getCairoConfiguration().exportConfiguration(sink) | this.getPublicPassthroughConfiguration().exportConfiguration(sink)) {
            sink.clear(sink.size() - 1);
        }
        sink.putAscii("},");
    }

    public CairoConfiguration getCairoConfiguration();

    public FactoryProvider getFactoryProvider();

    public HttpServerConfiguration getHttpMinServerConfiguration();

    public HttpFullFatServerConfiguration getHttpServerConfiguration();

    public WorkerPoolConfiguration getNetworkWorkerPoolConfiguration();

    public LineTcpReceiverConfiguration getLineTcpReceiverConfiguration();

    public LineUdpReceiverConfiguration getLineUdpReceiverConfiguration();

    public WorkerPoolConfiguration getMatViewRefreshPoolConfiguration();

    public MemoryConfiguration getMemoryConfiguration();

    public Metrics getMetrics();

    public MetricsConfiguration getMetricsConfiguration();

    public PGConfiguration getPGWireConfiguration();

    public PublicPassthroughConfiguration getPublicPassthroughConfiguration();

    public WorkerPoolConfiguration getQueryWorkerPoolConfiguration();

    default public String getReleaseType() {
        return OSS;
    }

    default public long getVersion() {
        return 0L;
    }

    public WorkerPoolConfiguration getWalApplyPoolConfiguration();

    public WorkerPoolConfiguration getWriteWorkerPoolConfiguration();

    default public void init(CairoEngine engine, FreeOnExit freeOnExit) {
    }
}

