/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import org.junit.rules.ExternalResource;

public final class OpenTelemetryClassRule
extends ExternalResource {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;

    public static OpenTelemetryClassRule create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).build();
        return new OpenTelemetryClassRule(openTelemetry, spanExporter);
    }

    private OpenTelemetryClassRule(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    protected void before() throws Throwable {
        GlobalOpenTelemetry.resetForTest();
        GlobalOpenTelemetry.set((OpenTelemetry)this.openTelemetry);
    }

    protected void after() {
        GlobalOpenTelemetry.resetForTest();
    }
}

