/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigDecimal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MetaTableMetrics;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.filter.BigDecimalComparator;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.TestHStore;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationObserver;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.FaultyFSLog;
import org.apache.hadoop.hbase.wal.NettyAsyncFSWALConfigHelper;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestHRegion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegion.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegion.class);
    @Rule
    public TestName name = new TestName();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    private static final EventLoopGroup GROUP = new NioEventLoopGroup();
    HRegion region = null;
    protected static HBaseTestingUtility TEST_UTIL;
    public static Configuration CONF;
    private String dir;
    private static FileSystem FILESYSTEM;
    private final int MAX_VERSIONS = 2;
    protected TableName tableName;
    protected String method;
    protected final byte[] qual = Bytes.toBytes((String)"qual");
    protected final byte[] qual1 = Bytes.toBytes((String)"qual1");
    protected final byte[] qual2 = Bytes.toBytes((String)"qual2");
    protected final byte[] qual3 = Bytes.toBytes((String)"qual3");
    protected final byte[] value = Bytes.toBytes((String)"value");
    protected final byte[] value1 = Bytes.toBytes((String)"value1");
    protected final byte[] value2 = Bytes.toBytes((String)"value2");
    protected final byte[] row = Bytes.toBytes((String)"rowA");
    protected final byte[] row2 = Bytes.toBytes((String)"rowB");
    protected final MetricsAssertHelper metricsAssertHelper = (MetricsAssertHelper)CompatibilitySingletonFactory.getInstance(MetricsAssertHelper.class);

    @Before
    public void setup() throws IOException {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        FILESYSTEM = TEST_UTIL.getTestFileSystem();
        CONF = TEST_UTIL.getConfiguration();
        NettyAsyncFSWALConfigHelper.setEventLoopConfig((Configuration)CONF, (EventLoopGroup)GROUP, NioSocketChannel.class);
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.method = this.name.getMethodName();
        this.tableName = TableName.valueOf((String)this.method);
        CONF.set("hbase.memstore.inmemoryflush.threshold.factor", String.valueOf(0.09));
    }

    @After
    public void tearDown() throws IOException {
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info("Cleaning test directory: " + TEST_UTIL.getDataTestDir());
        TEST_UTIL.cleanupTestDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequenceId() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
        Assert.assertEquals((long)-1L, (long)this.region.getMaxFlushedSeqId());
        Assert.assertEquals((long)0L, (long)((Long)this.region.getMaxStoreSeqId().get(COLUMN_FAMILY_BYTES)));
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        Assert.assertEquals((long)-1L, (long)this.region.getMaxFlushedSeqId());
        Assert.assertEquals((long)0L, (long)((Long)this.region.getMaxStoreSeqId().get(COLUMN_FAMILY_BYTES)));
        HRegion oldRegion = this.region;
        try {
            this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
            byte[] value = Bytes.toBytes((String)this.method);
            Put put = new Put(value);
            put.addColumn(COLUMN_FAMILY_BYTES, null, value);
            this.region.put(put);
            Assert.assertEquals((long)-1L, (long)this.region.getMaxFlushedSeqId());
            Assert.assertEquals((long)0L, (long)((Long)this.region.getMaxStoreSeqId().get(COLUMN_FAMILY_BYTES)));
            this.region.flush(true);
            long max = this.region.getMaxFlushedSeqId();
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            Assert.assertEquals((long)max, (long)this.region.getMaxFlushedSeqId());
            this.region = null;
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(oldRegion);
        }
    }

    @Test
    public void testCloseCarryingSnapshot() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
        HStore store = this.region.getStore(COLUMN_FAMILY_BYTES);
        byte[] value = Bytes.toBytes((String)this.method);
        Put put = new Put(value);
        put.addColumn(COLUMN_FAMILY_BYTES, null, value);
        this.region.put(put);
        StoreFlushContext storeFlushCtx = store.createFlushContext(12345L, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"abc"), value);
        this.region.put(put);
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        Assert.assertEquals((long)0L, (long)this.region.getMemStoreDataSize());
        this.region = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemstoreSnapshotSize() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + "testMemstoreSnapshotSize");
        class MyFaultyFSLog
        extends FaultyFSLog {
            StoreFlushContext storeFlushCtx;

            public MyFaultyFSLog(FileSystem fs, Path rootDir, String logName, Configuration conf) throws IOException {
                super(fs, rootDir, logName, conf);
            }

            void setStoreFlushCtx(StoreFlushContext storeFlushCtx) {
                this.storeFlushCtx = storeFlushCtx;
            }

            @Override
            protected void doSync(long txid, boolean forceSync) throws IOException {
                this.storeFlushCtx.prepare();
                super.doSync(txid, forceSync);
            }
        }
        MyFaultyFSLog faultyLog = new MyFaultyFSLog(fs, rootDir, "testMemstoreSnapshotSize", CONF);
        this.region = this.initHRegion(this.tableName, null, null, CONF, false, Durability.SYNC_WAL, (WAL)faultyLog, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
        HStore store = this.region.getStore(COLUMN_FAMILY_BYTES);
        byte[] value = Bytes.toBytes((String)this.method);
        faultyLog.setStoreFlushCtx(store.createFlushContext(12345L, FlushLifeCycleTracker.DUMMY));
        Put put = new Put(value);
        put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"abc"), value);
        faultyLog.setFailureType(FaultyFSLog.FailureType.SYNC);
        boolean threwIOE = false;
        try {
            this.region.put(put);
        }
        catch (IOException ioe) {
            threwIOE = true;
        }
        finally {
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwIOE);
        }
        MemStoreSize mss = store.getFlushableSize();
        Assert.assertTrue((String)("flushable size should be zero, but it is " + mss), (mss.getDataSize() == 0L ? 1 : 0) != 0);
    }

    private static WAL createWALCompatibleWithFaultyFileSystem(String callingMethod, Configuration conf, TableName tableName) throws IOException {
        Path logDir = TEST_UTIL.getDataTestDirOnTestFS(callingMethod + ".log");
        Configuration walConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)logDir);
        return new WALFactory(walConf, callingMethod).getWAL(RegionInfoBuilder.newBuilder((TableName)tableName).build());
    }

    @Test
    public void testMemstoreSizeAccountingWithFailedPostBatchMutate() throws IOException {
        String testName = "testMemstoreSizeAccountingWithFailedPostBatchMutate";
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + testName);
        FSHLog hLog = new FSHLog(fs, rootDir, testName, CONF);
        hLog.init();
        HRegion region = this.initHRegion(this.tableName, null, null, CONF, false, Durability.SYNC_WAL, (WAL)hLog, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
        HStore store = region.getStore(COLUMN_FAMILY_BYTES);
        Assert.assertEquals((long)0L, (long)region.getMemStoreDataSize());
        byte[] value = Bytes.toBytes((String)this.method);
        Put put = new Put(value);
        put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"abc"), value);
        region.put(put);
        long onePutSize = region.getMemStoreDataSize();
        Assert.assertTrue((onePutSize > 0L ? 1 : 0) != 0);
        RegionCoprocessorHost mockedCPHost = (RegionCoprocessorHost)Mockito.mock(RegionCoprocessorHost.class);
        ((RegionCoprocessorHost)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)mockedCPHost)).postBatchMutate((MiniBatchOperationInProgress)ArgumentMatchers.any());
        region.setCoprocessorHost(mockedCPHost);
        put = new Put(value);
        put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"dfg"), value);
        try {
            region.put(put);
            Assert.fail((String)"Should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long expectedSize = onePutSize * 2L;
        Assert.assertEquals((String)"memstoreSize should be incremented", (long)expectedSize, (long)region.getMemStoreDataSize());
        Assert.assertEquals((String)"flushable size should be incremented", (long)expectedSize, (long)store.getFlushableSize().getDataSize());
        region.setCoprocessorHost(null);
    }

    @Test
    public void testFlushAndMemstoreSizeCounting() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        for (byte[] row : HBaseTestingUtility.ROWS) {
            Put put = new Put(row);
            put.addColumn(family, family, row);
            this.region.put(put);
        }
        this.region.flush(true);
        Assert.assertEquals((long)0L, (long)this.region.getMemStoreDataSize());
        Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)this.region.getMemStoreHeapSize());
        Assert.assertEquals((long)0L, (long)this.region.getMemStoreOffHeapSize());
    }

    @Test
    public void testFlushSizeAccounting() throws Exception {
        final Configuration conf = HBaseConfiguration.create((Configuration)CONF);
        final WAL wal = TestHRegion.createWALCompatibleWithFaultyFileSystem(this.method, conf, this.tableName);
        conf.setInt("hbase.hstore.flush.retries.number", 1);
        User user = User.createUserForTesting((Configuration)conf, (String)this.method, (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", TestHStore.FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(TestHStore.FaultyFileSystem.class, fs.getClass());
                TestHStore.FaultyFileSystem ffs = (TestHStore.FaultyFileSystem)fs;
                HRegion region = null;
                try {
                    region = TestHRegion.this.initHRegion(TestHRegion.this.tableName, null, null, CONF, false, Durability.SYNC_WAL, wal, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
                    long size = region.getMemStoreDataSize();
                    Assert.assertEquals((long)0L, (long)size);
                    Put p1 = new Put(TestHRegion.this.row);
                    p1.add((Cell)new KeyValue(TestHRegion.this.row, COLUMN_FAMILY_BYTES, TestHRegion.this.qual1, 1L, (byte[])null));
                    region.put(p1);
                    long sizeOfOnePut = region.getMemStoreDataSize();
                    try {
                        LOG.info("Flushing");
                        region.flush(true);
                        Assert.fail((String)"Didn't bubble up IOE!");
                    }
                    catch (DroppedSnapshotException dse) {
                        region.closing.set(false);
                    }
                    ffs.fault.set(false);
                    Assert.assertEquals((long)sizeOfOnePut, (long)region.getMemStoreDataSize());
                    Put p2 = new Put(TestHRegion.this.row);
                    p2.add((Cell)new KeyValue(TestHRegion.this.row, COLUMN_FAMILY_BYTES, TestHRegion.this.qual2, 2L, (byte[])null));
                    p2.add((Cell)new KeyValue(TestHRegion.this.row, COLUMN_FAMILY_BYTES, TestHRegion.this.qual3, 3L, (byte[])null));
                    region.put(p2);
                    long expectedSize = sizeOfOnePut * 3L;
                    Assert.assertEquals((long)expectedSize, (long)region.getMemStoreDataSize());
                    region.flush(true);
                    Assert.assertEquals((long)(sizeOfOnePut * 2L), (long)region.getMemStoreDataSize());
                }
                catch (Throwable throwable) {
                    HBaseTestingUtility.closeRegionAndWAL(region);
                    throw throwable;
                }
                HBaseTestingUtility.closeRegionAndWAL(region);
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)user.getUGI());
    }

    @Test
    public void testCloseWithFailingFlush() throws Exception {
        final Configuration conf = HBaseConfiguration.create((Configuration)CONF);
        final WAL wal = TestHRegion.createWALCompatibleWithFaultyFileSystem(this.method, conf, this.tableName);
        conf.setInt("hbase.hstore.flush.retries.number", 1);
        User user = User.createUserForTesting((Configuration)conf, (String)this.method, (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", TestHStore.FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                block5: {
                    FileSystem fs = FileSystem.get((Configuration)conf);
                    Assert.assertEquals(TestHStore.FaultyFileSystem.class, fs.getClass());
                    TestHStore.FaultyFileSystem ffs = (TestHStore.FaultyFileSystem)fs;
                    HRegion region = null;
                    try {
                        region = TestHRegion.this.initHRegion(TestHRegion.this.tableName, null, null, CONF, false, Durability.SYNC_WAL, wal, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
                        long size = region.getMemStoreDataSize();
                        Assert.assertEquals((long)0L, (long)size);
                        Put p1 = new Put(TestHRegion.this.row);
                        p1.add((Cell)new KeyValue(TestHRegion.this.row, COLUMN_FAMILY_BYTES, TestHRegion.this.qual1, 1L, (byte[])null));
                        region.put(p1);
                        HStore store = region.getStore(COLUMN_FAMILY_BYTES);
                        StoreFlushContext storeFlushCtx = store.createFlushContext(12345L, FlushLifeCycleTracker.DUMMY);
                        storeFlushCtx.prepare();
                        Put p2 = new Put(TestHRegion.this.row);
                        p2.add((Cell)new KeyValue(TestHRegion.this.row, COLUMN_FAMILY_BYTES, TestHRegion.this.qual2, 2L, (byte[])null));
                        p2.add((Cell)new KeyValue(TestHRegion.this.row, COLUMN_FAMILY_BYTES, TestHRegion.this.qual3, 3L, (byte[])null));
                        region.put(p2);
                        HBaseTestingUtility.closeRegionAndWAL(region);
                        region = null;
                        Assert.fail();
                        ffs.fault.set(false);
                    }
                    catch (DroppedSnapshotException dse) {
                        LOG.info("Expected DroppedSnapshotException");
                        break block5;
                    }
                    finally {
                        ffs.fault.set(false);
                        HBaseTestingUtility.closeRegionAndWAL(region);
                    }
                    HBaseTestingUtility.closeRegionAndWAL(region);
                }
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)user.getUGI());
    }

    @Test
    public void testCompactionAffectedByScanners() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        this.region.put(put);
        this.region.flush(true);
        Scan scan = new Scan();
        scan.setMaxVersions(3);
        try (RegionScannerImpl scanner1 = this.region.getScanner(scan);){
            Delete delete = new Delete(Bytes.toBytes((String)"r1"));
            this.region.delete(delete);
            this.region.flush(true);
            try (RegionScannerImpl scanner2 = this.region.getScanner(scan);){
                ArrayList results = new ArrayList();
                LOG.info("Smallest read point:" + this.region.getSmallestReadPoint());
                this.region.compact(true);
                try (RegionScannerImpl scanner3 = this.region.getScanner(scan);){
                    scanner1.next(results);
                    LOG.info(((Object)results).toString());
                    Assert.assertEquals((long)1L, (long)results.size());
                    results.clear();
                    scanner2.next(results);
                    LOG.info(((Object)results).toString());
                    Assert.assertEquals((long)0L, (long)results.size());
                    results.clear();
                    scanner3.next(results);
                    LOG.info(((Object)results).toString());
                    Assert.assertEquals((long)0L, (long)results.size());
                }
            }
        }
    }

    @Test
    public void testToShowNPEOnRegionScannerReseek() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        this.region.put(put);
        put = new Put(Bytes.toBytes((String)"r2"));
        put.addColumn(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        this.region.put(put);
        this.region.flush(true);
        Scan scan = new Scan();
        scan.setMaxVersions(3);
        try (RegionScannerImpl scanner1 = this.region.getScanner(scan);){
            LOG.info("Smallest read point:" + this.region.getSmallestReadPoint());
            this.region.compact(true);
            scanner1.reseek(Bytes.toBytes((String)"r2"));
            ArrayList results = new ArrayList();
            scanner1.next(results);
            Cell keyValue = (Cell)results.get(0);
            Assert.assertTrue((Bytes.compareTo((byte[])CellUtil.cloneRow((Cell)keyValue), (byte[])Bytes.toBytes((String)"r2")) == 0 ? 1 : 0) != 0);
            scanner1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveRecoveredEditsReplay() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        WALFactory wals = new WALFactory(CONF, this.method);
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            long maxSeqId = 1050L;
            for (long i = minSeqId = 1000L; i <= maxSeqId; i += 10L) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                fs.create(recoveredEdits);
                WALProvider.Writer writer = wals.createRecoveredEditsWriter(fs, recoveredEdits);
                long time = System.nanoTime();
                WALEdit edit = new WALEdit();
                edit.add((Cell)new KeyValue(this.row, family, Bytes.toBytes((long)i), time, KeyValue.Type.Put, Bytes.toBytes((long)i)));
                writer.append(new WAL.Entry(new WALKeyImpl(regionName, this.tableName, i, time, HConstants.DEFAULT_CLUSTER_ID), edit));
                writer.close();
            }
            MonitoredTask status = TaskMonitor.get().createStatus(this.method);
            TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (HStore store : this.region.getStores()) {
                maxSeqIdInStores.put(Bytes.toBytes((String)store.getColumnFamilyName()), minSeqId - 1L);
            }
            CONF.set("hbase.region.archive.recovered.edits", "true");
            CONF.set("hbase.wal.dir", "/custom_wal_dir");
            long seqId = this.region.replayRecoveredEditsIfAny(maxSeqIdInStores, null, status);
            Assert.assertEquals((long)maxSeqId, (long)seqId);
            this.region.getMVCC().advanceTo(seqId);
            String fakeFamilyName = recoveredEditsDir.getName();
            Path rootDir = new Path(CONF.get("hbase.rootdir"));
            Path storeArchiveDir = HFileArchiveUtil.getStoreArchivePathForRootDir((Path)rootDir, (RegionInfo)this.region.getRegionInfo(), (byte[])Bytes.toBytes((String)fakeFamilyName));
            FileStatus[] list = TEST_UTIL.getTestFileSystem().listStatus(storeArchiveDir);
            Assert.assertEquals((long)6L, (long)list.length);
        }
        finally {
            CONF.set("hbase.region.archive.recovered.edits", "false");
            CONF.set("hbase.wal.dir", "");
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipRecoveredEditsReplay() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        WALFactory wals = new WALFactory(CONF, this.method);
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            long maxSeqId = 1050L;
            for (long i = minSeqId = 1000L; i <= maxSeqId; i += 10L) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                fs.create(recoveredEdits);
                WALProvider.Writer writer = wals.createRecoveredEditsWriter(fs, recoveredEdits);
                long time = System.nanoTime();
                WALEdit edit = new WALEdit();
                edit.add((Cell)new KeyValue(this.row, family, Bytes.toBytes((long)i), time, KeyValue.Type.Put, Bytes.toBytes((long)i)));
                writer.append(new WAL.Entry(new WALKeyImpl(regionName, this.tableName, i, time, HConstants.DEFAULT_CLUSTER_ID), edit));
                writer.close();
            }
            MonitoredTask status = TaskMonitor.get().createStatus(this.method);
            TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (HStore store : this.region.getStores()) {
                maxSeqIdInStores.put(Bytes.toBytes((String)store.getColumnFamilyName()), minSeqId - 1L);
            }
            long seqId = this.region.replayRecoveredEditsIfAny(maxSeqIdInStores, null, status);
            Assert.assertEquals((long)maxSeqId, (long)seqId);
            this.region.getMVCC().advanceTo(seqId);
            Get get = new Get(this.row);
            Result result = this.region.get(get);
            for (long i = minSeqId; i <= maxSeqId; i += 10L) {
                List kvs = result.getColumnCells(family, Bytes.toBytes((long)i));
                Assert.assertEquals((long)1L, (long)kvs.size());
                Assert.assertArrayEquals((byte[])Bytes.toBytes((long)i), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipRecoveredEditsReplaySomeIgnored() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        WALFactory wals = new WALFactory(CONF, this.method);
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            long maxSeqId = 1050L;
            for (long i = minSeqId = 1000L; i <= maxSeqId; i += 10L) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                fs.create(recoveredEdits);
                WALProvider.Writer writer = wals.createRecoveredEditsWriter(fs, recoveredEdits);
                long time = System.nanoTime();
                WALEdit edit = new WALEdit();
                edit.add((Cell)new KeyValue(this.row, family, Bytes.toBytes((long)i), time, KeyValue.Type.Put, Bytes.toBytes((long)i)));
                writer.append(new WAL.Entry(new WALKeyImpl(regionName, this.tableName, i, time, HConstants.DEFAULT_CLUSTER_ID), edit));
                writer.close();
            }
            long recoverSeqId = 1030L;
            MonitoredTask status = TaskMonitor.get().createStatus(this.method);
            TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (HStore store : this.region.getStores()) {
                maxSeqIdInStores.put(Bytes.toBytes((String)store.getColumnFamilyName()), recoverSeqId - 1L);
            }
            long seqId = this.region.replayRecoveredEditsIfAny(maxSeqIdInStores, null, status);
            Assert.assertEquals((long)maxSeqId, (long)seqId);
            this.region.getMVCC().advanceTo(seqId);
            Get get = new Get(this.row);
            Result result = this.region.get(get);
            for (long i = minSeqId; i <= maxSeqId; i += 10L) {
                List kvs = result.getColumnCells(family, Bytes.toBytes((long)i));
                if (i < recoverSeqId) {
                    Assert.assertEquals((long)0L, (long)kvs.size());
                    continue;
                }
                Assert.assertEquals((long)1L, (long)kvs.size());
                Assert.assertArrayEquals((byte[])Bytes.toBytes((long)i), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
        }
    }

    @Test
    public void testSkipRecoveredEditsReplayAllIgnored() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        Path regiondir = this.region.getRegionFileSystem().getRegionDir();
        FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
        Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
        for (int i = 1000; i < 1050; i += 10) {
            Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
            FSDataOutputStream dos = fs.create(recoveredEdits);
            dos.writeInt(i);
            dos.close();
        }
        long minSeqId = 2000L;
        Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", minSeqId - 1L));
        FSDataOutputStream dos = fs.create(recoveredEdits);
        dos.close();
        TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        for (HStore store : this.region.getStores()) {
            maxSeqIdInStores.put(Bytes.toBytes((String)store.getColumnFamilyName()), minSeqId);
        }
        long seqId = this.region.replayRecoveredEditsIfAny(maxSeqIdInStores, null, null);
        Assert.assertEquals((long)minSeqId, (long)seqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipRecoveredEditsReplayTheLastFileIgnored() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        WALFactory wals = new WALFactory(CONF, this.method);
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            byte[][] columns = (byte[][])this.region.getTableDescriptor().getColumnFamilyNames().toArray((T[])new byte[0][]);
            Assert.assertEquals((long)0L, (long)this.region.getStoreFileList(columns).size());
            Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            long maxSeqId = 1050L;
            for (long i = minSeqId = 1000L; i <= maxSeqId; i += 10L) {
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", i));
                fs.create(recoveredEdits);
                WALProvider.Writer writer = wals.createRecoveredEditsWriter(fs, recoveredEdits);
                long time = System.nanoTime();
                WALEdit edit = null;
                if (i == maxSeqId) {
                    edit = WALEdit.createCompaction((RegionInfo)this.region.getRegionInfo(), (WALProtos.CompactionDescriptor)WALProtos.CompactionDescriptor.newBuilder().setTableName(ByteString.copyFrom((byte[])this.tableName.getName())).setFamilyName(ByteString.copyFrom((byte[])regionName)).setEncodedRegionName(ByteString.copyFrom((byte[])regionName)).setStoreHomeDirBytes(ByteString.copyFrom((byte[])Bytes.toBytes((String)regiondir.toString()))).setRegionName(ByteString.copyFrom((byte[])this.region.getRegionInfo().getRegionName())).build());
                } else {
                    edit = new WALEdit();
                    edit.add((Cell)new KeyValue(this.row, family, Bytes.toBytes((long)i), time, KeyValue.Type.Put, Bytes.toBytes((long)i)));
                }
                writer.append(new WAL.Entry(new WALKeyImpl(regionName, this.tableName, i, time, HConstants.DEFAULT_CLUSTER_ID), edit));
                writer.close();
            }
            long recoverSeqId = 1030L;
            TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            MonitoredTask status = TaskMonitor.get().createStatus(this.method);
            for (HStore store : this.region.getStores()) {
                maxSeqIdInStores.put(Bytes.toBytes((String)store.getColumnFamilyName()), recoverSeqId - 1L);
            }
            long seqId = this.region.replayRecoveredEditsIfAny(maxSeqIdInStores, null, status);
            Assert.assertEquals((long)maxSeqId, (long)seqId);
            Assert.assertEquals((long)1L, (long)this.region.getStoreFileList(columns).size());
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
        }
    }

    @Test
    public void testRecoveredEditsReplayCompaction() throws Exception {
        this.testRecoveredEditsReplayCompaction(false);
        this.testRecoveredEditsReplayCompaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoveredEditsReplayCompaction(boolean mismatchedRegionName) throws Exception {
        CONF.setClass("hbase.hregion.impl", HRegionForTesting.class, Region.class);
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        WALFactory wals = new WALFactory(CONF, this.method);
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            long maxSeqId = 3L;
            for (long i = minSeqId = 0L; i < maxSeqId; ++i) {
                Put put = new Put(Bytes.toBytes((long)i));
                put.addColumn(family, Bytes.toBytes((long)i), Bytes.toBytes((long)i));
                this.region.put(put);
                this.region.flush(true);
            }
            Assert.assertEquals((long)3L, (long)this.region.getStore(family).getStorefilesCount());
            ArrayList<Path> storeFiles = new ArrayList<Path>(3);
            for (HStoreFile sf : this.region.getStore(family).getStorefiles()) {
                storeFiles.add(sf.getPath());
            }
            CONF.setBoolean("hbase.hstore.compaction.complete", false);
            this.region.compactStores();
            Assert.assertEquals((long)3L, (long)this.region.getStore(family).getStorefilesCount());
            Path tmpDir = new Path(this.region.getRegionFileSystem().getTempDir(), Bytes.toString((byte[])family));
            FileStatus[] files = CommonFSUtils.listStatus((FileSystem)fs, (Path)tmpDir);
            String errorMsg = "Expected to find 1 file in the region temp directory from the compaction, could not find any";
            Assert.assertNotNull((String)errorMsg, (Object)files);
            Assert.assertEquals((String)errorMsg, (long)1L, (long)files.length);
            Path newFile = this.region.getRegionFileSystem().commitStoreFile(Bytes.toString((byte[])family), files[0].getPath());
            byte[] encodedNameAsBytes = this.region.getRegionInfo().getEncodedNameAsBytes();
            byte[] fakeEncodedNameAsBytes = new byte[encodedNameAsBytes.length];
            for (int i = 0; i < encodedNameAsBytes.length; ++i) {
                fakeEncodedNameAsBytes[i] = (byte)(encodedNameAsBytes[i] + 1);
            }
            WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor((RegionInfo)this.region.getRegionInfo(), (byte[])((byte[])(mismatchedRegionName ? fakeEncodedNameAsBytes : null)), (byte[])family, storeFiles, (List)Lists.newArrayList((Object[])new Path[]{newFile}), (Path)this.region.getRegionFileSystem().getStoreDir(Bytes.toString((byte[])family)));
            WALUtil.writeCompactionMarker((WAL)this.region.getWAL(), (NavigableMap)this.region.getReplicationScope(), (RegionInfo)this.region.getRegionInfo(), (WALProtos.CompactionDescriptor)compactionDescriptor, (MultiVersionConcurrencyControl)this.region.getMVCC());
            Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
            Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", 1000));
            fs.create(recoveredEdits);
            WALProvider.Writer writer = wals.createRecoveredEditsWriter(fs, recoveredEdits);
            long time = System.nanoTime();
            writer.append(new WAL.Entry(new WALKeyImpl(regionName, this.tableName, 10L, time, HConstants.DEFAULT_CLUSTER_ID), WALEdit.createCompaction((RegionInfo)this.region.getRegionInfo(), (WALProtos.CompactionDescriptor)compactionDescriptor)));
            writer.close();
            this.region.getTableDescriptor();
            this.region.getRegionInfo();
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            try {
                this.region = HRegion.openHRegion((HRegion)this.region, null);
            }
            catch (WrongRegionException wre) {
                Assert.fail((String)"Matching encoded region name should not have produced WrongRegionException");
            }
            Collection sfs = this.region.getStore(family).getStorefiles();
            for (HStoreFile sf : sfs) {
                LOG.info(Objects.toString(sf.getPath()));
            }
            if (!mismatchedRegionName) {
                Assert.assertEquals((long)1L, (long)this.region.getStore(family).getStorefilesCount());
            }
            files = CommonFSUtils.listStatus((FileSystem)fs, (Path)tmpDir);
            Assert.assertTrue((String)("Expected to find 0 files inside " + tmpDir), (files == null || files.length == 0 ? 1 : 0) != 0);
            for (long i = minSeqId; i < maxSeqId; ++i) {
                Get get = new Get(Bytes.toBytes((long)i));
                Result result = this.region.get(get);
                byte[] value = result.getValue(family, Bytes.toBytes((long)i));
                Assert.assertArrayEquals((byte[])Bytes.toBytes((long)i), (byte[])value);
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
            CONF.setClass("hbase.hregion.impl", HRegion.class, Region.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushMarkers() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        Path logDir = TEST_UTIL.getDataTestDirOnTestFS(this.method + ".log");
        Configuration walConf = new Configuration(TEST_UTIL.getConfiguration());
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)logDir);
        WALFactory wals = new WALFactory(walConf, this.method);
        WAL wal = wals.getWAL(RegionInfoBuilder.newBuilder((TableName)this.tableName).build());
        this.region = this.initHRegion(this.tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, CONF, false, Durability.USE_DEFAULT, wal, (byte[][])new byte[][]{family});
        try {
            long minSeqId;
            Path regiondir = this.region.getRegionFileSystem().getRegionDir();
            FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
            byte[] regionName = this.region.getRegionInfo().getEncodedNameAsBytes();
            long maxSeqId = 3L;
            for (long i = minSeqId = 0L; i < maxSeqId; ++i) {
                Put put = new Put(Bytes.toBytes((long)i));
                put.addColumn(family, Bytes.toBytes((long)i), Bytes.toBytes((long)i));
                this.region.put(put);
                this.region.flush(true);
            }
            Assert.assertEquals((long)3L, (long)this.region.getStore(family).getStorefilesCount());
            ArrayList<String> storeFiles = new ArrayList<String>(3);
            for (HStoreFile sf : this.region.getStore(family).getStorefiles()) {
                storeFiles.add(sf.getPath().getName());
            }
            wal.shutdown();
            WAL.Reader reader = WALFactory.createReader((FileSystem)fs, (Path)AbstractFSWALProvider.getCurrentFileName((WAL)wal), (Configuration)TEST_UTIL.getConfiguration());
            try {
                WAL.Entry entry;
                ArrayList<WAL.Entry> flushDescriptors = new ArrayList<WAL.Entry>();
                long lastFlushSeqId = -1L;
                while ((entry = reader.next()) != null) {
                    Cell cell = (Cell)entry.getEdit().getCells().get(0);
                    if (!WALEdit.isMetaEditFamily((Cell)cell)) continue;
                    WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor((Cell)cell);
                    Assert.assertNotNull((Object)flushDesc);
                    Assert.assertArrayEquals((byte[])this.tableName.getName(), (byte[])flushDesc.getTableName().toByteArray());
                    if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                        Assert.assertTrue((flushDesc.getFlushSequenceNumber() > lastFlushSeqId ? 1 : 0) != 0);
                    } else if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH) {
                        Assert.assertTrue((flushDesc.getFlushSequenceNumber() == lastFlushSeqId ? 1 : 0) != 0);
                    }
                    lastFlushSeqId = flushDesc.getFlushSequenceNumber();
                    Assert.assertArrayEquals((byte[])regionName, (byte[])flushDesc.getEncodedRegionName().toByteArray());
                    Assert.assertEquals((long)1L, (long)flushDesc.getStoreFlushesCount());
                    WALProtos.FlushDescriptor.StoreFlushDescriptor storeFlushDesc = flushDesc.getStoreFlushes(0);
                    Assert.assertArrayEquals((byte[])family, (byte[])storeFlushDesc.getFamilyName().toByteArray());
                    Assert.assertEquals((Object)"family", (Object)storeFlushDesc.getStoreHomeDir());
                    if (flushDesc.getAction() == WALProtos.FlushDescriptor.FlushAction.START_FLUSH) {
                        Assert.assertEquals((long)0L, (long)storeFlushDesc.getFlushOutputCount());
                    } else {
                        Assert.assertEquals((long)1L, (long)storeFlushDesc.getFlushOutputCount());
                        Assert.assertTrue((boolean)storeFiles.contains(storeFlushDesc.getFlushOutput(0)));
                    }
                    flushDescriptors.add(entry);
                }
                Assert.assertEquals((long)6L, (long)flushDescriptors.size());
                Path recoveredEditsDir = WALSplitUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
                Path recoveredEdits = new Path(recoveredEditsDir, String.format("%019d", 1000));
                fs.create(recoveredEdits);
                WALProvider.Writer writer = wals.createRecoveredEditsWriter(fs, recoveredEdits);
                for (WAL.Entry entry2 : flushDescriptors) {
                    writer.append(entry2);
                }
                writer.close();
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException exception) {
                        LOG.warn("Problem closing wal: " + exception.getMessage());
                        LOG.debug("exception details", (Throwable)exception);
                    }
                }
            }
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = HRegion.openHRegion((HRegion)this.region, null);
            for (long i = minSeqId; i < maxSeqId; ++i) {
                Get get = new Get(Bytes.toBytes((long)i));
                Result result = this.region.get(get);
                byte[] value = result.getValue(family, Bytes.toBytes((long)i));
                Assert.assertArrayEquals((byte[])Bytes.toBytes((long)i), (byte[])value);
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
        }
    }

    @Test
    public void testFlushMarkersWALFail() throws Exception {
        AbstractMemStore memstore;
        byte[] family = Bytes.toBytes((String)"family");
        Path logDir = TEST_UTIL.getDataTestDirOnTestFS(this.method + "log");
        Configuration walConf = new Configuration(TEST_UTIL.getConfiguration());
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)logDir);
        class FailAppendFlushMarkerWAL
        extends FSHLog {
            volatile WALProtos.FlushDescriptor.FlushAction[] flushActions;

            public FailAppendFlushMarkerWAL(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
                super(fs, root, logDir, conf);
                this.flushActions = null;
            }

            protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
                final WALProvider.Writer w = super.createWriterInstance(path);
                return new WALProvider.Writer(){

                    public void close() throws IOException {
                        w.close();
                    }

                    public void sync(boolean forceSync) throws IOException {
                        w.sync(forceSync);
                    }

                    public void append(WAL.Entry entry) throws IOException {
                        WALProtos.FlushDescriptor desc;
                        ArrayList cells = entry.getEdit().getCells();
                        if (WALEdit.isMetaEditFamily((Cell)((Cell)cells.get(0))) && (desc = WALEdit.getFlushDescriptor((Cell)((Cell)cells.get(0)))) != null) {
                            for (WALProtos.FlushDescriptor.FlushAction flushAction : flushActions) {
                                if (!desc.getAction().equals((Object)flushAction)) continue;
                                throw new IOException("Failed to append flush marker! " + flushAction);
                            }
                        }
                        w.append(entry);
                    }

                    public long getLength() {
                        return w.getLength();
                    }

                    public long getSyncedLength() {
                        return w.getSyncedLength();
                    }
                };
            }
        }
        FailAppendFlushMarkerWAL wal = new FailAppendFlushMarkerWAL(FileSystem.get((Configuration)walConf), CommonFSUtils.getRootDir((Configuration)walConf), this.method, walConf);
        wal.init();
        this.region = this.initHRegion(this.tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, CONF, false, Durability.USE_DEFAULT, (WAL)wal, (byte[][])new byte[][]{family});
        int i = 0;
        Put put = new Put(Bytes.toBytes((int)i));
        put.setDurability(Durability.SKIP_WAL);
        put.addColumn(family, Bytes.toBytes((int)i), Bytes.toBytes((int)i));
        this.region.put(put);
        wal.flushActions = new WALProtos.FlushDescriptor.FlushAction[]{WALProtos.FlushDescriptor.FlushAction.START_FLUSH};
        try {
            this.region.flush(true);
            Assert.fail((String)"This should have thrown exception");
        }
        catch (DroppedSnapshotException unexpected) {
            throw unexpected;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.region.close(true);
        wal.close();
        for (HStore store : this.region.getStores()) {
            memstore = (AbstractMemStore)store.memstore;
            memstore.doClearSnapShot();
            memstore.close();
        }
        wal.flushActions = new WALProtos.FlushDescriptor.FlushAction[]{WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH};
        wal = new FailAppendFlushMarkerWAL(FileSystem.get((Configuration)walConf), CommonFSUtils.getRootDir((Configuration)walConf), this.method, walConf);
        wal.init();
        this.region = this.initHRegion(this.tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, CONF, false, Durability.USE_DEFAULT, (WAL)wal, (byte[][])new byte[][]{family});
        this.region.put(put);
        wal.flushActions = new WALProtos.FlushDescriptor.FlushAction[]{WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH, WALProtos.FlushDescriptor.FlushAction.ABORT_FLUSH};
        Assert.assertThrows(DroppedSnapshotException.class, () -> this.region.flush(true));
        this.region.close(true);
        for (HStore store : this.region.getStores()) {
            memstore = (AbstractMemStore)store.memstore;
            memstore.doClearSnapShot();
            memstore.close();
        }
        this.region = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWhileRegionClose() throws IOException {
        Configuration hc = this.initSplit();
        int numRows = 100;
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        this.region = this.initHRegion(this.tableName, this.method, hc, (byte[][])families);
        int startRow = 100;
        this.putData(100, numRows, this.qual1, families);
        this.putData(100, numRows, this.qual2, families);
        this.putData(100, numRows, this.qual3, families);
        AtomicBoolean done = new AtomicBoolean(false);
        AtomicInteger gets = new AtomicInteger(0);
        GetTillDoneOrException[] threads = new GetTillDoneOrException[10];
        try {
            int i;
            for (i = 0; i < threads.length / 2; ++i) {
                threads[i] = new GetTillDoneOrException(i, Bytes.toBytes((String)"100"), done, gets);
                threads[i].setDaemon(true);
                threads[i].start();
            }
            this.region.closing.set(true);
            for (i = threads.length / 2; i < threads.length; ++i) {
                threads[i] = new GetTillDoneOrException(i, Bytes.toBytes((String)"100"), done, gets);
                threads[i].setDaemon(true);
                threads[i].start();
            }
        }
        finally {
            if (this.region != null) {
                HBaseTestingUtility.closeRegionAndWAL(this.region);
                this.region = null;
            }
        }
        done.set(true);
        for (GetTillDoneOrException t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (t.e == null) continue;
            LOG.info("Exception=" + t.e);
            Assert.assertFalse((String)("Found a NPE in " + t.getName()), (boolean)(t.e instanceof NullPointerException));
        }
    }

    @Test
    public void testWeirdCacheBehaviour() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"trans-blob"), Bytes.toBytes((String)"trans-type"), Bytes.toBytes((String)"trans-date"), Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"trans-group")};
        this.region = this.initHRegion(tableName, this.method, CONF, (byte[][])FAMILIES);
        String value = "this is the value";
        String value2 = "this is some other value";
        String keyPrefix1 = "prefix1";
        String keyPrefix2 = "prefix2";
        String keyPrefix3 = "prefix3";
        this.putRows(this.region, 3, value, keyPrefix1);
        this.putRows(this.region, 3, value, keyPrefix2);
        this.putRows(this.region, 3, value, keyPrefix3);
        this.putRows(this.region, 3, value2, keyPrefix1);
        this.putRows(this.region, 3, value2, keyPrefix2);
        this.putRows(this.region, 3, value2, keyPrefix3);
        System.out.println("Checking values for key: " + keyPrefix1);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix1, value2, this.region));
        System.out.println("Checking values for key: " + keyPrefix2);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix2, value2, this.region));
        System.out.println("Checking values for key: " + keyPrefix3);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix3, value2, this.region));
        this.deleteColumns(this.region, value2, keyPrefix1);
        this.deleteColumns(this.region, value2, keyPrefix2);
        this.deleteColumns(this.region, value2, keyPrefix3);
        System.out.println("Starting important checks.....");
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, this.region));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, this.region));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (long)0L, (long)this.getNumberOfRows(keyPrefix3, value2, this.region));
    }

    @Test
    public void testAppendWithReadOnlyTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.region = this.initHRegion(tableName, this.method, CONF, true, (byte[][])new byte[][]{Bytes.toBytes((String)"somefamily")});
        boolean exceptionCaught = false;
        Append append = new Append(Bytes.toBytes((String)"somerow"));
        append.setDurability(Durability.SKIP_WAL);
        append.addColumn(Bytes.toBytes((String)"somefamily"), Bytes.toBytes((String)"somequalifier"), Bytes.toBytes((String)"somevalue"));
        try {
            this.region.append(append);
        }
        catch (IOException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((exceptionCaught ? 1 : 0) != 0);
    }

    @Test
    public void testIncrWithReadOnlyTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.region = this.initHRegion(tableName, this.method, CONF, true, (byte[][])new byte[][]{Bytes.toBytes((String)"somefamily")});
        boolean exceptionCaught = false;
        Increment inc = new Increment(Bytes.toBytes((String)"somerow"));
        inc.setDurability(Durability.SKIP_WAL);
        inc.addColumn(Bytes.toBytes((String)"somefamily"), Bytes.toBytes((String)"somequalifier"), 1L);
        try {
            this.region.increment(inc);
        }
        catch (IOException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((exceptionCaught ? 1 : 0) != 0);
    }

    /*
     * Exception decompiling
     */
    private void deleteColumns(HRegion r, String value, String keyPrefix) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 13[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getNumberOfRows(String keyPrefix, String value, HRegion r) throws Exception {
        try (InternalScanner resultScanner = this.buildScanner(keyPrefix, value, r);){
            int numberOfResults = 0;
            ArrayList results = new ArrayList();
            boolean more = false;
            do {
                more = resultScanner.next(results);
                if (results == null || results.isEmpty()) break;
                ++numberOfResults;
                for (Cell kv : results) {
                    LOG.info("kv=" + kv.toString() + ", " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
                }
                results.clear();
            } while (more);
            int n = numberOfResults;
            return n;
        }
    }

    private InternalScanner buildScanner(String keyPrefix, String value, HRegion r) throws IOException {
        FilterList allFilters = new FilterList(new Filter[0]);
        allFilters.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter((Filter)filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)"trans-blob"));
        scan.addFamily(Bytes.toBytes((String)"trans-type"));
        scan.addFamily(Bytes.toBytes((String)"trans-date"));
        scan.addFamily(Bytes.toBytes((String)"trans-tags"));
        scan.addFamily(Bytes.toBytes((String)"trans-group"));
        scan.setFilter((Filter)allFilters);
        return r.getScanner(scan);
    }

    private void putRows(HRegion r, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + i;
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes((String)row));
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(Bytes.toBytes((String)"trans-blob"), null, Bytes.toBytes((String)"value for blob"));
            put.addColumn(Bytes.toBytes((String)"trans-type"), null, Bytes.toBytes((String)"statement"));
            put.addColumn(Bytes.toBytes((String)"trans-date"), null, Bytes.toBytes((String)"20090921010101999"));
            put.addColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)value));
            put.addColumn(Bytes.toBytes((String)"trans-group"), null, Bytes.toBytes((String)"adhocTransactionGroupId"));
            r.put(put);
        }
    }

    @Test
    public void testFamilyWithAndWithoutColon() throws Exception {
        byte[] cf = Bytes.toBytes((String)COLUMN_FAMILY);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{cf});
        Put p = new Put(this.tableName.toBytes());
        byte[] cfwithcolon = Bytes.toBytes((String)"MyCF:");
        p.addColumn(cfwithcolon, cfwithcolon, cfwithcolon);
        boolean exception = false;
        try {
            this.region.put(p);
        }
        catch (NoSuchColumnFamilyException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testBatchPut_whileNoRowLocksHeld() throws IOException {
        int i;
        Put[] puts = new Put[10];
        MetricsWALSource source = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        long syncs = this.prepareRegionForBachPut(puts, source, false);
        OperationStatus[] codes = this.region.batchMutate((Mutation[])puts);
        Assert.assertEquals((long)10L, (long)codes.length);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)codes[i].getOperationStatusCode());
        }
        this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs + 1L, (BaseSource)source);
        LOG.info("Next a batch put with one invalid family");
        puts[5].addColumn(Bytes.toBytes((String)"BAD_CF"), this.qual, this.value);
        codes = this.region.batchMutate((Mutation[])puts);
        Assert.assertEquals((long)10L, (long)codes.length);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)(i == 5 ? HConstants.OperationStatusCode.BAD_FAMILY : HConstants.OperationStatusCode.SUCCESS), (Object)codes[i].getOperationStatusCode());
        }
        this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs + 2L, (BaseSource)source);
    }

    @Test
    public void testBatchPut_whileMultipleRowLocksHeld() throws Exception {
        final Put[] puts = new Put[10];
        MetricsWALSource source = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        long syncs = this.prepareRegionForBachPut(puts, source, false);
        puts[5].addColumn(Bytes.toBytes((String)"BAD_CF"), this.qual, this.value);
        LOG.info("batchPut will have to break into four batches to avoid row locks");
        Region.RowLock rowLock1 = this.region.getRowLock(Bytes.toBytes((String)"row_2"));
        Region.RowLock rowLock2 = this.region.getRowLock(Bytes.toBytes((String)"row_1"));
        Region.RowLock rowLock3 = this.region.getRowLock(Bytes.toBytes((String)"row_3"));
        Region.RowLock rowLock4 = this.region.getRowLock(Bytes.toBytes((String)"row_3"), true);
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(CONF);
        final AtomicReference retFromThread = new AtomicReference();
        final CountDownLatch startingPuts = new CountDownLatch(1);
        final CountDownLatch startingClose = new CountDownLatch(1);
        MultithreadedTestUtil.TestThread putter = new MultithreadedTestUtil.TestThread(ctx){

            @Override
            public void doWork() throws IOException {
                startingPuts.countDown();
                retFromThread.set(TestHRegion.this.region.batchMutate((Mutation[])puts));
            }
        };
        LOG.info("...starting put thread while holding locks");
        ctx.addThread(putter);
        ctx.startThreads();
        MultithreadedTestUtil.TestThread regionCloseThread = new MultithreadedTestUtil.TestThread(ctx){

            @Override
            public void doWork() {
                try {
                    startingPuts.await();
                    Thread.sleep(10L);
                    startingClose.countDown();
                    HBaseTestingUtility.closeRegionAndWAL(TestHRegion.this.region);
                    TestHRegion.this.region = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        regionCloseThread.start();
        startingClose.await();
        startingPuts.await();
        Thread.sleep(100L);
        LOG.info("...releasing row lock 1, which should let put thread continue");
        rowLock1.release();
        rowLock2.release();
        rowLock3.release();
        this.waitForCounter(source, "syncTimeNumOps", syncs + 1L);
        LOG.info("...joining on put thread");
        ctx.stop();
        regionCloseThread.join();
        OperationStatus[] codes = (OperationStatus[])retFromThread.get();
        for (int i = 0; i < codes.length; ++i) {
            Assert.assertEquals((Object)(i == 5 ? HConstants.OperationStatusCode.BAD_FAMILY : HConstants.OperationStatusCode.SUCCESS), (Object)codes[i].getOperationStatusCode());
        }
        rowLock4.release();
    }

    private void waitForCounter(MetricsWALSource source, String metricName, long expectedCount) throws InterruptedException {
        long currentCount;
        long startWait = EnvironmentEdgeManager.currentTime();
        while ((currentCount = this.metricsAssertHelper.getCounter(metricName, (BaseSource)source)) < expectedCount) {
            Thread.sleep(100L);
            if (EnvironmentEdgeManager.currentTime() - startWait <= 10000L) continue;
            Assert.fail((String)String.format("Timed out waiting for '%s' >= '%s', currentCount=%s", metricName, expectedCount, currentCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicBatchPut() throws IOException {
        final Put[] puts = new Put[10];
        MetricsWALSource source = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        long syncs = this.prepareRegionForBachPut(puts, source, false);
        OperationStatus[] codes = this.region.batchMutate((Mutation[])puts, true);
        Assert.assertEquals((long)10L, (long)codes.length);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)codes[i].getOperationStatusCode());
        }
        this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs + 1L, (BaseSource)source);
        Region.RowLock lock = this.region.getRowLock(Bytes.toBytes((String)"row_3"));
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(CONF);
        final AtomicReference retFromThread = new AtomicReference();
        final CountDownLatch finishedPuts = new CountDownLatch(1);
        MultithreadedTestUtil.TestThread putter = new MultithreadedTestUtil.TestThread(ctx){

            @Override
            public void doWork() throws IOException {
                try {
                    TestHRegion.this.region.batchMutate((Mutation[])puts, true);
                }
                catch (IOException ioe) {
                    LOG.error("test failed!", (Throwable)ioe);
                    retFromThread.set(ioe);
                }
                finishedPuts.countDown();
            }
        };
        LOG.info("...starting put thread while holding locks");
        ctx.addThread(putter);
        ctx.startThreads();
        LOG.info("...waiting for batch puts while holding locks");
        try {
            finishedPuts.await();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted!", (Throwable)e);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        Assert.assertNotNull(retFromThread.get());
        this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs + 1L, (BaseSource)source);
        LOG.info("Next a batch put with one invalid family");
        puts[5].addColumn(Bytes.toBytes((String)"BAD_CF"), this.qual, this.value);
        this.thrown.expect(NoSuchColumnFamilyException.class);
        this.region.batchMutate((Mutation[])puts, true);
    }

    @Test
    public void testBatchPutWithTsSlop() throws Exception {
        CONF.setInt("hbase.hregion.keyvalue.timestamp.slop.millisecs", 1000);
        Put[] puts = new Put[10];
        MetricsWALSource source = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        long syncs = this.prepareRegionForBachPut(puts, source, true);
        OperationStatus[] codes = this.region.batchMutate((Mutation[])puts);
        Assert.assertEquals((long)10L, (long)codes.length);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, (Object)codes[i].getOperationStatusCode());
        }
        this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs, (BaseSource)source);
    }

    private long prepareRegionForBachPut(Put[] puts, MetricsWALSource source, boolean slop) throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
        LOG.info("First a batch put with all valid puts");
        for (int i = 0; i < puts.length; ++i) {
            puts[i] = slop ? new Put(Bytes.toBytes((String)("row_" + i)), 9223372036854775707L) : new Put(Bytes.toBytes((String)("row_" + i)));
            puts[i].addColumn(COLUMN_FAMILY_BYTES, this.qual, this.value);
        }
        long syncs = this.metricsAssertHelper.getCounter("syncTimeNumOps", (BaseSource)source);
        this.metricsAssertHelper.assertCounter("syncTimeNumOps", syncs, (BaseSource)source);
        return syncs;
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_WithEmptyRowValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] emptyVal = new byte[]{};
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, emptyVal);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)put);
        Assert.assertTrue((boolean)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)put);
        Assert.assertTrue((boolean)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)put);
        Assert.assertFalse((boolean)res);
        Delete delete = new Delete(row1);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)delete);
        Assert.assertFalse((boolean)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put);
        Assert.assertTrue((boolean)res);
        delete = new Delete(row1);
        delete.addColumn(fam1, qf1);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)delete);
        Assert.assertTrue((boolean)res);
        delete = new Delete(row1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)delete);
        Assert.assertTrue((boolean)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new NullComparator(), (Mutation)put);
        Assert.assertTrue((boolean)res);
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_WithWrongValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        BigDecimal bd1 = new BigDecimal(Double.MAX_VALUE);
        BigDecimal bd2 = new BigDecimal(Double.MIN_VALUE);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        this.region.put(put);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        Delete delete = new Delete(row1);
        delete.addFamily(fam1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, Bytes.toBytes((BigDecimal)bd1));
        this.region.put(put);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BigDecimalComparator(bd2), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        delete = new Delete(row1);
        delete.addFamily(fam1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BigDecimalComparator(bd2), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_WithCorrectValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        BigDecimal bd1 = new BigDecimal(Double.MIN_VALUE);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        long now = EnvironmentEdgeManager.currentTime();
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, now, val1);
        this.region.put(put);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put);
        Assert.assertEquals((String)"First", (Object)true, (Object)res);
        Delete delete = new Delete(row1, now + 1L);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)delete);
        Assert.assertEquals((String)"Delete", (Object)true, (Object)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, now + 2L, Bytes.toBytes((BigDecimal)bd1));
        this.region.put(put);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BigDecimalComparator(bd1), (Mutation)put);
        Assert.assertEquals((String)"Second put", (Object)true, (Object)res);
        delete = new Delete(row1, now + 3L);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BigDecimalComparator(bd1), (Mutation)delete);
        Assert.assertEquals((String)"Second delete", (Object)true, (Object)res);
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_WithNonEqualCompareOp() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[] val3 = Bytes.toBytes((String)"value3");
        byte[] val4 = Bytes.toBytes((String)"value4");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val3);
        this.region.put(put);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.LESS, (ByteArrayComparable)new BinaryComparator(val3), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.LESS, (ByteArrayComparable)new BinaryComparator(val4), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.LESS, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)put);
        Assert.assertEquals((Object)true, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(val3), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)put);
        Assert.assertEquals((Object)true, (Object)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val3);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put);
        Assert.assertEquals((Object)true, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(val3), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(val4), (Mutation)put);
        Assert.assertEquals((Object)true, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put);
        Assert.assertEquals((Object)false, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)put);
        Assert.assertEquals((Object)true, (Object)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(val3), (Mutation)put);
        Assert.assertEquals((Object)true, (Object)res);
    }

    @Test
    @Deprecated
    public void testCheckAndPut_ThatPutWasWritten() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[][] families = new byte[][]{fam1, fam2};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        this.region.put(put);
        long ts = EnvironmentEdgeManager.currentTime();
        KeyValue kv = new KeyValue(row1, fam2, qf1, ts, KeyValue.Type.Put, val2);
        put = new Put(row1);
        put.add((Cell)kv);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)put);
        Assert.assertEquals((Object)true, (Object)res);
        Get get = new Get(row1);
        get.addColumn(fam2, qf1);
        Cell[] actual = this.region.get(get).rawCells();
        Cell[] expected = new Cell[]{kv};
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    @Test
    @Deprecated
    public void testCheckAndPut_wrongRowInPut() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, HBaseTestingUtility.COLUMNS);
        Put put = new Put(this.row2);
        put.addColumn(HBaseTestingUtility.fam1, this.qual1, this.value1);
        try {
            this.region.checkAndMutate(this.row, HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(this.value2), (Mutation)put);
            Assert.fail();
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
    }

    @Test
    @Deprecated
    public void testCheckAndDelete_ThatDeleteWasWritten() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] qf3 = Bytes.toBytes((String)"qualifier3");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[] val3 = Bytes.toBytes((String)"value3");
        byte[] emptyVal = new byte[]{};
        byte[][] families = new byte[][]{fam1, fam2};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        this.region.put(put);
        Threads.sleep((long)2L);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        put.addColumn(fam2, qf1, val3);
        put.addColumn(fam2, qf2, val2);
        put.addColumn(fam2, qf3, val1);
        put.addColumn(fam1, qf3, val1);
        this.region.put(put);
        LOG.info("get={}", (Object)this.region.get(new Get(row1).addColumn(fam1, qf1)).toString());
        Delete delete = new Delete(row1);
        delete.addColumn(fam1, qf1);
        delete.addColumn(fam2, qf1);
        delete.addColumn(fam1, qf3);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val2), (Mutation)delete);
        Assert.assertEquals((Object)true, (Object)res);
        Get get = new Get(row1);
        get.addColumn(fam1, qf1);
        get.addColumn(fam1, qf3);
        get.addColumn(fam2, qf2);
        Result r = this.region.get(get);
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertArrayEquals((byte[])val1, (byte[])r.getValue(fam1, qf1));
        Assert.assertArrayEquals((byte[])val2, (byte[])r.getValue(fam2, qf2));
        delete = new Delete(row1);
        delete.addFamily(fam2);
        res = this.region.checkAndMutate(row1, fam2, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(emptyVal), (Mutation)delete);
        Assert.assertEquals((Object)true, (Object)res);
        get = new Get(row1);
        r = this.region.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertArrayEquals((byte[])val1, (byte[])r.getValue(fam1, qf1));
        delete = new Delete(row1);
        res = this.region.checkAndMutate(row1, fam1, qf1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(val1), (Mutation)delete);
        Assert.assertEquals((Object)true, (Object)res);
        get = new Get(row1);
        r = this.region.get(get);
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_WithFilters() throws Throwable {
        byte[] FAMILY = Bytes.toBytes((String)"fam");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{FAMILY});
        Put put = new Put(this.row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        this.region.put(put);
        boolean ok = this.region.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))}), (Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")));
        Assert.assertTrue((boolean)ok);
        Result result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D")));
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        ok = this.region.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))}), (Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")));
        Assert.assertFalse((boolean)ok);
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"))).isEmpty());
        ok = this.region.checkAndMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))}), (Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"D")));
        Assert.assertTrue((boolean)ok);
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).isEmpty());
        ok = this.region.checkAndRowMutate(this.row, (Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))}), new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
        Assert.assertTrue((boolean)ok);
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E")));
        Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"E"))));
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).isEmpty());
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_WithFiltersAndTimeRange() throws Throwable {
        byte[] FAMILY = Bytes.toBytes((String)"fam");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{FAMILY});
        this.region.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
        boolean ok = this.region.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), TimeRange.between((long)0L, (long)101L), (Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
        Assert.assertTrue((boolean)ok);
        Result result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        ok = this.region.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), TimeRange.between((long)0L, (long)100L), (Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)ok);
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).isEmpty());
        ok = this.region.checkAndRowMutate(this.row, (Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), TimeRange.between((long)0L, (long)101L), new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A"))));
        Assert.assertTrue((boolean)ok);
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D")));
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).isEmpty());
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_wrongMutationType() throws Throwable {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        try {
            this.region.checkAndMutate(this.row, HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(this.value1), (Mutation)new Increment(this.row).addColumn(HBaseTestingUtility.fam1, this.qual1, 1L));
            Assert.fail((String)"should throw DoNotRetryIOException");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertEquals((Object)"Unsupported mutate type: INCREMENT", (Object)e.getMessage());
        }
        try {
            this.region.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, this.value1), (Mutation)new Increment(this.row).addColumn(HBaseTestingUtility.fam1, this.qual1, 1L));
            Assert.fail((String)"should throw DoNotRetryIOException");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertEquals((Object)"Unsupported mutate type: INCREMENT", (Object)e.getMessage());
        }
    }

    @Test
    @Deprecated
    public void testCheckAndMutate_wrongRow() throws Throwable {
        byte[] wrongRow = Bytes.toBytes((String)"wrongRow");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        try {
            this.region.checkAndMutate(this.row, HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(this.value1), (Mutation)new Put(wrongRow).addColumn(HBaseTestingUtility.fam1, this.qual1, this.value1));
            Assert.fail((String)"should throw DoNotRetryIOException");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertEquals((Object)"The row of the action <wrongRow> doesn't match the original one <rowA>", (Object)e.getMessage());
        }
        try {
            this.region.checkAndMutate(this.row, (Filter)new SingleColumnValueFilter(HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, this.value1), (Mutation)new Put(wrongRow).addColumn(HBaseTestingUtility.fam1, this.qual1, this.value1));
            Assert.fail((String)"should throw DoNotRetryIOException");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertEquals((Object)"The row of the action <wrongRow> doesn't match the original one <rowA>", (Object)e.getMessage());
        }
        try {
            this.region.checkAndRowMutate(this.row, HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(this.value1), new RowMutations(wrongRow).add((Mutation)new Put(wrongRow).addColumn(HBaseTestingUtility.fam1, this.qual1, this.value1)).add((Mutation)new Delete(wrongRow).addColumns(HBaseTestingUtility.fam1, this.qual2)));
            Assert.fail((String)"should throw DoNotRetryIOException");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertEquals((Object)"The row of the action <wrongRow> doesn't match the original one <rowA>", (Object)e.getMessage());
        }
        try {
            this.region.checkAndRowMutate(this.row, (Filter)new SingleColumnValueFilter(HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, this.value1), new RowMutations(wrongRow).add((Mutation)new Put(wrongRow).addColumn(HBaseTestingUtility.fam1, this.qual1, this.value1)).add((Mutation)new Delete(wrongRow).addColumns(HBaseTestingUtility.fam1, this.qual2)));
            Assert.fail((String)"should throw DoNotRetryIOException");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertEquals((Object)"The row of the action <wrongRow> doesn't match the original one <rowA>", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckAndMutateWithEmptyRowValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] emptyVal = new byte[]{};
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, emptyVal);
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, emptyVal).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, emptyVal).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, emptyVal).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Delete delete = new Delete(row1);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, emptyVal).build(delete));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val1).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        delete = new Delete(row1);
        delete.addColumn(fam1, qf1);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val2).build(delete));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        delete = new Delete(row1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, emptyVal).build(delete));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifNotExists(fam1, qf1).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
    }

    @Test
    public void testCheckAndMutateWithWrongValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        BigDecimal bd1 = new BigDecimal(Double.MAX_VALUE);
        BigDecimal bd2 = new BigDecimal(Double.MIN_VALUE);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        this.region.put(put);
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val2).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Delete delete = new Delete(row1);
        delete.addFamily(fam1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val2).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, Bytes.toBytes((BigDecimal)bd1));
        this.region.put(put);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, Bytes.toBytes((BigDecimal)bd2)).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        delete = new Delete(row1);
        delete.addFamily(fam1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, Bytes.toBytes((BigDecimal)bd2)).build(delete));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
    }

    @Test
    public void testCheckAndMutateWithCorrectValue() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        BigDecimal bd1 = new BigDecimal(Double.MIN_VALUE);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        long now = EnvironmentEdgeManager.currentTime();
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, now, val1);
        this.region.put(put);
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val1).build(put));
        Assert.assertTrue((String)"First", (boolean)res.isSuccess());
        Delete delete = new Delete(row1, now + 1L);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val1).build(delete));
        Assert.assertTrue((String)"Delete", (boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, now + 2L, Bytes.toBytes((BigDecimal)bd1));
        this.region.put(put);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, Bytes.toBytes((BigDecimal)bd1)).build(put));
        Assert.assertTrue((String)"Second put", (boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        delete = new Delete(row1, now + 3L);
        delete.addColumn(fam1, qf1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, Bytes.toBytes((BigDecimal)bd1)).build(delete));
        Assert.assertTrue((String)"Second delete", (boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
    }

    @Test
    public void testCheckAndMutateWithNonEqualCompareOp() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[] val3 = Bytes.toBytes((String)"value3");
        byte[] val4 = Bytes.toBytes((String)"value4");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val3);
        this.region.put(put);
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.LESS, val3).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.LESS, val4).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.LESS, val2).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.LESS_OR_EQUAL, val3).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.LESS_OR_EQUAL, val2).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, val3);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.LESS_OR_EQUAL, val1).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.GREATER, val3).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.GREATER, val2).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.GREATER, val4).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.GREATER_OR_EQUAL, val1).build(put));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.GREATER_OR_EQUAL, val2).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.GREATER_OR_EQUAL, val3).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
    }

    @Test
    public void testCheckAndPutThatPutWasWritten() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[][] families = new byte[][]{fam1, fam2};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        this.region.put(put);
        long ts = EnvironmentEdgeManager.currentTime();
        KeyValue kv = new KeyValue(row1, fam2, qf1, ts, KeyValue.Type.Put, val2);
        put = new Put(row1);
        put.add((Cell)kv);
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val1).build(put));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Get get = new Get(row1);
        get.addColumn(fam2, qf1);
        Cell[] actual = this.region.get(get).rawCells();
        Cell[] expected = new Cell[]{kv};
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    @Test
    public void testCheckAndDeleteThatDeleteWasWritten() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] qf3 = Bytes.toBytes((String)"qualifier3");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[] val3 = Bytes.toBytes((String)"value3");
        byte[] emptyVal = new byte[]{};
        byte[][] families = new byte[][]{fam1, fam2};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        this.region.put(put);
        Threads.sleep((long)2L);
        put = new Put(row1);
        put.addColumn(fam1, qf1, val2);
        put.addColumn(fam2, qf1, val3);
        put.addColumn(fam2, qf2, val2);
        put.addColumn(fam2, qf3, val1);
        put.addColumn(fam1, qf3, val1);
        this.region.put(put);
        LOG.info("get={}", (Object)this.region.get(new Get(row1).addColumn(fam1, qf1)).toString());
        Delete delete = new Delete(row1);
        delete.addColumn(fam1, qf1);
        delete.addColumn(fam2, qf1);
        delete.addColumn(fam1, qf3);
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val2).build(delete));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Get get = new Get(row1);
        get.addColumn(fam1, qf1);
        get.addColumn(fam1, qf3);
        get.addColumn(fam2, qf2);
        Result r = this.region.get(get);
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertArrayEquals((byte[])val1, (byte[])r.getValue(fam1, qf1));
        Assert.assertArrayEquals((byte[])val2, (byte[])r.getValue(fam2, qf2));
        delete = new Delete(row1);
        delete.addFamily(fam2);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam2, qf1, CompareOperator.EQUAL, emptyVal).build(delete));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        get = new Get(row1);
        r = this.region.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertArrayEquals((byte[])val1, (byte[])r.getValue(fam1, qf1));
        delete = new Delete(row1);
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])row1).ifMatches(fam1, qf1, CompareOperator.EQUAL, val1).build(delete));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        get = new Get(row1);
        r = this.region.get(get);
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testCheckAndMutateWithFilters() throws Throwable {
        byte[] FAMILY = Bytes.toBytes((String)"fam");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{FAMILY});
        Put put = new Put(this.row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
        this.region.put(put);
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Result result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D")));
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e"))));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"))).isEmpty());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"))).isEmpty());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"B"), CompareOperator.EQUAL, Bytes.toBytes((String)"b"))})).build(new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A")))));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"E")));
        Assert.assertEquals((Object)"e", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"E"))));
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).isEmpty());
    }

    @Test
    public void testCheckAndMutateWithFiltersAndTimeRange() throws Throwable {
        byte[] FAMILY = Bytes.toBytes((String)"fam");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{FAMILY});
        this.region.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), 100L, Bytes.toBytes((String)"a")));
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)101L)).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Result result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)100L)).build(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"))));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"))).isEmpty());
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a"))).timeRange(TimeRange.between((long)0L, (long)101L)).build(new RowMutations(this.row).add((Mutation)new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))).add((Mutation)new Delete(this.row).addColumns(FAMILY, Bytes.toBytes((String)"A")))));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"D")));
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertTrue((boolean)this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"))).isEmpty());
    }

    @Test
    public void testCheckAndIncrement() throws Throwable {
        byte[] FAMILY = Bytes.toBytes((String)"fam");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{FAMILY});
        this.region.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")));
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L)));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Result result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"b")).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 1L)));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        this.region.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 2L)));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"d"))})).build(new Increment(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), 2L)));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
    }

    @Test
    public void testCheckAndAppend() throws Throwable {
        byte[] FAMILY = Bytes.toBytes((String)"fam");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{FAMILY});
        this.region.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")));
        CheckAndMutateResult res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Result result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"b")).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"))));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        this.region.put(new Put(this.row).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"a")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"c"))})).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"bb"))));
        Assert.assertTrue((boolean)res.isSuccess());
        Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])res.getResult().getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        res = this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])this.row).ifMatches((Filter)new FilterList(new Filter[]{new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"A"), CompareOperator.EQUAL, Bytes.toBytes((String)"b")), new SingleColumnValueFilter(FAMILY, Bytes.toBytes((String)"C"), CompareOperator.EQUAL, Bytes.toBytes((String)"d"))})).build(new Append(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"bb"))));
        Assert.assertFalse((boolean)res.isSuccess());
        Assert.assertNull((Object)res.getResult());
        result = this.region.get(new Get(this.row).addColumn(FAMILY, Bytes.toBytes((String)"B")));
        Assert.assertEquals((Object)"bbb", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
    }

    @Test
    public void testCheckAndIncrementAndAppend() throws Throwable {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(HBaseTestingUtility.fam1, this.qual).build(new RowMutations(this.row).add((Mutation)new Increment(this.row).addColumn(HBaseTestingUtility.fam1, this.qual1, 1L)).add((Mutation)new Append(this.row).addColumn(HBaseTestingUtility.fam1, this.qual2, Bytes.toBytes((String)"a"))));
        CheckAndMutateResult result = this.region.checkAndMutate(checkAndMutate);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getResult().getValue(HBaseTestingUtility.fam1, this.qual1)));
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])result.getResult().getValue(HBaseTestingUtility.fam1, this.qual2)));
        Result r = this.region.get(new Get(this.row));
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])r.getValue(HBaseTestingUtility.fam1, this.qual1)));
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])r.getValue(HBaseTestingUtility.fam1, this.qual2)));
        checkAndMutate = CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(HBaseTestingUtility.fam1, this.qual).build(new RowMutations(this.row).add((Mutation)new Increment(this.row).addColumn(HBaseTestingUtility.fam1, this.qual1, 1L).setReturnResults(false)).add((Mutation)new Append(this.row).addColumn(HBaseTestingUtility.fam1, this.qual2, Bytes.toBytes((String)"a")).setReturnResults(false)));
        result = this.region.checkAndMutate(checkAndMutate);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult().getValue(HBaseTestingUtility.fam1, this.qual1));
        Assert.assertNull((Object)result.getResult().getValue(HBaseTestingUtility.fam1, this.qual2));
        r = this.region.get(new Get(this.row));
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])r.getValue(HBaseTestingUtility.fam1, this.qual1)));
        Assert.assertEquals((Object)"aa", (Object)Bytes.toString((byte[])r.getValue(HBaseTestingUtility.fam1, this.qual2)));
        checkAndMutate = CheckAndMutate.newBuilder((byte[])this.row).ifNotExists(HBaseTestingUtility.fam1, this.qual).build(new RowMutations(this.row).add((Mutation)new Increment(this.row).addColumn(HBaseTestingUtility.fam1, this.qual1, 1L)).add((Mutation)new Append(this.row).addColumn(HBaseTestingUtility.fam1, this.qual2, Bytes.toBytes((String)"a")).setReturnResults(false)));
        result = this.region.checkAndMutate(checkAndMutate);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getResult().getValue(HBaseTestingUtility.fam1, this.qual1)));
        Assert.assertNull((Object)result.getResult().getValue(HBaseTestingUtility.fam1, this.qual2));
        r = this.region.get(new Get(this.row));
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])r.getValue(HBaseTestingUtility.fam1, this.qual1)));
        Assert.assertEquals((Object)"aaa", (Object)Bytes.toString((byte[])r.getValue(HBaseTestingUtility.fam1, this.qual2)));
    }

    @Test
    public void testCheckAndRowMutations() throws Throwable {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] q3 = Bytes.toBytes((String)"q3");
        byte[] q4 = Bytes.toBytes((String)"q4");
        String v1 = "v1";
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        this.region.batchMutate(new Mutation[]{new Put(row).addColumn(HBaseTestingUtility.fam1, q2, Bytes.toBytes((String)"toBeDeleted")), new Put(row).addColumn(HBaseTestingUtility.fam1, q3, Bytes.toBytes((long)5L)), new Put(row).addColumn(HBaseTestingUtility.fam1, q4, Bytes.toBytes((String)"a"))});
        CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])row).ifNotExists(HBaseTestingUtility.fam1, q1).build(new RowMutations(row).add(Arrays.asList(new Put(row).addColumn(HBaseTestingUtility.fam1, q1, Bytes.toBytes((String)"v1")), new Delete(row).addColumns(HBaseTestingUtility.fam1, q2), new Increment(row).addColumn(HBaseTestingUtility.fam1, q3, 1L), new Append(row).addColumn(HBaseTestingUtility.fam1, q4, Bytes.toBytes((String)"b")))));
        CheckAndMutateResult result = this.region.checkAndMutate(checkAndMutate);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])result.getResult().getValue(HBaseTestingUtility.fam1, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])result.getResult().getValue(HBaseTestingUtility.fam1, q4)));
        Result r = this.region.get(new Get(row));
        Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])r.getValue(HBaseTestingUtility.fam1, q1)));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])r.getValue(HBaseTestingUtility.fam1, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])r.getValue(HBaseTestingUtility.fam1, q4)));
        checkAndMutate = CheckAndMutate.newBuilder((byte[])row).ifNotExists(HBaseTestingUtility.fam1, q1).build(new RowMutations(row).add(Arrays.asList(new Delete(row).addColumns(HBaseTestingUtility.fam1, q1), new Put(row).addColumn(HBaseTestingUtility.fam1, q2, Bytes.toBytes((String)"v1")), new Increment(row).addColumn(HBaseTestingUtility.fam1, q3, 1L), new Append(row).addColumn(HBaseTestingUtility.fam1, q4, Bytes.toBytes((String)"b")))));
        result = this.region.checkAndMutate(checkAndMutate);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertNull((Object)result.getResult());
        r = this.region.get(new Get(row));
        Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])r.getValue(HBaseTestingUtility.fam1, q1)));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])r.getValue(HBaseTestingUtility.fam1, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])r.getValue(HBaseTestingUtility.fam1, q4)));
    }

    @Test
    public void testDelete_multiDeleteColumn() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qual = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row1);
        put.addColumn(fam1, qual, 1L, value);
        put.addColumn(fam1, qual, 2L, value);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        this.region.put(put);
        Delete delete = new Delete(row1);
        delete.addColumn(fam1, qual);
        delete.addColumn(fam1, qual);
        this.region.delete(delete);
        Get get = new Get(row1);
        get.addFamily(fam1);
        Result r = this.region.get(get);
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testDelete_CheckFamily() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1, fam2, fam3});
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(row1, fam4, null, null));
        byte[] forUnitTestsOnly = Bytes.toBytes((String)"ForUnitTestsOnly");
        TreeMap<byte[], ArrayList<KeyValue>> deleteMap = new TreeMap<byte[], ArrayList<KeyValue>>(Bytes.BYTES_COMPARATOR);
        deleteMap.put(fam2, kvs);
        this.region.delete(new Delete(forUnitTestsOnly, Long.MAX_VALUE, deleteMap));
        TreeMap<byte[], ArrayList<KeyValue>> deleteMap2 = new TreeMap<byte[], ArrayList<KeyValue>>(Bytes.BYTES_COMPARATOR);
        deleteMap2.put(fam4, kvs);
        Assert.assertThrows((String)("Family " + Bytes.toString((byte[])fam4) + " does exist"), NoSuchColumnFamilyException.class, () -> this.region.delete(new Delete(forUnitTestsOnly, Long.MAX_VALUE, deleteMap2)));
    }

    @Test
    public void testDelete_mixed() throws IOException, InterruptedException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        byte[] row = Bytes.toBytes((String)"table_name");
        byte[] serverinfo = Bytes.toBytes((String)"serverinfo");
        byte[] splitA = Bytes.toBytes((String)"splitA");
        byte[] splitB = Bytes.toBytes((String)"splitB");
        Put put = new Put(row);
        put.addColumn(fam, splitA, Bytes.toBytes((String)"reference_A"));
        this.region.put(put);
        put = new Put(row);
        put.addColumn(fam, splitB, Bytes.toBytes((String)"reference_B"));
        this.region.put(put);
        put = new Put(row);
        put.addColumn(fam, serverinfo, Bytes.toBytes((String)"ip_address"));
        this.region.put(put);
        Delete delete = new Delete(row);
        delete.addColumns(fam, splitA);
        this.region.delete(delete);
        Get get = new Get(row).addColumn(fam, serverinfo);
        Result result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        get = new Get(row).addColumn(fam, splitA);
        result = this.region.get(get);
        Assert.assertEquals((long)0L, (long)result.size());
        get = new Get(row).addColumn(fam, splitB);
        result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        put = new Put(row);
        put.addColumn(fam, splitA, Bytes.toBytes((String)"reference_A"));
        this.region.put(put);
        get = new Get(row);
        result = this.region.get(get);
        Assert.assertEquals((long)3L, (long)result.size());
        delete = new Delete(row);
        this.region.delete(delete);
        Assert.assertEquals((long)0L, (long)this.region.get(get).size());
        this.region.put(new Put(row).addColumn(fam, splitA, Bytes.toBytes((String)"reference_A")));
        result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testDeleteRowWithFutureTs() throws IOException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        byte[] row = Bytes.toBytes((String)"table_name");
        byte[] serverinfo = Bytes.toBytes((String)"serverinfo");
        Put put = new Put(row);
        put.addColumn(fam, serverinfo, 0x7FFFFFFFFFFFFFFAL, Bytes.toBytes((String)"value"));
        this.region.put(put);
        Delete delete = new Delete(row);
        this.region.delete(delete);
        Get get = new Get(row).addColumn(fam, serverinfo);
        Result result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        delete = new Delete(row, 0x7FFFFFFFFFFFFFFCL);
        this.region.delete(delete);
        get = new Get(row).addColumn(fam, serverinfo);
        result = this.region.get(get);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testPutWithLatestTS() throws IOException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        byte[] row = Bytes.toBytes((String)"row1");
        byte[] qual = Bytes.toBytes((String)"qual");
        Put put = new Put(row);
        put.addColumn(fam, qual, Long.MAX_VALUE, Bytes.toBytes((String)"value"));
        this.region.put(put);
        Get get = new Get(row).addColumn(fam, qual);
        Result result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        LOG.info("Got: " + kv);
        Assert.assertTrue((String)"LATEST_TIMESTAMP was not replaced with real timestamp", (kv.getTimestamp() != Long.MAX_VALUE ? 1 : 0) != 0);
        row = Bytes.toBytes((String)"row2");
        put = new Put(row);
        put.addColumn(fam, qual, Long.MAX_VALUE, Bytes.toBytes((String)"value"));
        this.region.put(put);
        get = new Get(row).addColumn(fam, qual);
        result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        kv = result.rawCells()[0];
        LOG.info("Got: " + kv);
        Assert.assertTrue((String)"LATEST_TIMESTAMP was not replaced with real timestamp", (kv.getTimestamp() != Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testPutWithTsSlop() throws IOException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        CONF.setInt("hbase.hregion.keyvalue.timestamp.slop.millisecs", 1000);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        boolean caughtExcep = false;
        try {
            this.region.put(new Put(this.row).addColumn(fam, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value")));
            this.region.put(new Put(this.row).addColumn(fam, Bytes.toBytes((String)"qual"), EnvironmentEdgeManager.currentTime() + 2000L, Bytes.toBytes((String)"value")));
            Assert.fail((String)"Expected IOE for TS out of configured timerange");
        }
        catch (FailedSanityCheckException ioe) {
            LOG.debug("Received expected exception", (Throwable)ioe);
            caughtExcep = true;
        }
        Assert.assertTrue((String)"Should catch FailedSanityCheckException", (boolean)caughtExcep);
    }

    @Test
    public void testScanner_DeleteOneFamilyNotAnother() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"columnA");
        byte[] fam2 = Bytes.toBytes((String)"columnB");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1, fam2});
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] value = Bytes.toBytes((String)"value");
        Delete delete = new Delete(rowA);
        delete.addFamily(fam1);
        this.region.delete(delete);
        Put put = new Put(rowA);
        put.addColumn(fam2, null, value);
        this.region.put(put);
        put = new Put(rowB);
        put.addColumn(fam1, null, value);
        put.addColumn(fam2, null, value);
        this.region.put(put);
        Scan scan = new Scan();
        scan.addFamily(fam1).addFamily(fam2);
        try (RegionScannerImpl s = this.region.getScanner(scan);){
            ArrayList results = new ArrayList();
            s.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])rowA));
            results.clear();
            s.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])rowB));
        }
    }

    @Test
    public void testDataInMemoryWithoutWAL() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + "testDataInMemoryWithoutWAL");
        FSHLog hLog = new FSHLog(fs, rootDir, "testDataInMemoryWithoutWAL", CONF);
        hLog.init();
        this.region = this.initHRegion(this.tableName, null, null, CONF, false, Durability.SYNC_WAL, (WAL)hLog, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
        Cell originalCell = CellUtil.createCell((byte[])this.row, (byte[])COLUMN_FAMILY_BYTES, (byte[])this.qual1, (long)EnvironmentEdgeManager.currentTime(), (byte)KeyValue.Type.Put.getCode(), (byte[])this.value1);
        long originalSize = originalCell.getSerializedSize();
        Cell addCell = CellUtil.createCell((byte[])this.row, (byte[])COLUMN_FAMILY_BYTES, (byte[])this.qual1, (long)EnvironmentEdgeManager.currentTime(), (byte)KeyValue.Type.Put.getCode(), (byte[])Bytes.toBytes((String)"xxxxxxxxxx"));
        long addSize = addCell.getSerializedSize();
        LOG.info("originalSize:" + originalSize + ", addSize:" + addSize);
        TestHRegion.testDataInMemoryWithoutWAL(this.region, new Put(this.row).add(originalCell).setDurability(Durability.SKIP_WAL), new Put(this.row).add(addCell).setDurability(Durability.SKIP_WAL), originalSize + addSize);
        TestHRegion.testDataInMemoryWithoutWAL(this.region, new Put(this.row).add(originalCell).setDurability(Durability.SKIP_WAL), new Put(this.row).add(addCell).setDurability(Durability.SYNC_WAL), originalSize + addSize);
        TestHRegion.testDataInMemoryWithoutWAL(this.region, new Put(this.row).add(originalCell).setDurability(Durability.SYNC_WAL), new Put(this.row).add(addCell).setDurability(Durability.SKIP_WAL), 0L);
        TestHRegion.testDataInMemoryWithoutWAL(this.region, new Put(this.row).add(originalCell).setDurability(Durability.SYNC_WAL), new Put(this.row).add(addCell).setDurability(Durability.SYNC_WAL), 0L);
    }

    private static void testDataInMemoryWithoutWAL(HRegion region, Put originalPut, final Put addPut, long delta) throws IOException {
        long initSize = region.getDataInMemoryWithoutWAL();
        RegionCoprocessorHost normalCPHost = region.getCoprocessorHost();
        RegionCoprocessorHost mockedCPHost = (RegionCoprocessorHost)Mockito.mock(RegionCoprocessorHost.class);
        ((RegionCoprocessorHost)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                MiniBatchOperationInProgress mb = (MiniBatchOperationInProgress)invocation.getArgument(0);
                mb.addOperationsFromCP(0, new Mutation[]{addPut});
                return null;
            }
        }).when((Object)mockedCPHost)).preBatchMutate((MiniBatchOperationInProgress)ArgumentMatchers.isA(MiniBatchOperationInProgress.class));
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN_FAMILY_BYTES);
        ScanInfo info = new ScanInfo(CONF, builder.build(), Long.MAX_VALUE, Long.MAX_VALUE, region.getCellComparator());
        Mockito.when((Object)mockedCPHost.preFlushScannerOpen((HStore)ArgumentMatchers.any(HStore.class), (FlushLifeCycleTracker)ArgumentMatchers.any())).thenReturn((Object)info);
        Mockito.when((Object)mockedCPHost.preFlush((HStore)ArgumentMatchers.any(), (InternalScanner)ArgumentMatchers.any(StoreScanner.class), (FlushLifeCycleTracker)ArgumentMatchers.any())).thenAnswer(i -> i.getArgument(1));
        region.setCoprocessorHost(mockedCPHost);
        region.put(originalPut);
        region.setCoprocessorHost(normalCPHost);
        long finalSize = region.getDataInMemoryWithoutWAL();
        Assert.assertEquals((String)("finalSize:" + finalSize + ", initSize:" + initSize + ", delta:" + delta), (long)finalSize, (long)(initSize + delta));
    }

    @Test
    public void testDeleteColumns_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.addColumns(HBaseTestingUtility.fam1, this.qual1);
        this.doTestDelete_AndPostInsert(delete);
    }

    @Test
    public void testaddFamily_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.addFamily(HBaseTestingUtility.fam1);
        this.doTestDelete_AndPostInsert(delete);
    }

    public void doTestDelete_AndPostInsert(Delete delete) throws IOException, InterruptedException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        Put put = new Put(this.row);
        put.addColumn(HBaseTestingUtility.fam1, this.qual1, this.value1);
        this.region.put(put);
        this.region.delete(delete);
        put = new Put(this.row);
        put.addColumn(HBaseTestingUtility.fam1, this.qual1, this.value2);
        this.region.put(put);
        Get get = new Get(this.row);
        get.addColumn(HBaseTestingUtility.fam1, this.qual1);
        Result r = this.region.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertArrayEquals((byte[])this.value2, (byte[])r.getValue(HBaseTestingUtility.fam1, this.qual1));
        Scan scan = new Scan(this.row);
        scan.addColumn(HBaseTestingUtility.fam1, this.qual1);
        try (RegionScannerImpl s = this.region.getScanner(scan);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)false, (Object)s.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            Cell kv = (Cell)results.get(0);
            Assert.assertArrayEquals((byte[])this.value2, (byte[])CellUtil.cloneValue((Cell)kv));
            Assert.assertArrayEquals((byte[])HBaseTestingUtility.fam1, (byte[])CellUtil.cloneFamily((Cell)kv));
            Assert.assertArrayEquals((byte[])this.qual1, (byte[])CellUtil.cloneQualifier((Cell)kv));
            Assert.assertArrayEquals((byte[])this.row, (byte[])CellUtil.cloneRow((Cell)kv));
        }
    }

    @Test
    public void testDelete_CheckTimestampUpdated() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        byte[] forUnitTestsOnly = Bytes.toBytes((String)"ForUnitTestsOnly");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(row1, HBaseTestingUtility.fam1, col1, null));
        kvs.add(new KeyValue(row1, HBaseTestingUtility.fam1, col2, null));
        kvs.add(new KeyValue(row1, HBaseTestingUtility.fam1, col3, null));
        TreeMap<byte[], ArrayList<KeyValue>> deleteMap = new TreeMap<byte[], ArrayList<KeyValue>>(Bytes.BYTES_COMPARATOR);
        deleteMap.put(HBaseTestingUtility.fam1, kvs);
        this.region.delete(new Delete(forUnitTestsOnly, Long.MAX_VALUE, deleteMap));
        long now = EnvironmentEdgeManager.currentTime();
        AbstractMemStore memstore = (AbstractMemStore)this.region.getStore((byte[])HBaseTestingUtility.fam1).memstore;
        Cell firstCell = memstore.getActive().first();
        Assert.assertTrue((firstCell.getTimestamp() <= now ? 1 : 0) != 0);
        now = firstCell.getTimestamp();
        for (Cell cell : memstore.getActive().getCellSet()) {
            Assert.assertTrue((cell.getTimestamp() <= now ? 1 : 0) != 0);
            now = cell.getTimestamp();
        }
    }

    @Test
    public void testGet_FamilyChecker() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"False");
        byte[] col1 = Bytes.toBytes((String)"col1");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Get get = new Get(row1);
        get.addColumn(fam2, col1);
        try {
            this.region.get(get);
            Assert.fail((String)"Expecting DoNotRetryIOException in get but did not get any");
        }
        catch (DoNotRetryIOException e) {
            LOG.info("Got expected DoNotRetryIOException successfully");
        }
    }

    @Test
    public void testGet_Basic() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        byte[] col4 = Bytes.toBytes((String)"col4");
        byte[] col5 = Bytes.toBytes((String)"col5");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = new Put(row1);
        put.addColumn(fam1, col1, null);
        put.addColumn(fam1, col2, null);
        put.addColumn(fam1, col3, null);
        put.addColumn(fam1, col4, null);
        put.addColumn(fam1, col5, null);
        this.region.put(put);
        Get get = new Get(row1);
        get.addColumn(fam1, col2);
        get.addColumn(fam1, col4);
        KeyValue kv1 = new KeyValue(row1, fam1, col2);
        KeyValue kv2 = new KeyValue(row1, fam1, col4);
        KeyValue[] expected = new KeyValue[]{kv1, kv2};
        Result res = this.region.get(get);
        Assert.assertEquals((long)expected.length, (long)res.size());
        for (int i = 0; i < res.size(); ++i) {
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)expected[i], (Cell)res.rawCells()[i]));
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)expected[i], (Cell)res.rawCells()[i]));
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)expected[i], (Cell)res.rawCells()[i]));
        }
        Get g = new Get(row1);
        int count = 2;
        g.setFilter((Filter)new ColumnCountGetFilter(2));
        res = this.region.get(g);
        Assert.assertEquals((long)2L, (long)res.size());
    }

    @Test
    public void testGet_Empty() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] fam = Bytes.toBytes((String)"fam");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam});
        Get get = new Get(row);
        get.addFamily(fam);
        Result r = this.region.get(get);
        Assert.assertTrue((boolean)r.isEmpty());
    }

    @Test
    public void testGetWithFilter() throws IOException, InterruptedException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        int maxVersions = 3;
        HColumnDescriptor hcd = new HColumnDescriptor(fam1);
        hcd.setMaxVersions(3);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"testFilterAndColumnTracker"));
        htd.addFamily(hcd);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path logDir = TEST_UTIL.getDataTestDirOnTestFS(this.method + ".log");
        WAL wal = HBaseTestingUtility.createWal(TEST_UTIL.getConfiguration(), logDir, (RegionInfo)info);
        this.region = TEST_UTIL.createLocalHRegion(info, CONF, htd, wal);
        long ts = 0L;
        Put put = new Put(row1, ts);
        put.addColumn(fam1, col1, value1);
        this.region.put(put);
        put = new Put(row1, ts + 1L);
        put.addColumn(fam1, col1, Bytes.toBytes((String)"filter1"));
        this.region.put(put);
        put = new Put(row1, ts + 2L);
        put.addColumn(fam1, col1, Bytes.toBytes((String)"filter2"));
        this.region.put(put);
        put = new Put(row1, ts + 3L);
        put.addColumn(fam1, col1, value2);
        this.region.put(put);
        Get get = new Get(row1);
        get.setMaxVersions();
        Result res = this.region.get(get);
        Assert.assertEquals((long)3L, (long)res.size());
        get.setFilter((Filter)new ValueFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new SubstringComparator("value")));
        res = this.region.get(get);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)new KeyValue(row1, fam1, col1, value2), (Cell)res.rawCells()[0]));
        Assert.assertEquals((long)(ts + 3L), (long)res.rawCells()[0].getTimestamp());
        this.region.flush(true);
        this.region.compact(true);
        Thread.sleep(1000L);
        res = this.region.get(get);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)new KeyValue(row1, fam1, col1, value2), (Cell)res.rawCells()[0]));
    }

    @Test
    public void testGetScanner_WithOkFamilies() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1, fam2};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Scan scan = new Scan();
        scan.addFamily(fam1);
        scan.addFamily(fam2);
        this.region.getScanner(scan).close();
    }

    @Test
    public void testGetScanner_WithNotOkFamilies() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Scan scan = new Scan();
        scan.addFamily(fam2);
        Assert.assertThrows(NoSuchColumnFamilyException.class, () -> this.region.getScanner(scan));
    }

    @Test
    public void testGetScanner_WithNoFamilies() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = new Put(row1);
        put.addColumn(fam1, null, null);
        put.addColumn(fam2, null, null);
        put.addColumn(fam3, null, null);
        put.addColumn(fam4, null, null);
        this.region.put(put);
        Scan scan = null;
        scan = new Scan();
        scan.addFamily(fam2);
        scan.addFamily(fam4);
        try (RegionScannerImpl is = this.region.getScanner(scan);){
            Assert.assertEquals((long)1L, (long)is.storeHeap.getHeap().size());
        }
        scan = new Scan();
        is = this.region.getScanner(scan);
        var10_10 = null;
        try {
            Assert.assertEquals((long)(families.length - 1), (long)is.storeHeap.getHeap().size());
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var10_10 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScanner_WithRegionClosed() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1, fam2};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        this.region.closed.set(true);
        try {
            Assert.assertThrows(NotServingRegionException.class, () -> this.region.getScanner(null));
        }
        finally {
            this.region.closed.set(false);
        }
    }

    @Test
    public void testRegionScanner_Next() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        long ts = EnvironmentEdgeManager.currentTime();
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = null;
        put = new Put(row1);
        put.addColumn(fam1, (byte[])null, ts, null);
        put.addColumn(fam2, (byte[])null, ts, null);
        put.addColumn(fam3, (byte[])null, ts, null);
        put.addColumn(fam4, (byte[])null, ts, null);
        this.region.put(put);
        put = new Put(row2);
        put.addColumn(fam1, (byte[])null, ts, null);
        put.addColumn(fam2, (byte[])null, ts, null);
        put.addColumn(fam3, (byte[])null, ts, null);
        put.addColumn(fam4, (byte[])null, ts, null);
        this.region.put(put);
        Scan scan = new Scan();
        scan.addFamily(fam2);
        scan.addFamily(fam4);
        try (RegionScannerImpl is = this.region.getScanner(scan);){
            ArrayList res = null;
            ArrayList<KeyValue> expected1 = new ArrayList<KeyValue>();
            expected1.add(new KeyValue(row1, fam2, null, ts, KeyValue.Type.Put, null));
            expected1.add(new KeyValue(row1, fam4, null, ts, KeyValue.Type.Put, null));
            res = new ArrayList();
            is.next(res);
            for (int i = 0; i < res.size(); ++i) {
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)((Cell)expected1.get(i)), (Cell)((Cell)res.get(i))));
            }
            ArrayList<KeyValue> expected2 = new ArrayList<KeyValue>();
            expected2.add(new KeyValue(row2, fam2, null, ts, KeyValue.Type.Put, null));
            expected2.add(new KeyValue(row2, fam4, null, ts, KeyValue.Type.Put, null));
            res = new ArrayList();
            is.next(res);
            for (int i = 0; i < res.size(); ++i) {
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)((Cell)expected2.get(i)), (Cell)((Cell)res.get(i))));
            }
        }
    }

    @Test
    public void testScanner_ExplicitColumns_FromMemStore_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = EnvironmentEdgeManager.currentTime();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add((Cell)kv13);
        put.add((Cell)kv12);
        put.add((Cell)kv11);
        put.add((Cell)kv23);
        put.add((Cell)kv22);
        put.add((Cell)kv21);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals(expected.get(i), actual.get(i));
            }
        }
    }

    @Test
    public void testScanner_ExplicitColumns_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add((Cell)kv13);
        put.add((Cell)kv12);
        put.add((Cell)kv11);
        put.add((Cell)kv23);
        put.add((Cell)kv22);
        put.add((Cell)kv21);
        this.region.put(put);
        this.region.flush(true);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.addColumn(fam1, qf2);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
    }

    @Test
    public void testScanner_ExplicitColumns_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(row1);
        put.add((Cell)kv14);
        put.add((Cell)kv24);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row1);
        put.add((Cell)kv23);
        put.add((Cell)kv13);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row1);
        put.add((Cell)kv22);
        put.add((Cell)kv12);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row1);
        put.add((Cell)kv21);
        put.add((Cell)kv11);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv14);
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv24);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.addColumn(fam1, qf2);
        int versions = 3;
        scan.setMaxVersions(versions);
        ArrayList actual = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
    }

    @Test
    public void testScanner_Wildcard_FromMemStore_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = EnvironmentEdgeManager.currentTime();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add((Cell)kv13);
        put.add((Cell)kv12);
        put.add((Cell)kv11);
        put.add((Cell)kv23);
        put.add((Cell)kv22);
        put.add((Cell)kv21);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addFamily(fam1);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals(expected.get(i), actual.get(i));
            }
        }
    }

    @Test
    public void testScanner_Wildcard_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add((Cell)kv13);
        put.add((Cell)kv12);
        put.add((Cell)kv11);
        put.add((Cell)kv23);
        put.add((Cell)kv22);
        put.add((Cell)kv21);
        this.region.put(put);
        this.region.flush(true);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addFamily(fam1);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
    }

    @Test
    public void testScanner_StopRow1542() throws IOException {
        byte[] family = Bytes.toBytes((String)"testFamily");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        byte[] row1 = Bytes.toBytes((String)"row111");
        byte[] row2 = Bytes.toBytes((String)"row222");
        byte[] row3 = Bytes.toBytes((String)"row333");
        byte[] row4 = Bytes.toBytes((String)"row444");
        byte[] row5 = Bytes.toBytes((String)"row555");
        byte[] col1 = Bytes.toBytes((String)"Pub111");
        byte[] col2 = Bytes.toBytes((String)"Pub222");
        Put put = new Put(row1);
        put.addColumn(family, col1, Bytes.toBytes((long)10L));
        this.region.put(put);
        put = new Put(row2);
        put.addColumn(family, col1, Bytes.toBytes((long)15L));
        this.region.put(put);
        put = new Put(row3);
        put.addColumn(family, col2, Bytes.toBytes((long)20L));
        this.region.put(put);
        put = new Put(row4);
        put.addColumn(family, col2, Bytes.toBytes((long)30L));
        this.region.put(put);
        put = new Put(row5);
        put.addColumn(family, col1, Bytes.toBytes((long)40L));
        this.region.put(put);
        Scan scan = new Scan(row3, row4);
        scan.setMaxVersions();
        scan.addColumn(family, col1);
        try (RegionScannerImpl s = this.region.getScanner(scan);){
            ArrayList results = new ArrayList();
            Assert.assertEquals((Object)false, (Object)s.next(results));
            Assert.assertEquals((long)0L, (long)results.size());
        }
    }

    @Test
    public void testScanner_Wildcard_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"quateslifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(row1);
        put.add((Cell)kv14);
        put.add((Cell)kv24);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row1);
        put.add((Cell)kv23);
        put.add((Cell)kv13);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row1);
        put.add((Cell)kv22);
        put.add((Cell)kv12);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row1);
        put.add((Cell)kv21);
        put.add((Cell)kv11);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv14);
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv24);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        int versions = 3;
        scan.setMaxVersions(versions);
        ArrayList actual = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)((Cell)expected.get(i)), (Cell)((Cell)actual.get(i))));
            }
        }
    }

    @Test
    public void testScanner_JoinedScanners() throws IOException {
        byte[] cf_essential = Bytes.toBytes((String)"essential");
        byte[] cf_joined = Bytes.toBytes((String)"joined");
        byte[] cf_alpha = Bytes.toBytes((String)"alpha");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{cf_essential, cf_joined, cf_alpha});
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] row3 = Bytes.toBytes((String)"row3");
        byte[] col_normal = Bytes.toBytes((String)"d");
        byte[] col_alpha = Bytes.toBytes((String)"a");
        byte[] filtered_val = Bytes.toBytes((int)3);
        Put put = new Put(row1);
        put.addColumn(cf_essential, col_normal, Bytes.toBytes((int)1));
        put.addColumn(cf_joined, col_alpha, Bytes.toBytes((int)1));
        this.region.put(put);
        put = new Put(row2);
        put.addColumn(cf_essential, col_alpha, Bytes.toBytes((int)2));
        put.addColumn(cf_joined, col_normal, Bytes.toBytes((int)2));
        put.addColumn(cf_alpha, col_alpha, Bytes.toBytes((int)2));
        this.region.put(put);
        put = new Put(row3);
        put.addColumn(cf_essential, col_normal, filtered_val);
        put.addColumn(cf_joined, col_normal, filtered_val);
        this.region.put(put);
        Scan scan = new Scan();
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(cf_essential, col_normal, CompareFilter.CompareOp.NOT_EQUAL, filtered_val);
        scan.setFilter((Filter)filter);
        scan.setLoadColumnFamiliesOnDemand(true);
        try (RegionScannerImpl s = this.region.getScanner(scan);){
            ArrayList results = new ArrayList();
            Assert.assertTrue((boolean)s.next(results));
            Assert.assertEquals((long)1L, (long)results.size());
            results.clear();
            Assert.assertTrue((boolean)s.next(results));
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((String)"orderCheck", (boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(0)), (byte[])cf_alpha));
            Assert.assertTrue((String)"orderCheck", (boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(1)), (byte[])cf_essential));
            Assert.assertTrue((String)"orderCheck", (boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(2)), (byte[])cf_joined));
            results.clear();
            Assert.assertFalse((boolean)s.next(results));
            Assert.assertEquals((long)0L, (long)results.size());
        }
    }

    @Test
    public void testScanner_JoinedScannersWithLimits() throws IOException {
        final byte[] cf_first = Bytes.toBytes((String)"first");
        byte[] cf_second = Bytes.toBytes((String)"second");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{cf_first, cf_second});
        byte[] col_a = Bytes.toBytes((String)"a");
        byte[] col_b = Bytes.toBytes((String)"b");
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((String)("r" + Integer.toString(i))));
            put.addColumn(cf_first, col_a, Bytes.toBytes((int)i));
            if (i < 5) {
                put.addColumn(cf_first, col_b, Bytes.toBytes((int)i));
                put.addColumn(cf_second, col_a, Bytes.toBytes((int)i));
                put.addColumn(cf_second, col_b, Bytes.toBytes((int)i));
            }
            this.region.put(put);
        }
        Scan scan = new Scan();
        scan.setLoadColumnFamiliesOnDemand(true);
        FilterBase bogusFilter = new FilterBase(){

            public Filter.ReturnCode filterCell(Cell ignored) throws IOException {
                return Filter.ReturnCode.INCLUDE;
            }

            public boolean isFamilyEssential(byte[] name) {
                return Bytes.equals((byte[])name, (byte[])cf_first);
            }
        };
        scan.setFilter((Filter)bogusFilter);
        try (RegionScannerImpl s = this.region.getScanner(scan);){
            boolean more;
            ArrayList results = new ArrayList();
            int index = 0;
            ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(3).build();
            do {
                more = s.next(results, scannerContext);
                if (index >> 1 < 5) {
                    if (index % 2 == 0) {
                        Assert.assertEquals((long)3L, (long)results.size());
                    } else {
                        Assert.assertEquals((long)1L, (long)results.size());
                    }
                } else {
                    Assert.assertEquals((long)1L, (long)results.size());
                }
                results.clear();
                ++index;
            } while (more);
        }
    }

    @Test
    public void testScannerOperationId() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{COLUMN_FAMILY_BYTES});
        Scan scan = new Scan();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            Assert.assertNull((Object)scanner.getOperationId());
        }
        String operationId = "test_operation_id_0101";
        scan = new Scan().setId(operationId);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            Assert.assertEquals((Object)operationId, (Object)scanner.getOperationId());
        }
        HBaseTestingUtility.closeRegionAndWAL(this.region);
    }

    @Test
    public void testLongQualifier() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        byte[] q = new byte[32769];
        Arrays.fill(q, 0, q.length - 1, (byte)42);
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            Put p = new Put(Bytes.toBytes((String)"row"));
            q[q.length - 1] = i;
            p.addColumn(family, q, q);
            this.region.put(p);
        }
        this.region.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushCacheWhileScanning() throws IOException, InterruptedException {
        byte[] family = Bytes.toBytes((String)"family");
        int numRows = 1000;
        int flushAndScanInterval = 10;
        int compactInterval = 10 * flushAndScanInterval;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        FlushThread flushThread = new FlushThread();
        try {
            flushThread.start();
            Scan scan = new Scan();
            scan.addFamily(family);
            scan.setFilter((Filter)new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)5L))));
            int expectedCount = 0;
            ArrayList res = new ArrayList();
            boolean toggle = true;
            for (long i = 0L; i < (long)numRows; ++i) {
                Put put = new Put(Bytes.toBytes((long)i));
                put.setDurability(Durability.SKIP_WAL);
                put.addColumn(family, this.qual1, Bytes.toBytes((long)(i % 10L)));
                this.region.put(put);
                if (i != 0L && i % (long)compactInterval == 0L) {
                    LOG.debug("iteration = " + i + " ts=" + EnvironmentEdgeManager.currentTime());
                    this.region.compact(true);
                }
                if (i % 10L == 5L) {
                    ++expectedCount;
                }
                if (i == 0L || i % (long)flushAndScanInterval != 0L) continue;
                res.clear();
                try (RegionScannerImpl scanner = this.region.getScanner(scan);){
                    if (toggle) {
                        flushThread.flush();
                    }
                    while (scanner.next(res)) {
                    }
                }
                if (!toggle) {
                    flushThread.flush();
                }
                Assert.assertEquals((String)("toggle=" + toggle + "i=" + i + " ts=" + EnvironmentEdgeManager.currentTime()), (long)expectedCount, (long)res.size());
                toggle = !toggle;
            }
        }
        finally {
            try {
                flushThread.done();
                flushThread.join();
                flushThread.checkNoError();
            }
            catch (InterruptedException ie) {
                LOG.warn("Caught exception when joining with flushThread", (Throwable)ie);
            }
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    protected int getNumQualifiersForTestWritesWhileScanning() {
        return 100;
    }

    protected int getTestCountForTestWritesWhileScanning() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritesWhileScanning() throws IOException, InterruptedException {
        int testCount = this.getTestCountForTestWritesWhileScanning();
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = this.getNumQualifiersForTestWritesWhileScanning();
        int flushInterval = 7;
        int compactInterval = 5 * flushInterval;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes((String)("family" + i));
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qual" + i));
        }
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        FlushThread flushThread = new FlushThread();
        PutThread putThread = new PutThread(numRows, families, qualifiers);
        try {
            putThread.start();
            putThread.waitForFirstPut();
            flushThread.start();
            Scan scan = new Scan(Bytes.toBytes((String)"row0"), Bytes.toBytes((String)"row1"));
            int expectedCount = numFamilies * numQualifiers;
            ArrayList res = new ArrayList();
            long prevTimestamp = 0L;
            for (int i = 0; i < testCount; ++i) {
                if (i != 0 && i % compactInterval == 0) {
                    this.region.compact(true);
                    for (HStore store : this.region.getStores()) {
                        store.closeAndArchiveCompactedFiles();
                    }
                }
                if (i != 0 && i % flushInterval == 0) {
                    flushThread.flush();
                }
                boolean previousEmpty = res.isEmpty();
                res.clear();
                RegionScannerImpl scanner = this.region.getScanner(scan);
                while (scanner.next(res)) {
                }
                if (res.isEmpty() && previousEmpty && i <= compactInterval) continue;
                Assert.assertEquals((String)("i=" + i), (long)expectedCount, (long)res.size());
                long timestamp = ((Cell)res.get(0)).getTimestamp();
                Assert.assertTrue((String)("Timestamps were broke: " + timestamp + " prev: " + prevTimestamp), (timestamp >= prevTimestamp ? 1 : 0) != 0);
                prevTimestamp = timestamp;
            }
            putThread.done();
            this.region.flush(true);
        }
        finally {
            try {
                flushThread.done();
                flushThread.join();
                flushThread.checkNoError();
                putThread.join();
                putThread.checkNoError();
            }
            catch (InterruptedException ie) {
                LOG.warn("Caught exception when joining with flushThread", (Throwable)ie);
            }
            try {
                HBaseTestingUtility.closeRegionAndWAL(this.region);
            }
            catch (DroppedSnapshotException droppedSnapshotException) {}
            this.region = null;
        }
    }

    @Test
    public void testCloseAndArchiveCompactedFiles() throws IOException {
        byte[] CF1 = Bytes.toBytes((String)"CF1");
        byte[] CF2 = Bytes.toBytes((String)"CF2");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{CF1, CF2});
        int i = 0;
        while (i < 2) {
            int index = i++;
            Put put = new Put(Bytes.toBytes((int)index)).addColumn(CF1, Bytes.toBytes((String)"q"), Bytes.toBytes((int)index));
            this.region.put(put);
            this.region.flush(true);
        }
        this.region.compact(true);
        HStore store1 = this.region.getStore(CF1);
        HStore store2 = this.region.getStore(CF2);
        store1.closeAndArchiveCompactedFiles();
        store2.closeAndArchiveCompactedFiles();
        int storefilesCount = this.region.getStores().stream().mapToInt(Store::getStorefilesCount).sum();
        Assert.assertTrue((storefilesCount == 1 ? 1 : 0) != 0);
        FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
        Configuration conf = this.region.getReadOnlyConfiguration();
        RegionInfo regionInfo = this.region.getRegionInfo();
        Path store1ArchiveDir = HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (RegionInfo)regionInfo, (byte[])CF1);
        Assert.assertTrue((boolean)fs.exists(store1ArchiveDir));
        Path store2ArchiveDir = HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (RegionInfo)regionInfo, (byte[])CF2);
        Assert.assertFalse((boolean)fs.exists(store2ArchiveDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritesWhileGetting() throws Exception {
        int testCount = 50;
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = 100;
        int compactInterval = 100;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes((String)("family" + i));
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qual" + i));
        }
        Configuration conf = HBaseConfiguration.create((Configuration)CONF);
        conf.setInt("hbase.hstore.compaction.min", 1);
        conf.setInt("hbase.hstore.compaction.max", 1000);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        PutThread putThread = null;
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
        try {
            putThread = new PutThread(numRows, families, qualifiers);
            putThread.start();
            putThread.waitForFirstPut();
            ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){

                @Override
                public void doAnAction() throws Exception {
                    TestHRegion.this.region.flush(true);
                    TestHRegion.this.region.compact(false);
                    for (HStore store : TestHRegion.this.region.getStores()) {
                        store.closeAndArchiveCompactedFiles();
                    }
                }
            });
            ctx.startThreads();
            Get get = new Get(Bytes.toBytes((String)"row0"));
            Result result = null;
            int expectedCount = numFamilies * numQualifiers;
            long prevTimestamp = 0L;
            for (int i = 0; i < testCount; ++i) {
                LOG.info("testWritesWhileGetting verify turn " + i);
                boolean previousEmpty = result == null || result.isEmpty();
                result = this.region.get(get);
                if (result.isEmpty() && previousEmpty && i <= compactInterval) continue;
                Assert.assertEquals((String)("i=" + i), (long)expectedCount, (long)result.size());
                long timestamp = 0L;
                for (Cell kv : result.rawCells()) {
                    if (!CellUtil.matchingFamily((Cell)kv, (byte[])families[0]) || !CellUtil.matchingQualifier((Cell)kv, (byte[])qualifiers[0])) continue;
                    timestamp = kv.getTimestamp();
                }
                Assert.assertTrue((timestamp >= prevTimestamp ? 1 : 0) != 0);
                prevTimestamp = timestamp;
                Cell previousKV = null;
                for (Cell kv : result.rawCells()) {
                    byte[] thisValue = CellUtil.cloneValue((Cell)kv);
                    if (previousKV != null && Bytes.compareTo((byte[])CellUtil.cloneValue(previousKV), (byte[])thisValue) != 0) {
                        LOG.warn("These two KV should have the same value. Previous KV:" + previousKV + "(memStoreTS:" + previousKV.getSequenceId() + "), New KV: " + kv + "(memStoreTS:" + kv.getSequenceId() + ")");
                        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneValue((Cell)previousKV), (byte[])thisValue));
                    }
                    previousKV = kv;
                }
            }
        }
        finally {
            if (putThread != null) {
                putThread.done();
            }
            this.region.flush(true);
            if (putThread != null) {
                putThread.join();
                putThread.checkNoError();
            }
            ctx.stop();
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    @Test
    public void testHolesInMeta() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, Bytes.toBytes((String)"x"), Bytes.toBytes((String)"z"), this.method, CONF, false, (byte[][])new byte[][]{family});
        byte[] rowNotServed = Bytes.toBytes((String)"a");
        Get g = new Get(rowNotServed);
        try {
            this.region.get(g);
            Assert.fail();
        }
        catch (WrongRegionException wrongRegionException) {
            // empty catch block
        }
        byte[] row = Bytes.toBytes((String)"y");
        g = new Get(row);
        this.region.get(g);
    }

    @Test
    public void testIndexesScanWithOneDeletedRow() throws IOException {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((long)1L));
        put.addColumn(family, this.qual1, 1L, Bytes.toBytes((long)1L));
        this.region.put(put);
        this.region.flush(true);
        Delete delete = new Delete(Bytes.toBytes((long)1L), 1L);
        this.region.delete(delete);
        put = new Put(Bytes.toBytes((long)2L));
        put.addColumn(family, this.qual1, 2L, Bytes.toBytes((long)2L));
        this.region.put(put);
        Scan idxScan = new Scan();
        idxScan.addFamily(family);
        idxScan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)0L))), new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)3L))))));
        try (RegionScannerImpl scanner = this.region.getScanner(idxScan);){
            ArrayList res = new ArrayList();
            while (scanner.next(res)) {
            }
            Assert.assertEquals((long)1L, (long)res.size());
        }
    }

    @Test
    public void testBloomFilterSize() throws IOException {
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"col");
        byte[] val1 = Bytes.toBytes((String)"value1");
        HColumnDescriptor hcd = new HColumnDescriptor(fam1).setMaxVersions(Integer.MAX_VALUE).setBloomFilterType(BloomType.ROWCOL);
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = TEST_UTIL.createLocalHRegion((RegionInfo)info, (TableDescriptor)htd);
        int num_unique_rows = 10;
        int duplicate_multiplier = 2;
        int num_storefiles = 4;
        int version = 0;
        for (int f = 0; f < num_storefiles; ++f) {
            for (int i = 0; i < duplicate_multiplier; ++i) {
                for (int j = 0; j < num_unique_rows; ++j) {
                    Put put = new Put(Bytes.toBytes((String)("row" + j)));
                    put.setDurability(Durability.SKIP_WAL);
                    long ts = version++;
                    put.addColumn(fam1, qf1, ts, val1);
                    this.region.put(put);
                }
            }
            this.region.flush(true);
        }
        HStore store = this.region.getStore(fam1);
        Collection storeFiles = store.getStorefiles();
        for (HStoreFile storefile : storeFiles) {
            StoreFileReader reader = storefile.getReader();
            reader.loadFileInfo();
            reader.loadBloomfilter();
            Assert.assertEquals((long)(num_unique_rows * duplicate_multiplier), (long)reader.getEntries());
            Assert.assertEquals((long)num_unique_rows, (long)reader.getFilterEntries());
        }
        this.region.compact(true);
        storeFiles = store.getStorefiles();
        for (HStoreFile storefile : storeFiles) {
            StoreFileReader reader = storefile.getReader();
            reader.loadFileInfo();
            reader.loadBloomfilter();
            Assert.assertEquals((long)(num_unique_rows * duplicate_multiplier * num_storefiles), (long)reader.getEntries());
            Assert.assertEquals((long)num_unique_rows, (long)reader.getFilterEntries());
        }
    }

    @Test
    public void testAllColumnsWithBloomFilter() throws IOException {
        byte[] TABLE = Bytes.toBytes((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"family");
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY).setMaxVersions(Integer.MAX_VALUE).setBloomFilterType(BloomType.ROWCOL);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])TABLE));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = TEST_UTIL.createLocalHRegion((RegionInfo)info, (TableDescriptor)htd);
        byte[] row = Bytes.toBytes((String)"row:0");
        byte[] column = Bytes.toBytes((String)"column:0");
        Put put = new Put(row);
        put.setDurability(Durability.SKIP_WAL);
        for (long idx = 1L; idx <= 4L; ++idx) {
            put.addColumn(FAMILY, column, idx, Bytes.toBytes((String)("value-version-" + idx)));
        }
        this.region.put(put);
        this.region.flush(true);
        Get get = new Get(row);
        get.setMaxVersions();
        Cell[] kvs = this.region.get(get).rawCells();
        Assert.assertEquals((long)4L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 0, 0, 4L);
        this.checkOneCell(kvs[1], FAMILY, 0, 0, 3L);
        this.checkOneCell(kvs[2], FAMILY, 0, 0, 2L);
        this.checkOneCell(kvs[3], FAMILY, 0, 0, 1L);
    }

    @Test
    public void testDeleteRowWithBloomFilter() throws IOException {
        byte[] familyName = Bytes.toBytes((String)"familyName");
        HColumnDescriptor hcd = new HColumnDescriptor(familyName).setMaxVersions(Integer.MAX_VALUE).setBloomFilterType(BloomType.ROWCOL);
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = TEST_UTIL.createLocalHRegion((RegionInfo)info, (TableDescriptor)htd);
        byte[] row = Bytes.toBytes((String)"row1");
        byte[] col = Bytes.toBytes((String)"col1");
        Put put = new Put(row);
        put.addColumn(familyName, col, 1L, Bytes.toBytes((String)"SomeRandomValue"));
        this.region.put(put);
        this.region.flush(true);
        Delete del = new Delete(row);
        this.region.delete(del);
        this.region.flush(true);
        Get get = new Get(row);
        get.addColumn(familyName, col);
        Cell[] keyValues = this.region.get(get).rawCells();
        Assert.assertEquals((long)0L, (long)keyValues.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testgetHDFSBlocksDistribution() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        htu.getConfiguration().setInt("dfs.replication", 2);
        MiniHBaseCluster cluster = null;
        String[] dataNodeHosts = new String[]{"host1", "host2", "host3"};
        int regionServersCount = 3;
        try {
            StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(regionServersCount).dataNodeHosts(dataNodeHosts).build();
            cluster = htu.startMiniCluster(option);
            byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2};
            Table ht = htu.createTable(this.tableName, (byte[][])families);
            byte[] row = Bytes.toBytes((String)"row1");
            byte[] col = Bytes.toBytes((String)"col1");
            Put put = new Put(row);
            put.addColumn(HBaseTestingUtility.fam1, col, 1L, Bytes.toBytes((String)"test1"));
            put.addColumn(HBaseTestingUtility.fam2, col, 1L, Bytes.toBytes((String)"test2"));
            ht.put(put);
            HRegion firstRegion = htu.getHBaseCluster().getRegions(this.tableName).get(0);
            firstRegion.flush(true);
            HDFSBlocksDistribution blocksDistribution1 = firstRegion.getHDFSBlocksDistribution();
            long uniqueBlocksWeight1 = blocksDistribution1.getUniqueBlocksTotalWeight();
            StringBuilder sb = new StringBuilder();
            for (String host : blocksDistribution1.getTopHosts()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(host);
                sb.append("=");
                sb.append(blocksDistribution1.getWeight(host));
            }
            String topHost = (String)blocksDistribution1.getTopHosts().get(0);
            long topHostWeight = blocksDistribution1.getWeight(topHost);
            String msg = "uniqueBlocksWeight=" + uniqueBlocksWeight1 + ", topHostWeight=" + topHostWeight + ", topHost=" + topHost + "; " + sb.toString();
            LOG.info(msg);
            Assert.assertTrue((String)msg, (uniqueBlocksWeight1 == topHostWeight ? 1 : 0) != 0);
            HDFSBlocksDistribution blocksDistribution2 = HRegion.computeHDFSBlocksDistribution((Configuration)htu.getConfiguration(), (TableDescriptor)firstRegion.getTableDescriptor(), (RegionInfo)firstRegion.getRegionInfo());
            long uniqueBlocksWeight2 = blocksDistribution2.getUniqueBlocksTotalWeight();
            Assert.assertTrue((uniqueBlocksWeight1 == uniqueBlocksWeight2 ? 1 : 0) != 0);
            ht.close();
        }
        finally {
            if (cluster != null) {
                htu.shutdownMiniCluster();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testStatusSettingToAbortIfAnyExceptionDuringRegionInitilization() throws Exception {
        try {
            FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
            Mockito.when((Object)fs.exists((Path)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IOException()});
            HTableDescriptor htd = new HTableDescriptor(this.tableName);
            htd.addFamily(new HColumnDescriptor("cf"));
            HRegionInfo info = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, false);
            Path path = new Path(this.dir + "testStatusSettingToAbortIfAnyExceptionDuringRegionInitilization");
            this.region = HRegion.newHRegion((Path)path, null, (FileSystem)fs, (Configuration)CONF, (RegionInfo)info, (TableDescriptor)htd, null);
            this.region.initialize();
            Assert.fail((String)"Region initialization should fail due to IOException");
            return;
        }
        catch (IOException io) {
            MonitoredTask monitoredTask;
            List tasks = TaskMonitor.get().getTasks();
            Iterator iterator = tasks.iterator();
            do {
                if (!iterator.hasNext()) return;
            } while ((monitoredTask = (MonitoredTask)iterator.next()) instanceof MonitoredRPCHandler || !monitoredTask.getDescription().contains(this.region.toString()));
            Assert.assertTrue((String)"Region state should be ABORTED.", (boolean)monitoredTask.getState().equals((Object)MonitoredTask.State.ABORTED));
            return;
        }
    }

    @Test
    public void testRegionInfoFileCreation() throws IOException {
        Path rootDir = new Path(this.dir + "testRegionInfoFileCreation");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        htd.addFamily(new HColumnDescriptor("cf"));
        HRegionInfo hri = new HRegionInfo(htd.getTableName());
        this.region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, rootDir, CONF, (TableDescriptor)htd, false);
        Path regionDir = this.region.getRegionFileSystem().getRegionDir();
        FileSystem fs = this.region.getRegionFileSystem().getFileSystem();
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        Path regionInfoFile = new Path(regionDir, ".regioninfo");
        Assert.assertTrue((String)".regioninfo should be present in the region dir", (boolean)fs.exists(regionInfoFile));
        this.region = HRegion.openHRegion((Path)rootDir, (RegionInfo)hri, (TableDescriptor)htd, null, (Configuration)CONF);
        Assert.assertEquals((Object)regionDir, (Object)this.region.getRegionFileSystem().getRegionDir());
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        Assert.assertTrue((String)".regioninfo should be present in the region dir", (boolean)fs.exists(regionInfoFile));
        fs.delete(regionInfoFile, true);
        Assert.assertFalse((String)".regioninfo should be removed from the region dir", (boolean)fs.exists(regionInfoFile));
        this.region = HRegion.openHRegion((Path)rootDir, (RegionInfo)hri, (TableDescriptor)htd, null, (Configuration)CONF);
        Assert.assertEquals((Object)regionDir, (Object)this.region.getRegionFileSystem().getRegionDir());
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        Assert.assertTrue((String)".regioninfo should be present in the region dir", (boolean)fs.exists(new Path(regionDir, ".regioninfo")));
        this.region = null;
    }

    @Test
    public void testParallelIncrementWithMemStoreFlush() throws Exception {
        int i;
        byte[] family = Incrementer.family;
        final HRegion region = this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        final AtomicBoolean incrementDone = new AtomicBoolean(false);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                while (!incrementDone.get()) {
                    try {
                        region.flush(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        int threadNum = 20;
        int incCounter = 100;
        long expected = (long)threadNum * (long)incCounter;
        Thread[] incrementers = new Thread[threadNum];
        Thread flushThread = new Thread(flusher);
        for (i = 0; i < threadNum; ++i) {
            incrementers[i] = new Thread(new Incrementer(this.region, incCounter));
            incrementers[i].start();
        }
        flushThread.start();
        for (i = 0; i < threadNum; ++i) {
            incrementers[i].join();
        }
        incrementDone.set(true);
        flushThread.join();
        Get get = new Get(Incrementer.incRow);
        get.addColumn(Incrementer.family, Incrementer.qualifier);
        get.setMaxVersions(1);
        Result res = this.region.get(get);
        List kvs = res.getColumnCells(Incrementer.family, Incrementer.qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Cell kv = (Cell)kvs.get(0);
        Assert.assertEquals((long)expected, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset()));
    }

    @Test
    public void testParallelAppendWithMemStoreFlush() throws Exception {
        int i;
        byte[] family = Appender.family;
        final HRegion region = this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        final AtomicBoolean appendDone = new AtomicBoolean(false);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                while (!appendDone.get()) {
                    try {
                        region.flush(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        int threadNum = 20;
        int appendCounter = 100;
        byte[] expected = new byte[threadNum * appendCounter];
        for (int i2 = 0; i2 < threadNum * appendCounter; ++i2) {
            System.arraycopy(Appender.CHAR, 0, expected, i2, 1);
        }
        Thread[] appenders = new Thread[threadNum];
        Thread flushThread = new Thread(flusher);
        for (i = 0; i < threadNum; ++i) {
            appenders[i] = new Thread(new Appender(this.region, appendCounter));
            appenders[i].start();
        }
        flushThread.start();
        for (i = 0; i < threadNum; ++i) {
            appenders[i].join();
        }
        appendDone.set(true);
        flushThread.join();
        Get get = new Get(Appender.appendRow);
        get.addColumn(Appender.family, Appender.qualifier);
        get.setMaxVersions(1);
        Result res = this.region.get(get);
        List kvs = res.getColumnCells(Appender.family, Appender.qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Cell kv = (Cell)kvs.get(0);
        byte[] appendResult = new byte[kv.getValueLength()];
        System.arraycopy(kv.getValueArray(), kv.getValueOffset(), appendResult, 0, kv.getValueLength());
        Assert.assertArrayEquals((byte[])expected, (byte[])appendResult);
    }

    @Test
    public void testPutWithMemStoreFlush() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] row = Bytes.toBytes((String)"putRow");
        byte[] value = null;
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        Put put = null;
        Get get = null;
        List kvs = null;
        Result res = null;
        put = new Put(row);
        value = Bytes.toBytes((String)"value0");
        put.addColumn(family, qualifier, 1234567L, value);
        this.region.put(put);
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value0"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
        this.region.flush(true);
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value0"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
        put = new Put(row);
        value = Bytes.toBytes((String)"value1");
        put.addColumn(family, qualifier, 1234567L, value);
        this.region.put(put);
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value1"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
        this.region.flush(true);
        get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions();
        res = this.region.get(get);
        kvs = res.getColumnCells(family, qualifier);
        Assert.assertEquals((long)1L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"value1"), (byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))));
    }

    @Test
    public void testDurability() throws Exception {
        this.durabilityTest(this.method, Durability.SYNC_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.SYNC_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.SYNC_WAL, Durability.USE_DEFAULT, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.FSYNC_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.FSYNC_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.FSYNC_WAL, Durability.USE_DEFAULT, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.ASYNC_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.ASYNC_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.SKIP_WAL, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.SKIP_WAL, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.USE_DEFAULT, Durability.SYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.USE_DEFAULT, Durability.FSYNC_WAL, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.USE_DEFAULT, Durability.USE_DEFAULT, 0L, true, true, false);
        this.durabilityTest(this.method, Durability.SYNC_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(this.method, Durability.FSYNC_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(this.method, Durability.ASYNC_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(this.method, Durability.SKIP_WAL, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(this.method, Durability.USE_DEFAULT, Durability.ASYNC_WAL, 0L, true, false, false);
        this.durabilityTest(this.method, Durability.ASYNC_WAL, Durability.USE_DEFAULT, 0L, true, false, false);
        this.durabilityTest(this.method, Durability.SYNC_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(this.method, Durability.FSYNC_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(this.method, Durability.ASYNC_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(this.method, Durability.SKIP_WAL, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(this.method, Durability.USE_DEFAULT, Durability.ASYNC_WAL, 5000L, true, false, true);
        this.durabilityTest(this.method, Durability.ASYNC_WAL, Durability.USE_DEFAULT, 5000L, true, false, true);
        this.durabilityTest(this.method, Durability.SYNC_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(this.method, Durability.FSYNC_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(this.method, Durability.ASYNC_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(this.method, Durability.SKIP_WAL, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(this.method, Durability.USE_DEFAULT, Durability.SKIP_WAL, 0L, false, false, false);
        this.durabilityTest(this.method, Durability.SKIP_WAL, Durability.USE_DEFAULT, 0L, false, false, false);
    }

    private void durabilityTest(String method, Durability tableDurability, Durability mutationDurability, long timeout, boolean expectAppend, final boolean expectSync, final boolean expectSyncFromLogSyncer) throws Exception {
        Configuration conf = HBaseConfiguration.create((Configuration)CONF);
        method = method + "_" + tableDurability.name() + "_" + mutationDurability.name();
        byte[] family = Bytes.toBytes((String)"family");
        Path logDir = new Path(new Path(this.dir + method), "log");
        Configuration walConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)logDir);
        walConf.set("hbase.wal.provider", "filesystem");
        WALFactory wals = new WALFactory(walConf, TEST_UTIL.getRandomUUID().toString());
        final WAL wal = (WAL)Mockito.spy((Object)wals.getWAL(RegionInfoBuilder.newBuilder((TableName)this.tableName).build()));
        this.region = this.initHRegion(this.tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, CONF, false, tableDurability, wal, (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(family, Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"v1"));
        put.setDurability(mutationDurability);
        this.region.put(put);
        ((WAL)Mockito.verify((Object)wal, (VerificationMode)(expectAppend ? Mockito.times((int)1) : Mockito.never()))).appendData((RegionInfo)((HRegionInfo)ArgumentMatchers.any()), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)ArgumentMatchers.any());
        if (expectSync || expectSyncFromLogSyncer) {
            TEST_UTIL.waitFor(timeout, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    try {
                        if (expectSync) {
                            ((WAL)Mockito.verify((Object)wal, (VerificationMode)Mockito.times((int)1))).sync(ArgumentMatchers.anyLong());
                        } else if (expectSyncFromLogSyncer) {
                            ((WAL)Mockito.verify((Object)wal, (VerificationMode)Mockito.times((int)1))).sync();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return true;
                }
            });
        } else {
            ((WAL)Mockito.verify((Object)wal, (VerificationMode)Mockito.never())).sync();
        }
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        wals.close();
        this.region = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicaSecondary() throws IOException {
        HRegion secondaryRegion;
        block6: {
            Path rootDir = new Path(this.dir + this.name.getMethodName());
            CommonFSUtils.setRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)rootDir);
            byte[][] families = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"cf3")};
            byte[] cq = Bytes.toBytes((String)"cq");
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
            for (byte[] family : families) {
                htd.addFamily(new HColumnDescriptor(family));
            }
            long time = EnvironmentEdgeManager.currentTime();
            HRegionInfo primaryHri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, time, 0);
            HRegionInfo secondaryHri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, time, 1);
            HRegion primaryRegion = null;
            secondaryRegion = null;
            try {
                primaryRegion = HBaseTestingUtility.createRegionAndWAL((RegionInfo)primaryHri, rootDir, TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
                this.putData(primaryRegion, 0, 1000, cq, (byte[][])families);
                primaryRegion.flush(true);
                secondaryRegion = HRegion.openHRegion((Path)rootDir, (RegionInfo)secondaryHri, (TableDescriptor)htd, null, (Configuration)CONF);
                TestHRegion.verifyData(secondaryRegion, 0, 1000, cq, families);
                if (primaryRegion == null) break block6;
            }
            catch (Throwable throwable) {
                if (primaryRegion != null) {
                    HBaseTestingUtility.closeRegionAndWAL(primaryRegion);
                }
                if (secondaryRegion != null) {
                    HBaseTestingUtility.closeRegionAndWAL(secondaryRegion);
                }
                throw throwable;
            }
            HBaseTestingUtility.closeRegionAndWAL(primaryRegion);
        }
        if (secondaryRegion != null) {
            HBaseTestingUtility.closeRegionAndWAL(secondaryRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicaSecondaryIsReadOnly() throws IOException {
        HRegion secondaryRegion;
        block8: {
            Path rootDir = new Path(this.dir + this.name.getMethodName());
            CommonFSUtils.setRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)rootDir);
            byte[][] families = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"cf3")};
            byte[] cq = Bytes.toBytes((String)"cq");
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
            for (byte[] family : families) {
                htd.addFamily(new HColumnDescriptor(family));
            }
            long time = EnvironmentEdgeManager.currentTime();
            HRegionInfo primaryHri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, time, 0);
            HRegionInfo secondaryHri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, time, 1);
            HRegion primaryRegion = null;
            secondaryRegion = null;
            try {
                primaryRegion = HBaseTestingUtility.createRegionAndWAL((RegionInfo)primaryHri, rootDir, TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
                this.putData(primaryRegion, 0, 1000, cq, (byte[][])families);
                primaryRegion.flush(true);
                secondaryRegion = HRegion.openHRegion((Path)rootDir, (RegionInfo)secondaryHri, (TableDescriptor)htd, null, (Configuration)CONF);
                try {
                    this.putData(secondaryRegion, 0, 1000, cq, (byte[][])families);
                    Assert.fail((String)"Should have thrown exception");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (primaryRegion == null) break block8;
            }
            catch (Throwable throwable) {
                if (primaryRegion != null) {
                    HBaseTestingUtility.closeRegionAndWAL(primaryRegion);
                }
                if (secondaryRegion != null) {
                    HBaseTestingUtility.closeRegionAndWAL(secondaryRegion);
                }
                throw throwable;
            }
            HBaseTestingUtility.closeRegionAndWAL(primaryRegion);
        }
        if (secondaryRegion != null) {
            HBaseTestingUtility.closeRegionAndWAL(secondaryRegion);
        }
    }

    static WALFactory createWALFactory(Configuration conf, Path rootDir) throws IOException {
        Configuration confForWAL = new Configuration(conf);
        confForWAL.set("hbase.rootdir", rootDir.toString());
        return new WALFactory(confForWAL, "hregion-" + RandomStringUtils.randomNumeric((int)8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactionFromPrimary() throws IOException {
        HRegion secondaryRegion;
        block6: {
            Path rootDir = new Path(this.dir + this.name.getMethodName());
            CommonFSUtils.setRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)rootDir);
            byte[][] families = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"cf3")};
            byte[] cq = Bytes.toBytes((String)"cq");
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
            for (byte[] family : families) {
                htd.addFamily(new HColumnDescriptor(family));
            }
            long time = EnvironmentEdgeManager.currentTime();
            HRegionInfo primaryHri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, time, 0);
            HRegionInfo secondaryHri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, time, 1);
            HRegion primaryRegion = null;
            secondaryRegion = null;
            try {
                primaryRegion = HBaseTestingUtility.createRegionAndWAL((RegionInfo)primaryHri, rootDir, TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
                this.putData(primaryRegion, 0, 1000, cq, (byte[][])families);
                primaryRegion.flush(true);
                secondaryRegion = HRegion.openHRegion((Path)rootDir, (RegionInfo)secondaryHri, (TableDescriptor)htd, null, (Configuration)CONF);
                Collection storeFiles = primaryRegion.getStore(families[0]).getStorefiles();
                primaryRegion.getRegionFileSystem().removeStoreFiles(Bytes.toString((byte[])families[0]), storeFiles);
                List storeFileInfos = primaryRegion.getRegionFileSystem().getStoreFiles(Bytes.toString((byte[])families[0]));
                Assert.assertTrue((storeFileInfos == null || storeFileInfos.isEmpty() ? 1 : 0) != 0);
                TestHRegion.verifyData(secondaryRegion, 0, 1000, cq, families);
                if (primaryRegion == null) break block6;
            }
            catch (Throwable throwable) {
                if (primaryRegion != null) {
                    HBaseTestingUtility.closeRegionAndWAL(primaryRegion);
                }
                if (secondaryRegion != null) {
                    HBaseTestingUtility.closeRegionAndWAL(secondaryRegion);
                }
                throw throwable;
            }
            HBaseTestingUtility.closeRegionAndWAL(primaryRegion);
        }
        if (secondaryRegion != null) {
            HBaseTestingUtility.closeRegionAndWAL(secondaryRegion);
        }
    }

    private void putData(int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        this.putData(this.region, startRow, numRows, qf, families);
    }

    private void putData(HRegion region, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        TestHRegion.putData(region, Durability.SKIP_WAL, startRow, numRows, qf, families);
    }

    static void putData(HRegion region, Durability durability, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            Put put = new Put(Bytes.toBytes((String)("" + i)));
            put.setDurability(durability);
            for (byte[] family : families) {
                put.addColumn(family, qf, null);
            }
            region.put(put);
            LOG.info(put.toString());
        }
    }

    static void verifyData(HRegion newReg, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            byte[] row = Bytes.toBytes((String)("" + i));
            Get get = new Get(row);
            for (byte[] family : families) {
                get.addColumn(family, qf);
            }
            Result result = newReg.get(get);
            Cell[] raw = result.rawCells();
            Assert.assertEquals((long)families.length, (long)result.size());
            for (int j = 0; j < families.length; ++j) {
                Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)raw[j], (byte[])row));
                Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)raw[j], (byte[])families[j]));
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)raw[j], (byte[])qf));
            }
        }
    }

    static void assertGet(HRegion r, byte[] family, byte[] k) throws IOException {
        Get get = new Get(k).addFamily(family).setMaxVersions();
        Cell[] results = r.get(get).rawCells();
        for (int j = 0; j < results.length; ++j) {
            byte[] tmp = CellUtil.cloneValue((Cell)results[j]);
            Assert.assertTrue((boolean)Bytes.equals((byte[])k, (byte[])tmp));
        }
    }

    protected void assertScan(HRegion r, byte[] fs, byte[] firstValue) throws IOException {
        block16: {
            byte[][] families = new byte[][]{fs};
            Scan scan = new Scan();
            for (int i = 0; i < families.length; ++i) {
                scan.addFamily(families[i]);
            }
            try (RegionScannerImpl s = r.getScanner(scan);){
                ArrayList curVals = new ArrayList();
                boolean first = true;
                while (s.next(curVals)) {
                    for (Cell kv : curVals) {
                        byte[] val;
                        byte[] curval = val = CellUtil.cloneValue((Cell)kv);
                        if (first) {
                            first = false;
                            Assert.assertTrue((Bytes.compareTo((byte[])curval, (byte[])firstValue) == 0 ? 1 : 0) != 0);
                            continue;
                        }
                        break block16;
                    }
                }
            }
        }
    }

    @Test
    public void testFlushResult() throws IOException {
        Put put;
        int i;
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, new byte[][]{family});
        HRegion.FlushResult fr = this.region.flush(true);
        Assert.assertFalse((boolean)fr.isFlushSucceeded());
        Assert.assertFalse((boolean)fr.isCompactionNeeded());
        for (i = 0; i < 2; ++i) {
            put = new Put(this.tableName.toBytes()).addColumn(family, family, this.tableName.toBytes());
            this.region.put(put);
            fr = this.region.flush(true);
            Assert.assertTrue((boolean)fr.isFlushSucceeded());
            Assert.assertFalse((boolean)fr.isCompactionNeeded());
        }
        for (i = 0; i < 2; ++i) {
            put = new Put(this.tableName.toBytes()).addColumn(family, family, this.tableName.toBytes());
            this.region.put(put);
            fr = this.region.flush(true);
            Assert.assertTrue((boolean)fr.isFlushSucceeded());
            Assert.assertTrue((boolean)fr.isCompactionNeeded());
        }
    }

    protected Configuration initSplit() {
        CONF.setInt("hbase.hstore.compactionThreshold", 2);
        CONF.setInt("hbase.client.scanner.timeout.period", 10000);
        CONF.setLong("hbase.client.pause", 15000L);
        CONF.setLong("hbase.hregion.max.filesize", 131072L);
        return CONF;
    }

    protected HRegion initHRegion(TableName tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        return this.initHRegion(tableName, callingMethod, conf, false, families);
    }

    private HRegion initHRegion(TableName tableName, String callingMethod, Configuration conf, boolean isReadOnly, byte[] ... families) throws IOException {
        return this.initHRegion(tableName, null, null, callingMethod, conf, isReadOnly, families);
    }

    private HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, boolean isReadOnly, byte[] ... families) throws IOException {
        Path logDir = TEST_UTIL.getDataTestDirOnTestFS(callingMethod + ".log");
        HRegionInfo hri = new HRegionInfo(tableName, startKey, stopKey);
        WAL wal = HBaseTestingUtility.createWal(conf, logDir, (RegionInfo)hri);
        return this.initHRegion(tableName, startKey, stopKey, conf, isReadOnly, Durability.SYNC_WAL, wal, families);
    }

    protected HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, Configuration conf, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return TEST_UTIL.createLocalHRegion(tableName, startKey, stopKey, conf, isReadOnly, durability, wal, families);
    }

    private void checkOneCell(Cell kv, byte[] cf, int rowIdx, int colIdx, long ts) {
        String ctx = "rowIdx=" + rowIdx + "; colIdx=" + colIdx + "; ts=" + ts;
        Assert.assertEquals((String)("Row mismatch which checking: " + ctx), (Object)("row:" + rowIdx), (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv)));
        Assert.assertEquals((String)("ColumnFamily mismatch while checking: " + ctx), (Object)Bytes.toString((byte[])cf), (Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)));
        Assert.assertEquals((String)("Column qualifier mismatch while checking: " + ctx), (Object)("column:" + colIdx), (Object)Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertEquals((String)("Timestamp mismatch while checking: " + ctx), (long)ts, (long)kv.getTimestamp());
        Assert.assertEquals((String)("Value mismatch while checking: " + ctx), (Object)("value-version-" + ts), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
    }

    @Test
    public void testReverseScanner_FromMemStore_SingleCF_Normal() throws IOException {
        byte[] rowC = Bytes.toBytes((String)"rowC");
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] cf = Bytes.toBytes((String)"CF");
        byte[][] families = new byte[][]{cf};
        byte[] col = Bytes.toBytes((String)"C");
        long ts = 1L;
        this.region = this.initHRegion(this.tableName, this.method, families);
        KeyValue kv1 = new KeyValue(rowC, cf, col, ts, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(rowC, cf, col, ts + 1L, KeyValue.Type.Put, null);
        KeyValue kv2 = new KeyValue(rowA, cf, col, ts, KeyValue.Type.Put, null);
        KeyValue kv3 = new KeyValue(rowB, cf, col, ts, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(rowC);
        put.add((Cell)kv1);
        put.add((Cell)kv11);
        this.region.put(put);
        put = new Put(rowA);
        put.add((Cell)kv2);
        this.region.put(put);
        put = new Put(rowB);
        put.add((Cell)kv3);
        this.region.put(put);
        Scan scan = new Scan(rowC);
        scan.setMaxVersions(5);
        scan.setReversed(true);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            ArrayList currRow = new ArrayList();
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowC, (int)0, (int)rowC.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowB, (int)0, (int)rowB.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowA, (int)0, (int)rowA.length));
            Assert.assertFalse((boolean)hasNext);
        }
    }

    @Test
    public void testReverseScanner_FromMemStore_SingleCF_LargerKey() throws IOException {
        byte[] rowC = Bytes.toBytes((String)"rowC");
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] rowD = Bytes.toBytes((String)"rowD");
        byte[] cf = Bytes.toBytes((String)"CF");
        byte[][] families = new byte[][]{cf};
        byte[] col = Bytes.toBytes((String)"C");
        long ts = 1L;
        this.region = this.initHRegion(this.tableName, this.method, families);
        KeyValue kv1 = new KeyValue(rowC, cf, col, ts, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(rowC, cf, col, ts + 1L, KeyValue.Type.Put, null);
        KeyValue kv2 = new KeyValue(rowA, cf, col, ts, KeyValue.Type.Put, null);
        KeyValue kv3 = new KeyValue(rowB, cf, col, ts, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(rowC);
        put.add((Cell)kv1);
        put.add((Cell)kv11);
        this.region.put(put);
        put = new Put(rowA);
        put.add((Cell)kv2);
        this.region.put(put);
        put = new Put(rowB);
        put.add((Cell)kv3);
        this.region.put(put);
        Scan scan = new Scan(rowD);
        ArrayList currRow = new ArrayList();
        scan.setReversed(true);
        scan.setMaxVersions(5);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowC, (int)0, (int)rowC.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowB, (int)0, (int)rowB.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowA, (int)0, (int)rowA.length));
            Assert.assertFalse((boolean)hasNext);
        }
    }

    @Test
    public void testReverseScanner_FromMemStore_SingleCF_FullScan() throws IOException {
        byte[] rowC = Bytes.toBytes((String)"rowC");
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] cf = Bytes.toBytes((String)"CF");
        byte[][] families = new byte[][]{cf};
        byte[] col = Bytes.toBytes((String)"C");
        long ts = 1L;
        this.region = this.initHRegion(this.tableName, this.method, families);
        KeyValue kv1 = new KeyValue(rowC, cf, col, ts, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(rowC, cf, col, ts + 1L, KeyValue.Type.Put, null);
        KeyValue kv2 = new KeyValue(rowA, cf, col, ts, KeyValue.Type.Put, null);
        KeyValue kv3 = new KeyValue(rowB, cf, col, ts, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(rowC);
        put.add((Cell)kv1);
        put.add((Cell)kv11);
        this.region.put(put);
        put = new Put(rowA);
        put.add((Cell)kv2);
        this.region.put(put);
        put = new Put(rowB);
        put.add((Cell)kv3);
        this.region.put(put);
        Scan scan = new Scan();
        ArrayList currRow = new ArrayList();
        scan.setReversed(true);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowC, (int)0, (int)rowC.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowB, (int)0, (int)rowB.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowA, (int)0, (int)rowA.length));
            Assert.assertFalse((boolean)hasNext);
        }
    }

    @Test
    public void testReverseScanner_moreRowsMayExistAfter() throws IOException {
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] rowC = Bytes.toBytes((String)"rowC");
        byte[] rowD = Bytes.toBytes((String)"rowD");
        byte[] rowE = Bytes.toBytes((String)"rowE");
        byte[] cf = Bytes.toBytes((String)"CF");
        byte[][] families = new byte[][]{cf};
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        long ts = 1L;
        this.region = this.initHRegion(this.tableName, this.method, families);
        KeyValue kv1 = new KeyValue(rowA, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv2 = new KeyValue(rowB, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv3 = new KeyValue(rowC, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv4_1 = new KeyValue(rowD, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv4_2 = new KeyValue(rowD, cf, col2, ts, KeyValue.Type.Put, null);
        KeyValue kv5 = new KeyValue(rowE, cf, col1, ts, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(rowA);
        put.add((Cell)kv1);
        this.region.put(put);
        put = new Put(rowB);
        put.add((Cell)kv2);
        this.region.put(put);
        put = new Put(rowC);
        put.add((Cell)kv3);
        this.region.put(put);
        put = new Put(rowD);
        put.add((Cell)kv4_1);
        this.region.put(put);
        put = new Put(rowD);
        put.add((Cell)kv4_2);
        this.region.put(put);
        put = new Put(rowE);
        put.add((Cell)kv5);
        this.region.put(put);
        this.region.flush(true);
        Scan scan = new Scan(rowD, rowA);
        scan.addColumn(families[0], col1);
        scan.setReversed(true);
        ArrayList currRow = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowD, (int)0, (int)rowD.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowC, (int)0, (int)rowC.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowB, (int)0, (int)rowB.length));
            Assert.assertFalse((boolean)hasNext);
        }
        scan = new Scan(rowD, rowA);
        scan.addColumn(families[0], col2);
        scan.setReversed(true);
        currRow.clear();
        scanner = this.region.getScanner(scan);
        var22_21 = null;
        try {
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowD, (int)0, (int)rowD.length));
            Assert.assertTrue((boolean)hasNext);
        }
        catch (Throwable throwable) {
            var22_21 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var22_21 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var22_21.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    @Test
    public void testReverseScanner_smaller_blocksize() throws IOException {
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] rowC = Bytes.toBytes((String)"rowC");
        byte[] rowD = Bytes.toBytes((String)"rowD");
        byte[] rowE = Bytes.toBytes((String)"rowE");
        byte[] cf = Bytes.toBytes((String)"CF");
        byte[][] families = new byte[][]{cf};
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        long ts = 1L;
        Configuration conf = new Configuration(CONF);
        conf.setInt("test.block.size", 1);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        KeyValue kv1 = new KeyValue(rowA, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv2 = new KeyValue(rowB, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv3 = new KeyValue(rowC, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv4_1 = new KeyValue(rowD, cf, col1, ts, KeyValue.Type.Put, null);
        KeyValue kv4_2 = new KeyValue(rowD, cf, col2, ts, KeyValue.Type.Put, null);
        KeyValue kv5 = new KeyValue(rowE, cf, col1, ts, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(rowA);
        put.add((Cell)kv1);
        this.region.put(put);
        put = new Put(rowB);
        put.add((Cell)kv2);
        this.region.put(put);
        put = new Put(rowC);
        put.add((Cell)kv3);
        this.region.put(put);
        put = new Put(rowD);
        put.add((Cell)kv4_1);
        this.region.put(put);
        put = new Put(rowD);
        put.add((Cell)kv4_2);
        this.region.put(put);
        put = new Put(rowE);
        put.add((Cell)kv5);
        this.region.put(put);
        this.region.flush(true);
        Scan scan = new Scan(rowD, rowA);
        scan.addColumn(families[0], col1);
        scan.setReversed(true);
        ArrayList currRow = new ArrayList();
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowD, (int)0, (int)rowD.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowC, (int)0, (int)rowC.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowB, (int)0, (int)rowB.length));
            Assert.assertFalse((boolean)hasNext);
        }
        scan = new Scan(rowD, rowA);
        scan.addColumn(families[0], col2);
        scan.setReversed(true);
        currRow.clear();
        scanner = this.region.getScanner(scan);
        var23_22 = null;
        try {
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])rowD, (int)0, (int)rowD.length));
            Assert.assertTrue((boolean)hasNext);
        }
        catch (Throwable throwable) {
            var23_22 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var23_22 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var23_22.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    @Test
    public void testReverseScanner_FromMemStoreAndHFiles_MultiCFs1() throws IOException {
        byte[] row0 = Bytes.toBytes((String)"row0");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] row3 = Bytes.toBytes((String)"row3");
        byte[] row4 = Bytes.toBytes((String)"row4");
        byte[] row5 = Bytes.toBytes((String)"row5");
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[] cf2 = Bytes.toBytes((String)"CF2");
        byte[] cf3 = Bytes.toBytes((String)"CF3");
        byte[][] families = new byte[][]{cf1, cf2, cf3};
        byte[] col = Bytes.toBytes((String)"C");
        long ts = 1L;
        Configuration conf = new Configuration(CONF);
        conf.setInt("hbase.hstore.compactionThreshold", 10000);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        KeyValue kv0_1_1 = new KeyValue(row0, cf1, col, ts, KeyValue.Type.Put, null);
        KeyValue kv1_2_1 = new KeyValue(row1, cf2, col, ts, KeyValue.Type.Put, null);
        KeyValue kv1_2_2 = new KeyValue(row1, cf1, col, ts + 1L, KeyValue.Type.Put, null);
        KeyValue kv2_4_1 = new KeyValue(row2, cf2, col, ts, KeyValue.Type.Put, null);
        KeyValue kv2_4_2 = new KeyValue(row2, cf1, col, ts, KeyValue.Type.Put, null);
        KeyValue kv2_4_3 = new KeyValue(row2, cf3, col, ts, KeyValue.Type.Put, null);
        KeyValue kv2_4_4 = new KeyValue(row2, cf1, col, ts + 4L, KeyValue.Type.Put, null);
        KeyValue kv3_2_1 = new KeyValue(row3, cf2, col, ts, KeyValue.Type.Put, null);
        KeyValue kv3_2_2 = new KeyValue(row3, cf1, col, ts + 4L, KeyValue.Type.Put, null);
        KeyValue kv4_5_1 = new KeyValue(row4, cf1, col, ts, KeyValue.Type.Put, null);
        KeyValue kv4_5_2 = new KeyValue(row4, cf3, col, ts, KeyValue.Type.Put, null);
        KeyValue kv4_5_3 = new KeyValue(row4, cf3, col, ts + 5L, KeyValue.Type.Put, null);
        KeyValue kv4_5_4 = new KeyValue(row4, cf2, col, ts, KeyValue.Type.Put, null);
        KeyValue kv4_5_5 = new KeyValue(row4, cf1, col, ts + 3L, KeyValue.Type.Put, null);
        KeyValue kv5_2_1 = new KeyValue(row5, cf2, col, ts, KeyValue.Type.Put, null);
        KeyValue kv5_2_2 = new KeyValue(row5, cf3, col, ts, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(row1);
        put.add((Cell)kv1_2_1);
        this.region.put(put);
        put = new Put(row2);
        put.add((Cell)kv2_4_1);
        this.region.put(put);
        put = new Put(row4);
        put.add((Cell)kv4_5_4);
        put.add((Cell)kv4_5_5);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row4);
        put.add((Cell)kv4_5_1);
        put.add((Cell)kv4_5_3);
        this.region.put(put);
        put = new Put(row1);
        put.add((Cell)kv1_2_2);
        this.region.put(put);
        put = new Put(row2);
        put.add((Cell)kv2_4_4);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row4);
        put.add((Cell)kv4_5_2);
        this.region.put(put);
        put = new Put(row2);
        put.add((Cell)kv2_4_2);
        put.add((Cell)kv2_4_3);
        this.region.put(put);
        put = new Put(row3);
        put.add((Cell)kv3_2_2);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row0);
        put.add((Cell)kv0_1_1);
        this.region.put(put);
        put = new Put(row3);
        put.add((Cell)kv3_2_1);
        this.region.put(put);
        put = new Put(row5);
        put.add((Cell)kv5_2_1);
        put.add((Cell)kv5_2_2);
        this.region.put(put);
        Scan scan = new Scan(row4);
        scan.setMaxVersions(5);
        scan.setBatch(3);
        scan.setReversed(true);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            ArrayList currRow = new ArrayList();
            boolean hasNext = false;
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)3L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row4, (int)0, (int)row4.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row4, (int)0, (int)row4.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row3, (int)0, (int)row3.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)3L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row0, (int)0, (int)row0.length));
            Assert.assertFalse((boolean)hasNext);
        }
    }

    @Test
    public void testReverseScanner_FromMemStoreAndHFiles_MultiCFs2() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] row3 = Bytes.toBytes((String)"row3");
        byte[] row4 = Bytes.toBytes((String)"row4");
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[] cf2 = Bytes.toBytes((String)"CF2");
        byte[] cf3 = Bytes.toBytes((String)"CF3");
        byte[] cf4 = Bytes.toBytes((String)"CF4");
        byte[][] families = new byte[][]{cf1, cf2, cf3, cf4};
        byte[] col = Bytes.toBytes((String)"C");
        long ts = 1L;
        Configuration conf = new Configuration(CONF);
        conf.setInt("hbase.hstore.compactionThreshold", 10000);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        KeyValue kv1 = new KeyValue(row1, cf1, col, ts, KeyValue.Type.Put, null);
        KeyValue kv2 = new KeyValue(row2, cf2, col, ts, KeyValue.Type.Put, null);
        KeyValue kv3 = new KeyValue(row3, cf3, col, ts, KeyValue.Type.Put, null);
        KeyValue kv4 = new KeyValue(row4, cf4, col, ts, KeyValue.Type.Put, null);
        Put put = new Put(row1);
        put.add((Cell)kv1);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row2);
        put.add((Cell)kv2);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row3);
        put.add((Cell)kv3);
        this.region.put(put);
        this.region.flush(true);
        put = new Put(row4);
        put.add((Cell)kv4);
        this.region.put(put);
        Scan scan = new Scan(row4);
        scan.setReversed(true);
        scan.setBatch(10);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            ArrayList currRow = new ArrayList();
            boolean hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row4, (int)0, (int)row4.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row3, (int)0, (int)row3.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertTrue((boolean)hasNext);
            currRow.clear();
            hasNext = scanner.next(currRow);
            Assert.assertEquals((long)1L, (long)currRow.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertFalse((boolean)hasNext);
        }
    }

    @Test
    public void testReverseScanner_StackOverflow() throws IOException {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        byte[] col = Bytes.toBytes((String)"C");
        Configuration conf = new Configuration(CONF);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        Put put = new Put(Bytes.toBytes((String)"19998"));
        put.addColumn(cf1, col, Bytes.toBytes((String)"val"));
        this.region.put(put);
        this.region.flushcache(true, true, FlushLifeCycleTracker.DUMMY);
        Put put2 = new Put(Bytes.toBytes((String)"19997"));
        put2.addColumn(cf1, col, Bytes.toBytes((String)"val"));
        this.region.put(put2);
        Scan scan = new Scan(Bytes.toBytes((String)"19998"));
        scan.setReversed(true);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext;
            Put p;
            int i;
            for (i = 10000; i < 20000; ++i) {
                p = new Put(Bytes.toBytes((String)("" + i)));
                p.addColumn(cf1, col, Bytes.toBytes((String)("" + i)));
                this.region.put(p);
            }
            this.region.flushcache(true, true, FlushLifeCycleTracker.DUMMY);
            for (i = 10000; i < 20000; ++i) {
                p = new Put(Bytes.toBytes((String)("" + i)));
                p.addColumn(cf1, col, Bytes.toBytes((String)("" + i)));
                this.region.put(p);
            }
            ArrayList currRow = new ArrayList();
            while (hasNext = scanner.next(currRow)) {
            }
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertEquals((Object)"19998", (Object)Bytes.toString((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength()));
            Assert.assertEquals((Object)"19997", (Object)Bytes.toString((byte[])((Cell)currRow.get(1)).getRowArray(), (int)((Cell)currRow.get(1)).getRowOffset(), (int)((Cell)currRow.get(1)).getRowLength()));
        }
    }

    @Test
    public void testReverseScanShouldNotScanMemstoreIfReadPtLesser() throws Exception {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        byte[] col = Bytes.toBytes((String)"C");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = new Put(Bytes.toBytes((String)"19996"));
        put.addColumn(cf1, col, Bytes.toBytes((String)"val"));
        this.region.put(put);
        Put put2 = new Put(Bytes.toBytes((String)"19995"));
        put2.addColumn(cf1, col, Bytes.toBytes((String)"val"));
        this.region.put(put2);
        Scan scan = new Scan(Bytes.toBytes((String)"19996"));
        scan.setReversed(true);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext;
            this.region.flushcache(true, true, FlushLifeCycleTracker.DUMMY);
            for (int i = 10000; i < 20000; ++i) {
                Put p = new Put(Bytes.toBytes((String)("" + i)));
                p.addColumn(cf1, col, Bytes.toBytes((String)("" + i)));
                this.region.put(p);
            }
            ArrayList currRow = new ArrayList();
            boolean assertDone = false;
            do {
                hasNext = scanner.next(currRow);
                if (assertDone) continue;
                StoreScanner current = (StoreScanner)scanner.storeHeap.getCurrentForTesting();
                List scanners = current.getAllScannersForTesting();
                Assert.assertEquals((String)"There should be only one scanner the store file scanner", (long)1L, (long)scanners.size());
                assertDone = true;
            } while (hasNext);
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertEquals((Object)"19996", (Object)Bytes.toString((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength()));
            Assert.assertEquals((Object)"19995", (Object)Bytes.toString((byte[])((Cell)currRow.get(1)).getRowArray(), (int)((Cell)currRow.get(1)).getRowOffset(), (int)((Cell)currRow.get(1)).getRowLength()));
        }
    }

    @Test
    public void testReverseScanWhenPutCellsAfterOpenReverseScan() throws Exception {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        byte[] col = Bytes.toBytes((String)"C");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Put put = new Put(Bytes.toBytes((String)"199996"));
        put.addColumn(cf1, col, Bytes.toBytes((String)"val"));
        this.region.put(put);
        Put put2 = new Put(Bytes.toBytes((String)"199995"));
        put2.addColumn(cf1, col, Bytes.toBytes((String)"val"));
        this.region.put(put2);
        Scan scan = new Scan(Bytes.toBytes((String)"199996"));
        scan.setReversed(true);
        try (RegionScannerImpl scanner = this.region.getScanner(scan);){
            boolean hasNext;
            for (int i = 100000; i < 200000; ++i) {
                Put p = new Put(Bytes.toBytes((String)("" + i)));
                p.addColumn(cf1, col, Bytes.toBytes((String)("" + i)));
                this.region.put(p);
            }
            ArrayList currRow = new ArrayList();
            while (hasNext = scanner.next(currRow)) {
            }
            Assert.assertEquals((long)2L, (long)currRow.size());
            Assert.assertEquals((Object)"199996", (Object)Bytes.toString((byte[])((Cell)currRow.get(0)).getRowArray(), (int)((Cell)currRow.get(0)).getRowOffset(), (int)((Cell)currRow.get(0)).getRowLength()));
            Assert.assertEquals((Object)"199995", (Object)Bytes.toString((byte[])((Cell)currRow.get(1)).getRowArray(), (int)((Cell)currRow.get(1)).getRowOffset(), (int)((Cell)currRow.get(1)).getRowLength()));
        }
    }

    @Test
    public void testWriteRequestsCounter() throws IOException {
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        Assert.assertEquals((long)0L, (long)this.region.getWriteRequestsCount());
        Put put = new Put(this.row);
        put.addColumn(fam, fam, fam);
        Assert.assertEquals((long)0L, (long)this.region.getWriteRequestsCount());
        this.region.put(put);
        Assert.assertEquals((long)1L, (long)this.region.getWriteRequestsCount());
        this.region.put(put);
        Assert.assertEquals((long)2L, (long)this.region.getWriteRequestsCount());
        this.region.put(put);
        Assert.assertEquals((long)3L, (long)this.region.getWriteRequestsCount());
        this.region.delete(new Delete(this.row));
        Assert.assertEquals((long)4L, (long)this.region.getWriteRequestsCount());
    }

    @Test
    public void testOpenRegionWrittenToWAL() throws Exception {
        ServerName serverName = ServerName.valueOf((String)this.name.getMethodName(), (int)100, (long)42L);
        RegionServerServices rss = (RegionServerServices)Mockito.spy((Object)TEST_UTIL.createMockRegionServerService(serverName));
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HBaseTestingUtility.fam1)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HBaseTestingUtility.fam2)).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        this.region = HBaseTestingUtility.createRegionAndWAL(hri, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), htd);
        Assert.assertNotNull((Object)this.region);
        this.region.put(new Put(Bytes.toBytes((String)"a")).addColumn(HBaseTestingUtility.fam1, HBaseTestingUtility.fam1, HBaseTestingUtility.fam1));
        this.region.flush(true);
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        ArgumentCaptor editCaptor = ArgumentCaptor.forClass(WALEdit.class);
        WAL wal = this.mockWAL();
        Mockito.when((Object)rss.getWAL((RegionInfo)ArgumentMatchers.any(RegionInfo.class))).thenReturn((Object)wal);
        this.region = HRegion.openHRegion((RegionInfo)hri, (TableDescriptor)htd, (WAL)rss.getWAL(hri), (Configuration)TEST_UTIL.getConfiguration(), (RegionServerServices)rss, null);
        ((WAL)Mockito.verify((Object)wal, (VerificationMode)Mockito.times((int)1))).appendMarker((RegionInfo)ArgumentMatchers.any(RegionInfo.class), (WALKeyImpl)ArgumentMatchers.any(WALKeyImpl.class), (WALEdit)editCaptor.capture());
        WALEdit edit = (WALEdit)editCaptor.getValue();
        Assert.assertNotNull((Object)edit);
        Assert.assertNotNull((Object)edit.getCells());
        Assert.assertEquals((long)1L, (long)edit.getCells().size());
        WALProtos.RegionEventDescriptor desc = WALEdit.getRegionEventDescriptor((Cell)((Cell)edit.getCells().get(0)));
        Assert.assertNotNull((Object)desc);
        LOG.info("RegionEventDescriptor from WAL: " + desc);
        Assert.assertEquals((Object)WALProtos.RegionEventDescriptor.EventType.REGION_OPEN, (Object)desc.getEventType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])desc.getTableName().toByteArray(), (byte[])htd.getTableName().toBytes()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])desc.getEncodedRegionName().toByteArray(), (byte[])hri.getEncodedNameAsBytes()));
        Assert.assertTrue((desc.getLogSequenceNumber() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)serverName, (Object)ProtobufUtil.toServerName((HBaseProtos.ServerName)desc.getServer()));
        Assert.assertEquals((long)2L, (long)desc.getStoresCount());
        WALProtos.StoreDescriptor store = desc.getStores(0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])store.getFamilyName().toByteArray(), (byte[])HBaseTestingUtility.fam1));
        Assert.assertEquals((Object)store.getStoreHomeDir(), (Object)Bytes.toString((byte[])HBaseTestingUtility.fam1));
        Assert.assertEquals((long)1L, (long)store.getStoreFileCount());
        Assert.assertFalse((boolean)store.getStoreFile(0).contains("/"));
        store = desc.getStores(1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])store.getFamilyName().toByteArray(), (byte[])HBaseTestingUtility.fam2));
        Assert.assertEquals((Object)store.getStoreHomeDir(), (Object)Bytes.toString((byte[])HBaseTestingUtility.fam2));
        Assert.assertEquals((long)0L, (long)store.getStoreFileCount());
    }

    @Test
    public void testFlushedFileWithNoTags() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(HBaseTestingUtility.fam1));
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        Path path = TEST_UTIL.getDataTestDir(this.getClass().getSimpleName());
        this.region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, path, TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
        Put put = new Put(Bytes.toBytes((String)"a-b-0-0"));
        put.addColumn(HBaseTestingUtility.fam1, this.qual1, Bytes.toBytes((String)"c1-value"));
        this.region.put(put);
        this.region.flush(true);
        HStore store = this.region.getStore(HBaseTestingUtility.fam1);
        Collection storefiles = store.getStorefiles();
        for (HStoreFile sf : storefiles) {
            Assert.assertFalse((String)"Tags should not be present ", (boolean)sf.getReader().getHFileReader().getFileContext().isIncludesTags());
        }
    }

    private WAL mockWAL() throws IOException {
        WAL wal = (WAL)Mockito.mock(WAL.class);
        Mockito.when((Object)wal.appendData((RegionInfo)ArgumentMatchers.any(RegionInfo.class), (WALKeyImpl)ArgumentMatchers.any(WALKeyImpl.class), (WALEdit)ArgumentMatchers.any(WALEdit.class))).thenAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                WALKeyImpl key = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl.WriteEntry we = key.getMvcc().begin();
                key.setWriteEntry(we);
                return 1L;
            }
        });
        Mockito.when((Object)wal.appendMarker((RegionInfo)ArgumentMatchers.any(RegionInfo.class), (WALKeyImpl)ArgumentMatchers.any(WALKeyImpl.class), (WALEdit)ArgumentMatchers.any(WALEdit.class))).thenAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                WALKeyImpl key = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl.WriteEntry we = key.getMvcc().begin();
                key.setWriteEntry(we);
                return 1L;
            }
        });
        return wal;
    }

    @Test
    public void testCloseRegionWrittenToWAL() throws Exception {
        Path rootDir = new Path(this.dir + this.name.getMethodName());
        CommonFSUtils.setRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)rootDir);
        ServerName serverName = ServerName.valueOf((String)"testCloseRegionWrittenToWAL", (int)100, (long)42L);
        RegionServerServices rss = (RegionServerServices)Mockito.spy((Object)TEST_UTIL.createMockRegionServerService(serverName));
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HBaseTestingUtility.fam1)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HBaseTestingUtility.fam2)).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        ArgumentCaptor editCaptor = ArgumentCaptor.forClass(WALEdit.class);
        WAL wal = this.mockWAL();
        Mockito.when((Object)rss.getWAL((RegionInfo)ArgumentMatchers.any(RegionInfo.class))).thenReturn((Object)wal);
        this.region = HBaseTestingUtility.createRegionAndWAL(hri, rootDir, CONF, htd);
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        this.region = null;
        HRegion.openHRegion((RegionInfo)hri, (TableDescriptor)htd, (WAL)rss.getWAL(hri), (Configuration)TEST_UTIL.getConfiguration(), (RegionServerServices)rss, null).close();
        ((WAL)Mockito.verify((Object)wal, (VerificationMode)Mockito.times((int)2))).appendMarker((RegionInfo)ArgumentMatchers.any(RegionInfo.class), (WALKeyImpl)ArgumentMatchers.any(WALKeyImpl.class), (WALEdit)editCaptor.capture());
        WALEdit edit = (WALEdit)editCaptor.getAllValues().get(1);
        Assert.assertNotNull((Object)edit);
        Assert.assertNotNull((Object)edit.getCells());
        Assert.assertEquals((long)1L, (long)edit.getCells().size());
        WALProtos.RegionEventDescriptor desc = WALEdit.getRegionEventDescriptor((Cell)((Cell)edit.getCells().get(0)));
        Assert.assertNotNull((Object)desc);
        LOG.info("RegionEventDescriptor from WAL: " + desc);
        Assert.assertEquals((Object)WALProtos.RegionEventDescriptor.EventType.REGION_CLOSE, (Object)desc.getEventType());
        Assert.assertTrue((boolean)Bytes.equals((byte[])desc.getTableName().toByteArray(), (byte[])htd.getTableName().toBytes()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])desc.getEncodedRegionName().toByteArray(), (byte[])hri.getEncodedNameAsBytes()));
        Assert.assertTrue((desc.getLogSequenceNumber() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)serverName, (Object)ProtobufUtil.toServerName((HBaseProtos.ServerName)desc.getServer()));
        Assert.assertEquals((long)2L, (long)desc.getStoresCount());
        WALProtos.StoreDescriptor store = desc.getStores(0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])store.getFamilyName().toByteArray(), (byte[])HBaseTestingUtility.fam1));
        Assert.assertEquals((Object)store.getStoreHomeDir(), (Object)Bytes.toString((byte[])HBaseTestingUtility.fam1));
        Assert.assertEquals((long)0L, (long)store.getStoreFileCount());
        store = desc.getStores(1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])store.getFamilyName().toByteArray(), (byte[])HBaseTestingUtility.fam2));
        Assert.assertEquals((Object)store.getStoreHomeDir(), (Object)Bytes.toString((byte[])HBaseTestingUtility.fam2));
        Assert.assertEquals((long)0L, (long)store.getStoreFileCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionTooBusy() throws IOException {
        byte[] family = Bytes.toBytes((String)"family");
        long defaultBusyWaitDuration = CONF.getLong("hbase.busy.wait.duration", 60000L);
        CONF.setLong("hbase.busy.wait.duration", 1000L);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        final AtomicBoolean stopped = new AtomicBoolean(true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestHRegion.this.region.lock.writeLock().lock();
                    stopped.set(false);
                    while (!stopped.get()) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    TestHRegion.this.region.lock.writeLock().unlock();
                }
            }
        });
        t.start();
        Get get = new Get(this.row);
        try {
            while (stopped.get()) {
                Thread.sleep(100L);
            }
            this.region.get(get);
            Assert.fail((String)"Should throw RegionTooBusyException");
        }
        catch (InterruptedException ie) {
            Assert.fail((String)"test interrupted");
        }
        catch (RegionTooBusyException regionTooBusyException) {
        }
        finally {
            stopped.set(true);
            try {
                t.join();
            }
            catch (Throwable throwable) {}
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            CONF.setLong("hbase.busy.wait.duration", defaultBusyWaitDuration);
        }
    }

    @Test
    public void testCellTTLs() throws IOException {
        IncrementingEnvironmentEdge edge = new IncrementingEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        byte[] row = Bytes.toBytes((String)"testRow");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] q3 = Bytes.toBytes((String)"q3");
        byte[] q4 = Bytes.toBytes((String)"q4");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor(HBaseTestingUtility.fam1);
        hcd.setTimeToLive(10);
        htd.addFamily(hcd);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hfile.format.version", 3);
        this.region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)new HRegionInfo(htd.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY), TEST_UTIL.getDataTestDir(), conf, (TableDescriptor)htd);
        Assert.assertNotNull((Object)this.region);
        long now = EnvironmentEdgeManager.currentTime();
        this.region.put(new Put(row).add((Cell)new KeyValue(row, HBaseTestingUtility.fam1, q1, now, HConstants.EMPTY_BYTE_ARRAY, (Tag[])new ArrayBackedTag[]{new ArrayBackedTag(8, Bytes.toBytes((long)5000L))})));
        this.region.put(new Put(row).addColumn(HBaseTestingUtility.fam1, q2, now, HConstants.EMPTY_BYTE_ARRAY));
        this.region.put(new Put(row).add((Cell)new KeyValue(row, HBaseTestingUtility.fam1, q3, now + 10000L - 1L, HConstants.EMPTY_BYTE_ARRAY, (Tag[])new ArrayBackedTag[]{new ArrayBackedTag(8, Bytes.toBytes((long)5000L))})));
        this.region.put(new Put(row).addColumn(HBaseTestingUtility.fam1, q4, now + 10000L - 1L, HConstants.EMPTY_BYTE_ARRAY));
        this.region.flush(true);
        Result r = this.region.get(new Get(row));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q1));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q3));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q4));
        edge.incrementTime(5000L);
        r = this.region.get(new Get(row));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q1));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q3));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q4));
        edge.incrementTime(5000L);
        r = this.region.get(new Get(row));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q1));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q3));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q4));
        edge.incrementTime(5000L);
        r = this.region.get(new Get(row));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q1));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q3));
        Assert.assertNotNull((Object)r.getValue(HBaseTestingUtility.fam1, q4));
        edge.incrementTime(10000L);
        r = this.region.get(new Get(row));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q1));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q3));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q4));
        this.region.put(new Put(row).addColumn(HBaseTestingUtility.fam1, q1, Bytes.toBytes((long)1L)));
        r = this.region.get(new Get(row));
        byte[] val = r.getValue(HBaseTestingUtility.fam1, q1);
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])val));
        Increment incr = new Increment(row).addColumn(HBaseTestingUtility.fam1, q1, 1L);
        incr.setTTL(5000L);
        this.region.increment(incr);
        r = this.region.get(new Get(row));
        val = r.getValue(HBaseTestingUtility.fam1, q1);
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])val));
        edge.incrementTime(5000L);
        r = this.region.get(new Get(row));
        val = r.getValue(HBaseTestingUtility.fam1, q1);
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])val));
        edge.incrementTime(5000L);
        r = this.region.get(new Get(row));
        Assert.assertNull((Object)r.getValue(HBaseTestingUtility.fam1, q1));
    }

    @Test
    public void testIncrementTimestampsAreMonotonic() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        edge.setValue(10L);
        Increment inc = new Increment(this.row);
        inc.setDurability(Durability.SKIP_WAL);
        inc.addColumn(HBaseTestingUtility.fam1, this.qual1, 1L);
        this.region.increment(inc);
        Result result = this.region.get(new Get(this.row));
        Cell c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)10L, (long)c.getTimestamp());
        edge.setValue(1L);
        this.region.increment(inc);
        result = this.region.get(new Get(this.row));
        c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertEquals((long)11L, (long)c.getTimestamp());
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength()));
    }

    @Test
    public void testAppendTimestampsAreMonotonic() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        edge.setValue(10L);
        Append a = new Append(this.row);
        a.setDurability(Durability.SKIP_WAL);
        a.addColumn(HBaseTestingUtility.fam1, this.qual1, this.qual1);
        this.region.append(a);
        Result result = this.region.get(new Get(this.row));
        Cell c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)10L, (long)c.getTimestamp());
        edge.setValue(1L);
        this.region.append(a);
        result = this.region.get(new Get(this.row));
        c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertEquals((long)11L, (long)c.getTimestamp());
        byte[] expected = new byte[this.qual1.length * 2];
        System.arraycopy(this.qual1, 0, expected, 0, this.qual1.length);
        System.arraycopy(this.qual1, 0, expected, this.qual1.length, this.qual1.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength(), (byte[])expected, (int)0, (int)expected.length));
    }

    @Test
    public void testCheckAndMutateTimestampsAreMonotonic() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        edge.setValue(10L);
        Put p = new Put(this.row);
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(HBaseTestingUtility.fam1, this.qual1, this.qual1);
        this.region.put(p);
        Result result = this.region.get(new Get(this.row));
        Cell c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)10L, (long)c.getTimestamp());
        edge.setValue(1L);
        p = new Put(this.row);
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(HBaseTestingUtility.fam1, this.qual1, this.qual2);
        this.region.checkAndMutate(this.row, HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(this.qual1), (Mutation)p);
        result = this.region.get(new Get(this.row));
        c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertEquals((long)10L, (long)c.getTimestamp());
        Assert.assertTrue((boolean)Bytes.equals((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength(), (byte[])this.qual2, (int)0, (int)this.qual2.length));
    }

    @Test
    public void testBatchMutateWithWrongRegionException() throws Exception {
        final byte[] a = Bytes.toBytes((String)"a");
        final byte[] b = Bytes.toBytes((String)"b");
        byte[] c = Bytes.toBytes((String)"c");
        int prevLockTimeout = CONF.getInt("hbase.rowlock.wait.duration", 30000);
        CONF.setInt("hbase.rowlock.wait.duration", 1000);
        this.region = this.initHRegion(this.tableName, a, c, this.method, CONF, false, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        Mutation[] mutations = new Mutation[]{new Put(a).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(a).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build()), new Put(c).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(c).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build()), new Put(b).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(b).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build())};
        OperationStatus[] status = this.region.batchMutate(mutations);
        Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[0].getOperationStatusCode());
        Assert.assertEquals((Object)HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, (Object)status[1].getOperationStatusCode());
        Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[2].getOperationStatusCode());
        final CountDownLatch obtainedRowLock = new CountDownLatch(1);
        ExecutorService exec = Executors.newFixedThreadPool(2);
        Future<Void> f1 = exec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LOG.info("Acquiring row lock");
                Region.RowLock rl = TestHRegion.this.region.getRowLock(b);
                obtainedRowLock.countDown();
                LOG.info("Waiting for 5 seconds before releasing lock");
                Threads.sleep((long)5000L);
                LOG.info("Releasing row lock");
                rl.release();
                return null;
            }
        });
        obtainedRowLock.await(30L, TimeUnit.SECONDS);
        Future<Void> f2 = exec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Mutation[] mutations = new Mutation[]{new Put(a).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(a).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build()), new Put(b).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(b).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build())};
                OperationStatus[] status = TestHRegion.this.region.batchMutate(mutations);
                Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[0].getOperationStatusCode());
                Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[1].getOperationStatusCode());
                return null;
            }
        });
        f1.get();
        f2.get();
        CONF.setInt("hbase.rowlock.wait.duration", prevLockTimeout);
    }

    @Test
    public void testBatchMutateWithZeroRowLockWait() throws Exception {
        final byte[] a = Bytes.toBytes((String)"a");
        final byte[] b = Bytes.toBytes((String)"b");
        byte[] c = Bytes.toBytes((String)"c");
        Configuration conf = new Configuration(CONF);
        conf.setInt("hbase.rowlock.wait.duration", 0);
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)this.tableName).setStartKey(a).setEndKey(c).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HBaseTestingUtility.fam1)).build();
        this.region = HRegion.createHRegion((RegionInfo)hri, (Path)TEST_UTIL.getDataTestDir(), (Configuration)conf, (TableDescriptor)htd, (WAL)HBaseTestingUtility.createWal(conf, TEST_UTIL.getDataTestDirOnTestFS(this.method + ".log"), hri));
        Mutation[] mutations = new Mutation[]{new Put(a).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(a).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build()), new Put(b).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(b).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build())};
        OperationStatus[] status = this.region.batchMutate(mutations);
        Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[0].getOperationStatusCode());
        Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[1].getOperationStatusCode());
        final CountDownLatch obtainedRowLock = new CountDownLatch(1);
        ExecutorService exec = Executors.newFixedThreadPool(2);
        Future<Void> f1 = exec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LOG.info("Acquiring row lock");
                Region.RowLock rl = TestHRegion.this.region.getRowLock(b);
                obtainedRowLock.countDown();
                LOG.info("Waiting for 5 seconds before releasing lock");
                Threads.sleep((long)5000L);
                LOG.info("Releasing row lock");
                rl.release();
                return null;
            }
        });
        obtainedRowLock.await(30L, TimeUnit.SECONDS);
        Future<Void> f2 = exec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Mutation[] mutations = new Mutation[]{new Put(a).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(a).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build()), new Put(b).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(b).setFamily(HBaseTestingUtility.fam1).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).build())};
                OperationStatus[] status = TestHRegion.this.region.batchMutate(mutations);
                Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[0].getOperationStatusCode());
                Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)status[1].getOperationStatusCode());
                return null;
            }
        });
        f1.get();
        f2.get();
    }

    @Test
    public void testCheckAndRowMutateTimestampsAreMonotonic() throws IOException {
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        edge.setValue(10L);
        Put p = new Put(this.row);
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(HBaseTestingUtility.fam1, this.qual1, this.qual1);
        this.region.put(p);
        Result result = this.region.get(new Get(this.row));
        Cell c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)10L, (long)c.getTimestamp());
        edge.setValue(1L);
        p = new Put(this.row);
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(HBaseTestingUtility.fam1, this.qual1, this.qual2);
        RowMutations rm = new RowMutations(this.row);
        rm.add(p);
        Assert.assertTrue((boolean)this.region.checkAndRowMutate(this.row, HBaseTestingUtility.fam1, this.qual1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(this.qual1), rm));
        result = this.region.get(new Get(this.row));
        c = result.getColumnLatestCell(HBaseTestingUtility.fam1, this.qual1);
        Assert.assertEquals((long)10L, (long)c.getTimestamp());
        LOG.info("c value " + Bytes.toStringBinary((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength(), (byte[])this.qual2, (int)0, (int)this.qual2.length));
    }

    private HRegion initHRegion(TableName tableName, String callingMethod, byte[] ... families) throws IOException {
        return this.initHRegion(tableName, callingMethod, HBaseConfiguration.create(), families);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritesWhileRollWriter() throws IOException {
        int testCount = 10;
        int numRows = 1024;
        int numFamilies = 2;
        int numQualifiers = 2;
        final byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes((String)("family" + i));
        }
        final byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qual" + i));
        }
        CONF.setInt("hbase.regionserver.wal.disruptor.event.count", 2);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])families);
        try {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            int i = 0;
            while (i < numRows) {
                final int count = i++;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        byte[] row = Bytes.toBytes((String)("row" + count));
                        Put put = new Put(row);
                        put.setDurability(Durability.SYNC_WAL);
                        byte[] value = Bytes.toBytes((String)String.valueOf(count));
                        for (byte[] family : families) {
                            for (byte[] qualifier : qualifiers) {
                                put.addColumn(family, qualifier, (long)count, value);
                            }
                        }
                        try {
                            TestHRegion.this.region.put(put);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                threads.add(t);
            }
            for (Thread t : threads) {
                t.start();
            }
            for (i = 0; i < testCount; ++i) {
                this.region.getWAL().rollWriter();
                Thread.yield();
            }
        }
        finally {
            try {
                HBaseTestingUtility.closeRegionAndWAL(this.region);
                CONF.setInt("hbase.regionserver.wal.disruptor.event.count", 16384);
            }
            catch (DroppedSnapshotException droppedSnapshotException) {}
            this.region = null;
        }
    }

    @Test
    public void testMutateRow() throws Exception {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] q3 = Bytes.toBytes((String)"q3");
        byte[] q4 = Bytes.toBytes((String)"q4");
        String v1 = "v1";
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        this.region.batchMutate(new Mutation[]{new Put(row).addColumn(HBaseTestingUtility.fam1, q2, Bytes.toBytes((String)"toBeDeleted")), new Put(row).addColumn(HBaseTestingUtility.fam1, q3, Bytes.toBytes((long)5L)), new Put(row).addColumn(HBaseTestingUtility.fam1, q4, Bytes.toBytes((String)"a"))});
        Result result = this.region.mutateRow(new RowMutations(row).add(Arrays.asList(new Put(row).addColumn(HBaseTestingUtility.fam1, q1, Bytes.toBytes((String)"v1")), new Delete(row).addColumns(HBaseTestingUtility.fam1, q2), new Increment(row).addColumn(HBaseTestingUtility.fam1, q3, 1L), new Append(row).addColumn(HBaseTestingUtility.fam1, q4, Bytes.toBytes((String)"b")))));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])result.getValue(HBaseTestingUtility.fam1, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q4)));
        result = this.region.get(new Get(row));
        Assert.assertEquals((Object)"v1", (Object)Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q1)));
        Assert.assertNull((Object)result.getValue(HBaseTestingUtility.fam1, q2));
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])result.getValue(HBaseTestingUtility.fam1, q3)));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q4)));
    }

    @Test
    public void testMutateRowInParallel() throws Exception {
        int numReaderThreads = 100;
        CountDownLatch latch = new CountDownLatch(100);
        byte[] row = Bytes.toBytes((String)"row");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] q3 = Bytes.toBytes((String)"q3");
        byte[] q4 = Bytes.toBytes((String)"q4");
        String v1 = "v1";
        String v2 = "v2";
        AtomicLong deleteTimestamp = new AtomicLong();
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{HBaseTestingUtility.fam1});
        this.region.batchMutate(new Mutation[]{new Put(row).addColumn(HBaseTestingUtility.fam1, q1, Bytes.toBytes((String)"v1")).addColumn(HBaseTestingUtility.fam1, q2, deleteTimestamp.getAndIncrement(), Bytes.toBytes((String)"v2")).addColumn(HBaseTestingUtility.fam1, q3, Bytes.toBytes((long)1L)).addColumn(HBaseTestingUtility.fam1, q4, Bytes.toBytes((String)"a"))});
        AtomicReference assertionError = new AtomicReference();
        Thread writerThread = new Thread(() -> {
            try {
                while (true) {
                    if (latch.await(0L, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                    this.region.mutateRow(new RowMutations(row).add(Arrays.asList(new Put(row).addColumn(HBaseTestingUtility.fam1, q1, Bytes.toBytes((String)"v2")), new Delete(row).addColumns(HBaseTestingUtility.fam1, q2, deleteTimestamp.getAndIncrement()), new Increment(row).addColumn(HBaseTestingUtility.fam1, q3, 1L), new Append(row).addColumn(HBaseTestingUtility.fam1, q4, Bytes.toBytes((String)"b")))));
                    Result result = this.region.get(new Get(row).addColumn(HBaseTestingUtility.fam1, q3).addColumn(HBaseTestingUtility.fam1, q4));
                    long tsIncrement = result.getColumnLatestCell(HBaseTestingUtility.fam1, q3).getTimestamp();
                    long tsAppend = result.getColumnLatestCell(HBaseTestingUtility.fam1, q4).getTimestamp();
                    this.region.batchMutate(new Mutation[]{new Put(row).addColumn(HBaseTestingUtility.fam1, q1, Bytes.toBytes((String)"v1")).addColumn(HBaseTestingUtility.fam1, q2, deleteTimestamp.getAndIncrement(), Bytes.toBytes((String)"v2")).addColumn(HBaseTestingUtility.fam1, q3, tsIncrement + 1L, Bytes.toBytes((long)1L)).addColumn(HBaseTestingUtility.fam1, q4, tsAppend + 1L, Bytes.toBytes((String)"a"))});
                }
            }
            catch (Exception e) {
                assertionError.set(new AssertionError((Object)e));
                return;
            }
        });
        writerThread.start();
        for (int i = 0; i < 100; ++i) {
            new Thread(() -> {
                try {
                    for (int j = 0; j < 10000; ++j) {
                        Result result = this.region.get(new Get(row));
                        String q1Value = Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q1));
                        if ("v1".equals(q1Value)) {
                            Assert.assertEquals((Object)"v2", (Object)Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q2)));
                            Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(HBaseTestingUtility.fam1, q3)));
                            Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q4)));
                            continue;
                        }
                        if ("v2".equals(q1Value)) {
                            Assert.assertNull((Object)Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q2)));
                            Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])result.getValue(HBaseTestingUtility.fam1, q3)));
                            Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])result.getValue(HBaseTestingUtility.fam1, q4)));
                            continue;
                        }
                        Assert.fail((String)("the qualifier " + Bytes.toString((byte[])q1) + " should be " + "v1" + " or " + "v2" + ", but " + q1Value));
                    }
                }
                catch (Exception e) {
                    assertionError.set(new AssertionError((Object)e));
                }
                catch (AssertionError e) {
                    assertionError.set(e);
                }
                latch.countDown();
            }).start();
        }
        writerThread.join();
        if (assertionError.get() != null) {
            throw (AssertionError)assertionError.get();
        }
    }

    @Test
    public void testMutateRow_WriteRequestCount() throws Exception {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        RowMutations rm = new RowMutations(row1);
        Put put = new Put(row1);
        put.addColumn(fam1, qf1, val1);
        rm.add(put);
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{fam1});
        long wrcBeforeMutate = this.region.writeRequestsCount.longValue();
        this.region.mutateRow(rm);
        long wrcAfterMutate = this.region.writeRequestsCount.longValue();
        Assert.assertEquals((long)(wrcBeforeMutate + (long)rm.getMutations().size()), (long)wrcAfterMutate);
    }

    @Test
    public void testBulkLoadReplicationEnabled() throws IOException {
        TEST_UTIL.getConfiguration().setBoolean("hbase.replication.bulkload.enabled", true);
        ServerName serverName = ServerName.valueOf((String)this.name.getMethodName(), (int)100, (long)42L);
        RegionServerServices rss = (RegionServerServices)Mockito.spy((Object)TEST_UTIL.createMockRegionServerService(serverName));
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        htd.addFamily(new HColumnDescriptor(HBaseTestingUtility.fam1));
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        this.region = HRegion.openHRegion((RegionInfo)hri, (TableDescriptor)htd, (WAL)rss.getWAL((RegionInfo)hri), (Configuration)TEST_UTIL.getConfiguration(), (RegionServerServices)rss, null);
        Assert.assertTrue((boolean)this.region.conf.getBoolean("hbase.replication.bulkload.enabled", false));
        String plugins = this.region.conf.get("hbase.coprocessor.region.classes", "");
        String replicationCoprocessorClass = ReplicationObserver.class.getCanonicalName();
        Assert.assertTrue((boolean)plugins.contains(replicationCoprocessorClass));
        Assert.assertTrue((boolean)this.region.getCoprocessorHost().getCoprocessors().contains(ReplicationObserver.class.getSimpleName()));
    }

    @Test
    public void testCloseNoInterrupt() throws Exception {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        int SLEEP_TIME = 10000;
        Configuration conf = new Configuration(CONF);
        conf.setBoolean("hbase.regionserver.close.wait.abort", false);
        conf.setInt("hbase.regionserver.close.wait.interval.ms", 1000);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean holderInterrupted = new AtomicBoolean();
        Thread holder = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting region operation holder");
                    TestHRegion.this.region.startRegionOperation(Region.Operation.SCAN);
                    latch.countDown();
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        LOG.info("Interrupted");
                        holderInterrupted.set(true);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        TestHRegion.this.region.closeRegionOperation();
                    }
                    catch (IOException iOException) {}
                    LOG.info("Stopped region operation holder");
                }
            }
        });
        holder.start();
        latch.await();
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        this.region = null;
        holder.join();
        Assert.assertFalse((String)"Region lock holder should not have been interrupted", (boolean)holderInterrupted.get());
    }

    @Test
    public void testCloseInterrupt() throws Exception {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        int SLEEP_TIME = 10000;
        Configuration conf = new Configuration(CONF);
        conf.setBoolean("hbase.regionserver.close.wait.abort", true);
        conf.setInt("hbase.regionserver.close.wait.interval.ms", 1000);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean holderInterrupted = new AtomicBoolean();
        Thread holder = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting region operation holder");
                    TestHRegion.this.region.startRegionOperation(Region.Operation.SCAN);
                    latch.countDown();
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        LOG.info("Interrupted");
                        holderInterrupted.set(true);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        TestHRegion.this.region.closeRegionOperation();
                    }
                    catch (IOException iOException) {}
                    LOG.info("Stopped region operation holder");
                }
            }
        });
        holder.start();
        latch.await();
        this.region.close();
        this.region = null;
        holder.join();
        Assert.assertTrue((String)"Region lock holder was not interrupted", (boolean)holderInterrupted.get());
    }

    @Test
    public void testCloseAbort() throws Exception {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        int SLEEP_TIME = 10000;
        Configuration conf = new Configuration(CONF);
        conf.setBoolean("hbase.regionserver.close.wait.abort", true);
        conf.setInt("hbase.regionserver.close.wait.time.ms", 5000);
        conf.setInt("hbase.regionserver.close.wait.interval.ms", 2500);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)rsServices.getServerName()).thenReturn((Object)ServerName.valueOf((String)"localhost", (int)1000, (long)1000L));
        this.region.rsServices = rsServices;
        final CountDownLatch latch = new CountDownLatch(1);
        Thread holder = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting region operation holder");
                    TestHRegion.this.region.startRegionOperation(Region.Operation.SCAN);
                    latch.countDown();
                    int timeRemaining = 10000;
                    while (timeRemaining > 0) {
                        long start = EnvironmentEdgeManager.currentTime();
                        try {
                            Thread.sleep(timeRemaining);
                        }
                        catch (InterruptedException e) {
                            LOG.info("Interrupted");
                        }
                        long end = EnvironmentEdgeManager.currentTime();
                        timeRemaining = (int)((long)timeRemaining - (end - start));
                        if (timeRemaining < 0) {
                            timeRemaining = 0;
                        }
                        if (timeRemaining <= 0) continue;
                        LOG.info("Sleeping again, remaining time " + timeRemaining + " ms");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        TestHRegion.this.region.closeRegionOperation();
                    }
                    catch (IOException iOException) {}
                    LOG.info("Stopped region operation holder");
                }
            }
        });
        holder.start();
        latch.await();
        Assert.assertThrows(IOException.class, () -> this.region.close());
        holder.join();
        ((RegionServerServices)Mockito.verify((Object)rsServices, (VerificationMode)Mockito.atLeast((int)1))).abort(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any());
    }

    @Test
    public void testInterruptProtection() throws Exception {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        int SLEEP_TIME = 10000;
        Configuration conf = new Configuration(CONF);
        conf.setBoolean("hbase.regionserver.close.wait.abort", true);
        conf.setInt("hbase.regionserver.close.wait.interval.ms", 1000);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean holderInterrupted = new AtomicBoolean();
        Thread holder = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting region operation holder");
                    TestHRegion.this.region.startRegionOperation(Region.Operation.SCAN);
                    LOG.info("Protecting against interrupts");
                    TestHRegion.this.region.disableInterrupts();
                    try {
                        latch.countDown();
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            LOG.info("Interrupted");
                            holderInterrupted.set(true);
                        }
                    }
                    finally {
                        TestHRegion.this.region.enableInterrupts();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        TestHRegion.this.region.closeRegionOperation();
                    }
                    catch (IOException iOException) {}
                    LOG.info("Stopped region operation holder");
                }
            }
        });
        holder.start();
        latch.await();
        this.region.close();
        this.region = null;
        holder.join();
        Assert.assertFalse((String)"Region lock holder should not have been interrupted", (boolean)holderInterrupted.get());
    }

    @Test
    public void testRegionOnCoprocessorsChange() throws IOException {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        Configuration conf = new Configuration(CONF);
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        Assert.assertNull((Object)this.region.getCoprocessorHost());
        Configuration newConf = new Configuration(conf);
        newConf.set("hbase.coprocessor.region.classes", MetaTableMetrics.class.getName());
        newConf.set("hbase.coprocessor.user.region.classes", NoOpRegionCoprocessor.class.getName());
        this.region.onConfigurationChange(newConf);
        Assert.assertTrue((this.region.getCoprocessorHost() != null ? 1 : 0) != 0);
        Set coprocessors = this.region.getCoprocessorHost().getCoprocessors();
        Assert.assertTrue((coprocessors.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.region.getCoprocessorHost().getCoprocessors().contains(MetaTableMetrics.class.getSimpleName()));
        Assert.assertTrue((boolean)this.region.getCoprocessorHost().getCoprocessors().contains(NoOpRegionCoprocessor.class.getSimpleName()));
        newConf.unset("hbase.coprocessor.region.classes");
        this.region.onConfigurationChange(newConf);
        Assert.assertTrue((this.region.getCoprocessorHost() != null ? 1 : 0) != 0);
        coprocessors = this.region.getCoprocessorHost().getCoprocessors();
        Assert.assertTrue((coprocessors.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.region.getCoprocessorHost().getCoprocessors().contains(NoOpRegionCoprocessor.class.getSimpleName()));
    }

    @Test
    public void testRegionOnCoprocessorsWithoutChange() throws IOException {
        byte[] cf1 = Bytes.toBytes((String)"CF1");
        byte[][] families = new byte[][]{cf1};
        Configuration conf = new Configuration(CONF);
        conf.set("hbase.coprocessor.region.classes", MetaTableMetrics.class.getCanonicalName());
        this.region = this.initHRegion(this.tableName, this.method, conf, (byte[][])families);
        this.region.setCoprocessorHost(new RegionCoprocessorHost(this.region, null, conf));
        RegionCoprocessor regionCoprocessor = (RegionCoprocessor)this.region.getCoprocessorHost().findCoprocessor(MetaTableMetrics.class.getName());
        this.region.onConfigurationChange(conf);
        RegionCoprocessor regionCoprocessorAfterOnConfigurationChange = (RegionCoprocessor)this.region.getCoprocessorHost().findCoprocessor(MetaTableMetrics.class.getName());
        Assert.assertEquals((Object)regionCoprocessor, (Object)regionCoprocessorAfterOnConfigurationChange);
    }

    public static class NoOpRegionCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
    }

    public static class HStoreForTesting
    extends HStore {
        protected HStoreForTesting(HRegion region, ColumnFamilyDescriptor family, Configuration confParam, boolean warmup) throws IOException {
            super(region, family, confParam, warmup);
        }

        protected List<HStoreFile> doCompaction(CompactionRequestImpl cr, Collection<HStoreFile> filesToCompact, User user, long compactionStartTime, List<Path> newFiles) throws IOException {
            if (!this.conf.getBoolean("hbase.hstore.compaction.complete", true)) {
                LOG.warn("hbase.hstore.compaction.complete is set to false");
                ArrayList<HStoreFile> sfs = new ArrayList<HStoreFile>(newFiles.size());
                boolean evictOnClose = this.getCacheConfig() != null ? this.getCacheConfig().shouldEvictOnClose() : true;
                for (Path newFile : newFiles) {
                    HStoreFile sf = this.storeEngine.createStoreFileAndReader(newFile);
                    sf.closeStoreFile(evictOnClose);
                    sfs.add(sf);
                }
                return sfs;
            }
            return super.doCompaction(cr, filesToCompact, user, compactionStartTime, newFiles);
        }
    }

    public static class HRegionForTesting
    extends HRegion {
        public HRegionForTesting(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            this(new HRegionFileSystem(confParam, fs, tableDir, regionInfo), wal, confParam, htd, rsServices);
        }

        public HRegionForTesting(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        protected HStore instantiateHStore(ColumnFamilyDescriptor family, boolean warmup) throws IOException {
            if (family.isMobEnabled()) {
                if (HFile.getFormatVersion((Configuration)this.conf) < 3) {
                    throw new IOException("A minimum HFile version of 3 is required for MOB feature. Consider setting hfile.format.version accordingly.");
                }
                return new HMobStore((HRegion)this, family, this.conf, warmup);
            }
            return new HStoreForTesting(this, family, this.conf, warmup);
        }
    }

    static class HRegionWithSeqId
    extends HRegion {
        public HRegionWithSeqId(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        protected long getNextSequenceId(WAL wal) throws IOException {
            return 42L;
        }
    }

    private static class Appender
    implements Runnable {
        private HRegion region;
        private static final byte[] appendRow = Bytes.toBytes((String)"appendRow");
        private static final byte[] family = Bytes.toBytes((String)"family");
        private static final byte[] qualifier = Bytes.toBytes((String)"qualifier");
        private static final byte[] CHAR = Bytes.toBytes((String)"a");
        private int appendCounter;

        public Appender(HRegion region, int appendCounter) {
            this.region = region;
            this.appendCounter = appendCounter;
        }

        @Override
        public void run() {
            for (int count = 0; count < this.appendCounter; ++count) {
                Append app = new Append(appendRow);
                app.addColumn(family, qualifier, CHAR);
                try {
                    this.region.append(app);
                    continue;
                }
                catch (IOException e) {
                    LOG.info("Count=" + count + ", max=" + this.appendCounter + ", " + e);
                    break;
                }
            }
        }
    }

    private static class Incrementer
    implements Runnable {
        private HRegion region;
        private static final byte[] incRow = Bytes.toBytes((String)"incRow");
        private static final byte[] family = Bytes.toBytes((String)"family");
        private static final byte[] qualifier = Bytes.toBytes((String)"qualifier");
        private static final long ONE = 1L;
        private int incCounter;

        public Incrementer(HRegion region, int incCounter) {
            this.region = region;
            this.incCounter = incCounter;
        }

        @Override
        public void run() {
            for (int count = 0; count < this.incCounter; ++count) {
                Increment inc = new Increment(incRow);
                inc.addColumn(family, qualifier, 1L);
                try {
                    this.region.increment(inc);
                    continue;
                }
                catch (IOException e) {
                    LOG.info("Count=" + count + ", " + e);
                    break;
                }
            }
        }
    }

    protected class PutThread
    extends Thread {
        private volatile boolean done;
        private volatile int numPutsFinished;
        private Throwable error;
        private int numRows;
        private byte[][] families;
        private byte[][] qualifiers;

        private PutThread(int numRows, byte[][] families, byte[][] qualifiers) {
            super("PutThread");
            this.numPutsFinished = 0;
            this.error = null;
            this.numRows = numRows;
            this.families = families;
            this.qualifiers = qualifiers;
        }

        public void waitForFirstPut() throws InterruptedException {
            while (this.isAlive() && this.numPutsFinished == 0) {
                this.checkNoError();
                Thread.sleep(50L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            PutThread putThread = this;
            synchronized (putThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        @Override
        public void run() {
            this.done = false;
            while (!this.done) {
                try {
                    for (int r = 0; r < this.numRows; ++r) {
                        byte[] row = Bytes.toBytes((String)("row" + r));
                        Put put = new Put(row);
                        put.setDurability(Durability.SKIP_WAL);
                        byte[] value = Bytes.toBytes((String)String.valueOf(this.numPutsFinished));
                        for (byte[] family : this.families) {
                            for (byte[] qualifier : this.qualifiers) {
                                put.addColumn(family, qualifier, (long)this.numPutsFinished, value);
                            }
                        }
                        TestHRegion.this.region.put(put);
                        ++this.numPutsFinished;
                        if (this.numPutsFinished > 0 && this.numPutsFinished % 47 == 0) {
                            System.out.println("put iteration = " + this.numPutsFinished);
                            Delete delete = new Delete(row, (long)this.numPutsFinished - 30L);
                            TestHRegion.this.region.delete(delete);
                        }
                        ++this.numPutsFinished;
                    }
                }
                catch (InterruptedIOException e) {
                    LOG.info("Interrupted", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Error while putting records", (Throwable)e);
                    this.error = e;
                    break;
                }
            }
        }
    }

    protected class FlushThread
    extends Thread {
        private volatile boolean done;
        private Throwable error;

        FlushThread() {
            super("FlushThread");
            this.error = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.done = false;
            while (!this.done) {
                FlushThread flushThread = this;
                synchronized (flushThread) {
                    block9: {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            if (!this.done) break block9;
                            break;
                        }
                    }
                }
                try {
                    TestHRegion.this.region.flush(true);
                }
                catch (IOException e) {
                    if (this.done) break;
                    LOG.error("Error while flushing cache", (Throwable)e);
                    this.error = e;
                    break;
                }
                catch (Throwable t) {
                    LOG.error("Uncaught exception", t);
                    throw t;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.notify();
            }
        }
    }

    class GetTillDoneOrException
    extends Thread {
        private final Get g;
        private final AtomicBoolean done;
        private final AtomicInteger count;
        private Exception e;

        GetTillDoneOrException(int i, byte[] r, AtomicBoolean d, AtomicInteger c) {
            super("getter." + i);
            this.g = new Get(r);
            this.done = d;
            this.count = c;
        }

        @Override
        public void run() {
            while (!this.done.get()) {
                try {
                    Assert.assertTrue((TestHRegion.this.region.get(this.g).size() > 0 ? 1 : 0) != 0);
                    this.count.incrementAndGet();
                }
                catch (Exception e) {
                    this.e = e;
                    break;
                }
            }
        }
    }

    static class IsFlushWALMarker
    implements ArgumentMatcher<WALEdit> {
        volatile WALProtos.FlushDescriptor.FlushAction[] actions;

        public IsFlushWALMarker(WALProtos.FlushDescriptor.FlushAction ... actions) {
            this.actions = actions;
        }

        public boolean matches(WALEdit edit) {
            ArrayList cells = edit.getCells();
            if (cells.isEmpty()) {
                return false;
            }
            if (WALEdit.isMetaEditFamily((Cell)((Cell)cells.get(0)))) {
                WALProtos.FlushDescriptor desc;
                try {
                    desc = WALEdit.getFlushDescriptor((Cell)((Cell)cells.get(0)));
                }
                catch (IOException e) {
                    LOG.warn(e.toString(), (Throwable)e);
                    return false;
                }
                if (desc != null) {
                    for (WALProtos.FlushDescriptor.FlushAction action : this.actions) {
                        if (desc.getAction() != action) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public IsFlushWALMarker set(WALProtos.FlushDescriptor.FlushAction ... actions) {
            this.actions = actions;
            return this;
        }
    }
}

