/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterFailoverWithProceduresTestBase;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDisableTableWithMasterFailover
extends MasterFailoverWithProceduresTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDisableTableWithMasterFailover.class);

    @Test
    public void testDisableTableWithFailover() throws Exception {
        this.testDisableTableWithFailoverAtStep(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_MARK_REGIONS_OFFLINE.ordinal());
    }

    private void testDisableTableWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testDisableTableWithFailoverAtStep" + step));
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(TestDisableTableWithMasterFailover.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        ProcedureExecutor<MasterProcedureEnv> procExec = TestDisableTableWithMasterFailover.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        TestDisableTableWithMasterFailover.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableIsDisabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }
}

