/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QueueBalancer;
import org.apache.hadoop.hbase.ipc.RWQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.RandomQueueBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={RPCTests.class, MediumTests.class})
public class TestRWQueueRpcExecutor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRWQueueRpcExecutor.class);
    @Rule
    public TestName testName = new TestName();
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.conf.setFloat("hbase.ipc.server.callqueue.handler.factor", 1.0f);
        this.conf.setFloat("hbase.ipc.server.callqueue.scan.ratio", 0.5f);
        this.conf.setFloat("hbase.ipc.server.callqueue.read.ratio", 0.5f);
    }

    @Test
    public void itProvidesCorrectQueuesToBalancers() throws InterruptedException {
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        RWQueueRpcExecutor executor = new RWQueueRpcExecutor(this.testName.getMethodName(), 100, 100, qosFunction, this.conf, null);
        QueueBalancer readBalancer = executor.getReadBalancer();
        QueueBalancer writeBalancer = executor.getWriteBalancer();
        QueueBalancer scanBalancer = executor.getScanBalancer();
        Assert.assertTrue((boolean)(readBalancer instanceof RandomQueueBalancer));
        Assert.assertTrue((boolean)(writeBalancer instanceof RandomQueueBalancer));
        Assert.assertTrue((boolean)(scanBalancer instanceof RandomQueueBalancer));
        List readQueues = ((RandomQueueBalancer)readBalancer).getQueues();
        List writeQueues = ((RandomQueueBalancer)writeBalancer).getQueues();
        List scanQueues = ((RandomQueueBalancer)scanBalancer).getQueues();
        Assert.assertEquals((long)25L, (long)readQueues.size());
        Assert.assertEquals((long)50L, (long)writeQueues.size());
        Assert.assertEquals((long)25L, (long)scanQueues.size());
        this.verifyDistinct(readQueues, writeQueues, scanQueues);
        this.verifyDistinct(writeQueues, readQueues, scanQueues);
        this.verifyDistinct(scanQueues, readQueues, writeQueues);
    }

    private void verifyDistinct(List<BlockingQueue<CallRunner>> queues, List<BlockingQueue<CallRunner>> ... others) throws InterruptedException {
        CallRunner mock = (CallRunner)Mockito.mock(CallRunner.class);
        for (BlockingQueue<CallRunner> blockingQueue : queues) {
            blockingQueue.put(mock);
            Assert.assertEquals((long)1L, (long)blockingQueue.size());
        }
        for (List<BlockingQueue<CallRunner>> other : others) {
            for (BlockingQueue<CallRunner> queue : other) {
                Assert.assertEquals((long)0L, (long)queue.size());
            }
        }
        for (BlockingQueue blockingQueue : queues) {
            blockingQueue.clear();
        }
    }
}

