/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestSplitOrMergeAtTableLevel {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitOrMergeAtTableLevel.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    @Rule
    public TestName name = new TestName();
    private static Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testTableSplitSwitch() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setSplitEnabled(false).build();
        Table t = TEST_UTIL.createTable(tableDesc, (byte[][])null);
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.loadTable(t, FAMILY, false);
        Assert.assertTrue((admin.getRegions(tableName).size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)admin.getDescriptor(tableName).isSplitEnabled());
        this.trySplitAndEnsureItFails(tableName);
        this.enableTableSplit(tableName);
        this.trySplitAndEnsureItIsSuccess(tableName);
    }

    @Test
    public void testTableSplitSwitchForPreSplittedTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setSplitEnabled(false).build();
        Table t = TEST_UTIL.createTable(tableDesc, (byte[][])new byte[][]{Bytes.toBytes((int)10)});
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.loadTable(t, FAMILY, false);
        Assert.assertTrue((admin.getRegions(tableName).size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)admin.getDescriptor(tableName).isSplitEnabled());
        this.trySplitAndEnsureItFails(tableName);
        this.enableTableSplit(tableName);
        this.trySplitAndEnsureItIsSuccess(tableName);
    }

    @Test
    public void testTableMergeSwitch() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setMergeEnabled(false).build();
        Table t = TEST_UTIL.createTable(tableDesc, (byte[][])null);
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.loadTable(t, FAMILY, false);
        Assert.assertFalse((boolean)admin.getDescriptor(tableName).isMergeEnabled());
        this.trySplitAndEnsureItIsSuccess(tableName);
        Threads.sleep((long)10000L);
        this.tryMergeAndEnsureItFails(tableName);
        admin.disableTable(tableName);
        this.enableTableMerge(tableName);
        admin.enableTable(tableName);
        this.tryMergeAndEnsureItIsSuccess(tableName);
    }

    @Test
    public void testTableMergeSwitchForPreSplittedTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setMergeEnabled(false).build();
        Table t = TEST_UTIL.createTable(tableDesc, (byte[][])new byte[][]{Bytes.toBytes((int)10)});
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.loadTable(t, FAMILY, false);
        Assert.assertFalse((boolean)admin.getDescriptor(tableName).isMergeEnabled());
        Assert.assertTrue((admin.getRegions(tableName).size() == 2 ? 1 : 0) != 0);
        this.tryMergeAndEnsureItFails(tableName);
        this.enableTableMerge(tableName);
        this.tryMergeAndEnsureItIsSuccess(tableName);
    }

    private void trySplitAndEnsureItFails(TableName tableName) throws Exception {
        List regions = admin.getRegions(tableName);
        int originalCount = regions.size();
        Future f = admin.splitRegionAsync(((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), Bytes.toBytes((int)2));
        try {
            f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Should not get here.");
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((admin.getRegions(tableName).size() == originalCount ? 1 : 0) != 0);
        }
    }

    private void enableTableSplit(TableName tableName) throws Exception {
        TableDescriptor originalTableDesc = admin.getDescriptor(tableName);
        TableDescriptor modifiedTableDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)originalTableDesc).setSplitEnabled(true).build();
        admin.modifyTable(modifiedTableDesc);
        Assert.assertTrue((boolean)admin.getDescriptor(tableName).isSplitEnabled());
    }

    private void trySplitAndEnsureItIsSuccess(final TableName tableName) throws Exception {
        List regions = admin.getRegions(tableName);
        final int originalCount = regions.size();
        admin.split(tableName, Bytes.toBytes((int)3));
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return admin.getRegions(tableName).size() > originalCount;
            }

            public String explainFailure() throws Exception {
                return "Split has not finished yet";
            }
        });
    }

    private void tryMergeAndEnsureItFails(TableName tableName) throws Exception {
        List regions = admin.getRegions(tableName);
        int originalCount = regions.size();
        Assert.assertTrue((originalCount >= 2 ? 1 : 0) != 0);
        byte[] nameOfRegionA = ((RegionInfo)regions.get(0)).getEncodedNameAsBytes();
        byte[] nameOfRegionB = ((RegionInfo)regions.get(1)).getEncodedNameAsBytes();
        Future f = admin.mergeRegionsAsync(nameOfRegionA, nameOfRegionB, true);
        try {
            f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Should not get here.");
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((admin.getRegions(tableName).size() == originalCount ? 1 : 0) != 0);
        }
    }

    private void enableTableMerge(TableName tableName) throws Exception {
        TableDescriptor originalTableDesc = admin.getDescriptor(tableName);
        TableDescriptor modifiedTableDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)originalTableDesc).setMergeEnabled(true).build();
        admin.modifyTable(modifiedTableDesc);
        Assert.assertTrue((boolean)admin.getDescriptor(tableName).isMergeEnabled());
    }

    private void tryMergeAndEnsureItIsSuccess(final TableName tableName) throws Exception {
        List regions = admin.getRegions(tableName);
        final int originalCount = regions.size();
        Assert.assertTrue((originalCount >= 2 ? 1 : 0) != 0);
        byte[] nameOfRegionA = ((RegionInfo)regions.get(0)).getEncodedNameAsBytes();
        byte[] nameOfRegionB = ((RegionInfo)regions.get(1)).getEncodedNameAsBytes();
        admin.mergeRegionsAsync(nameOfRegionA, nameOfRegionB, true);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return admin.getRegions(tableName).size() < originalCount;
            }

            public String explainFailure() throws Exception {
                return "Merge has not finished yet";
            }
        });
    }
}

