/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class, ClientTests.class})
public class TestResult {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestResult.class);
    private static final Logger LOG = LoggerFactory.getLogger((String)TestResult.class.getName());
    static final byte[] row = Bytes.toBytes((String)"row");
    static final byte[] family = Bytes.toBytes((String)"family");
    static final byte[] value = Bytes.toBytes((String)"value");
    static final byte[] qual = Bytes.toBytes((String)"qual");

    static KeyValue[] genKVs(byte[] row, byte[] family, byte[] value, long timestamp, int cols) {
        KeyValue[] kvs = new KeyValue[cols];
        for (int i = 0; i < cols; ++i) {
            kvs[i] = new KeyValue(row, family, Bytes.toBytes((int)i), timestamp, Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)));
        }
        return kvs;
    }

    @Test
    public void testResultAsCellScanner() throws IOException {
        KeyValue[] cells = TestResult.genKVs(row, family, value, 1L, 10);
        Arrays.sort(cells, CellComparator.getInstance());
        Result r = Result.create((Cell[])cells);
        this.assertSame((CellScanner)r, (Cell[])cells);
        this.assertSame(r.cellScanner(), (Cell[])cells);
        this.assertSame(r.cellScanner(), (Cell[])cells);
        Assert.assertTrue((r == r.cellScanner() ? 1 : 0) != 0);
    }

    private void assertSame(CellScanner cellScanner, Cell[] cells) throws IOException {
        int count = 0;
        while (cellScanner.advance()) {
            Assert.assertTrue((boolean)cells[count].equals(cellScanner.current()));
            ++count;
        }
        Assert.assertEquals((long)cells.length, (long)count);
    }

    @Test
    public void testBasicGetColumn() throws Exception {
        KeyValue[] kvs = TestResult.genKVs(row, family, value, 1L, 100);
        Arrays.sort(kvs, CellComparator.getInstance());
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            List ks = r.getColumnCells(family, qf);
            Assert.assertEquals((long)1L, (long)ks.size());
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)((Cell)ks.get(0)), (byte[])qf));
            Assert.assertEquals(ks.get(0), (Object)r.getColumnLatestCell(family, qf));
        }
    }

    @Test
    public void testCurrentOnEmptyCell() throws IOException {
        Result r = Result.create((Cell[])new Cell[0]);
        Assert.assertFalse((boolean)r.advance());
        Assert.assertNull((Object)r.current());
    }

    @Test
    public void testAdvanceMultipleOnEmptyCell() throws IOException {
        Result r = Result.create((Cell[])new Cell[0]);
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)r.advance());
        }
    }

    @Test
    public void testMultiVersionGetColumn() throws Exception {
        KeyValue[] kvs1 = TestResult.genKVs(row, family, value, 1L, 100);
        KeyValue[] kvs2 = TestResult.genKVs(row, family, value, 200L, 100);
        KeyValue[] kvs = new KeyValue[kvs1.length + kvs2.length];
        System.arraycopy(kvs1, 0, kvs, 0, kvs1.length);
        System.arraycopy(kvs2, 0, kvs, kvs1.length, kvs2.length);
        Arrays.sort(kvs, CellComparator.getInstance());
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            List ks = r.getColumnCells(family, qf);
            Assert.assertEquals((long)2L, (long)ks.size());
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)((Cell)ks.get(0)), (byte[])qf));
            Assert.assertEquals((long)200L, (long)((Cell)ks.get(0)).getTimestamp());
            Assert.assertEquals(ks.get(0), (Object)r.getColumnLatestCell(family, qf));
        }
    }

    @Test
    public void testBasicGetValue() throws Exception {
        KeyValue[] kvs = TestResult.genKVs(row, family, value, 1L, 100);
        Arrays.sort(kvs, CellComparator.getInstance());
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            Assert.assertArrayEquals((byte[])Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)), (byte[])r.getValue(family, qf));
            Assert.assertTrue((boolean)r.containsColumn(family, qf));
        }
    }

    @Test
    public void testMultiVersionGetValue() throws Exception {
        KeyValue[] kvs1 = TestResult.genKVs(row, family, value, 1L, 100);
        KeyValue[] kvs2 = TestResult.genKVs(row, family, value, 200L, 100);
        KeyValue[] kvs = new KeyValue[kvs1.length + kvs2.length];
        System.arraycopy(kvs1, 0, kvs, 0, kvs1.length);
        System.arraycopy(kvs2, 0, kvs, kvs1.length, kvs2.length);
        Arrays.sort(kvs, CellComparator.getInstance());
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            Assert.assertArrayEquals((byte[])Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)), (byte[])r.getValue(family, qf));
            Assert.assertTrue((boolean)r.containsColumn(family, qf));
        }
    }

    @Test
    public void testBasicLoadValue() throws Exception {
        KeyValue[] kvs = TestResult.genKVs(row, family, value, 1L, 100);
        Arrays.sort(kvs, CellComparator.getInstance());
        Result r = Result.create((Cell[])kvs);
        ByteBuffer loadValueBuffer = ByteBuffer.allocate(1024);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            loadValueBuffer.clear();
            r.loadValue(family, qf, loadValueBuffer);
            loadValueBuffer.flip();
            Assert.assertEquals((Object)loadValueBuffer, (Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))));
            Assert.assertEquals((Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))), (Object)r.getValueAsByteBuffer(family, qf));
        }
    }

    @Test
    public void testMultiVersionLoadValue() throws Exception {
        KeyValue[] kvs1 = TestResult.genKVs(row, family, value, 1L, 100);
        KeyValue[] kvs2 = TestResult.genKVs(row, family, value, 200L, 100);
        KeyValue[] kvs = new KeyValue[kvs1.length + kvs2.length];
        System.arraycopy(kvs1, 0, kvs, 0, kvs1.length);
        System.arraycopy(kvs2, 0, kvs, kvs1.length, kvs2.length);
        Arrays.sort(kvs, CellComparator.getInstance());
        ByteBuffer loadValueBuffer = ByteBuffer.allocate(1024);
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            loadValueBuffer.clear();
            r.loadValue(family, qf, loadValueBuffer);
            loadValueBuffer.flip();
            Assert.assertEquals((Object)loadValueBuffer, (Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))));
            Assert.assertEquals((Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))), (Object)r.getValueAsByteBuffer(family, qf));
        }
    }

    @Test
    public void testCompareResults() throws Exception {
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] qual = Bytes.toBytes((String)"qual");
        KeyValue kv1 = new KeyValue(row, family, qual, value);
        KeyValue kv2 = new KeyValue(row, family, qual, value1);
        Result r1 = Result.create((Cell[])new KeyValue[]{kv1});
        Result r2 = Result.create((Cell[])new KeyValue[]{kv2});
        Result.compareResults((Result)r1, (Result)r1);
        try {
            Result.compareResults((Result)r1, (Result)r2);
            Assert.fail();
        }
        catch (Exception x) {
            Assert.assertTrue((boolean)x.getMessage().startsWith("This result was different:"));
        }
    }

    @Test
    public void testCompareResultsWithTags() throws Exception {
        ArrayBackedTag t1 = new ArrayBackedTag(1, Bytes.toBytes((String)"TAG1"));
        ArrayBackedTag t2 = new ArrayBackedTag(2, Bytes.toBytes((String)"TAG2"));
        Result result1 = this.getByteBufferBackedTagResult(null);
        Result result2 = this.getByteBufferBackedTagResult(null);
        Result.compareResults((Result)result1, (Result)result2);
        result1 = this.getByteBufferBackedTagResult((Tag)t1);
        result2 = this.getByteBufferBackedTagResult((Tag)t1);
        Result.compareResults((Result)result1, (Result)result2);
        result1 = this.getArrayBackedTagResult(null);
        result2 = this.getArrayBackedTagResult(null);
        Result.compareResults((Result)result1, (Result)result2);
        result1 = this.getArrayBackedTagResult((Tag)t1);
        result2 = this.getArrayBackedTagResult((Tag)t1);
        Result.compareResults((Result)result1, (Result)result2);
        result1 = this.getByteBufferBackedTagResult((Tag)t1);
        result2 = this.getArrayBackedTagResult((Tag)t1);
        Result.compareResults((Result)result1, (Result)result2);
        result1 = this.getArrayBackedTagResult((Tag)t1);
        result2 = this.getByteBufferBackedTagResult((Tag)t1);
        Result.compareResults((Result)result1, (Result)result2);
        result1 = this.getByteBufferBackedTagResult(null);
        result2 = this.getByteBufferBackedTagResult((Tag)t2);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result1 = this.getByteBufferBackedTagResult((Tag)t1);
        result2 = this.getByteBufferBackedTagResult(null);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result1 = this.getByteBufferBackedTagResult((Tag)t1);
        result2 = this.getByteBufferBackedTagResult((Tag)t2);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result1 = this.getArrayBackedTagResult((Tag)t1);
        result2 = this.getArrayBackedTagResult(null);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result1 = this.getByteBufferBackedTagResult(null);
        result2 = this.getByteBufferBackedTagResult((Tag)t2);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result1 = this.getArrayBackedTagResult((Tag)t1);
        result2 = this.getArrayBackedTagResult((Tag)t2);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result1 = this.getByteBufferBackedTagResult((Tag)t1);
        result2 = this.getArrayBackedTagResult((Tag)t2);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result1 = this.getArrayBackedTagResult((Tag)t1);
        result2 = this.getByteBufferBackedTagResult((Tag)t2);
        try {
            Result.compareResults((Result)result1, (Result)result2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCompareResultMemoryUsage() {
        ArrayList<KeyValue> cells1 = new ArrayList<KeyValue>();
        for (long i = 0L; i < 100L; ++i) {
            cells1.add(new KeyValue(row, family, Bytes.toBytes((long)i), value));
        }
        ArrayList<KeyValue> cells2 = new ArrayList<KeyValue>();
        for (long i = 0L; i < 100L; ++i) {
            cells2.add(new KeyValue(row, family, Bytes.toBytes((long)i), Bytes.toBytes((long)i)));
        }
        Result r1 = Result.create(cells1);
        Result r2 = Result.create(cells2);
        try {
            Result.compareResults((Result)r1, (Result)r2);
            Assert.fail();
        }
        catch (Exception x) {
            Assert.assertTrue((boolean)x.getMessage().startsWith("This result was different:"));
            MatcherAssert.assertThat((Object)x.getMessage().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100)));
        }
        try {
            Result.compareResults((Result)r1, (Result)r2, (boolean)false);
            Assert.fail();
        }
        catch (Exception x) {
            Assert.assertEquals((Object)"This result was different: row=row", (Object)x.getMessage());
            MatcherAssert.assertThat((Object)x.getMessage().length(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(100)));
        }
    }

    private Result getArrayBackedTagResult(Tag tag) {
        List<Tag> tags = null;
        if (tag != null) {
            tags = Arrays.asList(tag);
        }
        KeyValue kvCell = new KeyValue(row, family, qual, 0L, KeyValue.Type.Put, value, tags);
        return Result.create((Cell[])new Cell[]{kvCell});
    }

    private Result getByteBufferBackedTagResult(Tag tag) {
        List<Tag> tags = null;
        if (tag != null) {
            tags = Arrays.asList(tag);
        }
        KeyValue kvCell = new KeyValue(row, family, qual, 0L, KeyValue.Type.Put, value, tags);
        ByteBuffer buf = ByteBuffer.allocateDirect(kvCell.getBuffer().length);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)buf, (byte[])kvCell.getBuffer(), (int)0, (int)kvCell.getBuffer().length);
        ByteBufferKeyValue bbKV = new ByteBufferKeyValue(buf, 0, buf.capacity(), 0L);
        return Result.create((Cell[])new Cell[]{bbKV});
    }

    @Test
    public void testEmptyResultIsReadonly() {
        Result emptyResult = Result.EMPTY_RESULT;
        Result otherResult = new Result();
        try {
            emptyResult.copyFrom(otherResult);
            Assert.fail((String)"UnsupportedOperationException should have been thrown!");
        }
        catch (UnsupportedOperationException ex) {
            LOG.debug("As expected: " + ex.getMessage());
        }
        try {
            emptyResult.setExists(Boolean.valueOf(true));
            Assert.fail((String)"UnsupportedOperationException should have been thrown!");
        }
        catch (UnsupportedOperationException ex) {
            LOG.debug("As expected: " + ex.getMessage());
        }
    }

    public void doReadBenchmark() throws Exception {
        int n = 5;
        int m = 100000000;
        StringBuilder valueSB = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            valueSB.append((byte)(Math.random() * 10.0));
        }
        StringBuilder rowSB = new StringBuilder();
        for (int i = 0; i < 50; ++i) {
            rowSB.append((byte)(Math.random() * 10.0));
        }
        KeyValue[] kvs = TestResult.genKVs(Bytes.toBytes((String)rowSB.toString()), family, Bytes.toBytes((String)valueSB.toString()), 1L, 5);
        Arrays.sort(kvs, CellComparator.getInstance());
        ByteBuffer loadValueBuffer = ByteBuffer.allocate(1024);
        Result r = Result.create((Cell[])kvs);
        byte[][] qfs = new byte[5][4];
        for (int i = 0; i < 5; ++i) {
            System.arraycopy(qfs[i], 0, Bytes.toBytes((int)i), 0, 4);
        }
        for (int k = 0; k < 100000; ++k) {
            for (int i = 0; i < 5; ++i) {
                r.getValue(family, qfs[i]);
                loadValueBuffer.clear();
                r.loadValue(family, qfs[i], loadValueBuffer);
                loadValueBuffer.flip();
            }
        }
        System.gc();
        long start = System.nanoTime();
        for (int k = 0; k < 100000000; ++k) {
            for (int i = 0; i < 5; ++i) {
                loadValueBuffer.clear();
                r.loadValue(family, qfs[i], loadValueBuffer);
                loadValueBuffer.flip();
            }
        }
        long stop = System.nanoTime();
        System.out.println("loadValue(): " + (stop - start));
        System.gc();
        start = System.nanoTime();
        for (int k = 0; k < 100000000; ++k) {
            for (int i = 0; i < 5; ++i) {
                r.getValue(family, qfs[i]);
            }
        }
        stop = System.nanoTime();
        System.out.println("getValue():  " + (stop - start));
    }

    public static void main(String[] args) {
        TestResult testResult = new TestResult();
        try {
            testResult.doReadBenchmark();
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
        }
    }
}

