/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMasterRegistry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegistry.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        StartMiniClusterOption.Builder builder = StartMiniClusterOption.builder();
        builder.numMasters(3).numRegionServers(3);
        TEST_UTIL.startMiniCluster(builder.build());
        HBaseTestingUtility.setReplicas(TEST_UTIL.getAdmin(), TableName.META_TABLE_NAME, 3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static String generateDummyMastersList(int size) {
        ArrayList<String> masters = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            masters.add(" localhost" + (i % 2 == 0 ? ":" + (1000 + i) : ""));
        }
        return String.join((CharSequence)",", masters);
    }

    @Test
    public void testMasterAddressParsing() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        int numMasters = 10;
        conf.set("hbase.masters", TestMasterRegistry.generateDummyMastersList(numMasters));
        try (MasterRegistry registry = new MasterRegistry(conf);){
            ArrayList parsedMasters = new ArrayList(registry.getParsedServers());
            Assert.assertEquals((long)(numMasters / 2 + 1), (long)parsedMasters.size());
            Collections.sort(parsedMasters, Comparator.comparingInt(ServerName::getPort));
            for (int i = 0; i < parsedMasters.size(); ++i) {
                ServerName sn = (ServerName)parsedMasters.get(i);
                Assert.assertEquals((Object)"localhost", (Object)sn.getHostname());
                if (i == parsedMasters.size() - 1) {
                    Assert.assertEquals((long)16000L, (long)sn.getPort());
                    continue;
                }
                Assert.assertEquals((long)(1000 + 2 * i), (long)sn.getPort());
            }
        }
    }

    @Test
    public void testMasterPortDefaults() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.masters", "localhost");
        try (MasterRegistry registry = new MasterRegistry(conf);){
            ArrayList parsedMasters = new ArrayList(registry.getParsedServers());
            ServerName sn = (ServerName)parsedMasters.get(0);
            Assert.assertEquals((long)16000L, (long)sn.getPort());
        }
        int CUSTOM_MASTER_PORT = 9999;
        conf.setInt("hbase.master.port", 9999);
        try (MasterRegistry registry = new MasterRegistry(conf);){
            ArrayList parsedMasters = new ArrayList(registry.getParsedServers());
            ServerName sn = (ServerName)parsedMasters.get(0);
            Assert.assertEquals((long)9999L, (long)sn.getPort());
        }
    }

    @Test
    public void testRegistryRPCs() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        HMaster activeMaster = TEST_UTIL.getHBaseCluster().getMaster();
        int size = ((List)activeMaster.getMetaRegionLocationCache().getMetaRegionLocations().get()).size();
        for (int numHedgedReqs = 1; numHedgedReqs <= size; ++numHedgedReqs) {
            conf.setInt("hbase.client.master_registry.hedged.fanout", numHedgedReqs);
            try (MasterRegistry registry = new MasterRegistry(conf);){
                RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(TEST_UTIL, (ConnectionRegistry)registry);
                Assert.assertEquals(registry.getClusterId().get(), (Object)activeMaster.getClusterId());
                Assert.assertEquals(registry.getActiveMaster().get(), (Object)activeMaster.getServerName());
                List<HRegionLocation> metaLocations = Arrays.asList(((RegionLocations)registry.getMetaRegionLocations().get()).getRegionLocations());
                List actualMetaLocations = (List)activeMaster.getMetaRegionLocationCache().getMetaRegionLocations().get();
                Collections.sort(metaLocations);
                Collections.sort(actualMetaLocations);
                Assert.assertEquals((Object)actualMetaLocations, metaLocations);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicMasterConfigurationRefresh() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        String currentMasterAddrs = (String)Preconditions.checkNotNull((Object)conf.get("hbase.masters"));
        HMaster activeMaster = TEST_UTIL.getHBaseCluster().getMaster();
        String clusterId = activeMaster.getClusterId();
        ServerName badServer = ServerName.valueOf((String)"localhost", (int)1234, (long)-1L);
        conf.set("hbase.masters", badServer.toShortString() + "," + currentMasterAddrs);
        conf.setInt("hbase.client.master_registry.hedged.fanout", 4);
        conf.setLong("hbase.client.master_registry.min_secs_between_refreshes", 0L);
        try (MasterRegistry registry = new MasterRegistry(conf);){
            Set masters = registry.getParsedServers();
            Assert.assertTrue((boolean)masters.contains(badServer));
            Assert.assertEquals(registry.getClusterId().get(), (Object)clusterId);
            TEST_UTIL.waitFor(5000L, () -> !registry.getParsedServers().equals(masters));
            Set newMasters = registry.getParsedServers();
            Assert.assertEquals((long)3L, (long)newMasters.size());
            Assert.assertFalse((boolean)newMasters.contains(badServer));
            activeMaster.stopMaster();
            TEST_UTIL.waitFor(10000L, () -> TEST_UTIL.getMiniHBaseCluster().getLiveMasterThreads().size() == 2);
            TEST_UTIL.getMiniHBaseCluster().waitForActiveAndReadyMaster(10000L);
            TEST_UTIL.waitFor(10000L, () -> ((Set)registry.getMasters().get()).size() == 2);
            TEST_UTIL.waitFor(20000L, () -> registry.getParsedServers().size() == 2);
            Set newMasters2 = registry.getParsedServers();
            Assert.assertEquals((long)2L, (long)newMasters2.size());
            Assert.assertFalse((boolean)newMasters2.contains(activeMaster.getServerName()));
        }
        finally {
            TEST_UTIL.getMiniHBaseCluster().startMaster();
        }
    }
}

