/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestCloneSnapshotFromClientCustomSFT
extends CloneSnapshotFromClientTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCloneSnapshotFromClientCustomSFT.class);
    public static final String CLONE_SFT = "FILE";

    @Test
    public void testCloneSnapshotWithCustomSFT() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + EnvironmentEdgeManager.currentTime()));
        this.admin.cloneSnapshot(Bytes.toString((byte[])this.snapshotName1), clonedTableName, false, CLONE_SFT);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot1Rows);
        TableDescriptor td = this.admin.getDescriptor(clonedTableName);
        Assert.assertEquals((Object)CLONE_SFT, (Object)td.getValue("hbase.store.file-tracker.impl"));
        TEST_UTIL.deleteTable(clonedTableName);
    }

    @Test
    public void testCloneSnapshotWithIncorrectCustomSFT() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)(this.getValidMethodName() + "-" + EnvironmentEdgeManager.currentTime()));
        IOException ioException = (IOException)Assert.assertThrows(IOException.class, () -> this.admin.cloneSnapshot(Bytes.toString((byte[])this.snapshotName1), clonedTableName, false, "IncorrectSFT"));
        Assert.assertEquals((Object)"java.lang.RuntimeException: java.lang.RuntimeException: java.lang.ClassNotFoundException: Class IncorrectSFT not found", (Object)ioException.getMessage());
    }
}

