/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.CatalogReplicaLoadBalanceSelector;
import org.apache.hadoop.hbase.client.CatalogReplicaLoadBalanceSelectorFactory;
import org.apache.hadoop.hbase.client.CatalogReplicaLoadBalanceSimpleSelector;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestCatalogReplicaLoadBalanceSimpleSelector {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCatalogReplicaLoadBalanceSimpleSelector.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCatalogReplicaLoadBalanceSimpleSelector.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NB_SERVERS = 4;
    private static int numOfMetaReplica = 3;
    private static AsyncConnectionImpl CONN;
    private static ConnectionRegistry registry;
    private static Admin admin;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(4);
        admin = TEST_UTIL.getAdmin();
        admin.balancerSwitch(false, true);
        HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, numOfMetaReplica);
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getMiniHBaseCluster().getRegions(TableName.META_TABLE_NAME).size() >= numOfMetaReplica);
        registry = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        CONN = new AsyncConnectionImpl(conf, registry, (String)registry.getClusterId().get(), User.getCurrent());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaChangeFromReplicaNoReplica() throws IOException, InterruptedException {
        String replicaSelectorClass = CONN.getConfiguration().get("hbase.locator.meta.replicas.mode.loadbalance.selector", CatalogReplicaLoadBalanceSimpleSelector.class.getName());
        CatalogReplicaLoadBalanceSelector metaSelector = CatalogReplicaLoadBalanceSelectorFactory.createSelector((String)replicaSelectorClass, (TableName)TableName.META_TABLE_NAME, (ChoreService)CONN.getChoreService(), () -> {
            int numOfReplicas = -1;
            try {
                RegionLocations metaLocations = (RegionLocations)TestCatalogReplicaLoadBalanceSimpleSelector.CONN.registry.getMetaRegionLocations().get(TestCatalogReplicaLoadBalanceSimpleSelector.CONN.connConf.getMetaReadRpcTimeoutNs(), TimeUnit.NANOSECONDS);
                numOfReplicas = metaLocations.size();
            }
            catch (Exception e) {
                LOG.error("Failed to get table {}'s region replication, ", (Object)TableName.META_TABLE_NAME, (Object)e);
            }
            return numOfReplicas;
        });
        int[] replicaIdCount = new int[numOfMetaReplica];
        IntStream.range(1, 100).forEach(i -> {
            int n = metaSelector.select(TableName.valueOf((String)"test"), HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT);
            replicaIdCount[n] = replicaIdCount[n] + 1;
        });
        IntStream.range(0, numOfMetaReplica).forEach(i -> Assert.assertNotEquals((long)replicaIdCount[i], (long)0L));
        HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, 1);
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getMiniHBaseCluster().getRegions(TableName.META_TABLE_NAME).size() == 1);
        CatalogReplicaLoadBalanceSelector metaSelectorWithNoReplica = CatalogReplicaLoadBalanceSelectorFactory.createSelector((String)replicaSelectorClass, (TableName)TableName.META_TABLE_NAME, (ChoreService)CONN.getChoreService(), () -> {
            int numOfReplicas = -1;
            try {
                RegionLocations metaLocations = (RegionLocations)TestCatalogReplicaLoadBalanceSimpleSelector.CONN.registry.getMetaRegionLocations().get(TestCatalogReplicaLoadBalanceSimpleSelector.CONN.connConf.getMetaReadRpcTimeoutNs(), TimeUnit.NANOSECONDS);
                numOfReplicas = metaLocations.size();
            }
            catch (Exception e) {
                LOG.error("Failed to get table {}'s region replication, ", (Object)TableName.META_TABLE_NAME, (Object)e);
            }
            return numOfReplicas;
        });
        Assert.assertEquals((long)metaSelectorWithNoReplica.select(TableName.valueOf((String)"test"), HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT), (long)0L);
    }
}

