/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.TableInfoModel;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.CacheControl;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionsResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(RegionsResource.class);
    static CacheControl cacheControl = new CacheControl();
    TableResource tableResource;

    public RegionsResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            List locs;
            TableName tableName = TableName.valueOf((String)this.tableResource.getName());
            if (!this.tableResource.exists()) {
                throw new TableNotFoundException(tableName);
            }
            TableInfoModel model = new TableInfoModel(tableName.getNameAsString());
            try (Connection connection = ConnectionFactory.createConnection((Configuration)this.servlet.getConfiguration());
                 RegionLocator locator = connection.getRegionLocator(tableName);){
                locs = locator.getAllRegionLocations();
            }
            for (HRegionLocation loc : locs) {
                RegionInfo hri = loc.getRegion();
                ServerName addr = loc.getServerName();
                model.add(new TableRegionModel(tableName.getNameAsString(), hri.getRegionId(), hri.getStartKey(), hri.getEndKey(), addr.getAddress().toString()));
            }
            Response.ResponseBuilder response = Response.ok((Object)model);
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (TableNotFoundException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

