/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategyUtils;
import org.apache.hadoop.hbase.hbtop.mode.RegionModeStrategy;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RegionServerModeStrategy
implements ModeStrategy {
    private final List<FieldInfo> fieldInfos = Arrays.asList(new FieldInfo(Field.REGION_SERVER, 0, true), new FieldInfo(Field.LONG_REGION_SERVER, 0, false), new FieldInfo(Field.REGION_COUNT, 7, true), new FieldInfo(Field.REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.READ_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND, 8, true), new FieldInfo(Field.WRITE_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.STORE_FILE_SIZE, 13, true), new FieldInfo(Field.UNCOMPRESSED_STORE_FILE_SIZE, 15, false), new FieldInfo(Field.NUM_STORE_FILES, 7, true), new FieldInfo(Field.MEM_STORE_SIZE, 11, true), new FieldInfo(Field.USED_HEAP_SIZE, 11, true), new FieldInfo(Field.MAX_HEAP_SIZE, 11, true));
    private final RegionModeStrategy regionModeStrategy = new RegionModeStrategy();

    RegionServerModeStrategy() {
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Field getDefaultSortField() {
        return Field.REQUEST_COUNT_PER_SECOND;
    }

    @Override
    public List<Record> getRecords(ClusterMetrics clusterMetrics, List<RecordFilter> pushDownFilters) {
        List<Record> records = this.regionModeStrategy.selectModeFieldsAndAddCountField(this.fieldInfos, this.regionModeStrategy.getRecords(clusterMetrics, pushDownFilters), Field.REGION_COUNT);
        Map<String, Record> retMap = ModeStrategyUtils.aggregateRecords(records, Field.LONG_REGION_SERVER).stream().collect(Collectors.toMap(r -> r.get((Object)Field.LONG_REGION_SERVER).asString(), r -> r));
        for (ServerMetrics sm : clusterMetrics.getLiveServerMetrics().values()) {
            Record record = retMap.get(sm.getServerName().getServerName());
            if (record == null) continue;
            Record newRecord = Record.builder().putAll(record).put(Field.USED_HEAP_SIZE, sm.getUsedHeapSize()).put(Field.MAX_HEAP_SIZE, sm.getMaxHeapSize()).build();
            retMap.put(sm.getServerName().getServerName(), newRecord);
        }
        return new ArrayList<Record>(retMap.values());
    }

    @Override
    public DrillDownInfo drillDown(Record selectedRecord) {
        List<RecordFilter> initialFilters = Collections.singletonList(RecordFilter.newBuilder(Field.REGION_SERVER).doubleEquals(selectedRecord.get((Object)Field.REGION_SERVER)));
        return new DrillDownInfo(Mode.REGION, initialFilters);
    }
}

