/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.resolver.dns;

import java.net.InetSocketAddress;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FastThreadLocal;

final class ThreadLocalNameServerAddressStream
implements DnsServerAddressStream {
    private final String hostname;
    private final DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private final FastThreadLocal<DnsServerAddressStream> threadLocal = new FastThreadLocal<DnsServerAddressStream>(){

        @Override
        protected DnsServerAddressStream initialValue() {
            return ThreadLocalNameServerAddressStream.this.dnsServerAddressStreamProvider.nameServerAddressStream(ThreadLocalNameServerAddressStream.this.hostname);
        }
    };

    ThreadLocalNameServerAddressStream(DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this(dnsServerAddressStreamProvider, "");
    }

    ThreadLocalNameServerAddressStream(DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String hostname) {
        this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
        this.hostname = hostname;
    }

    @Override
    public InetSocketAddress next() {
        return this.threadLocal.get().next();
    }

    @Override
    public DnsServerAddressStream duplicate() {
        return new ThreadLocalNameServerAddressStream(this.dnsServerAddressStreamProvider, this.hostname);
    }

    @Override
    public int size() {
        return this.threadLocal.get().size();
    }
}

