/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKMetadata {
    private static final byte MAGIC = -1;
    private static final int MAGIC_SIZE = 1;
    private static final int ID_LENGTH_OFFSET = 1;
    private static final int ID_LENGTH_SIZE = 4;

    private ZKMetadata() {
    }

    public static byte[] appendMetaData(byte[] id, byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte[] salt = Bytes.toBytes(ThreadLocalRandom.current().nextLong());
        int idLength = id.length + salt.length;
        byte[] newData = new byte[5 + idLength + data.length];
        int pos = 0;
        pos = Bytes.putByte(newData, pos, (byte)-1);
        pos = Bytes.putInt(newData, pos, idLength);
        pos = Bytes.putBytes(newData, pos, id, 0, id.length);
        pos = Bytes.putBytes(newData, pos, salt, 0, salt.length);
        Bytes.putBytes(newData, pos, data, 0, data.length);
        return newData;
    }

    public static byte[] removeMetaData(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte magic = data[0];
        if (magic != -1) {
            return data;
        }
        int idLength = Bytes.toInt(data, 1);
        int dataLength = data.length - 1 - 4 - idLength;
        int dataOffset = 5 + idLength;
        byte[] newData = new byte[dataLength];
        System.arraycopy(data, dataOffset, newData, 0, dataLength);
        return newData;
    }
}

