/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSHLogProvider
extends AbstractFSWALProvider<FSHLog> {
    private static final Logger LOG = LoggerFactory.getLogger(FSHLogProvider.class);

    public static Writer createWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable) throws IOException {
        return FSHLogProvider.createWriter(conf, fs, path, overwritable, WALUtil.getWALBlockSize(conf, fs, path, overwritable));
    }

    public static Writer createWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable, long blocksize) throws IOException {
        Class logWriterClass = conf.getClass("hbase.regionserver.hlog.writer.impl", ProtobufLogWriter.class, Writer.class);
        Writer writer = null;
        try {
            writer = (Writer)logWriterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            FileSystem rootFs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
            writer.init(rootFs, path, conf, overwritable, blocksize, StreamSlowMonitor.create(conf, path.getName()));
            return writer;
        }
        catch (Exception e) {
            if (e instanceof CommonFSUtils.StreamLacksCapabilityException) {
                LOG.error("The RegionServer write ahead log provider for FileSystem implementations relies on the ability to call " + e.getMessage() + " for proper operation during component failures, but the current FileSystem does not support doing so. Please check the config value of '" + "hbase.wal.dir" + "' and ensure it points to a FileSystem mount that has suitable capabilities for output streams.");
            } else {
                LOG.debug("Error instantiating log writer.", (Throwable)e);
            }
            throw new IOException("cannot get log writer", e);
        }
    }

    @Override
    protected FSHLog createWAL() throws IOException {
        return new FSHLog(CommonFSUtils.getWALFileSystem(this.conf), this.abortable, CommonFSUtils.getWALRootDir(this.conf), FSHLogProvider.getWALDirectoryName(this.factory.factoryId), FSHLogProvider.getWALArchiveDirectoryName(this.conf, this.factory.factoryId), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null);
    }

    @Override
    protected void doInit(Configuration conf) throws IOException {
    }

    public static interface Writer
    extends WALProvider.Writer {
        public void init(FileSystem var1, Path var2, Configuration var3, boolean var4, long var5, StreamSlowMonitor var7) throws IOException, CommonFSUtils.StreamLacksCapabilityException;
    }
}

