/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.nio;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.Selector;
import org.apache.hadoop.hbase.shaded.org.agrona.LangUtil;
import org.apache.hadoop.hbase.shaded.org.agrona.nio.NioSelectedKeySet;

public class TransportPoller
implements AutoCloseable {
    public static final String ITERATION_THRESHOLD_PROP_NAME = "org.apache.hadoop.hbase.shaded.org.agrona.transport.iteration.threshold";
    public static final int ITERATION_THRESHOLD_DEFAULT = 5;
    public static final int ITERATION_THRESHOLD = Integer.getInteger("org.apache.hadoop.hbase.shaded.org.agrona.transport.iteration.threshold", 5);
    protected static final Field SELECTED_KEYS_FIELD;
    protected static final Field PUBLIC_SELECTED_KEYS_FIELD;
    private static final String SELECTOR_IMPL = "sun.nio.ch.SelectorImpl";
    protected final NioSelectedKeySet selectedKeySet = new NioSelectedKeySet();
    protected final Selector selector;

    public TransportPoller() {
        try {
            this.selector = Selector.open();
            SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
            PUBLIC_SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        this.selector.wakeup();
        try {
            this.selector.close();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public void selectNowWithoutProcessing() {
        try {
            this.selector.selectNow();
            this.selectedKeySet.clear();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    static {
        Field selectKeysField = null;
        Field publicSelectKeysField = null;
        try {
            Class<?> clazz = Class.forName(SELECTOR_IMPL, false, ClassLoader.getSystemClassLoader());
            if (clazz.isAssignableFrom(Selector.open().getClass())) {
                selectKeysField = clazz.getDeclaredField("selectedKeys");
                selectKeysField.setAccessible(true);
                publicSelectKeysField = clazz.getDeclaredField("publicSelectedKeys");
                publicSelectKeysField.setAccessible(true);
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        finally {
            SELECTED_KEYS_FIELD = selectKeysField;
            PUBLIC_SELECTED_KEYS_FIELD = publicSelectKeysField;
        }
    }
}

