/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.IteratorUtils;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.DiagnosticsCollector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSortingManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PendingAskUpdateResult;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppPlacementAllocator<N extends SchedulerNode> {
    protected AppSchedulingInfo appSchedulingInfo;
    protected SchedulerRequestKey schedulerRequestKey;
    protected RMContext rmContext;
    private AtomicInteger placementAttempt = new AtomicInteger(0);
    private MultiNodeSortingManager<N> multiNodeSortingManager = null;
    private String multiNodeSortPolicyName;
    private static final Logger LOG = LoggerFactory.getLogger(AppPlacementAllocator.class);

    public Iterator<N> getPreferredNodeIterator(CandidateNodeSet<N> candidateNodeSet) {
        N singleNode = CandidateNodeSetUtils.getSingleNode(candidateNodeSet);
        if (singleNode != null) {
            return IteratorUtils.singletonIterator(singleNode);
        }
        return this.multiNodeSortingManager.getMultiNodeSortIterator(candidateNodeSet.getAllNodes().values(), candidateNodeSet.getPartition(), this.multiNodeSortPolicyName);
    }

    public abstract PendingAskUpdateResult updatePendingAsk(Collection<ResourceRequest> var1, boolean var2);

    public abstract PendingAskUpdateResult updatePendingAsk(SchedulerRequestKey var1, SchedulingRequest var2, boolean var3);

    public abstract Map<String, ResourceRequest> getResourceRequests();

    public abstract PendingAsk getPendingAsk(String var1);

    public abstract int getOutstandingAsksCount(String var1);

    public abstract ContainerRequest allocate(SchedulerRequestKey var1, NodeType var2, SchedulerNode var3);

    public abstract boolean canAllocate(NodeType var1, SchedulerNode var2);

    public abstract boolean canDelayTo(String var1);

    public abstract boolean precheckNode(SchedulerNode var1, SchedulingMode var2, Optional<DiagnosticsCollector> var3);

    public abstract boolean precheckNode(SchedulerNode var1, SchedulingMode var2);

    public abstract String getPrimaryRequestedNodePartition();

    public abstract int getUniqueLocationAsks();

    public abstract void showRequests();

    public void initialize(AppSchedulingInfo appSchedulingInfo, SchedulerRequestKey schedulerRequestKey, RMContext rmContext) {
        this.appSchedulingInfo = appSchedulingInfo;
        this.rmContext = rmContext;
        this.schedulerRequestKey = schedulerRequestKey;
        this.multiNodeSortPolicyName = appSchedulingInfo.getApplicationSchedulingEnvs().get("MULTI_NODE_SORTING_POLICY_CLASS");
        this.multiNodeSortingManager = rmContext.getMultiNodeSortingManager();
        if (LOG.isDebugEnabled()) {
            LOG.debug("nodeLookupPolicy used for " + appSchedulingInfo.getApplicationId() + " is " + (this.multiNodeSortPolicyName != null ? this.multiNodeSortPolicyName : ""));
        }
    }

    public abstract SchedulingRequest getSchedulingRequest();

    public int getPlacementAttempt() {
        return this.placementAttempt.get();
    }

    public void incrementPlacementAttempt() {
        this.placementAttempt.getAndIncrement();
    }
}

