/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.HBaseServiceHandler;
import org.apache.hadoop.hbase.thrift.IncrementCoalescer;
import org.apache.hadoop.hbase.thrift.ThriftUtilities;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.BatchMutation;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TAppend;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TIncrement;
import org.apache.hadoop.hbase.thrift.generated.TRegionInfo;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.thrift.generated.TScan;
import org.apache.hadoop.hbase.thrift.generated.TThriftServerType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.thrift.TException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ThriftHBaseServiceHandler
extends HBaseServiceHandler
implements Hbase.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftHBaseServiceHandler.class);
    public static final int HREGION_VERSION = 1;
    private int nextScannerId = 0;
    private Cache<Integer, ResultScannerWrapper> scannerMap;
    IncrementCoalescer coalescer;

    byte[][] getAllColumns(Table table) throws IOException {
        HColumnDescriptor[] cds = table.getTableDescriptor().getColumnFamilies();
        byte[][] columns = new byte[cds.length][];
        for (int i = 0; i < cds.length; ++i) {
            columns[i] = Bytes.add((byte[])cds[i].getName(), (byte[])KeyValue.COLUMN_FAMILY_DELIM_ARRAY);
        }
        return columns;
    }

    protected synchronized int addScanner(ResultScanner scanner, boolean sortColumns) {
        int id = this.nextScannerId++;
        ResultScannerWrapper resultScannerWrapper = new ResultScannerWrapper(scanner, sortColumns);
        this.scannerMap.put((Object)id, (Object)resultScannerWrapper);
        return id;
    }

    private synchronized ResultScannerWrapper getScanner(int id) {
        return (ResultScannerWrapper)this.scannerMap.getIfPresent((Object)id);
    }

    private synchronized void removeScanner(int id) {
        this.scannerMap.invalidate((Object)id);
    }

    protected ThriftHBaseServiceHandler(Configuration c, UserProvider userProvider) throws IOException {
        super(c, userProvider);
        long cacheTimeout = c.getLong("hbase.client.scanner.timeout.period", 60000L) * 2L;
        this.scannerMap = CacheBuilder.newBuilder().expireAfterAccess(cacheTimeout, TimeUnit.MILLISECONDS).build();
        this.coalescer = new IncrementCoalescer(this);
    }

    @Override
    public void enableTable(ByteBuffer tableName) throws IOError {
        try {
            this.getAdmin().enableTable(ThriftHBaseServiceHandler.getTableName(tableName));
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public void disableTable(ByteBuffer tableName) throws IOError {
        try {
            this.getAdmin().disableTable(ThriftHBaseServiceHandler.getTableName(tableName));
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public boolean isTableEnabled(ByteBuffer tableName) throws IOError {
        try {
            return this.connectionCache.getAdmin().isTableEnabled(ThriftHBaseServiceHandler.getTableName(tableName));
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public Map<ByteBuffer, Boolean> getTableNamesWithIsTableEnabled() throws IOError {
        try {
            HashMap<ByteBuffer, Boolean> tables = new HashMap<ByteBuffer, Boolean>();
            for (ByteBuffer tableName : this.getTableNames()) {
                tables.put(tableName, this.isTableEnabled(tableName));
            }
            return tables;
        }
        catch (IOError e) {
            LOG.warn(e.getMessage(), (Throwable)((Object)e));
            throw ThriftHBaseServiceHandler.getIOError((Throwable)((Object)e));
        }
    }

    @Override
    public void compact(ByteBuffer tableNameOrRegionName) throws IOError {
        try {
            try {
                this.getAdmin().compactRegion(Bytes.getBytes((ByteBuffer)tableNameOrRegionName));
            }
            catch (IllegalArgumentException e) {
                this.getAdmin().compact(TableName.valueOf((byte[])Bytes.getBytes((ByteBuffer)tableNameOrRegionName)));
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public void majorCompact(ByteBuffer tableNameOrRegionName) throws IOError {
        try {
            try {
                this.getAdmin().compactRegion(Bytes.getBytes((ByteBuffer)tableNameOrRegionName));
            }
            catch (IllegalArgumentException e) {
                this.getAdmin().compact(TableName.valueOf((byte[])Bytes.getBytes((ByteBuffer)tableNameOrRegionName)));
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public List<ByteBuffer> getTableNames() throws IOError {
        try {
            TableName[] tableNames = this.getAdmin().listTableNames();
            ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(tableNames.length);
            for (TableName tableName : tableNames) {
                list.add(ByteBuffer.wrap(tableName.getName()));
            }
            return list;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TRegionInfo> getTableRegions(ByteBuffer tableName) throws IOError {
        try (RegionLocator locator = this.connectionCache.getRegionLocator(Bytes.getBytes((ByteBuffer)tableName));){
            List regionLocations = locator.getAllRegionLocations();
            ArrayList<TRegionInfo> results = new ArrayList<TRegionInfo>(regionLocations.size());
            for (HRegionLocation regionLocation : regionLocations) {
                HRegionInfo info = regionLocation.getRegionInfo();
                ServerName serverName = regionLocation.getServerName();
                TRegionInfo region = new TRegionInfo();
                region.serverName = ByteBuffer.wrap(Bytes.toBytes((String)serverName.getHostname()));
                region.port = serverName.getPort();
                region.startKey = ByteBuffer.wrap(info.getStartKey());
                region.endKey = ByteBuffer.wrap(info.getEndKey());
                region.id = info.getRegionId();
                region.name = ByteBuffer.wrap(info.getRegionName());
                region.version = 1;
                results.add(region);
            }
            ArrayList<TRegionInfo> arrayList = results;
            return arrayList;
        }
        catch (TableNotFoundException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public List<TCell> get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
        if (famAndQf.length == 1) {
            return this.get(tableName, row, famAndQf[0], null, attributes);
        }
        if (famAndQf.length == 2) {
            return this.get(tableName, row, famAndQf[0], famAndQf[1], attributes);
        }
        throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
    }

    protected List<TCell> get(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)get2, attributes);
            if (qualifier == null) {
                get2.addFamily(family);
            } else {
                get2.addColumn(family, qualifier);
            }
            Result result = table.get(get2);
            List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
            return list;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
        if (famAndQf.length == 1) {
            return this.getVer(tableName, row, famAndQf[0], null, numVersions, attributes);
        }
        if (famAndQf.length == 2) {
            return this.getVer(tableName, row, famAndQf[0], famAndQf[1], numVersions, attributes);
        }
        throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
    }

    public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)get2, attributes);
            if (null == qualifier) {
                get2.addFamily(family);
            } else {
                get2.addColumn(family, qualifier);
            }
            get2.setMaxVersions(numVersions);
            Result result = table.get(get2);
            List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
            return list;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
        if (famAndQf.length == 1) {
            return this.getVerTs(tableName, row, famAndQf[0], null, timestamp, numVersions, attributes);
        }
        if (famAndQf.length == 2) {
            return this.getVerTs(tableName, row, famAndQf[0], famAndQf[1], timestamp, numVersions, attributes);
        }
        throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
    }

    protected List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, long timestamp, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)get2, attributes);
            if (null == qualifier) {
                get2.addFamily(family);
            } else {
                get2.addColumn(family, qualifier);
            }
            get2.setTimeRange(0L, timestamp);
            get2.setMaxVersions(numVersions);
            Result result = table.get(get2);
            List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
            return list;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public List<TRowResult> getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        return this.getRowWithColumnsTs(tableName, row, null, Long.MAX_VALUE, attributes);
    }

    @Override
    public List<TRowResult> getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        return this.getRowWithColumnsTs(tableName, row, columns, Long.MAX_VALUE, attributes);
    }

    @Override
    public List<TRowResult> getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        return this.getRowWithColumnsTs(tableName, row, null, timestamp, attributes);
    }

    @Override
    public List<TRowResult> getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            if (columns == null) {
                Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
                ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)get2, attributes);
                get2.setTimeRange(0L, timestamp);
                Result result = table.get(get2);
                List<TRowResult> list = ThriftUtilities.rowResultFromHBase(result);
                return list;
            }
            Get get3 = new Get(Bytes.getBytes((ByteBuffer)row));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)get3, attributes);
            for (ByteBuffer column : columns) {
                byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                if (famAndQf.length == 1) {
                    get3.addFamily(famAndQf[0]);
                    continue;
                }
                get3.addColumn(famAndQf[0], famAndQf[1]);
            }
            get3.setTimeRange(0L, timestamp);
            Result result = table.get(get3);
            List<TRowResult> list = ThriftUtilities.rowResultFromHBase(result);
            return list;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public List<TRowResult> getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        return this.getRowsWithColumnsTs(tableName, rows, null, Long.MAX_VALUE, attributes);
    }

    @Override
    public List<TRowResult> getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        return this.getRowsWithColumnsTs(tableName, rows, columns, Long.MAX_VALUE, attributes);
    }

    @Override
    public List<TRowResult> getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        return this.getRowsWithColumnsTs(tableName, rows, null, timestamp, attributes);
    }

    @Override
    public List<TRowResult> getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            ArrayList<Get> gets = new ArrayList<Get>(rows.size());
            table = this.getTable(tableName);
            if (this.metrics != null) {
                this.metrics.incNumRowKeysInBatchGet(rows.size());
            }
            for (ByteBuffer row : rows) {
                Get get2 = new Get(Bytes.getBytes((ByteBuffer)row));
                ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)get2, attributes);
                if (columns != null) {
                    for (ByteBuffer column : columns) {
                        byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                        if (famAndQf.length == 1) {
                            get2.addFamily(famAndQf[0]);
                            continue;
                        }
                        get2.addColumn(famAndQf[0], famAndQf[1]);
                    }
                }
                get2.setTimeRange(0L, timestamp);
                gets.add(get2);
            }
            Result[] result = table.get(gets);
            List<TRowResult> list = ThriftUtilities.rowResultFromHBase(result);
            this.closeTable(table);
            return list;
        }
        catch (IOException e) {
            try {
                LOG.warn(e.getMessage(), (Throwable)e);
                throw ThriftHBaseServiceHandler.getIOError(e);
            }
            catch (Throwable throwable) {
                this.closeTable(table);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        this.deleteAllTs(tableName, row, column, Long.MAX_VALUE, attributes);
    }

    @Override
    public void deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Delete delete = new Delete(Bytes.getBytes((ByteBuffer)row));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)delete, attributes);
            byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
            if (famAndQf.length == 1) {
                delete.addFamily(famAndQf[0], timestamp);
            } else {
                delete.addColumns(famAndQf[0], famAndQf[1], timestamp);
            }
            table.delete(delete);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public void deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        this.deleteAllRowTs(tableName, row, Long.MAX_VALUE, attributes);
    }

    @Override
    public void deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Delete delete = new Delete(Bytes.getBytes((ByteBuffer)row), timestamp);
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)delete, attributes);
            table.delete(delete);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public void createTable(ByteBuffer in_tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists {
        TableName tableName = ThriftHBaseServiceHandler.getTableName(in_tableName);
        try {
            if (this.getAdmin().tableExists(tableName)) {
                throw new AlreadyExists("table name already in use");
            }
            HTableDescriptor desc = new HTableDescriptor(tableName);
            for (ColumnDescriptor col : columnFamilies) {
                HColumnDescriptor colDesc = ThriftUtilities.colDescFromThrift(col);
                desc.addFamily(colDesc);
            }
            this.getAdmin().createTable((TableDescriptor)desc);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private static TableName getTableName(ByteBuffer buffer) {
        return TableName.valueOf((byte[])Bytes.getBytes((ByteBuffer)buffer));
    }

    @Override
    public void deleteTable(ByteBuffer in_tableName) throws IOError {
        TableName tableName = ThriftHBaseServiceHandler.getTableName(in_tableName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("deleteTable: table={}", (Object)tableName);
        }
        try {
            if (!this.getAdmin().tableExists(tableName)) {
                throw new IOException("table does not exist");
            }
            this.getAdmin().deleteTable(tableName);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public void mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument {
        this.mutateRowTs(tableName, row, mutations, Long.MAX_VALUE, attributes);
    }

    @Override
    public void mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Put put2 = new Put(Bytes.getBytes((ByteBuffer)row), timestamp);
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)put2, attributes);
            Delete delete = new Delete(Bytes.getBytes((ByteBuffer)row));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)delete, attributes);
            if (this.metrics != null) {
                this.metrics.incNumRowKeysInBatchMutate(mutations.size());
            }
            CellBuilder builder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
            for (Mutation m : mutations) {
                byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)m.column));
                if (m.isDelete) {
                    if (famAndQf.length == 1) {
                        delete.addFamily(famAndQf[0], timestamp);
                    } else {
                        delete.addColumns(famAndQf[0], famAndQf[1], timestamp);
                    }
                    delete.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                    continue;
                }
                if (famAndQf.length == 1) {
                    LOG.warn("No column qualifier specified. Delete is the only mutation supported over the whole column family.");
                } else {
                    put2.add(builder.clear().setRow(put2.getRow()).setFamily(famAndQf[0]).setQualifier(famAndQf[1]).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(m.value != null ? Bytes.getBytes((ByteBuffer)m.value) : HConstants.EMPTY_BYTE_ARRAY).build());
                }
                put2.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            }
            if (!delete.isEmpty()) {
                table.delete(delete);
            }
            if (!put2.isEmpty()) {
                table.put(put2);
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public void mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
        this.mutateRowsTs(tableName, rowBatches, Long.MAX_VALUE, attributes);
    }

    @Override
    public void mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
        ArrayList<Put> puts = new ArrayList<Put>();
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        CellBuilder builder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
        for (BatchMutation batch : rowBatches) {
            byte[] row = Bytes.getBytes((ByteBuffer)batch.row);
            List<Mutation> mutations = batch.mutations;
            Delete delete = new Delete(row);
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)delete, attributes);
            Put put2 = new Put(row, timestamp);
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)put2, attributes);
            for (Mutation m : mutations) {
                byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)m.column));
                if (m.isDelete) {
                    if (famAndQf.length == 1) {
                        delete.addFamily(famAndQf[0], timestamp);
                    } else {
                        delete.addColumns(famAndQf[0], famAndQf[1], timestamp);
                    }
                    delete.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                    continue;
                }
                if (famAndQf.length == 1) {
                    LOG.warn("No column qualifier specified. Delete is the only mutation supported over the whole column family.");
                }
                if (famAndQf.length == 2) {
                    try {
                        put2.add(builder.clear().setRow(put2.getRow()).setFamily(famAndQf[0]).setQualifier(famAndQf[1]).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(m.value != null ? Bytes.getBytes((ByteBuffer)m.value) : HConstants.EMPTY_BYTE_ARRAY).build());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid famAndQf provided.");
                }
                put2.setDurability(m.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            }
            if (!delete.isEmpty()) {
                deletes.add(delete);
            }
            if (put2.isEmpty()) continue;
            puts.add(put2);
        }
        Table table = null;
        try {
            table = this.getTable(tableName);
            if (!puts.isEmpty()) {
                table.put(puts);
            }
            if (!deletes.isEmpty()) {
                table.delete(deletes);
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public long atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long amount) throws IOError, IllegalArgument, TException {
        byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
        if (famAndQf.length == 1) {
            return this.atomicIncrement(tableName, row, famAndQf[0], HConstants.EMPTY_BYTE_ARRAY, amount);
        }
        return this.atomicIncrement(tableName, row, famAndQf[0], famAndQf[1], amount);
    }

    protected long atomicIncrement(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, long amount) throws IOError, IllegalArgument, TException {
        Table table = null;
        try {
            table = this.getTable(tableName);
            long l = table.incrementColumnValue(Bytes.getBytes((ByteBuffer)row), family, qualifier, amount);
            return l;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public void scannerClose(int id) throws IOError, IllegalArgument {
        LOG.debug("scannerClose: id={}", (Object)id);
        ResultScannerWrapper resultScannerWrapper = this.getScanner(id);
        if (resultScannerWrapper == null) {
            LOG.warn("scanner ID is invalid");
            throw new IllegalArgument("scanner ID is invalid");
        }
        resultScannerWrapper.getScanner().close();
        this.removeScanner(id);
    }

    @Override
    public List<TRowResult> scannerGetList(int id, int nbRows) throws IllegalArgument, IOError {
        Result[] results;
        LOG.debug("scannerGetList: id={}", (Object)id);
        ResultScannerWrapper resultScannerWrapper = this.getScanner(id);
        if (null == resultScannerWrapper) {
            String message = "scanner ID is invalid";
            LOG.warn(message);
            throw new IllegalArgument("scanner ID is invalid");
        }
        try {
            results = resultScannerWrapper.getScanner().next(nbRows);
            if (null == results) {
                ArrayList<TRowResult> arrayList = new ArrayList<TRowResult>();
                return arrayList;
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.scannerMap.put((Object)id, (Object)resultScannerWrapper);
        }
        return ThriftUtilities.rowResultFromHBase(results, resultScannerWrapper.isColumnSorted());
    }

    @Override
    public List<TRowResult> scannerGet(int id) throws IllegalArgument, IOError {
        return this.scannerGetList(id, 1);
    }

    @Override
    public int scannerOpenWithScan(ByteBuffer tableName, TScan tScan, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Scan scan = new Scan();
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)scan, attributes);
            if (tScan.isSetStartRow()) {
                scan.setStartRow(tScan.getStartRow());
            }
            if (tScan.isSetStopRow()) {
                scan.setStopRow(tScan.getStopRow());
            }
            if (tScan.isSetTimestamp()) {
                scan.setTimeRange(0L, tScan.getTimestamp());
            }
            if (tScan.isSetCaching()) {
                scan.setCaching(tScan.getCaching());
            }
            if (tScan.isSetBatchSize()) {
                scan.setBatch(tScan.getBatchSize());
            }
            if (tScan.isSetColumns() && !tScan.getColumns().isEmpty()) {
                for (ByteBuffer column : tScan.getColumns()) {
                    byte[][] famQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                    if (famQf.length == 1) {
                        scan.addFamily(famQf[0]);
                        continue;
                    }
                    scan.addColumn(famQf[0], famQf[1]);
                }
            }
            if (tScan.isSetFilterString()) {
                ParseFilter parseFilter = new ParseFilter();
                scan.setFilter(parseFilter.parseFilterString(tScan.getFilterString()));
            }
            if (tScan.isSetReversed()) {
                scan.setReversed(tScan.isReversed());
            }
            if (tScan.isSetCacheBlocks()) {
                scan.setCacheBlocks(tScan.isCacheBlocks());
            }
            int n = this.addScanner(table.getScanner(scan), tScan.sortColumns);
            return n;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public int scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)scan, attributes);
            if (columns != null && !columns.isEmpty()) {
                for (ByteBuffer column : columns) {
                    byte[][] famQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                    if (famQf.length == 1) {
                        scan.addFamily(famQf[0]);
                        continue;
                    }
                    scan.addColumn(famQf[0], famQf[1]);
                }
            }
            int n = this.addScanner(table.getScanner(scan), false);
            return n;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public int scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow), Bytes.getBytes((ByteBuffer)stopRow));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)scan, attributes);
            if (columns != null && !columns.isEmpty()) {
                for (ByteBuffer column : columns) {
                    byte[][] famQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                    if (famQf.length == 1) {
                        scan.addFamily(famQf[0]);
                        continue;
                    }
                    scan.addColumn(famQf[0], famQf[1]);
                }
            }
            int n = this.addScanner(table.getScanner(scan), false);
            return n;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public int scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startAndPrefix));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)scan, attributes);
            WhileMatchFilter f = new WhileMatchFilter((Filter)new PrefixFilter(Bytes.getBytes((ByteBuffer)startAndPrefix)));
            scan.setFilter((Filter)f);
            if (columns != null && !columns.isEmpty()) {
                for (ByteBuffer column : columns) {
                    byte[][] famQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                    if (famQf.length == 1) {
                        scan.addFamily(famQf[0]);
                        continue;
                    }
                    scan.addColumn(famQf[0], famQf[1]);
                }
            }
            int n = this.addScanner(table.getScanner(scan), false);
            return n;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public int scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)scan, attributes);
            scan.setTimeRange(0L, timestamp);
            if (columns != null && !columns.isEmpty()) {
                for (ByteBuffer column : columns) {
                    byte[][] famQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                    if (famQf.length == 1) {
                        scan.addFamily(famQf[0]);
                        continue;
                    }
                    scan.addColumn(famQf[0], famQf[1]);
                }
            }
            int n = this.addScanner(table.getScanner(scan), false);
            return n;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public int scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
        Table table = null;
        try {
            table = this.getTable(tableName);
            Scan scan = new Scan(Bytes.getBytes((ByteBuffer)startRow), Bytes.getBytes((ByteBuffer)stopRow));
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)scan, attributes);
            scan.setTimeRange(0L, timestamp);
            if (columns != null && !columns.isEmpty()) {
                for (ByteBuffer column : columns) {
                    byte[][] famQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
                    if (famQf.length == 1) {
                        scan.addFamily(famQf[0]);
                        continue;
                    }
                    scan.addColumn(famQf[0], famQf[1]);
                }
            }
            scan.setTimeRange(0L, timestamp);
            int n = this.addScanner(table.getScanner(scan), false);
            return n;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public Map<ByteBuffer, ColumnDescriptor> getColumnDescriptors(ByteBuffer tableName) throws IOError, TException {
        Table table = null;
        try {
            TreeMap<ByteBuffer, ColumnDescriptor> columns = new TreeMap<ByteBuffer, ColumnDescriptor>();
            table = this.getTable(tableName);
            HTableDescriptor desc = table.getTableDescriptor();
            for (HColumnDescriptor e : desc.getFamilies()) {
                ColumnDescriptor col = ThriftUtilities.colDescFromHbase(e);
                columns.put(col.name, col);
            }
            TreeMap<ByteBuffer, ColumnDescriptor> treeMap = columns;
            this.closeTable(table);
            return treeMap;
        }
        catch (IOException e) {
            try {
                LOG.warn(e.getMessage(), (Throwable)e);
                throw ThriftHBaseServiceHandler.getIOError(e);
            }
            catch (Throwable throwable) {
                this.closeTable(table);
                throw throwable;
            }
        }
    }

    private void closeTable(Table table) throws IOError {
        try {
            if (table != null) {
                table.close();
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    @Override
    public TRegionInfo getRegionInfo(ByteBuffer searchRow) throws IOError {
        try {
            byte[] row = Bytes.getBytes((ByteBuffer)searchRow);
            Result startRowResult = this.getReverseScanResult(TableName.META_TABLE_NAME.getName(), row, HConstants.CATALOG_FAMILY);
            if (startRowResult == null) {
                throw new IOException("Cannot find row in " + TableName.META_TABLE_NAME + ", row=" + Bytes.toStringBinary((byte[])row));
            }
            RegionInfo regionInfo = MetaTableAccessor.getRegionInfo((Result)startRowResult);
            if (regionInfo == null) {
                throw new IOException("RegionInfo REGIONINFO was null or  empty in Meta for row=" + Bytes.toStringBinary((byte[])row));
            }
            TRegionInfo region = new TRegionInfo();
            region.setStartKey(regionInfo.getStartKey());
            region.setEndKey(regionInfo.getEndKey());
            region.id = regionInfo.getRegionId();
            region.setName(regionInfo.getRegionName());
            region.version = 1;
            ServerName serverName = MetaTableAccessor.getServerName((Result)startRowResult, (int)0);
            if (serverName != null) {
                region.setServerName(Bytes.toBytes((String)serverName.getHostname()));
                region.port = serverName.getPort();
            }
            return region;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
    }

    /*
     * Exception decompiling
     */
    private Result getReverseScanResult(byte[] tableName, byte[] row, byte[] family) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void increment(TIncrement tincrement) throws IOError, TException {
        if (tincrement.getRow().length == 0 || tincrement.getTable().length == 0) {
            throw new TException("Must supply a table and a row key; can't increment");
        }
        if (this.conf.getBoolean("hbase.regionserver.thrift.coalesceIncrement", false)) {
            this.coalescer.queueIncrement(tincrement);
            return;
        }
        Table table = null;
        try {
            table = this.getTable(tincrement.getTable());
            Increment inc = ThriftUtilities.incrementFromThrift(tincrement);
            table.increment(inc);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public void incrementRows(List<TIncrement> tincrements) throws IOError, TException {
        if (this.conf.getBoolean("hbase.regionserver.thrift.coalesceIncrement", false)) {
            this.coalescer.queueIncrements(tincrements);
            return;
        }
        for (TIncrement tinc : tincrements) {
            this.increment(tinc);
        }
    }

    @Override
    public List<TCell> append(TAppend tappend) throws IOError, TException {
        if (tappend.getRow().length == 0 || tappend.getTable().length == 0) {
            throw new TException("Must supply a table and a row key; can't append");
        }
        Table table = null;
        try {
            table = this.getTable(tappend.getTable());
            Append append2 = ThriftUtilities.appendFromThrift(tappend);
            Result result = table.append(append2);
            List<TCell> list = ThriftUtilities.cellFromHBase(result.rawCells());
            return list;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public boolean checkAndPut(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, ByteBuffer value, Mutation mput, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
        Put put2;
        try {
            put2 = new Put(Bytes.getBytes((ByteBuffer)row), Long.MAX_VALUE);
            ThriftHBaseServiceHandler.addAttributes((OperationWithAttributes)put2, attributes);
            byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)mput.column));
            put2.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put2.getRow()).setFamily(famAndQf[0]).setQualifier(famAndQf[1]).setTimestamp(put2.getTimestamp()).setType(Cell.Type.Put).setValue(mput.value != null ? Bytes.getBytes((ByteBuffer)mput.value) : HConstants.EMPTY_BYTE_ARRAY).build());
            put2.setDurability(mput.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
        }
        Table table = null;
        try {
            table = this.getTable(tableName);
            byte[][] famAndQf = CellUtil.parseColumn((byte[])Bytes.getBytes((ByteBuffer)column));
            Table.CheckAndMutateBuilder mutateBuilder = table.checkAndMutate(Bytes.getBytes((ByteBuffer)row), famAndQf[0]).qualifier(famAndQf[1]);
            if (value != null) {
                boolean bl = mutateBuilder.ifEquals(Bytes.getBytes((ByteBuffer)value)).thenPut(put2);
                return bl;
            }
            boolean bl = mutateBuilder.ifNotExists().thenPut(put2);
            return bl;
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw ThriftHBaseServiceHandler.getIOError(e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgument(Throwables.getStackTraceAsString((Throwable)e));
        }
        finally {
            this.closeTable(table);
        }
    }

    @Override
    public TThriftServerType getThriftServerType() {
        return TThriftServerType.ONE;
    }

    @Override
    public String getClusterId() throws TException {
        return this.connectionCache.getClusterId();
    }

    private static IOError getIOError(Throwable throwable) {
        IOErrorWithCause error = new IOErrorWithCause(throwable);
        error.setCanRetry(!(throwable instanceof DoNotRetryIOException));
        error.setMessage(Throwables.getStackTraceAsString((Throwable)throwable));
        return error;
    }

    private static void addAttributes(OperationWithAttributes op, Map<ByteBuffer, ByteBuffer> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : attributes.entrySet()) {
            String name = Bytes.toStringBinary((byte[])Bytes.getBytes((ByteBuffer)entry.getKey()));
            byte[] value = Bytes.getBytes((ByteBuffer)entry.getValue());
            op.setAttribute(name, value);
        }
    }

    public static class IOErrorWithCause
    extends IOError {
        private final Throwable cause;

        public IOErrorWithCause(Throwable cause) {
            this.cause = cause;
        }

        public synchronized Throwable getCause() {
            return this.cause;
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other) && other instanceof IOErrorWithCause) {
                Throwable otherCause = ((IOErrorWithCause)other).getCause();
                if (this.getCause() != null) {
                    return otherCause != null && this.getCause().equals(otherCause);
                }
                return otherCause == null;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
            return result;
        }
    }

    protected static class ResultScannerWrapper {
        private final ResultScanner scanner;
        private final boolean sortColumns;

        public ResultScannerWrapper(ResultScanner resultScanner, boolean sortResultColumns) {
            this.scanner = resultScanner;
            this.sortColumns = sortResultColumns;
        }

        public ResultScanner getScanner() {
            return this.scanner;
        }

        public boolean isColumnSorted() {
            return this.sortColumns;
        }
    }
}

