/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.Map;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.sls.AMDefinition;
import org.apache.hadoop.yarn.sls.AMDefinitionRumen;
import org.apache.hadoop.yarn.sls.AMDefinitionSLS;
import org.apache.hadoop.yarn.sls.AMDefinitionSynth;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.conf.SLSConfiguration;
import org.apache.hadoop.yarn.sls.synthetic.SynthJob;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMDefinitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AMDefinitionFactory.class);
    public static final String DEFAULT_JOB_TYPE = "mapreduce";

    private AMDefinitionFactory() {
    }

    public static AMDefinitionSLS createFromSlsTrace(Map<String, String> jsonJob, SLSRunner slsRunner) throws YarnException {
        AMDefinitionSLS amDefinition = AMDefinitionSLS.Builder.create(jsonJob).withAmType("yarn.sls.am.type").withAmResource(AMDefinitionFactory.getAMContainerResourceSLS(jsonJob, slsRunner)).withTaskContainers(AMDefinitionSLS.getTaskContainers(jsonJob, slsRunner)).withJobStartTime("job.start.ms").withJobFinishTime("job.end.ms").withLabelExpression("job.label.expression").withUser("job.user").withQueue("job.queue.name").withJobId("job.id").withJobCount("job.count").build();
        slsRunner.increaseQueueAppNum(amDefinition.getQueue());
        return amDefinition;
    }

    public static AMDefinitionRumen createFromRumenTrace(LoggedJob job, long baselineTimeMs, SLSRunner slsRunner) throws YarnException {
        AMDefinitionRumen amDefinition = AMDefinitionRumen.Builder.create().withAmType(DEFAULT_JOB_TYPE).withAmResource(AMDefinitionFactory.getAMContainerResourceSynthAndRumen(slsRunner)).withTaskContainers(AMDefinitionRumen.getTaskContainers(job, slsRunner)).withJobStartTime(job.getSubmitTime()).withJobFinishTime(job.getFinishTime()).withBaseLineTimeMs(baselineTimeMs).withUser(job.getUser()).withQueue(job.getQueue().getValue()).withJobId(job.getJobID().toString()).build();
        slsRunner.increaseQueueAppNum(amDefinition.getQueue());
        return amDefinition;
    }

    public static AMDefinitionSynth createFromSynth(SynthJob job, SLSRunner slsRunner) throws YarnException {
        AMDefinitionSynth amDefinition = AMDefinitionSynth.Builder.create().withAmType(job.getType()).withAmResource(AMDefinitionFactory.getAMContainerResourceSynthAndRumen(slsRunner)).withTaskContainers(AMDefinitionSynth.getTaskContainers(job, slsRunner)).withUser(job.getUser()).withQueue(job.getQueueName()).withJobId(job.getJobID().toString()).withJobStartTime(job.getSubmissionTime()).withJobFinishTime(job.getSubmissionTime() + job.getDuration()).withBaseLineTimeMs(0L).build();
        slsRunner.increaseQueueAppNum(amDefinition.getQueue());
        return amDefinition;
    }

    private static Resource getAMContainerResourceSLS(Map<String, String> jsonJob, Configured configured) {
        ResourceInformation[] infors;
        Resource amContainerResource = SLSConfiguration.getAMContainerResource(configured.getConf());
        if (jsonJob == null) {
            return amContainerResource;
        }
        for (ResourceInformation info : infors = ResourceUtils.getResourceTypesArray()) {
            String key = "am." + info.getName();
            if (!jsonJob.containsKey(key)) continue;
            long value = Long.parseLong(jsonJob.get(key));
            amContainerResource.setResourceValue(info.getName(), value);
        }
        return amContainerResource;
    }

    private static Resource getAMContainerResourceSynthAndRumen(Configured configured) {
        return SLSConfiguration.getAMContainerResource(configured.getConf());
    }

    static void adjustTimeValuesToBaselineTime(AMDefinition amDef, AMDefinition.AmDefinitionBuilder builder, long baselineTimeMs) {
        builder.jobStartTime -= baselineTimeMs;
        builder.jobFinishTime -= baselineTimeMs;
        if (builder.jobStartTime < 0L) {
            LOG.warn("Warning: reset job {} start time to 0.", (Object)amDef.getOldAppId());
            builder.jobFinishTime -= builder.jobStartTime;
            builder.jobStartTime = 0L;
        }
        amDef.jobStartTime = builder.jobStartTime;
    }
}

