/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InputStriper {
    public static final Logger LOG = LoggerFactory.getLogger(InputStriper.class);
    int idx;
    long currentStart;
    FileStatus current;
    final List<FileStatus> files = new ArrayList<FileStatus>();
    final Configuration conf = new Configuration();
    static final Comparator<Map.Entry<String, Double>> hostRank = new Comparator<Map.Entry<String, Double>>(){

        @Override
        public int compare(Map.Entry<String, Double> a, Map.Entry<String, Double> b) {
            return Double.compare(a.getValue(), b.getValue());
        }
    };

    InputStriper(FilePool inputDir, long mapBytes) throws IOException {
        long inputBytes = inputDir.getInputFiles(mapBytes, this.files);
        if (mapBytes > inputBytes) {
            LOG.warn("Using " + inputBytes + "/" + mapBytes + " bytes");
        }
        if (this.files.isEmpty() && mapBytes > 0L) {
            throw new IOException("Failed to satisfy request for " + mapBytes);
        }
        this.current = this.files.isEmpty() ? null : this.files.get(0);
    }

    CombineFileSplit splitFor(FilePool inputDir, long bytes, int nLocs) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList<Long> start = new ArrayList<Long>();
        ArrayList<Long> length = new ArrayList<Long>();
        HashMap<String, Double> sb = new HashMap<String, Double>();
        do {
            paths.add(this.current.getPath());
            start.add(this.currentStart);
            long fromFile = Math.min(bytes, this.current.getLen() - this.currentStart);
            length.add(fromFile);
            for (BlockLocation loc : inputDir.locationsFor(this.current, this.currentStart, fromFile)) {
                double tedium = (double)loc.getLength() / (1.0 * (double)bytes);
                for (String l : loc.getHosts()) {
                    Double j = (Double)sb.get(l);
                    if (null == j) {
                        sb.put(l, tedium);
                        continue;
                    }
                    sb.put(l, j + tedium);
                }
            }
            this.currentStart += fromFile;
            bytes -= fromFile;
            CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(this.conf);
            CompressionCodec codec = compressionCodecs.getCodec(this.current.getPath());
            if (this.current.getLen() - this.currentStart != 0L && codec == null) continue;
            this.current = this.files.get(++this.idx % this.files.size());
            this.currentStart = 0L;
        } while (bytes > 0L);
        ArrayList sort = new ArrayList(sb.entrySet());
        Collections.sort(sort, hostRank);
        String[] hosts = new String[Math.min(nLocs, sort.size())];
        for (int i = 0; i < nLocs && i < sort.size(); ++i) {
            hosts[i] = (String)sort.get(i).getKey();
        }
        return new CombineFileSplit(paths.toArray(new Path[0]), this.toLongArray(start), this.toLongArray(length), hosts);
    }

    private long[] toLongArray(ArrayList<Long> sigh) {
        long[] ret = new long[sigh.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = sigh.get(i);
        }
        return ret;
    }
}

