/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.thirdparty.com.google.common.primitives.SignedBytes;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Preconditions;

class SnapshotDiffInfo {
    public static final Comparator<INode> INODE_COMPARATOR = new Comparator<INode>(){

        @Override
        public int compare(INode left, INode right) {
            if (left == null) {
                return right == null ? 0 : -1;
            }
            if (right == null) {
                return 1;
            }
            int cmp = this.compare(left.getParent(), right.getParent());
            return cmp == 0 ? SignedBytes.lexicographicalComparator().compare(left.getLocalNameBytes(), right.getLocalNameBytes()) : cmp;
        }
    };
    private final INodeDirectory snapshotRoot;
    private final INodeDirectory snapshotDiffScopeDir;
    private final Snapshot from;
    private final Snapshot to;
    private final SortedMap<INode, byte[][]> diffMap = new TreeMap<INode, byte[][]>(INODE_COMPARATOR);
    private final Map<INodeDirectory, DirectoryWithSnapshotFeature.ChildrenDiff> dirDiffMap = new HashMap<INodeDirectory, DirectoryWithSnapshotFeature.ChildrenDiff>();
    private final Map<Long, RenameEntry> renameMap = new HashMap<Long, RenameEntry>();
    private long totalDirsCompared;
    private long totalDirsProcessed;
    private long totalFilesCompared;
    private long totalFilesProcessed;
    private long childrenListingTime;

    SnapshotDiffInfo(INodeDirectory snapshotRootDir, INodeDirectory snapshotDiffScopeDir, Snapshot start, Snapshot end) {
        Preconditions.checkArgument((snapshotRootDir.isSnapshottable() && snapshotDiffScopeDir.isDescendantOfSnapshotRoot(snapshotRootDir) ? 1 : 0) != 0);
        this.snapshotRoot = snapshotRootDir;
        this.snapshotDiffScopeDir = snapshotDiffScopeDir;
        this.from = start;
        this.to = end;
        this.totalDirsCompared = 0L;
        this.totalDirsProcessed = 0L;
        this.totalFilesCompared = 0L;
        this.totalFilesProcessed = 0L;
    }

    void addDirDiff(INodeDirectory dir, byte[][] relativePath, DirectoryWithSnapshotFeature.ChildrenDiff diff) {
        RenameEntry entry;
        this.dirDiffMap.put(dir, diff);
        this.diffMap.put(dir, relativePath);
        for (INode created : diff.getCreatedUnmodifiable()) {
            if (!created.isReference() || (entry = this.getEntry(created.getId())).getTargetPath() != null) continue;
            entry.setTarget(created, relativePath);
        }
        for (INode deleted : diff.getDeletedUnmodifiable()) {
            if (!(deleted instanceof INodeReference.WithName)) continue;
            entry = this.getEntry(deleted.getId());
            entry.setSource(deleted, relativePath);
        }
    }

    Snapshot getFrom() {
        return this.from;
    }

    Snapshot getTo() {
        return this.to;
    }

    void incrementDirsCompared() {
        ++this.totalDirsCompared;
        this.incrementDirsProcessed();
    }

    void incrementDirsProcessed() {
        ++this.totalDirsProcessed;
    }

    void incrementFilesCompared() {
        ++this.totalFilesCompared;
        this.incrementFilesProcessed();
    }

    void incrementFilesProcessed() {
        ++this.totalFilesProcessed;
    }

    public void addChildrenListingTime(long millis) {
        this.childrenListingTime += millis;
    }

    private RenameEntry getEntry(long inodeId) {
        RenameEntry entry = this.renameMap.get(inodeId);
        if (entry == null) {
            entry = new RenameEntry();
            this.renameMap.put(inodeId, entry);
        }
        return entry;
    }

    void setRenameTarget(long inodeId, byte[][] path) {
        this.getEntry(inodeId).setTarget(path);
    }

    void addFileDiff(INodeFile file, byte[][] relativePath) {
        this.diffMap.put(file, relativePath);
    }

    boolean isFromEarlier() {
        return Snapshot.ID_COMPARATOR.compare(this.from, this.to) < 0;
    }

    public SnapshotDiffReport generateReport() {
        ChunkedArrayList diffReportList = new ChunkedArrayList();
        for (Map.Entry<INode, byte[][]> drEntry : this.diffMap.entrySet()) {
            INode node = drEntry.getKey();
            byte[][] path = drEntry.getValue();
            diffReportList.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, path, (byte[][])null));
            if (!node.isDirectory()) continue;
            List<SnapshotDiffReport.DiffReportEntry> subList = this.generateReport(this.dirDiffMap.get(node), path, this.isFromEarlier(), this.renameMap);
            diffReportList.addAll(subList);
        }
        SnapshotDiffReport.DiffStats dStats = new SnapshotDiffReport.DiffStats(this.totalDirsCompared, this.totalDirsProcessed, this.totalFilesCompared, this.totalFilesProcessed, this.childrenListingTime);
        return new SnapshotDiffReport(this.snapshotRoot.getFullPathName(), Snapshot.getSnapshotName(this.from), Snapshot.getSnapshotName(this.to), dStats, (List)diffReportList);
    }

    private List<SnapshotDiffReport.DiffReportEntry> generateReport(DirectoryWithSnapshotFeature.ChildrenDiff dirDiff, byte[][] parentPath, boolean fromEarlier, Map<Long, RenameEntry> renameMap) {
        RenameEntry entry;
        ChunkedArrayList list = new ChunkedArrayList();
        byte[][] fullPath = new byte[parentPath.length + 1][];
        System.arraycopy(parentPath, 0, fullPath, 0, parentPath.length);
        for (INode cnode : dirDiff.getCreatedUnmodifiable()) {
            entry = renameMap.get(cnode.getId());
            if (entry != null && entry.isRename()) continue;
            fullPath[fullPath.length - 1] = cnode.getLocalNameBytes();
            list.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.CREATE : SnapshotDiffReport.DiffType.DELETE, (byte[][])fullPath));
        }
        for (INode dnode : dirDiff.getDeletedUnmodifiable()) {
            entry = renameMap.get(dnode.getId());
            if (entry != null && entry.isRename()) {
                list.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, fromEarlier ? entry.getSourcePath() : entry.getTargetPath(), fromEarlier ? entry.getTargetPath() : entry.getSourcePath()));
                continue;
            }
            fullPath[fullPath.length - 1] = dnode.getLocalNameBytes();
            list.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.DELETE : SnapshotDiffReport.DiffType.CREATE, (byte[][])fullPath));
        }
        return list;
    }

    static class RenameEntry {
        private byte[][] sourcePath;
        private byte[][] targetPath;

        RenameEntry() {
        }

        void setSource(INode source, byte[][] sourceParentPath) {
            Preconditions.checkState((this.sourcePath == null ? 1 : 0) != 0);
            this.sourcePath = new byte[sourceParentPath.length + 1][];
            System.arraycopy(sourceParentPath, 0, this.sourcePath, 0, sourceParentPath.length);
            this.sourcePath[this.sourcePath.length - 1] = source.getLocalNameBytes();
        }

        void setTarget(INode target, byte[][] targetParentPath) {
            this.targetPath = new byte[targetParentPath.length + 1][];
            System.arraycopy(targetParentPath, 0, this.targetPath, 0, targetParentPath.length);
            this.targetPath[this.targetPath.length - 1] = target.getLocalNameBytes();
        }

        void setTarget(byte[][] targetPath) {
            this.targetPath = targetPath;
        }

        boolean isRename() {
            return this.sourcePath != null && this.targetPath != null;
        }

        byte[][] getSourcePath() {
            return this.sourcePath;
        }

        byte[][] getTargetPath() {
            return this.targetPath;
        }
    }
}

