/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.GenericDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;

abstract class InPlaceDecomposition<N extends Number>
extends GenericDecomposition<N> {
    private int myColDim;
    private DecompositionStore<N> myInPlace;
    private int myRowDim;

    protected InPlaceDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        super(factory);
    }

    public final MatrixStore<N> getInverse() {
        return this.getInverse(this.allocate(this.getRowDim(), this.getRowDim()));
    }

    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        throw new UnsupportedOperationException();
    }

    protected final int getColDim() {
        return this.myColDim;
    }

    protected final DecompositionStore<N> getInPlace() {
        return this.myInPlace;
    }

    protected final int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    protected final int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    protected final int getRowDim() {
        return this.myRowDim;
    }

    final DecompositionStore<N> setInPlace(Access2D.Collectable<N, ? super DecompositionStore<N>> matrix) {
        int tmpRowDim = (int)matrix.countRows();
        int tmpColDim = (int)matrix.countColumns();
        if (this.myInPlace == null || this.myRowDim != tmpRowDim || this.myColDim != tmpColDim) {
            this.myInPlace = this.makeZero(tmpRowDim, tmpColDim);
            this.myRowDim = tmpRowDim;
            this.myColDim = tmpColDim;
        }
        matrix.supplyTo(this.myInPlace);
        this.aspectRatioNormal(tmpRowDim >= tmpColDim);
        this.computed(false);
        return this.myInPlace;
    }
}

