/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.finance.FinanceUtils;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public class MarketEquilibrium {
    private static final BigDecimal DEFAULT_RISK_AVERSION = BigMath.ONE;
    private static final String STRING_ZERO = "0";
    private static final String SYMBOL = "Asset_";
    private final String[] myAssetKeys;
    private final BasicMatrix myCovariances;
    private BigDecimal myRiskAversion;

    public static Scalar<?> calculatePortfolioReturn(BasicMatrix assetWeights, BasicMatrix assetReturns) {
        return PrimitiveScalar.valueOf(assetWeights.dot(assetReturns));
    }

    private static String[] makeSymbols(int count) {
        String[] retVal = new String[count];
        int tmpMaxLength = Integer.toString(count - 1).length();
        for (int i = 0; i < count; ++i) {
            String tmpNumberString = Integer.toString(i);
            while (tmpNumberString.length() < tmpMaxLength) {
                tmpNumberString = STRING_ZERO + tmpNumberString;
            }
            retVal[i] = SYMBOL + tmpNumberString;
        }
        return retVal;
    }

    public MarketEquilibrium(BasicMatrix covarianceMatrix) {
        this(covarianceMatrix, DEFAULT_RISK_AVERSION);
    }

    public MarketEquilibrium(BasicMatrix covarianceMatrix, Number riskAversionFactor) {
        this(MarketEquilibrium.makeSymbols((int)covarianceMatrix.countRows()), covarianceMatrix, riskAversionFactor);
    }

    public MarketEquilibrium(String[] assetNamesOrKeys, BasicMatrix covarianceMatrix) {
        this.myAssetKeys = ArrayUtils.copyOf(assetNamesOrKeys);
        this.myCovariances = covarianceMatrix;
        this.myRiskAversion = DEFAULT_RISK_AVERSION;
    }

    public MarketEquilibrium(String[] assetNamesOrKeys, BasicMatrix covarianceMatrix, Number riskAversionFactor) {
        this.myAssetKeys = ArrayUtils.copyOf(assetNamesOrKeys);
        this.myCovariances = covarianceMatrix;
        this.myRiskAversion = TypeUtils.toBigDecimal(riskAversionFactor);
    }

    MarketEquilibrium(MarketEquilibrium marketEquilibrium) {
        this(marketEquilibrium.getAssetKeys(), marketEquilibrium.getCovariances(), (Number)marketEquilibrium.getRiskAversion().getNumber());
    }

    public BasicMatrix calculateAssetReturns(BasicMatrix assetWeights) {
        BasicMatrix tmpAssetWeights = this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0 ? assetWeights : (BasicMatrix)assetWeights.multiply(this.myRiskAversion);
        return (BasicMatrix)this.myCovariances.multiply(tmpAssetWeights);
    }

    public BasicMatrix calculateAssetWeights(BasicMatrix assetReturns) {
        BasicMatrix tmpAssetWeights = this.myCovariances.solve(assetReturns);
        if (this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0) {
            return tmpAssetWeights;
        }
        return (BasicMatrix)tmpAssetWeights.divide(this.myRiskAversion);
    }

    public Scalar<?> calculatePortfolioVariance(BasicMatrix assetWeights) {
        BasicMatrix tmpRight;
        BasicMatrix tmpLeft;
        if (assetWeights.countColumns() == 1L) {
            tmpLeft = assetWeights.transpose();
            tmpRight = assetWeights;
        } else {
            tmpLeft = assetWeights;
            tmpRight = assetWeights.transpose();
        }
        return ((BasicMatrix)tmpLeft.multiply(this.myCovariances.multiply(tmpRight))).toScalar(0L, 0L);
    }

    public void calibrate(BasicMatrix assetWeights, BasicMatrix assetReturns) {
        Scalar<?> tmpImpliedRiskAversion = this.calculateImpliedRiskAversion(assetWeights, assetReturns);
        this.setRiskAversion((Number)tmpImpliedRiskAversion.getNumber());
    }

    public MarketEquilibrium clean() {
        PrimitiveMatrix tmpAssetVolatilities = FinanceUtils.toVolatilities(this.myCovariances, true);
        PrimitiveMatrix tmpCleanedCorrelations = FinanceUtils.toCorrelations(this.myCovariances, true);
        PrimitiveMatrix tmpCovariances = FinanceUtils.toCovariances(tmpAssetVolatilities, tmpCleanedCorrelations);
        return new MarketEquilibrium(this.myAssetKeys, tmpCovariances, this.myRiskAversion);
    }

    public MarketEquilibrium copy() {
        return new MarketEquilibrium(this);
    }

    public String getAssetKey(int index) {
        return this.myAssetKeys[index];
    }

    public String[] getAssetKeys() {
        return ArrayUtils.copyOf(this.myAssetKeys);
    }

    public BasicMatrix getCovariances() {
        return this.myCovariances;
    }

    public Scalar<?> getRiskAversion() {
        return BigScalar.of(this.myRiskAversion);
    }

    public void setRiskAversion(Number factor) {
        BigDecimal tmpFactor = TypeUtils.toBigDecimal(factor);
        this.myRiskAversion = tmpFactor.signum() == 0 ? DEFAULT_RISK_AVERSION : (tmpFactor.signum() < 0 ? tmpFactor.negate() : tmpFactor);
    }

    public int size() {
        return (int)Math.min(this.myCovariances.countRows(), this.myCovariances.countColumns());
    }

    public BasicMatrix toCorrelations() {
        return FinanceUtils.toCorrelations(this.myCovariances, false);
    }

    Scalar<?> calculateImpliedRiskAversion(BasicMatrix assetWeights, BasicMatrix assetReturns) {
        Scalar<BigDecimal> retVal = ((BasicMatrix)this.myCovariances.multiply(assetWeights)).solve(assetReturns).toScalar(0L, 0L);
        if (retVal.isSmall(PrimitiveMath.ONE)) {
            retVal = BigScalar.ONE;
        } else if (!retVal.isAbsolute()) {
            retVal = (Scalar)retVal.negate();
        }
        return retVal;
    }

    boolean isDefaultRiskAversion() {
        return this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0;
    }
}

