/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ClientSideRequestStatistics;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponse {
    static final Logger LOGGER = LoggerFactory.getLogger(StoreResponse.class);
    private final int status;
    private final String[] responseHeaderNames;
    private final String[] responseHeaderValues;
    private final InputStream httpEntityStream;
    private final String content;
    private ClientSideRequestStatistics clientSideRequestStatistics;

    public StoreResponse(int status, List<Map.Entry<String, String>> headerEntries, InputStream inputStream) {
        this(status, headerEntries, null, inputStream);
    }

    public StoreResponse(int status, List<Map.Entry<String, String>> headerEntries, String content) {
        this(status, headerEntries, content, null);
    }

    private StoreResponse(int status, List<Map.Entry<String, String>> headerEntries, String content, InputStream inputStream) {
        this.responseHeaderNames = new String[headerEntries.size()];
        this.responseHeaderValues = new String[headerEntries.size()];
        int i = 0;
        for (Map.Entry<String, String> headerEntry : headerEntries) {
            this.responseHeaderNames[i] = headerEntry.getKey();
            this.responseHeaderValues[i] = headerEntry.getValue();
            ++i;
        }
        this.status = status;
        this.content = content;
        this.httpEntityStream = inputStream;
    }

    public int getStatus() {
        return this.status;
    }

    public String[] getResponseHeaderNames() {
        return this.responseHeaderNames;
    }

    public String[] getResponseHeaderValues() {
        return this.responseHeaderValues;
    }

    public String getResponseBody() {
        return this.content;
    }

    public InputStream getResponseStream() {
        return this.httpEntityStream;
    }

    public long getLSN() {
        String lsnString = this.getHeaderValue("lsn");
        if (StringUtils.isNotEmpty((CharSequence)lsnString)) {
            return Long.parseLong(lsnString);
        }
        return -1L;
    }

    public String getPartitionKeyRangeId() {
        return this.getHeaderValue("x-ms-documentdb-partitionkeyrangeid");
    }

    public String getContinuation() {
        return this.getHeaderValue("x-ms-continuation");
    }

    public String getHeaderValue(String attribute) {
        if (this.responseHeaderValues == null || this.responseHeaderNames.length != this.responseHeaderValues.length) {
            return null;
        }
        for (int i = 0; i < this.responseHeaderNames.length; ++i) {
            if (!this.responseHeaderNames[i].equalsIgnoreCase(attribute)) continue;
            return this.responseHeaderValues[i];
        }
        return null;
    }

    public ClientSideRequestStatistics getClientSideRequestStatistics() {
        return this.clientSideRequestStatistics;
    }

    public void setClientSideRequestStatistics(ClientSideRequestStatistics clientSideRequestStatistics) {
        this.clientSideRequestStatistics = clientSideRequestStatistics;
    }

    int getSubStatusCode() {
        int subStatusCode = 0;
        String subStatusCodeString = this.getHeaderValue("x-ms-substatus");
        if (StringUtils.isNotEmpty((CharSequence)subStatusCodeString)) {
            try {
                subStatusCode = Integer.parseInt(subStatusCodeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return subStatusCode;
    }
}

