/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Attribute;

public abstract class TelemetryDatapoint {
    @NonNull
    private final String name;
    @NonNull
    private final Map<String, Attribute> attributes;

    protected TelemetryDatapoint(@NonNull String name, @NonNull Map<String, Attribute> attributes) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.name = name;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelemetryDatapoint)) {
            return false;
        }
        TelemetryDatapoint other = (TelemetryDatapoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, Attribute> this$attributes = this.getAttributes();
        Map<String, Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TelemetryDatapoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public static abstract class TelemetryDatapointBuilder<T extends TelemetryDatapoint, TBuilder extends TelemetryDatapointBuilder<T, TBuilder>> {
        private String name;
        private final Map<String, Attribute> attributes = new HashMap<String, Attribute>();

        public TBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this.self();
        }

        public TBuilder attribute(@NonNull String name, @NonNull Object value) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.attribute(Attribute.of(name, value));
        }

        public TBuilder attribute(@NonNull Attribute attribute) {
            if (attribute == null) {
                throw new NullPointerException("attribute is marked non-null but is null");
            }
            Attribute existingAttribute = this.attributes.putIfAbsent(attribute.getName(), attribute);
            if (existingAttribute != null) {
                throw new IllegalArgumentException("Attribute with this name already already exists: " + existingAttribute);
            }
            return this.self();
        }

        protected TBuilder self() {
            return (TBuilder)this;
        }

        public T build() {
            Preconditions.checkNotNull(this.name, "The `name` must be set");
            return this.buildCore();
        }

        protected abstract T buildCore();

        @Generated
        protected String getName() {
            return this.name;
        }

        @Generated
        protected Map<String, Attribute> getAttributes() {
            return this.attributes;
        }
    }
}

