/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.servlet;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.shaded.org.glassfish.grizzly.servlet.WebappContext;

public abstract class Registration {
    protected String name;
    protected String className;
    protected Map<String, String> initParameters;
    protected WebappContext ctx;

    protected Registration(WebappContext ctx, String name, String className) {
        this.ctx = ctx;
        this.name = name;
        this.className = className;
        this.initParameters = new LinkedHashMap<String, String>(4, 1.0f);
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean setInitParameter(String name, String value) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("'value' cannot be null");
        }
        if (!this.initParameters.containsKey(name)) {
            this.initParameters.put(name, value);
            return true;
        }
        return false;
    }

    public String getInitParameter(String name) {
        return name == null ? null : this.initParameters.get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (initParameters == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> conflicts = new LinkedHashSet<String>(4, 1.0f);
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (this.setInitParameter(entry.getKey(), entry.getValue())) continue;
            conflicts.add(entry.getKey());
        }
        return conflicts;
    }

    public Map<String, String> getInitParameters() {
        return Collections.unmodifiableMap(this.initParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration that = (Registration)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.ctx != null ? !this.ctx.equals(that.ctx) : that.ctx != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.ctx != null ? this.ctx.hashCode() : 0);
        return result;
    }
}

