/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class ACCESS3Response
extends NFS3Response {
    private final int access;
    private final Nfs3FileAttributes postOpAttr;

    public ACCESS3Response(int status) {
        this(status, new Nfs3FileAttributes(), 0);
    }

    public ACCESS3Response(int status, Nfs3FileAttributes postOpAttr, int access) {
        super(status);
        this.postOpAttr = postOpAttr;
        this.access = access;
    }

    public static ACCESS3Response deserialize(XDR xdr) {
        int status = xdr.readInt();
        Nfs3FileAttributes postOpAttr = null;
        int access = 0;
        if (status == 0) {
            postOpAttr = Nfs3FileAttributes.deserialize(xdr);
            access = xdr.readInt();
        }
        return new ACCESS3Response(status, postOpAttr, access);
    }

    @Override
    public XDR serialize(XDR out, int xid, Verifier verifier) {
        super.serialize(out, xid, verifier);
        if (this.getStatus() == 0) {
            out.writeBoolean(true);
            this.postOpAttr.serialize(out);
            out.writeInt(this.access);
        } else {
            out.writeBoolean(false);
        }
        return out;
    }
}

