/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRandomOpsWithSnapshots {
    private static final Logger LOG = LoggerFactory.getLogger(TestRandomOpsWithSnapshots.class);
    private static final short REPL = 3;
    private static final long BLOCKSIZE = 1024L;
    private static final int TOTAL_FILECOUNT = 250;
    private static final int MAX_NUM_ITERATIONS = 10;
    private static final int MAX_NUM_FILESYSTEM_OPERATIONS = 50;
    private static final int MAX_NUM_SNAPSHOT_OPERATIONS = 50;
    private static final int MAX_NUM_SUB_DIRECTORIES_LEVEL = 10;
    private static final int MAX_NUM_FILE_LENGTH = 100;
    private static final int MIN_NUM_OPERATIONS = 25;
    private static final String TESTDIRSTRING = "/testDir";
    private static final String WITNESSDIRSTRING = "/WITNESSDIR";
    private static final Path TESTDIR = new Path("/testDir");
    private static final Path WITNESSDIR = new Path("/WITNESSDIR");
    private static List<Path> snapshottableDirectories = new ArrayList<Path>();
    private static Map<Path, ArrayList<String>> pathToSnapshotsMap = new HashMap<Path, ArrayList<String>>();
    private static final Configuration CONFIG = new Configuration();
    private MiniDFSCluster cluster;
    private DistributedFileSystem hdfs;
    private static Random generator = null;
    private int numberFileCreated = 0;
    private int numberFileDeleted = 0;
    private int numberFileRenamed = 0;
    private int numberDirectoryCreated = 0;
    private int numberDirectoryDeleted = 0;
    private int numberDirectoryRenamed = 0;
    private int numberSnapshotCreated = 0;
    private int numberSnapshotDeleted = 0;
    private int numberSnapshotRenamed = 0;

    @Before
    public void setUp() throws Exception {
        CONFIG.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(CONFIG).numDataNodes(3).format(true).build();
        this.cluster.waitActive();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.mkdirs(TESTDIR);
        this.hdfs.mkdirs(WITNESSDIR);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=900000L)
    public void testRandomOperationsWithSnapshots() throws IOException, InterruptedException, TimeoutException {
        SnapshottableDirectoryStatus[] snapshottableDirectoryStatus;
        long seed = System.currentTimeMillis();
        LOG.info("testRandomOperationsWithSnapshots, seed to be used: " + seed);
        generator = new Random(seed);
        int fileLen = generator.nextInt(100);
        this.createFiles(TESTDIRSTRING, fileLen);
        for (SnapshottableDirectoryStatus ssds : snapshottableDirectoryStatus = this.hdfs.getSnapshottableDirListing()) {
            snapshottableDirectories.add(ssds.getFullPath());
        }
        if (snapshottableDirectories.size() == 0) {
            this.hdfs.allowSnapshot(this.hdfs.getHomeDirectory());
            snapshottableDirectories.add(this.hdfs.getHomeDirectory());
        }
        int numberOfIterations = generator.nextInt(10);
        LOG.info("Number of iterations: " + numberOfIterations);
        int numberFileSystemOperations = generator.nextInt(26) + 25;
        LOG.info("Number of FileSystem operations: " + numberFileSystemOperations);
        int numberSnapshotOperations = generator.nextInt(25) + 25;
        LOG.info("Number of Snapshot operations: " + numberSnapshotOperations);
        this.randomOperationsWithSnapshots(numberOfIterations, numberFileSystemOperations, numberSnapshotOperations);
    }

    public void randomOperationsWithSnapshots(int numberOfIterations, int numberFileSystemOperations, int numberSnapshotOperations) throws IOException, InterruptedException, TimeoutException {
        for (int i = 0; i < numberOfIterations; ++i) {
            block14: for (int j = 0; j < numberFileSystemOperations; ++j) {
                Operations fsOperation = Operations.getRandomOperation(OperationType.FileSystem);
                LOG.info("fsOperation: " + (Object)((Object)fsOperation));
                switch (fsOperation) {
                    case FileSystem_CreateDir: {
                        this.createTestDir();
                        continue block14;
                    }
                    case FileSystem_DeleteDir: {
                        this.deleteTestDir();
                        continue block14;
                    }
                    case FileSystem_RenameDir: {
                        this.renameTestDir();
                        continue block14;
                    }
                    case FileSystem_CreateFile: {
                        this.createTestFile();
                        continue block14;
                    }
                    case FileSystem_DeleteFile: {
                        this.deleteTestFile();
                        continue block14;
                    }
                    case FileSystem_RenameFile: {
                        this.renameTestFile();
                        continue block14;
                    }
                    default: {
                        Assert.assertNull((String)"Invalid FileSystem operation", (Object)((Object)fsOperation));
                    }
                }
            }
            block15: for (int k = 0; k < numberSnapshotOperations; ++k) {
                Operations snapshotOperation = Operations.getRandomOperation(OperationType.Snapshot);
                LOG.info("snapshotOperation: " + (Object)((Object)snapshotOperation));
                switch (snapshotOperation) {
                    case Snapshot_CreateSnapshot: {
                        this.createSnapshot();
                        continue block15;
                    }
                    case Snapshot_DeleteSnapshot: {
                        this.deleteSnapshot();
                        continue block15;
                    }
                    case Snapshot_RenameSnapshot: {
                        this.renameSnapshot();
                        continue block15;
                    }
                    default: {
                        Assert.assertNull((String)"Invalid Snapshot operation", (Object)((Object)snapshotOperation));
                    }
                }
            }
            this.checkClusterHealth();
        }
    }

    private void createTestDir() throws IOException {
        if (snapshottableDirectories.size() > 0) {
            int index = generator.nextInt(snapshottableDirectories.size());
            Path parentDir = snapshottableDirectories.get(index);
            Path newDir = new Path(parentDir, "createTestDir_" + UUID.randomUUID().toString());
            for (OperationDirectories dir : OperationDirectories.values()) {
                if (dir == OperationDirectories.WitnessDir) {
                    newDir = new Path(this.getNewPathString(newDir.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                }
                this.hdfs.mkdirs(newDir);
                Assert.assertTrue((String)"Directory exists", (boolean)this.hdfs.exists(newDir));
                LOG.info("Directory created: " + newDir);
                ++this.numberDirectoryCreated;
            }
        }
    }

    private void deleteTestDir() throws IOException {
        int index;
        Path deleteDir;
        if (snapshottableDirectories.size() > 0 && !pathToSnapshotsMap.containsKey(deleteDir = snapshottableDirectories.get(index = generator.nextInt(snapshottableDirectories.size())))) {
            boolean isWitnessDir = false;
            for (OperationDirectories dir : OperationDirectories.values()) {
                if (dir == OperationDirectories.WitnessDir) {
                    isWitnessDir = true;
                    deleteDir = new Path(this.getNewPathString(deleteDir.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                }
                this.hdfs.delete(deleteDir, true);
                Assert.assertFalse((String)"Directory does not exist", (boolean)this.hdfs.exists(deleteDir));
                if (!isWitnessDir) {
                    snapshottableDirectories.remove(deleteDir);
                }
                LOG.info("Directory removed: " + deleteDir);
                ++this.numberDirectoryDeleted;
            }
        }
    }

    private void renameTestDir() throws IOException {
        int index;
        Path oldDir;
        if (snapshottableDirectories.size() > 0 && !pathToSnapshotsMap.containsKey(oldDir = snapshottableDirectories.get(index = generator.nextInt(snapshottableDirectories.size())))) {
            Path newDir = oldDir.suffix("_renameDir+" + UUID.randomUUID().toString());
            for (OperationDirectories dir : OperationDirectories.values()) {
                if (dir == OperationDirectories.WitnessDir) {
                    oldDir = new Path(this.getNewPathString(oldDir.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                    newDir = new Path(this.getNewPathString(newDir.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                }
                this.hdfs.rename(oldDir, newDir, new Options.Rename[]{Options.Rename.OVERWRITE});
                Assert.assertTrue((String)"Target directory exists", (boolean)this.hdfs.exists(newDir));
                Assert.assertFalse((String)"Source directory does not exist", (boolean)this.hdfs.exists(oldDir));
                if (dir == OperationDirectories.TestDir) {
                    snapshottableDirectories.remove(oldDir);
                    snapshottableDirectories.add(newDir);
                }
                LOG.info("Renamed directory:" + oldDir + " to directory: " + newDir);
                ++this.numberDirectoryRenamed;
            }
        }
    }

    private void createSnapshot() throws IOException {
        if (snapshottableDirectories.size() > 0) {
            int index = generator.nextInt(snapshottableDirectories.size());
            Path randomDir = snapshottableDirectories.get(index);
            String snapshotName = Integer.toString(generator.nextInt()) + ".ss";
            this.hdfs.createSnapshot(randomDir, snapshotName);
            LOG.info("createSnapshot, directory: " + randomDir + ", snapshot name: " + snapshotName);
            ++this.numberSnapshotCreated;
            if (pathToSnapshotsMap.containsKey(randomDir)) {
                pathToSnapshotsMap.get(randomDir).add(snapshotName);
            } else {
                pathToSnapshotsMap.put(randomDir, new ArrayList<String>(Arrays.asList(snapshotName)));
            }
        }
    }

    private void deleteSnapshot() throws IOException {
        if (!pathToSnapshotsMap.isEmpty()) {
            int index = generator.nextInt(pathToSnapshotsMap.size());
            Object[] snapshotPaths = pathToSnapshotsMap.keySet().toArray();
            Path snapshotPath = (Path)snapshotPaths[index];
            ArrayList<String> snapshotNameList = pathToSnapshotsMap.get(snapshotPath);
            String snapshotNameToBeDeleted = snapshotNameList.get(generator.nextInt(snapshotNameList.size()));
            this.hdfs.deleteSnapshot(snapshotPath, snapshotNameToBeDeleted);
            LOG.info("deleteSnapshot, directory: " + snapshotPath + ", snapshot name: " + snapshotNameToBeDeleted);
            ++this.numberSnapshotDeleted;
            if (snapshotNameList.size() == 1) {
                pathToSnapshotsMap.remove(snapshotPath);
            } else {
                pathToSnapshotsMap.get(snapshotPath).remove(snapshotNameToBeDeleted);
            }
        }
    }

    private void renameSnapshot() throws IOException {
        if (!pathToSnapshotsMap.isEmpty()) {
            int index = generator.nextInt(pathToSnapshotsMap.size());
            Object[] snapshotPaths = pathToSnapshotsMap.keySet().toArray();
            Path snapshotPath = (Path)snapshotPaths[index];
            ArrayList<String> snapshotNameList = pathToSnapshotsMap.get(snapshotPath);
            String snapshotOldName = snapshotNameList.get(generator.nextInt(snapshotNameList.size()));
            String snapshotOldNameNoExt = snapshotOldName.substring(0, snapshotOldName.lastIndexOf(46) - 1);
            String snapshotNewName = snapshotOldNameNoExt + "_rename.ss";
            this.hdfs.renameSnapshot(snapshotPath, snapshotOldName, snapshotNewName);
            LOG.info("renameSnapshot, directory:" + snapshotPath + ", snapshot name:" + snapshotOldName + " to " + snapshotNewName);
            ++this.numberSnapshotRenamed;
            pathToSnapshotsMap.get(snapshotPath).remove(snapshotOldName);
            pathToSnapshotsMap.get(snapshotPath).add(snapshotNewName);
        }
    }

    private void createTestFile() throws IOException {
        if (snapshottableDirectories.size() > 0) {
            int index = generator.nextInt(snapshottableDirectories.size());
            Path randomDir = snapshottableDirectories.get(index);
            if (!randomDir.isRoot()) {
                randomDir = randomDir.getParent();
            }
            Path newFile = new Path(randomDir, "createTestFile.log");
            for (OperationDirectories dir : OperationDirectories.values()) {
                if (dir == OperationDirectories.WitnessDir) {
                    newFile = new Path(this.getNewPathString(newFile.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                }
                this.hdfs.createNewFile(newFile);
                Assert.assertTrue((String)"File exists", (boolean)this.hdfs.exists(newFile));
                LOG.info("createTestFile, file created: " + newFile);
                ++this.numberFileCreated;
            }
        }
    }

    private void deleteTestFile() throws IOException {
        if (snapshottableDirectories.size() > 0) {
            FileStatus[] fileStatusList;
            int index = generator.nextInt(snapshottableDirectories.size());
            Path randomDir = snapshottableDirectories.get(index);
            for (FileStatus fsEntry : fileStatusList = this.hdfs.listStatus(randomDir)) {
                if (!fsEntry.isFile()) continue;
                Path deleteFile = fsEntry.getPath();
                for (OperationDirectories dir : OperationDirectories.values()) {
                    if (dir == OperationDirectories.WitnessDir) {
                        deleteFile = new Path(this.getNewPathString(deleteFile.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                    }
                    this.hdfs.delete(deleteFile, false);
                    Assert.assertFalse((String)"File does not exists", (boolean)this.hdfs.exists(deleteFile));
                    LOG.info("deleteTestFile, file deleted: " + deleteFile);
                    ++this.numberFileDeleted;
                }
                break;
            }
        }
    }

    private void renameTestFile() throws IOException {
        if (snapshottableDirectories.size() > 0) {
            FileStatus[] fileStatusList;
            int index = generator.nextInt(snapshottableDirectories.size());
            Path randomDir = snapshottableDirectories.get(index);
            for (FileStatus fsEntry : fileStatusList = this.hdfs.listStatus(randomDir)) {
                if (!fsEntry.isFile()) continue;
                Path oldFile = fsEntry.getPath();
                Path newFile = oldFile.suffix("_renameFile");
                for (OperationDirectories dir : OperationDirectories.values()) {
                    if (dir == OperationDirectories.WitnessDir) {
                        oldFile = new Path(this.getNewPathString(oldFile.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                        newFile = new Path(this.getNewPathString(newFile.toString(), TESTDIRSTRING, WITNESSDIRSTRING));
                    }
                    this.hdfs.rename(oldFile, newFile, new Options.Rename[]{Options.Rename.OVERWRITE});
                    Assert.assertTrue((String)"Target file exists", (boolean)this.hdfs.exists(newFile));
                    Assert.assertFalse((String)"Source file does not exist", (boolean)this.hdfs.exists(oldFile));
                    LOG.info("Renamed file: " + oldFile + " to file: " + newFile);
                    ++this.numberFileRenamed;
                }
                break;
            }
        }
    }

    private void checkClusterHealth() throws IOException, InterruptedException, TimeoutException {
        Object[] testDirStatus = this.hdfs.listStatus(TESTDIR);
        Object[] witnessDirStatus = this.hdfs.listStatus(WITNESSDIR);
        Assert.assertEquals((long)witnessDirStatus.length, (long)testDirStatus.length);
        LOG.info("checkClusterHealth, number of entries verified.");
        Arrays.sort(testDirStatus);
        Arrays.sort(witnessDirStatus);
        for (int i = 0; i < testDirStatus.length; ++i) {
            Assert.assertEquals((Object)witnessDirStatus[i].getPermission(), (Object)testDirStatus[i].getPermission());
            Assert.assertEquals((Object)witnessDirStatus[i].getOwner(), (Object)testDirStatus[i].getOwner());
            Assert.assertEquals((Object)witnessDirStatus[i].getGroup(), (Object)testDirStatus[i].getGroup());
            Assert.assertEquals((long)witnessDirStatus[i].getLen(), (long)testDirStatus[i].getLen());
            Assert.assertEquals((long)witnessDirStatus[i].getBlockSize(), (long)testDirStatus[i].getBlockSize());
            Assert.assertEquals((Object)witnessDirStatus[i].hasAcl(), (Object)testDirStatus[i].hasAcl());
            Assert.assertEquals((Object)witnessDirStatus[i].isEncrypted(), (Object)testDirStatus[i].isEncrypted());
            Assert.assertEquals((Object)witnessDirStatus[i].isErasureCoded(), (Object)testDirStatus[i].isErasureCoded());
            Assert.assertEquals((Object)witnessDirStatus[i].isDirectory(), (Object)testDirStatus[i].isDirectory());
            Assert.assertEquals((Object)witnessDirStatus[i].isFile(), (Object)testDirStatus[i].isFile());
        }
        LOG.info("checkClusterHealth, metadata verified.");
        if (generator.nextBoolean()) {
            LOG.info("checkClusterHealth, doing a checkpoint on NN.");
            this.hdfs.setSafeMode(SafeModeAction.ENTER);
            this.hdfs.saveNamespace();
            this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        }
        LOG.info("checkClusterHealth, restarting NN.");
        this.cluster.restartNameNodes();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return !TestRandomOpsWithSnapshots.this.cluster.getNameNode().isInSafeMode();
            }
        }, (long)10L, (long)100000L);
        Assert.assertTrue((String)"NameNode is up", (boolean)this.cluster.getNameNode().isActiveState());
        Assert.assertTrue((String)"DataNode is up and running", (boolean)this.cluster.isDataNodeUp());
        Assert.assertTrue((String)"Cluster is up and running", (boolean)this.cluster.isClusterUp());
        LOG.info("checkClusterHealth, cluster is healthy.");
        this.printOperationStats();
    }

    private void createFile(String fileName, long filelen, boolean enableSnapshot) throws IOException {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile((FileSystem)fs, filePath, filelen, (short)1, 0L);
        if (enableSnapshot && generator.nextBoolean()) {
            try {
                this.hdfs.allowSnapshot(filePath.getParent());
            }
            catch (SnapshotException e) {
                LOG.info("createFile, exception setting snapshotable directory: " + e.getMessage());
            }
        }
    }

    private void createFiles(String rootDir, int fileLength) throws IOException {
        if (!rootDir.endsWith("/")) {
            rootDir = rootDir + "/";
        }
        for (int i = 0; i < 250; ++i) {
            String filename = rootDir;
            int dirs = generator.nextInt(10);
            for (int j = i; j >= i - dirs; --j) {
                filename = filename + j + "/";
            }
            filename = filename + "file" + i;
            this.createFile(filename, fileLength, true);
            Assert.assertTrue((String)"Test file created", (boolean)this.hdfs.exists(new Path(filename)));
            LOG.info("createFiles, file: " + filename + "was created");
            String witnessFile = filename.replaceAll(TESTDIRSTRING, WITNESSDIRSTRING);
            this.createFile(witnessFile, fileLength, false);
            Assert.assertTrue((String)"Witness file exists", (boolean)this.hdfs.exists(new Path(witnessFile)));
            LOG.info("createFiles, file: " + witnessFile + "was created");
        }
    }

    private String getNewPathString(String originalString, String targetString, String replacementString) {
        String str = originalString.replaceAll(targetString, replacementString);
        LOG.info("Original string: " + originalString);
        LOG.info("New string: " + str);
        return str;
    }

    private void printOperationStats() {
        LOG.info("Operation statistics for this iteration: ");
        LOG.info("Number of files created: " + this.numberFileCreated);
        LOG.info("Number of files deleted: " + this.numberFileDeleted);
        LOG.info("Number of files renamed: " + this.numberFileRenamed);
        LOG.info("Number of directories created: " + this.numberDirectoryCreated);
        LOG.info("Number of directories deleted: " + this.numberDirectoryDeleted);
        LOG.info("Number of directories renamed: " + this.numberDirectoryRenamed);
        LOG.info("Number of snapshots created: " + this.numberSnapshotCreated);
        LOG.info("Number of snapshots deleted: " + this.numberSnapshotDeleted);
        LOG.info("Number of snapshots renamed: " + this.numberSnapshotRenamed);
        this.numberFileCreated = 0;
        this.numberFileDeleted = 0;
        this.numberFileRenamed = 0;
        this.numberDirectoryCreated = 0;
        this.numberDirectoryDeleted = 0;
        this.numberDirectoryRenamed = 0;
        this.numberSnapshotCreated = 0;
        this.numberSnapshotDeleted = 0;
        this.numberSnapshotRenamed = 0;
    }

    private static enum Operations {
        FileSystem_CreateFile(2, OperationType.FileSystem),
        FileSystem_DeleteFile(2, OperationType.FileSystem),
        FileSystem_RenameFile(2, OperationType.FileSystem),
        FileSystem_CreateDir(1, OperationType.FileSystem),
        FileSystem_DeleteDir(1, OperationType.FileSystem),
        FileSystem_RenameDir(2, OperationType.FileSystem),
        Snapshot_CreateSnapshot(5, OperationType.Snapshot),
        Snapshot_DeleteSnapshot(3, OperationType.Snapshot),
        Snapshot_RenameSnapshot(2, OperationType.Snapshot);

        private int weight;
        private OperationType operationType;
        private static final Operations[] VALUES;
        private static final int TOTAL_WEIGHT_FILESYSTEM;
        private static final int TOTAL_WEIGHT_SNAPSHOT;

        private Operations(int weight, OperationType type) {
            this.weight = weight;
            this.operationType = type;
        }

        private int getWeight() {
            return this.weight;
        }

        private static int sumWeights(OperationType type) {
            int sum = 0;
            for (Operations value : VALUES) {
                if (value.operationType != type) continue;
                sum += value.getWeight();
            }
            return sum;
        }

        public static Operations getRandomOperation(OperationType type) {
            int randomNum = 0;
            Operations randomOperation = null;
            switch (type) {
                case FileSystem: {
                    randomNum = generator.nextInt(TOTAL_WEIGHT_FILESYSTEM);
                    break;
                }
                case Snapshot: {
                    randomNum = generator.nextInt(TOTAL_WEIGHT_SNAPSHOT);
                    break;
                }
            }
            int currentWeightSum = 0;
            for (Operations currentValue : VALUES) {
                if (currentValue.operationType != type) continue;
                if (randomNum <= currentWeightSum + currentValue.getWeight()) {
                    randomOperation = currentValue;
                    break;
                }
                currentWeightSum += currentValue.getWeight();
            }
            return randomOperation;
        }

        static {
            VALUES = Operations.values();
            TOTAL_WEIGHT_FILESYSTEM = Operations.sumWeights(OperationType.FileSystem);
            TOTAL_WEIGHT_SNAPSHOT = Operations.sumWeights(OperationType.Snapshot);
        }
    }

    private static enum OperationType {
        FileSystem,
        Snapshot;

    }

    private static enum OperationDirectories {
        TestDir,
        WitnessDir;

    }
}

