/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;

public final class BigMatrix
extends AbstractMatrix<BigDecimal, BigMatrix> {
    public static final BasicMatrix.Factory<BigMatrix> FACTORY = new MatrixFactory<BigDecimal, BigMatrix>(BigMatrix.class, BigDenseStore.FACTORY);

    BigMatrix(MatrixStore<BigDecimal> aStore) {
        super(aStore);
    }

    @Override
    ElementsSupplier<BigDecimal> cast(Access1D<?> matrix) {
        if (matrix instanceof BigMatrix) {
            return ((BigMatrix)matrix).getStore();
        }
        if (matrix instanceof BigDenseStore) {
            return (BigDenseStore)matrix;
        }
        if (matrix instanceof ElementsSupplier && matrix.count() > 0L && matrix.get(0L) instanceof BigDecimal) {
            return (ElementsSupplier)((Object)matrix);
        }
        if (matrix instanceof Access2D) {
            Access2D tmpAccess2D = (Access2D)matrix;
            return this.getStore().physical().builder().makeWrapper(tmpAccess2D);
        }
        return (ElementsSupplier)this.getStore().physical().columns(matrix);
    }

    @Override
    DeterminantTask<BigDecimal> getDeterminantTask(MatrixStore<BigDecimal> template) {
        return DeterminantTask.BIG.make(template, this.isHermitian(), false);
    }

    @Override
    MatrixFactory<BigDecimal, BigMatrix> getFactory() {
        return (MatrixFactory)FACTORY;
    }

    @Override
    InverterTask<BigDecimal> getInverterTask(MatrixStore<BigDecimal> base) {
        return InverterTask.BIG.make(base, this.isHermitian(), false);
    }

    @Override
    SolverTask<BigDecimal> getSolverTask(MatrixStore<BigDecimal> templateBody, Access2D<?> templateRHS) {
        return SolverTask.BIG.make(templateBody, templateRHS, this.isHermitian(), false);
    }
}

