/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.security.token.delegation.RouterDelegationTokenSupport;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterDelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<RMDelegationTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(RouterDelegationTokenSecretManager.class);
    private FederationStateStoreFacade federationFacade;

    public RouterDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, Configuration conf) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.federationFacade = FederationStateStoreFacade.getInstance((Configuration)conf);
    }

    public RMDelegationTokenIdentifier createIdentifier() {
        return new RMDelegationTokenIdentifier();
    }

    private boolean shouldIgnoreException(Exception e) {
        return !this.running && e.getCause() instanceof InterruptedException;
    }

    public void storeNewMasterKey(DelegationKey newKey) {
        block2: {
            try {
                this.federationFacade.storeNewMasterKey(newKey);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in storing master key with KeyID: {}.", (Object)newKey.getKeyId());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public void removeStoredMasterKey(DelegationKey delegationKey) {
        block2: {
            try {
                this.federationFacade.removeStoredMasterKey(delegationKey);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in removing master key with KeyID: {}.", (Object)delegationKey.getKeyId());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public void storeNewToken(RMDelegationTokenIdentifier identifier, long renewDate) throws IOException {
        block2: {
            try {
                this.federationFacade.storeNewToken(identifier, renewDate);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in storing RMDelegationToken with sequence number: {}.", (Object)identifier.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public void storeNewToken(RMDelegationTokenIdentifier identifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) {
        block2: {
            try {
                String token = RouterDelegationTokenSupport.encodeDelegationTokenInformation(tokenInfo);
                long renewDate = tokenInfo.getRenewDate();
                this.federationFacade.storeNewToken(identifier, renewDate, token);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in storing RMDelegationToken with sequence number: {}.", (Object)identifier.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public void updateStoredToken(RMDelegationTokenIdentifier id, long renewDate) throws IOException {
        block2: {
            try {
                this.federationFacade.updateStoredToken(id, renewDate);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in updating persisted RMDelegationToken with sequence number: {}.", (Object)id.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public void updateStoredToken(RMDelegationTokenIdentifier identifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) {
        block2: {
            try {
                long renewDate = tokenInfo.getRenewDate();
                String token = RouterDelegationTokenSupport.encodeDelegationTokenInformation(tokenInfo);
                this.federationFacade.updateStoredToken(identifier, renewDate, token);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in updating persisted RMDelegationToken with sequence number: {}.", (Object)identifier.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public void removeStoredToken(RMDelegationTokenIdentifier identifier) throws IOException {
        block2: {
            try {
                this.federationFacade.removeStoredToken(identifier);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in removing RMDelegationToken with sequence number: {}", (Object)identifier.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    public DelegationKey getMasterKeyByDelegationKey(DelegationKey key) throws YarnException, IOException {
        try {
            RouterMasterKeyResponse response = this.federationFacade.getMasterKeyByDelegationKey(key);
            RouterMasterKey masterKey = response.getRouterMasterKey();
            ByteBuffer keyByteBuf = masterKey.getKeyBytes();
            byte[] keyBytes = new byte[keyByteBuf.remaining()];
            keyByteBuf.get(keyBytes);
            DelegationKey delegationKey = new DelegationKey(masterKey.getKeyId().intValue(), masterKey.getExpiryDate().longValue(), keyBytes);
            return delegationKey;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
        catch (YarnException ex) {
            throw new YarnException((Throwable)ex);
        }
    }

    public RMDelegationTokenIdentifier getTokenByRouterStoreToken(RMDelegationTokenIdentifier identifier) throws YarnException, IOException {
        try {
            RouterRMTokenResponse response = this.federationFacade.getTokenByRouterStoreToken(identifier);
            YARNDelegationTokenIdentifier responseIdentifier = response.getRouterStoreToken().getTokenIdentifier();
            return (RMDelegationTokenIdentifier)responseIdentifier;
        }
        catch (Exception ex) {
            throw new YarnException((Throwable)ex);
        }
    }

    public void setFederationFacade(FederationStateStoreFacade federationFacade) {
        this.federationFacade = federationFacade;
    }

    @InterfaceAudience.Public
    @VisibleForTesting
    public int getLatestDTSequenceNumber() {
        return this.delegationTokenSequenceNumber;
    }

    @InterfaceAudience.Public
    @VisibleForTesting
    public synchronized Set<DelegationKey> getAllMasterKeys() {
        return new HashSet<DelegationKey>(this.allKeys.values());
    }

    @InterfaceAudience.Public
    @VisibleForTesting
    public synchronized Map<RMDelegationTokenIdentifier, Long> getAllTokens() {
        HashMap<RMDelegationTokenIdentifier, Long> allTokens = new HashMap<RMDelegationTokenIdentifier, Long>();
        for (Map.Entry entry : this.currentTokens.entrySet()) {
            RMDelegationTokenIdentifier keyIdentifier = (RMDelegationTokenIdentifier)entry.getKey();
            AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInformation = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)entry.getValue();
            allTokens.put(keyIdentifier, tokenInformation.getRenewDate());
        }
        return allTokens;
    }

    public long getRenewDate(RMDelegationTokenIdentifier ident) throws SecretManager.InvalidToken {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(ident);
        if (info == null) {
            throw new SecretManager.InvalidToken("token (" + ident.toString() + ") can't be found in cache");
        }
        return info.getRenewDate();
    }

    protected synchronized int incrementDelegationTokenSeqNum() {
        return this.federationFacade.incrementDelegationTokenSeqNum();
    }

    protected void storeToken(RMDelegationTokenIdentifier rmDelegationTokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        this.currentTokens.put(rmDelegationTokenIdentifier, tokenInfo);
        this.addTokenForOwnerStats((AbstractDelegationTokenIdentifier)rmDelegationTokenIdentifier);
        this.storeNewToken(rmDelegationTokenIdentifier, tokenInfo);
    }

    protected void updateToken(RMDelegationTokenIdentifier rmDelegationTokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        this.currentTokens.put(rmDelegationTokenIdentifier, tokenInfo);
        this.updateStoredToken(rmDelegationTokenIdentifier, tokenInfo);
    }

    protected AbstractDelegationTokenSecretManager.DelegationTokenInformation getTokenInfo(RMDelegationTokenIdentifier ident) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(ident);
        if (tokenInfo == null) {
            try {
                RouterRMTokenResponse response = this.federationFacade.getTokenByRouterStoreToken(ident);
                RouterStoreToken routerStoreToken = response.getRouterStoreToken();
                String tokenStr = routerStoreToken.getTokenInfo();
                byte[] tokenBytes = Base64.getUrlDecoder().decode(tokenStr);
                tokenInfo = RouterDelegationTokenSupport.decodeDelegationTokenInformation(tokenBytes);
            }
            catch (Exception e) {
                LOG.error("Error retrieving tokenInfo [" + ident.getSequenceNumber() + "] from StateStore.", (Throwable)e);
                throw new YarnRuntimeException((Throwable)e);
            }
        }
        return tokenInfo;
    }

    protected synchronized int getDelegationTokenSeqNum() {
        return this.federationFacade.getDelegationTokenSeqNum();
    }

    protected synchronized void setDelegationTokenSeqNum(int seqNum) {
        this.federationFacade.setDelegationTokenSeqNum(seqNum);
    }

    protected synchronized int getCurrentKeyId() {
        return this.federationFacade.getCurrentKeyId();
    }

    protected synchronized int incrementCurrentKeyId() {
        return this.federationFacade.incrementCurrentKeyId();
    }
}

