/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.adaptor;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.CsiAdaptorPlugin;
import org.apache.hadoop.yarn.csi.adaptor.DefaultCsiAdaptorImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsiAdaptorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CsiAdaptorFactory.class);

    private CsiAdaptorFactory() {
    }

    public static CsiAdaptorPlugin getAdaptor(String driverName, Configuration conf) throws YarnException {
        String configName = "yarn.nodemanager.csi-driver-adaptor." + driverName + ".class";
        Class impl = conf.getClass(configName, DefaultCsiAdaptorImpl.class, CsiAdaptorPlugin.class);
        if (impl == null) {
            throw new YarnException("Unable to init csi-adaptor from the class specified via " + configName);
        }
        CsiAdaptorPlugin instance = (CsiAdaptorPlugin)ReflectionUtils.newInstance((Class)impl, (Configuration)conf);
        LOG.info("csi-adaptor initiated, implementation: " + impl.getCanonicalName());
        return instance;
    }
}

