/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.Map;

public class NotFoundException
extends DocumentClientException {
    private static final long serialVersionUID = 1L;

    public NotFoundException() {
        this("Entity with the specified id does not exist in the system.");
    }

    public NotFoundException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(404, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public NotFoundException(String message) {
        this(message, (Exception)null, (HttpResponseHeaders)null, null);
    }

    public NotFoundException(String message, Map<String, String> headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public NotFoundException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public NotFoundException(String message, HttpResponseHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    public NotFoundException(Exception innerException) {
        this("Entity with the specified id does not exist in the system.", innerException, (Map<String, String>)null, null);
    }

    public NotFoundException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        this(message, innerException, HttpUtils.asMap((HttpResponseHeaders)headers), requestUri);
    }

    public NotFoundException(String message, Exception innerException, Map<String, String> headers, String requestUri) {
        super(String.format("%s: %s", "Entity with the specified id does not exist in the system.", message), innerException, headers, 404, requestUri);
    }
}

