/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOrderedSnapshotDeletion {
    static final String xattrName = "user.a1";
    static final byte[] xattrValue = new byte[]{49, 50, 51};
    private final Path snapshottableDir = new Path("/" + this.getClass().getSimpleName());
    private MiniDFSCluster cluster;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.snapshot.deletion.ordered", true);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testOrderedSnapshotDeletion() throws Exception {
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        hdfs.mkdirs(this.snapshottableDir);
        hdfs.allowSnapshot(this.snapshottableDir);
        Path sub0 = new Path(this.snapshottableDir, "sub0");
        hdfs.mkdirs(sub0);
        hdfs.createSnapshot(this.snapshottableDir, "s0");
        Path sub1 = new Path(this.snapshottableDir, "sub1");
        hdfs.mkdirs(sub1);
        hdfs.createSnapshot(this.snapshottableDir, "s1");
        Path sub2 = new Path(this.snapshottableDir, "sub2");
        hdfs.mkdirs(sub2);
        hdfs.createSnapshot(this.snapshottableDir, "s2");
        this.assertXAttrSet("s1", hdfs, null);
        this.assertXAttrSet("s2", hdfs, null);
        hdfs.deleteSnapshot(this.snapshottableDir, "s0");
        this.assertXAttrSet("s2", hdfs, null);
        hdfs.deleteSnapshot(this.snapshottableDir, TestOrderedSnapshotDeletion.getDeletedSnapshotName(hdfs, this.snapshottableDir, "s1"));
        hdfs.deleteSnapshot(this.snapshottableDir, TestOrderedSnapshotDeletion.getDeletedSnapshotName(hdfs, this.snapshottableDir, "s2"));
    }

    static void assertMarkedAsDeleted(Path snapshotRoot, Path snapshottableDir, MiniDFSCluster cluster) throws IOException {
        String snapName = TestOrderedSnapshotDeletion.getDeletedSnapshotName(cluster.getFileSystem(), snapshottableDir, snapshotRoot.getName());
        Path snapPathNew = SnapshotTestHelper.getSnapshotRoot(snapshottableDir, snapName);
        Assert.assertNotNull((Object)cluster.getFileSystem().getFileStatus(snapPathNew));
        INode inode = cluster.getNamesystem().getFSDirectory().getINode(snapPathNew.toString());
        XAttrFeature f = inode.getXAttrFeature();
        XAttr xAttr = f.getXAttr("system.hdfs.snapshot.deleted");
        Assert.assertNotNull((Object)xAttr);
        Assert.assertEquals((Object)"system.hdfs.snapshot.deleted".substring("system.".length()), (Object)xAttr.getName());
        Assert.assertEquals((Object)XAttr.NameSpace.SYSTEM, (Object)xAttr.getNameSpace());
        Assert.assertNull((Object)xAttr.getValue());
        Assert.assertTrue((boolean)(inode instanceof Snapshot.Root));
        Assert.assertTrue((boolean)((Snapshot.Root)inode).isMarkedAsDeleted());
    }

    static void assertNotMarkedAsDeleted(Path snapshotRoot, MiniDFSCluster cluster) throws IOException {
        Assert.assertNotNull((Object)cluster.getFileSystem().getFileStatus(snapshotRoot));
        INode inode = cluster.getNamesystem().getFSDirectory().getINode(snapshotRoot.toString());
        XAttrFeature f = inode.getXAttrFeature();
        if (f != null) {
            XAttr xAttr = f.getXAttr("system.hdfs.snapshot.deleted");
            Assert.assertNull((Object)xAttr);
        }
        Assert.assertTrue((boolean)(inode instanceof Snapshot.Root));
        Assert.assertFalse((boolean)((Snapshot.Root)inode).isMarkedAsDeleted());
    }

    void assertXAttrSet(String snapshot, DistributedFileSystem hdfs, XAttr newXattr) throws IOException {
        String snapName = TestOrderedSnapshotDeletion.getDeletedSnapshotName(hdfs, this.snapshottableDir, snapshot);
        hdfs.deleteSnapshot(this.snapshottableDir, snapName);
        Path snapshotRoot = SnapshotTestHelper.getSnapshotRoot(this.snapshottableDir, snapshot);
        TestOrderedSnapshotDeletion.assertMarkedAsDeleted(snapshotRoot, this.snapshottableDir, this.cluster);
        snapName = TestOrderedSnapshotDeletion.getDeletedSnapshotName(hdfs, this.snapshottableDir, snapshot);
        snapshotRoot = SnapshotTestHelper.getSnapshotRoot(this.snapshottableDir, snapName);
        if (this.cluster.getNameNode().getConf().getBoolean("dfs.namenode.xattrs.enabled", true)) {
            Map xattrMap = hdfs.getXAttrs(snapshotRoot);
            Assert.assertTrue((boolean)(newXattr == null ? xattrMap.isEmpty() : Arrays.equals(newXattr.getValue(), (byte[])xattrMap.get(xattrName))));
        }
    }

    @Test(timeout=60000L)
    public void testSnapshotXattrPersistence() throws Exception {
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        hdfs.mkdirs(this.snapshottableDir);
        hdfs.allowSnapshot(this.snapshottableDir);
        Path sub0 = new Path(this.snapshottableDir, "sub0");
        hdfs.mkdirs(sub0);
        hdfs.createSnapshot(this.snapshottableDir, "s0");
        Path sub1 = new Path(this.snapshottableDir, "sub1");
        hdfs.mkdirs(sub1);
        hdfs.createSnapshot(this.snapshottableDir, "s1");
        this.assertXAttrSet("s1", hdfs, null);
        this.assertXAttrSet("s1", hdfs, null);
        this.cluster.restartNameNodes();
        this.assertXAttrSet("s1", hdfs, null);
    }

    @Test(timeout=60000L)
    public void testSnapshotXattrWithSaveNameSpace() throws Exception {
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        hdfs.mkdirs(this.snapshottableDir);
        hdfs.allowSnapshot(this.snapshottableDir);
        Path sub0 = new Path(this.snapshottableDir, "sub0");
        hdfs.mkdirs(sub0);
        hdfs.createSnapshot(this.snapshottableDir, "s0");
        Path sub1 = new Path(this.snapshottableDir, "sub1");
        hdfs.mkdirs(sub1);
        hdfs.createSnapshot(this.snapshottableDir, "s1");
        this.assertXAttrSet("s1", hdfs, null);
        hdfs.setSafeMode(SafeModeAction.ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.restartNameNodes();
        this.assertXAttrSet("s1", hdfs, null);
    }

    @Test(timeout=6000000L)
    public void testOrderedDeletionWithRestart() throws Exception {
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        hdfs.mkdirs(this.snapshottableDir);
        hdfs.allowSnapshot(this.snapshottableDir);
        Path sub0 = new Path(this.snapshottableDir, "sub0");
        hdfs.mkdirs(sub0);
        hdfs.createSnapshot(this.snapshottableDir, "s0");
        Path sub1 = new Path(this.snapshottableDir, "sub1");
        hdfs.mkdirs(sub1);
        hdfs.createSnapshot(this.snapshottableDir, "s1");
        this.assertXAttrSet("s1", hdfs, null);
        this.assertXAttrSet("s1", hdfs, null);
        this.cluster.getNameNode().getConf().setBoolean("dfs.namenode.snapshot.deletion.ordered", false);
        this.cluster.restartNameNodes();
    }

    @Test(timeout=60000L)
    public void testSnapshotXattrWithDisablingXattr() throws Exception {
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        hdfs.mkdirs(this.snapshottableDir);
        hdfs.allowSnapshot(this.snapshottableDir);
        Path sub0 = new Path(this.snapshottableDir, "sub0");
        hdfs.mkdirs(sub0);
        hdfs.createSnapshot(this.snapshottableDir, "s0");
        Path sub1 = new Path(this.snapshottableDir, "sub1");
        hdfs.mkdirs(sub1);
        hdfs.createSnapshot(this.snapshottableDir, "s1");
        this.assertXAttrSet("s1", hdfs, null);
        this.cluster.getNameNode().getConf().setBoolean("dfs.namenode.xattrs.enabled", false);
        this.cluster.restartNameNodes();
        try {
            hdfs.getXAttrs(this.snapshottableDir);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The XAttr operation has been rejected.  Support for XAttrs has been disabled by setting dfs.namenode.xattrs.enabled to false"));
        }
        this.assertXAttrSet("s1", hdfs, null);
    }

    @Test(timeout=60000L)
    public void testSnapshotXAttrWithPreExistingXattrs() throws Exception {
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        hdfs.mkdirs(this.snapshottableDir);
        hdfs.allowSnapshot(this.snapshottableDir);
        hdfs.setXAttr(this.snapshottableDir, xattrName, xattrValue, EnumSet.of(XAttrSetFlag.CREATE));
        XAttr newXAttr = XAttrHelper.buildXAttr((String)xattrName, (byte[])xattrValue);
        Path sub0 = new Path(this.snapshottableDir, "sub0");
        hdfs.mkdirs(sub0);
        hdfs.createSnapshot(this.snapshottableDir, "s0");
        Path sub1 = new Path(this.snapshottableDir, "sub1");
        hdfs.mkdirs(sub1);
        hdfs.createSnapshot(this.snapshottableDir, "s1");
        this.assertXAttrSet("s1", hdfs, newXAttr);
    }

    public static String getDeletedSnapshotName(DistributedFileSystem hdfs, Path snapshottableDir, String snapshot) throws IOException {
        return Arrays.stream(hdfs.getSnapshotListing(snapshottableDir)).filter(p -> p.getFullPath().getName().startsWith(snapshot)).findFirst().get().getFullPath().getName();
    }
}

