/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.TestViewFileSystemOverloadSchemeWithHdfsScheme;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.ViewDistributedFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestViewDistributedFileSystemWithMountLinks
extends TestViewFileSystemOverloadSchemeWithHdfsScheme {
    @Override
    public void setUp() throws IOException {
        super.setUp();
        Configuration conf = this.getConf();
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setInt("ipc.client.connect.max.retries", 1);
        conf.set("fs.hdfs.impl", ViewDistributedFileSystem.class.getName());
        conf.setBoolean("fs.viewfs.ignore.port.in.mount.table.name", false);
        URI defaultFSURI = URI.create(conf.get("fs.defaultFS"));
        ConfigUtil.addLinkFallback((Configuration)conf, (String)defaultFSURI.getAuthority(), (URI)new Path(defaultFSURI.toString() + "/").toUri());
        this.setConf(conf);
    }

    @Override
    @Test(timeout=30000L)
    public void testCreateOnRoot() throws Exception {
        this.testCreateOnRoot(true);
    }

    @Override
    @Test(timeout=30000L)
    public void testMountLinkWithNonExistentLink() throws Exception {
        this.testMountLinkWithNonExistentLink(false);
    }

    @Test
    public void testRenameOnInternalDirWithFallback() throws Exception {
        Configuration conf = this.getConf();
        URI defaultFSURI = URI.create(conf.get("fs.defaultFS"));
        Path hdfsTargetPath1 = new Path(defaultFSURI + "/HDFSUser");
        Path hdfsTargetPath2 = new Path(defaultFSURI + "/NewHDFSUser/next");
        ViewFsTestSetup.addMountLinksToConf((String)defaultFSURI.getAuthority(), (String[])new String[]{"/HDFSUser", "/NewHDFSUser/next"}, (String[])new String[]{hdfsTargetPath1.toUri().toString(), hdfsTargetPath2.toUri().toString()}, (Configuration)conf);
        try (DistributedFileSystem dfs = new DistributedFileSystem();){
            dfs.initialize(defaultFSURI, conf);
            dfs.mkdirs(hdfsTargetPath1);
            dfs.mkdirs(hdfsTargetPath2);
        }
        var6_6 = null;
        try (FileSystem fs = FileSystem.get((Configuration)conf);){
            Path src = new Path("/newFileOnRoot");
            Path dst = new Path("/newFileOnRoot1");
            fs.create(src).close();
            this.verifyRename(fs, src, dst);
            src = new Path("/newFileOnRoot1");
            dst = new Path("/NewHDFSUser/newFileOnRoot");
            fs.mkdirs(dst.getParent());
            this.verifyRename(fs, src, dst);
            src = new Path("/NewHDFSUser/newFileOnRoot");
            dst = new Path("/NewHDFSUser/newFileOnRoot1");
            this.verifyRename(fs, src, dst);
            src = new Path("/NewHDFSUser/newFileOnRoot1");
            dst = new Path("/newFileOnRoot");
            this.verifyRename(fs, src, dst);
            src = new Path("/HDFSUser/newFileOnRoot1");
            dst = new Path("/HDFSUser/newFileOnRoot");
            fs.create(src).close();
            this.verifyRename(fs, src, dst);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testRenameWhenDstOnInternalDirWithFallback() throws Exception {
        Configuration conf = this.getConf();
        URI defaultFSURI = URI.create(conf.get("fs.defaultFS"));
        Path hdfsTargetPath1 = new Path(defaultFSURI + "/HDFSUser");
        Path hdfsTargetPath2 = new Path(defaultFSURI + "/dstNewHDFSUser/next");
        ViewFsTestSetup.addMountLinksToConf((String)defaultFSURI.getAuthority(), (String[])new String[]{"/InternalDirDoesNotExistInFallback/test", "/NewHDFSUser/next/next1"}, (String[])new String[]{hdfsTargetPath1.toUri().toString(), hdfsTargetPath2.toUri().toString()}, (Configuration)conf);
        try (DistributedFileSystem dfs = new DistributedFileSystem();){
            dfs.initialize(defaultFSURI, conf);
            dfs.mkdirs(hdfsTargetPath1);
            dfs.mkdirs(hdfsTargetPath2);
            dfs.mkdirs(new Path("/NewHDFSUser/next/next1"));
        }
        var6_6 = null;
        try (FileSystem fs = FileSystem.get((Configuration)conf);){
            Path src = new Path("/newFileOnRoot");
            Path dst = new Path("/NewHDFSUser/next");
            fs.create(src).close();
            this.verifyRename(fs, src, dst);
            src = new Path("/newFileOnRoot");
            dst = new Path("/NewHDFSUser/next/file");
            fs.create(src).close();
            this.verifyRename(fs, src, dst);
            src = new Path("/newFileOnRoot");
            dst = new Path("/InternalDirDoesNotExistInFallback/file");
            fs.create(src).close();
            Assert.assertFalse((boolean)fs.rename(src, dst));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    private void verifyRename(FileSystem fs, Path src, Path dst) throws IOException {
        fs.rename(src, dst);
        Assert.assertFalse((boolean)fs.exists(src));
        Assert.assertTrue((boolean)fs.exists(dst));
    }
}

