/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConvexSolver;

final class UnconstrainedSolver
extends ConvexSolver {
    UnconstrainedSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    @Override
    protected MatrixStore<Double> getIterationKKT() {
        return this.getQ();
    }

    @Override
    protected MatrixStore<Double> getIterationRHS() {
        return this.getC();
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        this.myCholesky.compute(this.getQ());
        this.resetX();
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return this.countIterations() < 1;
    }

    @Override
    protected void performIteration() {
        MatrixStore<Double> tmpQ = this.getQ();
        MatrixStore<Double> tmpC = this.getC();
        PhysicalStore<Double> tmpX = this.getX();
        boolean tmpSolvable = true;
        tmpSolvable = this.myCholesky.isSolvable();
        if (tmpSolvable) {
            this.myCholesky.getSolution(tmpC, tmpX);
        } else {
            tmpSolvable = this.myLU.compute(tmpQ);
            if (tmpSolvable) {
                this.myLU.getSolution(tmpC, tmpX);
            }
        }
        if (!tmpSolvable && this.isDebug()) {
            this.options.debug_appender.println("KKT system unsolvable!");
            this.options.debug_appender.printmtrx("KKT", this.getIterationKKT());
            this.options.debug_appender.printmtrx("RHS", this.getIterationRHS());
        }
        if (tmpSolvable) {
            this.setState(Optimisation.State.DISTINCT);
        } else {
            this.setState(Optimisation.State.UNBOUNDED);
            this.resetX();
        }
    }
}

