/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;
import org.ojalgo.netio.BasicParser;

abstract class AbstractParser<T>
implements BasicParser<T> {
    private transient BufferedReader myBufferedReader = null;

    AbstractParser() {
    }

    @Override
    public final void parse(Reader reader, Consumer<T> consumer) {
        String tmpLine = null;
        Object tmpItem = null;
        try (BufferedReader tmpBufferedReader = new BufferedReader(reader);){
            this.myBufferedReader = tmpBufferedReader;
            while ((tmpLine = tmpBufferedReader.readLine()) != null) {
                if (tmpLine.length() <= 0 || tmpLine.startsWith("#")) continue;
                T t = this.parse(tmpLine, tmpBufferedReader);
                tmpItem = t;
                if (t == null) continue;
                consumer.accept(tmpItem);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public final T parse(String line) {
        return this.parse(line, this.myBufferedReader);
    }

    abstract T parse(String var1, BufferedReader var2);
}

