/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.TypeUtils;

public final class FillMatchingSingle
extends MatrixOperation {
    public static final FillMatchingSingle SETUP = new FillMatchingSingle();
    public static int THRESHOLD = 64;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int limitColumn, Access1D<? extends Number> source) {
        int tmpIndex = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[tmpIndex] = TypeUtils.toBigDecimal(source.get(tmpIndex));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int limitColumn, Access1D<? extends Number> source) {
        int tmpIndex = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[tmpIndex] = ComplexNumber.valueOf(source.get(tmpIndex));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int limitColumn, Access1D<? extends Number> source) {
        int tmpIndex = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[tmpIndex] = source.doubleValue(tmpIndex);
                ++tmpIndex;
            }
        }
    }

    private FillMatchingSingle() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

