/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.auth.InvalidCredentialsException;
import com.aliyun.oss.common.auth.ProfileConfigLoader;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.common.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ProfileConfigFile {
    private final File profileFile;
    private final ProfileConfigLoader profileLoader;
    private volatile long profileFileLastModified;
    private volatile DefaultCredentials credentials;

    public ProfileConfigFile(String filePath) {
        this(new File(ProfileConfigFile.validateFilePath(filePath)));
    }

    public ProfileConfigFile(String filePath, ProfileConfigLoader profileLoader) {
        this(new File(ProfileConfigFile.validateFilePath(filePath)), profileLoader);
    }

    private static String validateFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Unable to load oss profiles: specified file path is null.");
        }
        return filePath;
    }

    public ProfileConfigFile(File file) {
        this(file, new ProfileConfigLoader());
    }

    public ProfileConfigFile(File file, ProfileConfigLoader profileLoader) {
        this.profileFile = file;
        this.profileLoader = profileLoader;
        this.profileFileLastModified = file.lastModified();
    }

    public Credentials getCredentials() {
        this.refresh();
        return this.credentials;
    }

    public void refresh() {
        if (this.credentials == null || this.profileFile.lastModified() > this.profileFileLastModified) {
            this.profileFileLastModified = this.profileFile.lastModified();
            Map<String, String> profileProperties = null;
            try {
                profileProperties = this.profileLoader.loadProfile(this.profileFile);
            }
            catch (IOException e) {
                LogUtils.logException("ProfilesConfigFile.refresh Exception:", e);
                return;
            }
            String accessKeyId = StringUtils.trim(profileProperties.get("oss_access_key_id"));
            String secretAccessKey = StringUtils.trim(profileProperties.get("oss_secret_access_key"));
            String sessionToken = StringUtils.trim(profileProperties.get("oss_session_token"));
            if (StringUtils.isNullOrEmpty(accessKeyId)) {
                throw new InvalidCredentialsException("Access key id should not be null or empty.");
            }
            if (StringUtils.isNullOrEmpty(secretAccessKey)) {
                throw new InvalidCredentialsException("Secret access key should not be null or empty.");
            }
            this.credentials = new DefaultCredentials(accessKeyId, secretAccessKey, sessionToken);
        }
    }
}

