/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterNetworkTopologyServlet {
    private static StateStoreDFSCluster clusterWithDatanodes;
    private static StateStoreDFSCluster clusterNoDatanodes;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().quota().rpc().build();
        routerConf.set("dfs.federation.router.http.enable", "true");
        Configuration hdfsConf = new Configuration(false);
        clusterWithDatanodes = new StateStoreDFSCluster(false, 2, MultipleDestinationMountTableResolver.class);
        clusterWithDatanodes.addNamenodeOverrides(hdfsConf);
        clusterWithDatanodes.addRouterOverrides(routerConf);
        clusterWithDatanodes.setNumDatanodesPerNameservice(9);
        clusterWithDatanodes.setIndependentDNs();
        clusterWithDatanodes.setRacks(new String[]{"/rack1", "/rack1", "/rack1", "/rack2", "/rack2", "/rack2", "/rack3", "/rack3", "/rack3", "/rack4", "/rack4", "/rack4", "/rack5", "/rack5", "/rack5", "/rack6", "/rack6", "/rack6"});
        clusterWithDatanodes.startCluster();
        clusterWithDatanodes.startRouters();
        clusterWithDatanodes.waitClusterUp();
        clusterWithDatanodes.waitActiveNamespaces();
        clusterNoDatanodes = new StateStoreDFSCluster(false, 2, MultipleDestinationMountTableResolver.class);
        clusterNoDatanodes.addNamenodeOverrides(hdfsConf);
        clusterNoDatanodes.addRouterOverrides(routerConf);
        clusterNoDatanodes.setNumDatanodesPerNameservice(0);
        clusterNoDatanodes.setIndependentDNs();
        clusterNoDatanodes.startCluster();
        clusterNoDatanodes.startRouters();
        clusterNoDatanodes.waitClusterUp();
        clusterNoDatanodes.waitActiveNamespaces();
    }

    @Test
    public void testPrintTopologyTextFormat() throws Exception {
        String httpAddress = clusterWithDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assert.assertTrue((boolean)topology.contains("/ns0/rack1"));
        Assert.assertTrue((boolean)topology.contains("/ns0/rack2"));
        Assert.assertTrue((boolean)topology.contains("/ns0/rack3"));
        Assert.assertTrue((boolean)topology.contains("/ns1/rack4"));
        Assert.assertTrue((boolean)topology.contains("/ns1/rack5"));
        Assert.assertTrue((boolean)topology.contains("/ns1/rack6"));
        Assert.assertEquals((long)18L, (long)(topology.split("127.0.0.1").length - 1));
    }

    @Test
    public void testPrintTopologyJsonFormat() throws Exception {
        String httpAddress = clusterWithDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.setRequestProperty("Accept", "application/json");
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        String topology = out.toString();
        JsonNode racks = new ObjectMapper().readTree(topology);
        Assert.assertEquals((long)6L, (long)racks.size());
        Assert.assertTrue((boolean)topology.contains("/ns0/rack1"));
        Assert.assertTrue((boolean)topology.contains("/ns0/rack2"));
        Assert.assertTrue((boolean)topology.contains("/ns0/rack3"));
        Assert.assertTrue((boolean)topology.contains("/ns1/rack4"));
        Assert.assertTrue((boolean)topology.contains("/ns1/rack5"));
        Assert.assertTrue((boolean)topology.contains("/ns1/rack6"));
        Iterator elements = racks.elements();
        int dataNodesCount = 0;
        while (elements.hasNext()) {
            JsonNode rack = (JsonNode)elements.next();
            Iterator fields = rack.fields();
            while (fields.hasNext()) {
                dataNodesCount += ((JsonNode)((Map.Entry)fields.next()).getValue()).size();
            }
        }
        Assert.assertEquals((long)18L, (long)dataNodesCount);
    }

    @Test
    public void testPrintTopologyNoDatanodesTextFormat() throws Exception {
        String httpAddress = clusterNoDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assert.assertTrue((boolean)topology.contains("No DataNodes"));
    }

    @Test
    public void testPrintTopologyNoDatanodesJsonFormat() throws Exception {
        String httpAddress = clusterNoDatanodes.getRandomRouter().getRouter().getHttpServerAddress().toString();
        URL url = new URL("http:/" + httpAddress + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.setRequestProperty("Accept", "application/json");
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assert.assertTrue((boolean)topology.contains("No DataNodes"));
    }
}

