/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;
import org.apache.hadoop.mapred.nativetask.serde.NativeSerialization;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Platform {
    private final NativeSerialization serialization;
    protected Set<String> keyClassNames = new HashSet<String>();

    public Platform() {
        this.serialization = NativeSerialization.getInstance();
    }

    public abstract void init() throws IOException;

    public abstract String name();

    protected void registerKey(String keyClassName, Class<?> key) throws IOException {
        this.serialization.register(keyClassName, key);
        this.keyClassNames.add(keyClassName);
    }

    protected abstract boolean support(String var1, INativeSerializer<?> var2, JobConf var3);

    protected abstract boolean define(Class<?> var1);
}

